/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.edit.layout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.emf.common.ecore.DataTypeEObject;
import net.astah.notation.Shape;
import net.astah.notation.edit.layout.Layout;

public class FreeLayout
extends Layout {
    protected FreeLayout(String string, double d, double d2, double d3, double d4, double d5, double d6, Map<String, Layout> map) {
        super(string, d, d2, d3, d4, d5, d6, map);
    }

    @Override
    public Map<DiagramElement, DataTypeEObject> calculate(Map<String, List<DiagramElement>> map, Bounds bounds, LayoutCalculator layoutCalculator, Class<? extends DataTypeEObject> clazz) {
        HashMap<DiagramElement, DataTypeEObject> hashMap = new HashMap<DiagramElement, DataTypeEObject>();
        if (map.containsKey(this.id)) {
            List<DiagramElement> list = map.get(this.id);
            if (clazz == Point.class) {
                this.a(list, bounds, layoutCalculator, hashMap);
            } else if (clazz == Dimension.class) {
                this.a(list, layoutCalculator, hashMap);
            }
        }
        return hashMap;
    }

    private void a(List<DiagramElement> list, Bounds bounds, LayoutCalculator layoutCalculator, Map<DiagramElement, DataTypeEObject> map) {
        Point point = DCFactory.eINSTANCE.createPoint(bounds.getX(), bounds.getY());
        for (DiagramElement diagramElement : list) {
            map.put(diagramElement, (DataTypeEObject)layoutCalculator.getLocationOn((Object)diagramElement, point));
        }
    }

    private void a(List<DiagramElement> list, LayoutCalculator layoutCalculator, Map<DiagramElement, DataTypeEObject> map) {
        for (DiagramElement diagramElement : list) {
            map.put(diagramElement, (DataTypeEObject)layoutCalculator.getBoundsSize((Object)diagramElement));
        }
    }

    @Override
    public void calculateTotalBounds(DiagramElement diagramElement, Shape shape, Map<String, List<DiagramElement>> map, LayoutCalculator layoutCalculator, Bounds bounds) {
        if (!map.containsKey(this.id)) {
            return;
        }
        List<DiagramElement> list = map.get(this.id);
        Bounds bounds2 = layoutCalculator.getTotalBounds(list, (Object)diagramElement);
        double d = bounds2.getX() - this.leftMargin;
        double d2 = bounds2.getY() - this.topMargin;
        double d3 = bounds2.getWidth() + this.leftMargin + this.rightMargin;
        double d4 = bounds2.getHeight() + this.topMargin + this.bottomMargin;
        bounds.setX(d);
        bounds.setY(d2);
        bounds.setWidth(Math.max(d3, this.minWidth));
        bounds.setHeight(Math.max(d4, this.minHeight));
    }

    public static class Builder
    extends Layout.Builder<Builder> {
        public Builder(String string) {
            this.id = string;
        }

        @Override
        public FreeLayout build() {
            return new FreeLayout(this.id, this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin, this.minWidth, this.minHeight, this.ownedLayouts);
        }
    }
}

