/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.edit.layout;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.emf.common.ecore.DataTypeEObject;
import net.astah.notation.Location;
import net.astah.notation.LocationConstraint;
import net.astah.notation.Shape;
import net.astah.notation.Size;
import net.astah.notation.SizeConstraint;
import net.astah.notation.edit.layout.Layout;
import net.astah.notation.provider.GeometryProviderHelper;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

public class FlowLayout
extends Layout {
    private final boolean a;

    protected FlowLayout(String string, double d, double d2, double d3, double d4, double d5, double d6, Map<String, Layout> map, boolean bl) {
        super(string, d, d2, d3, d4, d5, d6, map);
        this.a = bl;
    }

    @Override
    public Map<DiagramElement, DataTypeEObject> calculate(Map<String, List<DiagramElement>> map, Bounds bounds, LayoutCalculator layoutCalculator, Class<? extends DataTypeEObject> clazz) {
        HashMap<DiagramElement, DataTypeEObject> hashMap = new HashMap<DiagramElement, DataTypeEObject>();
        for (Layout layout : this.ownedLayouts.values()) {
            hashMap.putAll(layout.calculate(map, bounds, layoutCalculator, clazz));
        }
        return hashMap;
    }

    @Override
    public void calculateTotalBounds(DiagramElement diagramElement, Shape shape, Map<String, List<DiagramElement>> map, LayoutCalculator layoutCalculator, Bounds bounds) {
        RectangularShape rectangularShape = null;
        for (Layout layout : this.ownedLayouts.values()) {
            LocationConstraint locationConstraint;
            if (rectangularShape != null && (locationConstraint = GeometryProviderHelper.getLocation(shape, layoutCalculator)) instanceof Location) {
                double d = rectangularShape.getWidth() + rectangularShape.getX() - ((Location)locationConstraint).getX();
                bounds.setWidth(d);
            }
            layout.calculateTotalBounds(diagramElement, null, map, layoutCalculator, bounds);
            if (bounds.getWidth() == 0.0) continue;
            locationConstraint = Geometries.toRectangle2d((Bounds)bounds);
            if (rectangularShape == null) {
                rectangularShape = locationConstraint;
                continue;
            }
            ((Rectangle2D)rectangularShape).add((Rectangle2D)locationConstraint);
        }
        Object object = null;
        if (rectangularShape != null) {
            object = Geometries.toBounds(rectangularShape);
        }
        if (shape != null) {
            Layout layout;
            layout = this.a(shape, diagramElement, layoutCalculator);
            if (layout.getWidth() == 0.0 && shape.getBounds() != null) {
                if (object != null) {
                    if (object.getWidth() < shape.getBounds().getWidth() && this.a(map, layoutCalculator) != shape) {
                        object.setWidth(shape.getBounds().getWidth());
                    }
                } else {
                    object = DCFactory.eINSTANCE.createBounds(layout.getX(), layout.getY(), shape.getBounds().getWidth(), shape.getBounds().getHeight());
                }
            } else if (object != null) {
                if (object.getWidth() < layout.getWidth()) {
                    object.setWidth(layout.getWidth());
                }
                if (object.getHeight() < layout.getHeight()) {
                    object.setHeight(layout.getHeight());
                }
            } else {
                object = layout;
            }
        }
        if (object == null) {
            return;
        }
        if (object.getWidth() < this.minWidth) {
            object.setWidth(this.minWidth);
        }
        if (object.getHeight() < this.minHeight) {
            object.setHeight(this.minHeight);
        }
        bounds.setX(object.getX());
        bounds.setY(object.getY());
        bounds.setWidth(object.getWidth());
        bounds.setHeight(object.getHeight());
    }

    private DiagramElement a(Map<String, List<DiagramElement>> map, LayoutCalculator layoutCalculator) {
        return layoutCalculator.getOwningElement(map.values().iterator().next().get(0));
    }

    private Bounds a(Shape shape, DiagramElement diagramElement, LayoutCalculator layoutCalculator) {
        LocationConstraint locationConstraint = GeometryProviderHelper.getLocation(shape, layoutCalculator);
        if (!(locationConstraint instanceof Location)) {
            return null;
        }
        Location location = (Location)locationConstraint;
        Point point = LayoutCalculator.translate((Point)DCFactory.eINSTANCE.createPoint(location.getX(), location.getY()), (Point)layoutCalculator.getOrigin((Object)shape, (Object)diagramElement));
        SizeConstraint sizeConstraint = GeometryProviderHelper.getSize(shape, layoutCalculator);
        double d = 0.0;
        double d2 = 0.0;
        if (sizeConstraint instanceof Size) {
            Size size = (Size)sizeConstraint;
            d = size.getWidth();
            d2 = size.getHeight();
        }
        return DCFactory.eINSTANCE.createBounds(point.getX(), point.getY(), d, d2);
    }

    @Keep
    @KeepPublicProtectedClassMembers
    public static class Builder
    extends Layout.Builder<Builder> {
        private boolean a;

        public Builder horizontal(boolean bl) {
            this.a = bl;
            return this;
        }

        @Override
        public FlowLayout build() {
            return new FlowLayout(this.id, this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin, this.minWidth, this.minHeight, this.ownedLayouts, this.a);
        }
    }
}

