/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.edit.command;

import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.Point;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Group;
import net.astah.dd.dg.Image;
import net.astah.dd.dg.Text;
import net.astah.dd.dg.util.DGSwitch;
import net.astah.dd.di.edit.command.MoveLocationCommand;
import net.astah.dd.di.edit.command.SetBoundsCommand;
import net.astah.dd.di.edit.command.SetEdgeLineCommand;
import net.astah.dd.di.edit.command.SetLocationCommand;
import net.astah.dd.di.edit.command.SetSizeCommand;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.notation.AnchorConstraint;
import net.astah.notation.Edge;
import net.astah.notation.GraphicalShape;
import net.astah.notation.LineConstraint;
import net.astah.notation.NotationFactory;
import net.astah.notation.NotationPackage;
import net.astah.notation.Shape;
import net.astah.notation.Vector;
import net.astah.notation.util.NotationGetPointsHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notations {
    static final Logger a = LoggerFactory.getLogger(Notations.class);

    public static boolean moveLocation(Shape shape, double d, double d2) {
        return Notations.moveLocation(shape, NotationFactory.eINSTANCE.createVector(d, d2));
    }

    public static boolean moveLocation(Shape shape, Vector vector) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)shape);
        return Notations.a(MoveLocationCommand.create((EditingDomain)editingDomain, null, (Object)shape, (Object)vector));
    }

    public static boolean moveLocation(Edge edge, int n, double d, double d2) {
        return Notations.moveLocation(edge, n, NotationFactory.eINSTANCE.createVector(d, d2));
    }

    public static boolean moveLocation(Edge edge, int n, Vector vector) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)edge);
        return Notations.a(MoveLocationCommand.create((EditingDomain)editingDomain, null, (Object)edge, (Object)vector, (int)n));
    }

    public static boolean setLocation(Shape shape, double d, double d2) {
        return Notations.setLocation(shape, DCFactory.eINSTANCE.createPoint(d, d2));
    }

    public static boolean setLocation(Shape shape, Point point) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)shape);
        return Notations.a(SetLocationCommand.create((EditingDomain)editingDomain, null, (Object)shape, (Object)point));
    }

    public static boolean setLocation(Edge edge, int n, double d, double d2) {
        return Notations.setLocation(edge, n, DCFactory.eINSTANCE.createPoint(d, d2));
    }

    public static boolean setLocation(Edge edge, int n, Point point) {
        if (edge == null || n < 0 || point == null) {
            a.error("illegal arguments. " + Objects.toString(edge) + ", " + Objects.toString(n) + ", " + Objects.toString(point));
            return false;
        }
        LineConstraint lineConstraint = edge.getLine();
        if (lineConstraint == null) {
            a.error("line must be setted. {}", (Object)edge);
            return false;
        }
        LineConstraint lineConstraint2 = (LineConstraint)EcoreUtil.copy((EObject)lineConstraint);
        EList eList = (EList)NotationGetPointsHelper.INSTANCE.doSwitch((EObject)lineConstraint2);
        if (n < eList.size()) {
            eList.set(n, (Object)DCFactory.eINSTANCE.createPoint(point));
        } else if (n == eList.size()) {
            eList.add((Object)DCFactory.eINSTANCE.createPoint(point));
        } else {
            a.error("index out of bounds. index={}, size={}", (Object)n, (Object)eList.size());
            return false;
        }
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)edge);
        return Notations.a(SetEdgeLineCommand.create((EditingDomain)editingDomain, null, (Object)edge, (Object)lineConstraint2));
    }

    public static boolean setSize(Shape shape, double d, double d2) {
        return Notations.setSize(shape, DCFactory.eINSTANCE.createDimension(d, d2));
    }

    public static boolean setSize(Shape shape, Dimension dimension) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)shape);
        return Notations.a(SetSizeCommand.create((EditingDomain)editingDomain, null, (Object)shape, (Object)dimension));
    }

    public static boolean setPoints(Shape shape, List<Point> list) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)shape);
        return Notations.a(SetSizeCommand.create((EditingDomain)editingDomain, null, (Object)shape, list));
    }

    public static boolean setAutomaticSize(Shape shape) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)shape);
        return Notations.a(SetSizeCommand.create((EditingDomain)editingDomain, null, (Object)shape, (Object)SetSizeCommand.AUTOMATIC_VALUE));
    }

    public static boolean setDefaultSizeIfNeed(@NonNull GraphicalShape graphicalShape) {
        if (graphicalShape == null) {
            throw new NullPointerException("graphicalShape");
        }
        return Notations.a(Notations.createCommandOfSetDefaultSizeIfNeed(graphicalShape));
    }

    public static Command createCommandOfSetDefaultSizeIfNeed(@NonNull GraphicalShape graphicalShape) {
        Dimension dimension;
        if (graphicalShape == null) {
            throw new NullPointerException("graphicalShape");
        }
        String string = Notations.a(graphicalShape);
        if (string == null) {
            return UnexecutableCommand.INSTANCE;
        }
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)graphicalShape);
        String string2 = "default_size." + string;
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault(string2 + ".default_use");
        if (!bl) {
            return SetSizeCommand.create((EditingDomain)editingDomain, null, (Object)graphicalShape, (Object)SetSizeCommand.AUTOMATIC_VALUE);
        }
        String string3 = string2 + ".default_width";
        String string4 = string2 + ".default_height";
        String string5 = RuntimeGlobal.sysProp.getStringWithDefault(string3);
        String string6 = RuntimeGlobal.sysProp.getStringWithDefault(string4);
        try {
            double d = Double.parseDouble(string5);
            double d2 = Double.parseDouble(string6);
            dimension = DCFactory.eINSTANCE.createDimension(d, d2);
        }
        catch (NumberFormatException numberFormatException) {
            a.warn("The value of the default size is not numeric. : " + string3 + " or " + string4);
            return SetSizeCommand.create((EditingDomain)editingDomain, null, (Object)graphicalShape, (Object)SetSizeCommand.AUTOMATIC_VALUE);
        }
        return SetSizeCommand.create((EditingDomain)editingDomain, null, (Object)graphicalShape, (Object)dimension);
    }

    private static String a(@NonNull GraphicalShape graphicalShape) {
        if (graphicalShape == null) {
            throw new NullPointerException("graphicalShape");
        }
        return (String)new DGSwitch<String>(){

            public String caseImage(Image image) {
                return "image";
            }

            public String caseText(Text text) {
                return "text";
            }

            public String caseGroup(Group group) {
                for (GraphicalElement graphicalElement : group.getMembers()) {
                    String string = (String)this.doSwitch((EObject)graphicalElement);
                    if (string == null) continue;
                    return string;
                }
                return null;
            }
        }.doSwitch((EObject)graphicalShape.getFigure());
    }

    public static boolean setSize(Edge edge, int n, double d, double d2) {
        return Notations.setSize(edge, n, DCFactory.eINSTANCE.createDimension(d, d2));
    }

    public static boolean setSize(Edge edge, int n, Dimension dimension) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)edge);
        return Notations.a(SetSizeCommand.create((EditingDomain)editingDomain, null, (Object)edge, (Object)dimension, (int)n));
    }

    public static boolean setSourceAnchor(Edge edge, double d, double d2) {
        return Notations.setSourceAnchor(edge, (AnchorConstraint)NotationFactory.eINSTANCE.createRatioAnchor(d, d2));
    }

    public static boolean setSourceAnchor(Edge edge, AnchorConstraint anchorConstraint) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)edge);
        return Notations.a(SetLocationCommand.create((EditingDomain)editingDomain, null, (Object)edge, (Object)NotationPackage.Literals.EDGE__SOURCE_ANCHOR, (Object)anchorConstraint));
    }

    public static boolean setTargetAnchor(Edge edge, double d, double d2) {
        return Notations.setTargetAnchor(edge, (AnchorConstraint)NotationFactory.eINSTANCE.createRatioAnchor(d, d2));
    }

    public static boolean setTargetAnchor(Edge edge, AnchorConstraint anchorConstraint) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)edge);
        return Notations.a(SetLocationCommand.create((EditingDomain)editingDomain, null, (Object)edge, (Object)NotationPackage.Literals.EDGE__TARGET_ANCHOR, (Object)anchorConstraint));
    }

    public static boolean setBounds(Shape shape, Bounds bounds) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)shape);
        return Notations.a(SetBoundsCommand.create((EditingDomain)editingDomain, null, (Object)shape, (Object)bounds));
    }

    static boolean a(Command command) {
        if (command.canExecute()) {
            command.execute();
            command.dispose();
            return true;
        }
        return false;
    }
}

