/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.compare.factories.extensions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCPackage;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DIPackage;
import net.astah.emf.compare.diagram.CompareDiagramConfiguration;
import net.astah.emf.compare.diagram.extensions.CoordinatesChange;
import net.astah.emf.compare.diagram.extensions.DiagramDiff;
import net.astah.emf.compare.diagram.extensions.ExtensionsFactory;
import net.astah.notation.NotationPackage;
import net.astah.notation.compare.factories.extensions.ShapeChangeFactory;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

public class CoordinatesChangeFactory
extends ShapeChangeFactory {
    private final CompareDiagramConfiguration a;

    public CoordinatesChangeFactory(CompareDiagramConfiguration compareDiagramConfiguration) {
        this.a = compareDiagramConfiguration;
    }

    @Override
    public Class<? extends Diff> getExtensionKind() {
        return CoordinatesChange.class;
    }

    @Override
    public DiagramDiff createExtension() {
        return ExtensionsFactory.eINSTANCE.createCoordinatesChange();
    }

    @Override
    public void setRefiningChanges(Diff diff, DifferenceKind differenceKind, Diff diff2) {
        if (differenceKind == DifferenceKind.CHANGE) {
            diff.getRefinedBy().addAll(Collections2.filter(this.getAllDifferencesForChange(diff2), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)diff.getSource())));
        }
    }

    @Override
    protected Collection<Diff> getAllDifferencesForChange(Diff diff) {
        Collection<Diff> collection = super.getAllDifferencesForChange(diff);
        return Collections2.filter(collection, diff2 -> diff2 instanceof AttributeChange && CoordinatesChangeFactory.a((AttributeChange)diff2) && EMFComparePredicates.fromSide((DifferenceSource)diff.getSource()).apply(diff2));
    }

    public static Predicate<? super Diff> isCoordinatesChangeExtension() {
        return Predicates.and((Predicate)Predicates.instanceOf(CoordinatesChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE));
    }

    protected boolean isRelatedToAnExtensionChange(AttributeChange attributeChange) {
        return CoordinatesChangeFactory.a(attributeChange) && Collections2.filter((Collection)attributeChange.getRefines(), CoordinatesChangeFactory.isCoordinatesChangeExtension()).isEmpty() && this.c(attributeChange) && !this.b(attributeChange);
    }

    private static Predicate<? super Diff> a(List<Match> list) {
        return diff -> {
            if (!list.isEmpty()) {
                return diff instanceof ReferenceChange && CoordinatesChangeFactory.isRelatedToAMoveShape((ReferenceChange)diff) && list.contains(((Match)list.get(0)).getComparison().getMatch(((ReferenceChange)diff).getValue()));
            }
            return false;
        };
    }

    private static boolean a(AttributeChange attributeChange) {
        EAttribute eAttribute = attributeChange.getAttribute();
        if (eAttribute == DCPackage.Literals.POINT__X || eAttribute == DCPackage.Literals.POINT__Y || eAttribute == DCPackage.Literals.BOUNDS__X || eAttribute == DCPackage.Literals.BOUNDS__Y) {
            Comparison comparison;
            EObject eObject;
            EClass eClass = eAttribute.getEContainingClass();
            if (eClass == DCPackage.Literals.BOUNDS) {
                Comparison comparison2 = attributeChange.getMatch().getComparison();
                EObject eObject2 = MatchUtil.getContainer((Comparison)comparison2, (Diff)attributeChange);
                if (eObject2 != null) {
                    EReference eReference = eObject2.eContainmentFeature();
                    return eReference == DIPackage.Literals.SHAPE__BOUNDS;
                }
            } else if (NotationPackage.Literals.LOCATION.isSuperTypeOf(eClass)) {
                Comparison comparison3 = attributeChange.getMatch().getComparison();
                EObject eObject3 = MatchUtil.getContainer((Comparison)comparison3, (Diff)attributeChange);
                if (eObject3 != null) {
                    EReference eReference = eObject3.eContainmentFeature();
                    return eReference == NotationPackage.Literals.SHAPE__LOCATION;
                }
            } else if (NotationPackage.Literals.SIZE.isSuperTypeOf(eClass) && (eObject = MatchUtil.getContainer((Comparison)(comparison = attributeChange.getMatch().getComparison()), (Diff)attributeChange)) != null) {
                EReference eReference = eObject.eContainmentFeature();
                return eReference == NotationPackage.Literals.SHAPE__SIZE;
            }
        }
        return false;
    }

    private boolean b(AttributeChange attributeChange) {
        ArrayList<Match> arrayList = new ArrayList<Match>();
        boolean bl = false;
        Match match = attributeChange.getMatch();
        while (!bl && match instanceof Match) {
            arrayList.add(match);
            bl = Iterators.any((Iterator)match.getDifferences().iterator(), CoordinatesChangeFactory.a(arrayList));
            match = match.eContainer();
        }
        return bl;
    }

    private boolean c(AttributeChange attributeChange) {
        Comparison comparison = attributeChange.getMatch().getComparison();
        EObject eObject = MatchUtil.getContainer((Comparison)comparison, (Diff)attributeChange);
        EObject eObject2 = MatchUtil.getOriginContainer((Comparison)comparison, (Diff)attributeChange);
        CoordinateProvider coordinateProvider = new CoordinateProvider(eObject);
        CoordinateProvider coordinateProvider2 = new CoordinateProvider(eObject2);
        if (coordinateProvider.hasCoordinates() && coordinateProvider2.hasCoordinates()) {
            double d = coordinateProvider.getX();
            double d2 = coordinateProvider.getY();
            double d3 = coordinateProvider2.getX();
            double d4 = coordinateProvider2.getY();
            double d5 = Math.abs(d - d3);
            double d6 = Math.abs(d2 - d4);
            int n = 0;
            if (this.a != null) {
                n = this.a.getMoveThreshold();
            }
            return d5 + d6 > (double)n;
        }
        return false;
    }

    private static class CoordinateProvider {
        private final EObject a;

        CoordinateProvider(EObject eObject) {
            this.a = eObject;
        }

        public boolean hasCoordinates() {
            return this.a instanceof Bounds || this.a instanceof Point;
        }

        public double getX() {
            if (this.a instanceof Bounds) {
                return ((Bounds)this.a).getX();
            }
            if (this.a instanceof Point) {
                return ((Point)this.a).getX();
            }
            return Double.NaN;
        }

        public double getY() {
            if (this.a instanceof Bounds) {
                return ((Bounds)this.a).getY();
            }
            if (this.a instanceof Point) {
                return ((Point)this.a).getY();
            }
            return Double.NaN;
        }
    }
}

