/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml.util;

import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Tpl2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.ActivityNodePresentation;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.ForkNodePresentation;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.JmodelFactory;
import net.astah.jmodel.JoinNodePresentation;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LinePresentation;
import net.astah.jmodel.NoteAnchorPresentation;
import net.astah.jmodel.NotePresentation;
import net.astah.jmodel.PinPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.Project;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.TextPresentation;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtFontUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionUtil {
    private static final double a = 15.0;
    public static final double TEMP_CRECT_SPAN = 25.0;
    private static final Logger b = LoggerFactory.getLogger(PartitionUtil.class);

    public static ActivityPartition createTopSwimlane(Project project, IEntityStore iEntityStore, UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        ActivityPartition activityPartition = UMLFactory.eINSTANCE.createActivityPartition();
        ActivityPartitionPresentation activityPartitionPresentation = JmodelFactory.eINSTANCE.createActivityPartitionPresentation();
        activityPartitionPresentation.setHorizontal(bl);
        if (bl) {
            activityPartitionPresentation.setLocation(new Pnt2d(0.0 - PartitionUtil.getNameBlockHeightWithChildren(uMLActivityDiagram, activityPartitionPresentation) * 2.0, 0.0));
        } else {
            activityPartitionPresentation.setLocation(new Pnt2d(0.0, 0.0 - PartitionUtil.getNameBlockHeightWithChildren(uMLActivityDiagram, activityPartitionPresentation) * 2.0));
        }
        activityPartition.setName(PropertyManager.getProjectViewResourceBundle().getString("uml.dimension.label") + project.dimensionNum++);
        activityPartitionPresentation.setModel(activityPartition);
        iEntityStore.addEntity((EObject)activityPartitionPresentation);
        uMLActivityDiagram.addPresentation(activityPartitionPresentation);
        uMLActivityDiagram.getActivityGraph().getPartitions().add((Object)activityPartition);
        activityPartitionPresentation.setBodyColorWithDefault();
        return activityPartition;
    }

    public static List<ActivityPartitionPresentation> getOrderedSwimlanePs(UMLActivityDiagram uMLActivityDiagram) {
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePs(uMLActivityDiagram);
        PartitionUtil.sortSwimlanePs(list, false);
        return list;
    }

    public static List<ActivityPartitionPresentation> getOrderedSwimlanePs(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePss(uMLActivityDiagram, bl);
        PartitionUtil.sortSwimlanePs(list, bl);
        return list;
    }

    public static List<ActivityPartition> getAllSwimlanes(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        List<ActivityPartition> list = new ArrayList<ActivityPartition>();
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, bl);
        if (activityPartition != null) {
            list.add(activityPartition);
            list = PartitionUtil.a(list, activityPartition, bl);
        }
        return list;
    }

    private static List<ActivityPartition> a(List<ActivityPartition> list, ActivityPartition activityPartition, boolean bl) {
        EList eList = activityPartition.getSubpartitions();
        for (int i2 = 0; i2 < eList.size(); ++i2) {
            ActivityPartition activityPartition2 = (ActivityPartition)eList.get(i2);
            if (!list.contains(activityPartition2)) {
                list.add(activityPartition2);
            }
            list = PartitionUtil.a(list, activityPartition2, bl);
        }
        return list;
    }

    public static List<ActivityPartition> getAllSwimlanes(UMLActivityDiagram uMLActivityDiagram) {
        List<ActivityPartition> list = new ArrayList<ActivityPartition>();
        List<ActivityPartition> list2 = PartitionUtil.getTopSwimlanes(uMLActivityDiagram);
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            ActivityPartition activityPartition = list2.get(i2);
            list.add(activityPartition);
            list = PartitionUtil.a(list, activityPartition);
        }
        return list;
    }

    private static List<ActivityPartition> a(List<ActivityPartition> list, ActivityPartition activityPartition) {
        EList eList = activityPartition.getSubpartitions();
        for (int i2 = 0; i2 < eList.size(); ++i2) {
            ActivityPartition activityPartition2 = (ActivityPartition)eList.get(i2);
            if (!list.contains(activityPartition2)) {
                list.add(activityPartition2);
            }
            list = PartitionUtil.a(list, activityPartition2);
        }
        return list;
    }

    public static List<ActivityPartition> getTopSwimlanes(UMLActivityDiagram uMLActivityDiagram) {
        return uMLActivityDiagram.getActivityGraph().getPartitions();
    }

    public static ActivityPartition getTopSwimlane(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        if (uMLActivityDiagram == null) {
            return null;
        }
        Activity activity = uMLActivityDiagram.getActivityGraph();
        if (activity != null) {
            EList eList = activity.getPartitions();
            for (int i2 = 0; i2 < eList.size(); ++i2) {
                ActivityPartition activityPartition = (ActivityPartition)eList.get(i2);
                ActivityPartitionPresentation activityPartitionPresentation = PartitionUtil.getPresentation(activityPartition);
                if (activityPartitionPresentation == null || activityPartitionPresentation.isHorizontal() != bl) continue;
                return activityPartition;
            }
        }
        return null;
    }

    public static List<ActivityPartitionPresentation> getSwimlanePs(UMLActivityDiagram uMLActivityDiagram) {
        List<ActivityPartition> list = PartitionUtil.getTopSwimlanes(uMLActivityDiagram);
        List<ActivityPartitionPresentation> list2 = new ArrayList<ActivityPartitionPresentation>();
        for (ActivityPartition activityPartition : list) {
            list2 = PartitionUtil.addChildPartitionPs(list2, activityPartition);
        }
        return list2;
    }

    public static List<ActivityPartitionPresentation> addChildPartitionPs(List<ActivityPartitionPresentation> list, ActivityPartition activityPartition) {
        EList eList = activityPartition.getSubpartitions();
        for (int i2 = 0; i2 < eList.size(); ++i2) {
            ActivityPartitionPresentation activityPartitionPresentation;
            ActivityPartition activityPartition2 = (ActivityPartition)eList.get(i2);
            List<Presentation> list2 = Presentations.getPresentations((EObject)activityPartition2);
            if (list2.size() > 0 && !list.contains(activityPartitionPresentation = (ActivityPartitionPresentation)list2.get(0))) {
                list.add(activityPartitionPresentation);
            }
            list = PartitionUtil.addChildPartitionPs(list, activityPartition2);
        }
        return list;
    }

    public static List<ActivityPartitionPresentation> getSwimlanePss(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        List<ActivityPartitionPresentation> list = new ArrayList<ActivityPartitionPresentation>();
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, bl);
        if (activityPartition == null) {
            return list;
        }
        list = PartitionUtil.b(list, activityPartition, bl);
        return list;
    }

    private static List<ActivityPartitionPresentation> b(List<ActivityPartitionPresentation> list, ActivityPartition activityPartition, boolean bl) {
        EList eList = activityPartition.getSubpartitions();
        for (int i2 = 0; i2 < eList.size(); ++i2) {
            ActivityPartitionPresentation activityPartitionPresentation;
            ActivityPartition activityPartition2 = (ActivityPartition)eList.get(i2);
            List<Presentation> list2 = Presentations.getPresentations((EObject)activityPartition2);
            if (list2.size() > 0 && !list.contains(activityPartitionPresentation = (ActivityPartitionPresentation)list2.get(0)) && activityPartitionPresentation.isHorizontal() == bl) {
                list.add(activityPartitionPresentation);
            }
            list = PartitionUtil.addChildPartitionPs(list, activityPartition2);
        }
        return list;
    }

    public static int getSwimlaneCount(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        List<ActivityPartitionPresentation> list = new ArrayList<ActivityPartitionPresentation>();
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, bl);
        if (activityPartition == null) {
            return 0;
        }
        list = PartitionUtil.b(list, activityPartition, bl);
        return list.size() + 1;
    }

    public static void sortLevelSwimlanePs(List<ActivityPartitionPresentation> list) {
        Comparator<ActivityPartitionPresentation> comparator = new Comparator<ActivityPartitionPresentation>(){

            @Override
            public int compare(ActivityPartitionPresentation activityPartitionPresentation, ActivityPartitionPresentation activityPartitionPresentation2) {
                double d2;
                ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
                ActivityPartition activityPartition2 = (ActivityPartition)activityPartitionPresentation2.getModel();
                double d3 = PartitionUtil.getLevel(activityPartition);
                if (d3 < (d2 = (double)PartitionUtil.getLevel(activityPartition2))) {
                    return -1;
                }
                if (d3 > d2) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
    }

    public static void sortHighLevelSwimlanePs(List<ActivityPartitionPresentation> list) {
        Comparator<ActivityPartitionPresentation> comparator = new Comparator<ActivityPartitionPresentation>(){

            @Override
            public int compare(ActivityPartitionPresentation activityPartitionPresentation, ActivityPartitionPresentation activityPartitionPresentation2) {
                double d2;
                ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
                ActivityPartition activityPartition2 = (ActivityPartition)activityPartitionPresentation2.getModel();
                double d3 = PartitionUtil.getLevel(activityPartition);
                if (d3 > (d2 = (double)PartitionUtil.getLevel(activityPartition2))) {
                    return -1;
                }
                if (d3 < d2) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
    }

    public static void sortSwimlanePs(List<ActivityPartitionPresentation> list, boolean bl) {
        Comparator<ActivityPartitionPresentation> comparator = null;
        comparator = bl ? new Comparator<ActivityPartitionPresentation>(){

            @Override
            public int compare(ActivityPartitionPresentation activityPartitionPresentation, ActivityPartitionPresentation activityPartitionPresentation2) {
                double d2;
                double d3 = activityPartitionPresentation.getMinY();
                if (d3 < (d2 = activityPartitionPresentation2.getMinY())) {
                    return -1;
                }
                if (d3 > d2) {
                    return 1;
                }
                return 0;
            }
        } : new Comparator<ActivityPartitionPresentation>(){

            @Override
            public int compare(ActivityPartitionPresentation activityPartitionPresentation, ActivityPartitionPresentation activityPartitionPresentation2) {
                double d2;
                double d3 = activityPartitionPresentation.getMinX();
                if (d3 < (d2 = activityPartitionPresentation2.getMinX())) {
                    return -1;
                }
                if (d3 > d2) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
    }

    public static ActivityPartitionPresentation getReferedSwimlanePs(UMLActivityDiagram uMLActivityDiagram, Pnt2d pnt2d, boolean bl) {
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, bl);
        if (activityPartition == null) {
            return null;
        }
        EList eList = activityPartition.getSubpartitions();
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePsFromModel((List<ActivityPartition>)eList);
        PartitionUtil.sortSwimlanePs(list, bl);
        if (list.size() > 0) {
            ActivityPartitionPresentation activityPartitionPresentation = list.get(0);
            ActivityPartitionPresentation activityPartitionPresentation2 = list.get(list.size() - 1);
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) {
                bl2 = pnt2d.y < activityPartitionPresentation.getMinY();
                bl3 = pnt2d.y > activityPartitionPresentation2.getMaxY();
            } else {
                bl2 = pnt2d.x < activityPartitionPresentation.getMinX();
                boolean bl4 = bl3 = pnt2d.x > activityPartitionPresentation2.getMaxX();
            }
            if (bl2) {
                return PartitionUtil.a(activityPartitionPresentation, pnt2d, bl);
            }
            if (bl3) {
                Pnt2d pnt2d2 = new Pnt2d((Tpl2d)pnt2d);
                if (bl) {
                    pnt2d2.set(pnt2d.x, activityPartitionPresentation2.getMaxY());
                } else {
                    pnt2d2.set(activityPartitionPresentation2.getMaxX(), pnt2d.y);
                }
                return PartitionUtil.a(uMLActivityDiagram, list, pnt2d2, bl);
            }
            return PartitionUtil.a(uMLActivityDiagram, list, pnt2d, bl);
        }
        return null;
    }

    private static ActivityPartitionPresentation a(ActivityPartitionPresentation activityPartitionPresentation, Pnt2d pnt2d, boolean bl) {
        ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
        EList eList = activityPartition.getSubpartitions();
        if (eList.size() == 0) {
            return activityPartitionPresentation;
        }
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePsFromModel((List<ActivityPartition>)eList);
        PartitionUtil.sortSwimlanePs(list, bl);
        if (list.size() == 0) {
            return activityPartitionPresentation;
        }
        Pnt2d pnt2d2 = activityPartitionPresentation.getLocation();
        boolean bl2 = false;
        if (bl) {
            bl2 = pnt2d.x < pnt2d2.x && pnt2d.x + activityPartitionPresentation.getMyNameBlockHeight() > pnt2d2.x;
        } else {
            boolean bl3 = bl2 = pnt2d.y < pnt2d2.y && pnt2d.y + activityPartitionPresentation.getMyNameBlockHeight() > pnt2d2.y;
        }
        if (bl2) {
            return activityPartitionPresentation;
        }
        ActivityPartitionPresentation activityPartitionPresentation2 = list.get(0);
        return PartitionUtil.a(activityPartitionPresentation2, pnt2d, bl);
    }

    public static List<ActivityPartitionPresentation> getSwimlanePsFromModel(List<ActivityPartition> list) {
        ArrayList<ActivityPartitionPresentation> arrayList = new ArrayList<ActivityPartitionPresentation>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List<Presentation> list2 = Presentations.getPresentations((EObject)list.get(i2));
            if (list2.size() <= 0) continue;
            ActivityPartitionPresentation activityPartitionPresentation = (ActivityPartitionPresentation)list2.get(0);
            arrayList.add(activityPartitionPresentation);
        }
        return arrayList;
    }

    private static ActivityPartitionPresentation a(UMLActivityDiagram uMLActivityDiagram, List<ActivityPartitionPresentation> list, Pnt2d pnt2d, boolean bl) {
        PartitionUtil.sortSwimlanePs(list, bl);
        if (list.size() > 0) {
            for (ActivityPartitionPresentation activityPartitionPresentation : list) {
                boolean bl2 = false;
                boolean bl3 = false;
                if (bl) {
                    bl2 = pnt2d.y > activityPartitionPresentation.getMinY() && pnt2d.y <= activityPartitionPresentation.getMaxY();
                    bl3 = pnt2d.x > activityPartitionPresentation.getMinX() && pnt2d.x < activityPartitionPresentation.getMinX() + PartitionUtil.getNameBlockHeightWithChildren(uMLActivityDiagram, activityPartitionPresentation);
                } else {
                    bl2 = pnt2d.x > activityPartitionPresentation.getMinX() && pnt2d.x <= activityPartitionPresentation.getMaxX();
                    boolean bl4 = bl3 = pnt2d.y > activityPartitionPresentation.getMinY() && pnt2d.y < activityPartitionPresentation.getMinY() + PartitionUtil.getNameBlockHeightWithChildren(uMLActivityDiagram, activityPartitionPresentation);
                }
                if (!bl2) continue;
                if (bl3) {
                    return activityPartitionPresentation;
                }
                EList eList = ((ActivityPartition)activityPartitionPresentation.getModel()).getSubpartitions();
                if (eList.size() > 0) {
                    List<ActivityPartitionPresentation> list2 = PartitionUtil.getSwimlanePsFromModel((List<ActivityPartition>)eList);
                    if (list2.size() > 0) {
                        return PartitionUtil.a(uMLActivityDiagram, list2, pnt2d, bl);
                    }
                    return activityPartitionPresentation;
                }
                return activityPartitionPresentation;
            }
        }
        return null;
    }

    public static boolean isValidPosition(Pnt2d pnt2d, UMLActivityDiagram uMLActivityDiagram) {
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePs(uMLActivityDiagram);
        if (list != null && list.size() != 0) {
            ActivityPartitionPresentation activityPartitionPresentation = PartitionUtil.getReferedSwimlanePsToMoveIn(uMLActivityDiagram, pnt2d, false);
            ActivityPartitionPresentation activityPartitionPresentation2 = PartitionUtil.getReferedSwimlanePsToMoveIn(uMLActivityDiagram, pnt2d, true);
            if (activityPartitionPresentation == null && activityPartitionPresentation2 == null) {
                return false;
            }
        }
        return true;
    }

    public static ActivityPartition getMyPartition(UMLActivityDiagram uMLActivityDiagram, EObject eObject, boolean bl) {
        if (!(eObject instanceof ActivityNode)) {
            return null;
        }
        ActivityNode activityNode = (ActivityNode)eObject;
        Optional<ActivityPartition> optional = activityNode.getInPartitions().stream().filter(activityPartition -> PartitionUtil.getPresentation(activityPartition).isHorizontal() == bl && activityPartition.getSubpartitions().isEmpty()).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static void alignLengthOfSwimlanesBySpanAfterDelete(UMLActivityDiagram uMLActivityDiagram, double d2, double d3) {
        ActivityPartitionPresentation activityPartitionPresentation;
        ActivityPartition activityPartition;
        int n2;
        Iterator<ActivityPartitionPresentation> iterator;
        List<ActivityPartitionPresentation> list;
        double d4 = PartitionUtil.getAllSpanSum(uMLActivityDiagram, false);
        double d5 = PartitionUtil.getAllSpanSum(uMLActivityDiagram, true);
        if (d2 != d4 && d4 != 0.0) {
            list = PartitionUtil.getSwimlanePss(uMLActivityDiagram, true);
            iterator = list.iterator();
            while (iterator.hasNext() && (n2 = PartitionUtil.getLevel(activityPartition = (ActivityPartition)(activityPartitionPresentation = iterator.next()).getModel())) != 0) {
                activityPartitionPresentation.setLength(activityPartitionPresentation.getLength() - (d2 - d4));
            }
        }
        if (d3 != d5 && d5 != 0.0) {
            list = PartitionUtil.getSwimlanePss(uMLActivityDiagram, false);
            iterator = list.iterator();
            while (iterator.hasNext() && (n2 = PartitionUtil.getLevel(activityPartition = (ActivityPartition)(activityPartitionPresentation = iterator.next()).getModel())) != 0) {
                activityPartitionPresentation.setLength(activityPartitionPresentation.getLength() - (d3 - d5));
            }
        }
    }

    public static void alignLengthOfSwimlanesByLevelAfterDelete(UMLActivityDiagram uMLActivityDiagram, int n2, int n3) {
        Object object;
        ActivityPartitionPresentation activityPartitionPresentation;
        ActivityPartition activityPartition;
        int n4;
        Iterator<ActivityPartitionPresentation> iterator;
        List<ActivityPartitionPresentation> list;
        int n5 = uMLActivityDiagram.getVerticalMaxLevel();
        int n6 = uMLActivityDiagram.getHorizontalMaxLevel();
        if (n2 > n5) {
            list = PartitionUtil.getSwimlanePss(uMLActivityDiagram, false);
            iterator = list.iterator();
            while (iterator.hasNext() && (n4 = PartitionUtil.getLevel(activityPartition = (ActivityPartition)(activityPartitionPresentation = iterator.next()).getModel())) != 0) {
                object = PartitionUtil.getTopSwimlane(uMLActivityDiagram, false);
                ActivityPartitionPresentation activityPartitionPresentation2 = (ActivityPartitionPresentation)Presentations.getPresentations((EObject)object).get(0);
                double d2 = (double)(n2 - n5) * activityPartitionPresentation2.getMyNameBlockHeight();
                activityPartitionPresentation.setLength(activityPartitionPresentation.getLength() - d2);
            }
        }
        if (n3 > n6) {
            list = PartitionUtil.getSwimlanePss(uMLActivityDiagram, true);
            iterator = list.iterator();
            while (iterator.hasNext() && (n4 = PartitionUtil.getLevel(activityPartition = (ActivityPartition)(activityPartitionPresentation = iterator.next()).getModel())) != 0) {
                object = (ActivityPartitionPresentation)Presentations.getPresentations((EObject)PartitionUtil.getTopSwimlane(uMLActivityDiagram, true)).get(0);
                double d3 = (double)(n3 - n6) * object.getMyNameBlockHeight();
                activityPartitionPresentation.setLength(activityPartitionPresentation.getLength() - d3);
            }
        }
    }

    public static void alignLengthOfSwimlanes(UMLActivityDiagram uMLActivityDiagram, ActivityPartitionPresentation activityPartitionPresentation) {
        ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
        int n2 = PartitionUtil.getLevel(activityPartition);
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePs(uMLActivityDiagram);
        double d2 = activityPartitionPresentation.getLocation().x;
        double d3 = activityPartitionPresentation.getLocation().y;
        for (ActivityPartitionPresentation activityPartitionPresentation2 : list) {
            ActivityPartition activityPartition2 = (ActivityPartition)activityPartitionPresentation2.getModel();
            int n3 = PartitionUtil.getLevel(activityPartition2);
            if (n2 == 0) break;
            if (activityPartition2 == activityPartition) continue;
            if (activityPartitionPresentation2.isHorizontal() == activityPartitionPresentation.isHorizontal()) {
                if (n2 == n3) {
                    double d4;
                    Pnt2d pnt2d;
                    activityPartitionPresentation2.setLength(activityPartitionPresentation.getLength());
                    if (!activityPartitionPresentation2.isHorizontal()) {
                        Pnt2d pnt2d2 = new Pnt2d(activityPartitionPresentation2.getLocation().x, d3);
                        pnt2d = activityPartitionPresentation2.getLocation();
                        activityPartitionPresentation2.setLocation(pnt2d2);
                        double d5 = pnt2d2.x - pnt2d.x;
                        d4 = pnt2d2.y - pnt2d.y;
                        PartitionUtil.a(activityPartitionPresentation2, d5, d4);
                        continue;
                    }
                    Pnt2d pnt2d3 = new Pnt2d(d2, activityPartitionPresentation2.getLocation().y);
                    pnt2d = activityPartitionPresentation2.getLocation();
                    activityPartitionPresentation2.setLocation(pnt2d3);
                    double d6 = pnt2d3.x - pnt2d.x;
                    d4 = pnt2d3.y - pnt2d.y;
                    PartitionUtil.a(activityPartitionPresentation2, d6, d4);
                    continue;
                }
                double d7 = PartitionUtil.getAllSpanSum(uMLActivityDiagram, !activityPartitionPresentation2.isHorizontal());
                if (d7 == 0.0) {
                    d7 = activityPartitionPresentation.getLength() - activityPartitionPresentation.getMyNameBlockHeight();
                }
                activityPartitionPresentation2.setLength(d7 + ((double)n2 - (double)n3 + 1.0) * activityPartitionPresentation2.getMyNameBlockHeight());
                b.debug("[A]{} {} partitionLevel={}", new Object[]{activityPartitionPresentation2, activityPartitionPresentation, n3});
                continue;
            }
            double d8 = 0.0;
            int n4 = -1;
            if (activityPartitionPresentation2.isHorizontal()) {
                d8 = PartitionUtil.getAllSpanSum(uMLActivityDiagram, false);
                n4 = uMLActivityDiagram.getHorizontalMaxLevel();
            } else {
                d8 = PartitionUtil.getAllSpanSum(uMLActivityDiagram, true);
                n4 = uMLActivityDiagram.getVerticalMaxLevel();
            }
            activityPartitionPresentation2.setLength(d8 + ((double)n4 - (double)n3 + 1.0) * activityPartitionPresentation2.getMyNameBlockHeight());
            b.debug("[B]{} {} dgmMaxLevel={} partitionLevel={}", new Object[]{activityPartitionPresentation2, activityPartitionPresentation, n4, n3});
        }
    }

    public static boolean isElementsInDifferPartitions(List<JomtPresentation> list, UMLActivityDiagram uMLActivityDiagram) {
        return PartitionUtil.isElementsInDifferentPartitions(list, uMLActivityDiagram, true) || PartitionUtil.isElementsInDifferentPartitions(list, uMLActivityDiagram, false);
    }

    public static boolean isElementsInDifferentPartitions(List<JomtPresentation> list, UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        ActivityPartition activityPartition = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            JomtPresentation jomtPresentation = list.get(i2);
            if (!(jomtPresentation instanceof ActivityNodePresentation)) continue;
            ActivityPartition activityPartition2 = PartitionUtil.getMyPartition(uMLActivityDiagram, ((ActivityNodePresentation)jomtPresentation).getModel(), bl);
            if (activityPartition == null) {
                activityPartition = activityPartition2;
                continue;
            }
            if (activityPartition2 == null || activityPartition2 == activityPartition) continue;
            return true;
        }
        return false;
    }

    public static void movePartitionAfetrDelete(UMLActivityDiagram uMLActivityDiagram, int n2, int n3) {
        double d2;
        ActivityPartitionPresentation activityPartitionPresentation;
        ActivityPartition activityPartition;
        int n4 = uMLActivityDiagram.getVerticalMaxLevel();
        int n5 = uMLActivityDiagram.getHorizontalMaxLevel();
        double d3 = 0.0;
        if (n2 > n4 && n5 != -1) {
            d3 = n2 - n4;
            if (n4 == -1) {
                d3 -= 2.0;
            }
            if ((activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, true)) != null && (activityPartitionPresentation = PartitionUtil.getPresentation(activityPartition)) != null) {
                d2 = d3 * activityPartitionPresentation.getMyNameBlockHeight();
                PartitionUtil.moveAll(uMLActivityDiagram, -d2, true, true);
            }
        }
        if (n3 > n5 && n4 != -1) {
            d3 = n3 - n5;
            if (n5 == -1) {
                d3 -= 2.0;
            }
            if ((activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, false)) != null && (activityPartitionPresentation = PartitionUtil.getPresentation(activityPartition)) != null) {
                d2 = d3 * activityPartitionPresentation.getMyNameBlockHeight();
                PartitionUtil.moveAll(uMLActivityDiagram, -d2, false, true);
            }
        }
    }

    private static void a(ActivityPartitionPresentation activityPartitionPresentation, double d2, double d3) {
        if (activityPartitionPresentation == null) {
            return;
        }
        ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
        if (activityPartition == null) {
            return;
        }
        EList eList = activityPartition.getOwnedElements();
        for (Element element : eList) {
            List<Presentation> list = Presentations.getPresentations((EObject)element);
            if (list.isEmpty()) continue;
            JomtPresentation jomtPresentation = (JomtPresentation)list.get(0);
            if (activityPartitionPresentation.isHorizontal()) {
                jomtPresentation.setLocation(new Pnt2d(jomtPresentation.getLocation().x + d2, jomtPresentation.getLocation().y));
                continue;
            }
            jomtPresentation.setLocation(new Pnt2d(jomtPresentation.getLocation().x, jomtPresentation.getLocation().y + d3));
        }
    }

    public static double getNameBlockHeightWithChildren(UMLActivityDiagram uMLActivityDiagram, ActivityPartitionPresentation activityPartitionPresentation) {
        double d2 = 35.0;
        if (activityPartitionPresentation != null) {
            d2 = PartitionUtil.getNameBlockHeight(uMLActivityDiagram, activityPartitionPresentation);
        }
        return d2;
    }

    public static int getDeepestPartitionLevel(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        List<ActivityPartitionPresentation> list = PartitionUtil.getDeepestPartitionPs(uMLActivityDiagram, bl);
        if (list.size() > 0) {
            ActivityPartition activityPartition = (ActivityPartition)list.get(0).getModel();
            return PartitionUtil.getLevel(activityPartition);
        }
        return -1;
    }

    public static List<ActivityPartitionPresentation> getDeepestPartitionPs(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        ArrayList<ActivityPartitionPresentation> arrayList = new ArrayList<ActivityPartitionPresentation>();
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePss(uMLActivityDiagram, bl);
        PartitionUtil.sortLevelSwimlanePs(list);
        int n2 = 0;
        for (int i2 = list.size() - 1; i2 > -1; --i2) {
            ActivityPartitionPresentation activityPartitionPresentation = list.get(i2);
            ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
            int n3 = PartitionUtil.getLevel(activityPartition);
            if (n2 < n3) {
                arrayList.clear();
                arrayList.add(activityPartitionPresentation);
                n2 = n3;
                continue;
            }
            if (n2 != n3) continue;
            arrayList.add(activityPartitionPresentation);
            n2 = n3;
        }
        return arrayList;
    }

    private static ActivityPartitionPresentation a(ActivityPartitionPresentation activityPartitionPresentation, ActivityPartitionPresentation activityPartitionPresentation2) {
        ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
        if (activityPartition == null) {
            return null;
        }
        ActivityPartition activityPartition2 = (ActivityPartition)activityPartitionPresentation2.getModel();
        if (activityPartition2 == null) {
            return null;
        }
        int n2 = PartitionUtil.getLevel(activityPartition);
        if (n2 == 0) {
            return null;
        }
        int n3 = PartitionUtil.getLevel(activityPartition2);
        int n4 = n3 - n2;
        if (n4 > 0) {
            while (n4 != 0) {
                activityPartition2 = activityPartition2.getSuperPartition();
                --n4;
            }
        }
        return (ActivityPartitionPresentation)Presentations.getPresentations((EObject)activityPartition2).get(0);
    }

    private static boolean b(ActivityPartitionPresentation activityPartitionPresentation, ActivityPartitionPresentation activityPartitionPresentation2) {
        if (activityPartitionPresentation.equals(activityPartitionPresentation2)) {
            return true;
        }
        ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
        ActivityPartition activityPartition2 = (ActivityPartition)activityPartitionPresentation2.getModel();
        ActivityPartition activityPartition3 = activityPartition2.getSuperPartition();
        ActivityPartitionPresentation activityPartitionPresentation3 = null;
        if (activityPartition3 != null) {
            if (activityPartition3.equals(activityPartition)) {
                return true;
            }
            List<Presentation> list = Presentations.getPresentations((EObject)activityPartition3);
            if (list.size() > 0) {
                activityPartitionPresentation3 = (ActivityPartitionPresentation)list.get(0);
                return PartitionUtil.b(activityPartitionPresentation, activityPartitionPresentation3);
            }
            return false;
        }
        return false;
    }

    public static double getNameBlockHeight(UMLActivityDiagram uMLActivityDiagram, ActivityPartitionPresentation activityPartitionPresentation) {
        List<ActivityPartitionPresentation> list = PartitionUtil.getDeepestPartitionPs(uMLActivityDiagram, activityPartitionPresentation.isHorizontal());
        if (list.size() > 0) {
            ActivityPartitionPresentation activityPartitionPresentation2;
            ActivityPartition activityPartition;
            ActivityPartitionPresentation activityPartitionPresentation3;
            ActivityPartitionPresentation activityPartitionPresentation4 = null;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                activityPartitionPresentation3 = list.get(i2);
                if (!PartitionUtil.b(activityPartitionPresentation, activityPartitionPresentation3)) continue;
                activityPartitionPresentation4 = activityPartitionPresentation3;
                break;
            }
            if (activityPartitionPresentation4 == null && (activityPartition = (ActivityPartition)activityPartitionPresentation.getModel()).getSubpartitions().size() == 0 && (activityPartitionPresentation2 = PartitionUtil.a(activityPartitionPresentation, activityPartitionPresentation3 = list.get(list.size() - 1))) != null) {
                return PartitionUtil.c(activityPartitionPresentation2, activityPartitionPresentation3);
            }
        }
        return activityPartitionPresentation.getMyNameBlockHeight();
    }

    private static double c(ActivityPartitionPresentation activityPartitionPresentation, ActivityPartitionPresentation activityPartitionPresentation2) {
        double d2 = activityPartitionPresentation.getMyNameBlockHeight();
        ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
        ActivityPartition activityPartition2 = (ActivityPartition)activityPartitionPresentation2.getModel();
        while (!activityPartition.equals(activityPartition2)) {
            d2 += activityPartitionPresentation2.getMyNameBlockHeight();
            activityPartition2 = activityPartition2.getSuperPartition();
            activityPartitionPresentation2 = (ActivityPartitionPresentation)Presentations.getPresentations((EObject)activityPartition2).get(0);
        }
        return d2;
    }

    public static double getAllSpanSum(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        double d2 = 0.0;
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, bl);
        if (activityPartition != null) {
            EList eList = activityPartition.getSubpartitions();
            for (int i2 = 0; i2 < eList.size(); ++i2) {
                ActivityPartition activityPartition2 = (ActivityPartition)eList.get(i2);
                List<Presentation> list = Presentations.getPresentations((EObject)activityPartition2);
                if (list.size() <= 0) continue;
                ActivityPartitionPresentation activityPartitionPresentation = (ActivityPartitionPresentation)list.get(0);
                d2 += activityPartitionPresentation.getSpan();
            }
        }
        return d2;
    }

    public static double getSuperSpan(ActivityPartitionPresentation activityPartitionPresentation, boolean bl) {
        ActivityPartitionPresentation activityPartitionPresentation2;
        ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
        ActivityPartition activityPartition2 = activityPartition.getSuperPartition();
        if (activityPartition2 != null && (activityPartitionPresentation2 = PartitionUtil.getPresentation(activityPartition2)) != null) {
            if (bl) {
                return Math.max(activityPartitionPresentation2.getSpan(), PartitionUtil.getSuperSpan(activityPartitionPresentation2, bl));
            }
            return activityPartitionPresentation2.getSpan();
        }
        return 0.0;
    }

    public static double getAllChildrenSpan(ActivityPartitionPresentation activityPartitionPresentation) {
        double d2 = 0.0;
        ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
        EList eList = activityPartition.getSubpartitions();
        for (int i2 = 0; i2 < eList.size(); ++i2) {
            ActivityPartitionPresentation activityPartitionPresentation2 = PartitionUtil.getPresentation((ActivityPartition)eList.get(i2));
            if (activityPartitionPresentation2 == null) continue;
            d2 += activityPartitionPresentation2.getSpan();
        }
        return d2;
    }

    public static void alignLengthOfCrossingSwimlanes(UMLActivityDiagram uMLActivityDiagram, ActivityPartitionPresentation activityPartitionPresentation) {
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePss(uMLActivityDiagram, !activityPartitionPresentation.isHorizontal());
        for (ActivityPartitionPresentation activityPartitionPresentation2 : list) {
            if (activityPartitionPresentation2.getPartition().getSubpartitions().size() != 0) continue;
            activityPartitionPresentation2.resize();
        }
    }

    public static void alignLastSpanOfCrossingSwimlane(UMLActivityDiagram uMLActivityDiagram, ActivityPartitionPresentation activityPartitionPresentation) {
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePs(uMLActivityDiagram);
        for (ActivityPartitionPresentation activityPartitionPresentation2 : list) {
            if (activityPartitionPresentation2.isHorizontal() == activityPartitionPresentation.isHorizontal()) continue;
            ActivityPartitionPresentation activityPartitionPresentation3 = PartitionUtil.getLastLane(activityPartitionPresentation2);
            double d2 = 100.0;
            if (activityPartitionPresentation2.isHorizontal()) {
                double d3 = activityPartitionPresentation.getMaxY();
                d2 = d3 - activityPartitionPresentation3.getMinY();
            } else {
                double d4 = activityPartitionPresentation.getMaxX();
                d2 = d4 - activityPartitionPresentation3.getMinX();
            }
            activityPartitionPresentation3.setSpan(d2);
            break;
        }
    }

    public static ActivityPartitionPresentation getLastLane(ActivityPartitionPresentation activityPartitionPresentation) {
        ActivityPartitionPresentation activityPartitionPresentation2 = activityPartitionPresentation.getNextLane();
        while (activityPartitionPresentation2 != null) {
            activityPartitionPresentation = activityPartitionPresentation2;
            activityPartitionPresentation2 = activityPartitionPresentation.getNextLane();
        }
        return activityPartitionPresentation;
    }

    public static boolean isCrossSwimlane(UMLActivityDiagram uMLActivityDiagram) {
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePs(uMLActivityDiagram);
        ActivityPartitionPresentation activityPartitionPresentation = list.get(0);
        boolean bl = activityPartitionPresentation.isHorizontal();
        for (int i2 = 1; i2 < list.size(); ++i2) {
            ActivityPartitionPresentation activityPartitionPresentation2 = list.get(i2);
            if (bl == activityPartitionPresentation2.isHorizontal()) continue;
            return true;
        }
        return false;
    }

    public static boolean isLastLaneOfSameDirection(ActivityPartitionPresentation activityPartitionPresentation) {
        boolean bl = activityPartitionPresentation.isHorizontal();
        UMLActivityDiagram uMLActivityDiagram = (UMLActivityDiagram)activityPartitionPresentation.getDiagram();
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, bl);
        return activityPartition == null || activityPartition.getSubpartitions().size() == 1 && activityPartition.getSubpartitions().get(0) == activityPartitionPresentation.getModel();
    }

    public static boolean hasTopSwimlane(UMLActivityDiagram uMLActivityDiagram, ActivityPartitionPresentation activityPartitionPresentation) {
        boolean bl = activityPartitionPresentation.isHorizontal();
        Activity activity = uMLActivityDiagram.getActivityGraph();
        EList eList = activity.getPartitions();
        for (int i2 = 0; i2 < eList.size(); ++i2) {
            ActivityPartition activityPartition = (ActivityPartition)eList.get(i2);
            ActivityPartitionPresentation activityPartitionPresentation2 = (ActivityPartitionPresentation)Presentations.getPresentations((EObject)activityPartition).get(0);
            if (activityPartitionPresentation2.isHorizontal() != bl) continue;
            return true;
        }
        return false;
    }

    public static ActivityPartitionPresentation getTopHorizontalSwimlanePs(UMLActivityDiagram uMLActivityDiagram) {
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, true);
        if (activityPartition != null) {
            return (ActivityPartitionPresentation)Presentations.getPresentations((EObject)activityPartition).get(0);
        }
        return null;
    }

    public static ActivityPartitionPresentation getTopVerticalSwimlanePs(UMLActivityDiagram uMLActivityDiagram) {
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, false);
        if (activityPartition != null) {
            return (ActivityPartitionPresentation)Presentations.getPresentations((EObject)activityPartition).get(0);
        }
        return null;
    }

    public static ActivityPartitionPresentation getLowestLastChildPartitionPs(ActivityPartitionPresentation activityPartitionPresentation) {
        ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
        EList eList = activityPartition.getSubpartitions();
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePsFromModel((List<ActivityPartition>)eList);
        PartitionUtil.sortSwimlanePs(list, activityPartitionPresentation.isHorizontal());
        if (list.size() > 0) {
            ActivityPartitionPresentation activityPartitionPresentation2 = null;
            for (int i2 = 0; i2 < list.size() && (activityPartitionPresentation2 = list.get(i2)).getNextLane() != null; ++i2) {
            }
            return PartitionUtil.getLowestLastChildPartitionPs(activityPartitionPresentation2);
        }
        return activityPartitionPresentation;
    }

    public static List<ActivityPartitionPresentation> getSameLevelPartitionPss(ActivityPartitionPresentation activityPartitionPresentation) {
        ActivityPartition activityPartition2 = ((ActivityPartition)activityPartitionPresentation.getModel()).getSuperPartition();
        EList eList = activityPartition2.getSubpartitions();
        return eList.stream().map(activityPartition -> PartitionUtil.getPresentation(activityPartition)).collect(Collectors.toList());
    }

    public static ActivityPartitionPresentation getLowerLevelLastChildPartitionPs(ActivityPartitionPresentation activityPartitionPresentation) {
        if (activityPartitionPresentation == null || activityPartitionPresentation.getModel() == null) {
            return null;
        }
        ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
        EList eList = activityPartition.getSubpartitions();
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePsFromModel((List<ActivityPartition>)eList);
        PartitionUtil.sortSwimlanePs(list, activityPartitionPresentation.isHorizontal());
        if (list.size() > 0) {
            ActivityPartitionPresentation activityPartitionPresentation2 = null;
            for (int i2 = 0; i2 < list.size() && (activityPartitionPresentation2 = list.get(i2)).getNextLane() != null; ++i2) {
            }
            return activityPartitionPresentation2;
        }
        return null;
    }

    public static void resizeAllPartitionPsHavingNoChild(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        List<ActivityPartitionPresentation> list = PartitionUtil.getSwimlanePss(uMLActivityDiagram, bl);
        ArrayList<ActivityPartitionPresentation> arrayList = new ArrayList<ActivityPartitionPresentation>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ActivityPartitionPresentation activityPartitionPresentation = list.get(i2);
            ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
            if (activityPartition == null || activityPartition.getSubpartitions().size() != 0) continue;
            arrayList.add(activityPartitionPresentation);
        }
        PartitionUtil.a(arrayList);
    }

    public static void resizeAllPartitionPsHavingNoChild(UMLActivityDiagram uMLActivityDiagram) {
        PartitionUtil.resizeAllPartitionPsHavingNoChild(uMLActivityDiagram, true);
        PartitionUtil.resizeAllPartitionPsHavingNoChild(uMLActivityDiagram, false);
    }

    private static void a(List<ActivityPartitionPresentation> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ActivityPartitionPresentation activityPartitionPresentation = list.get(i2);
            activityPartitionPresentation.resize();
        }
    }

    public static void getDeepestChildren(ActivityPartition activityPartition, List<ActivityPartition> list) {
        EList eList = activityPartition.getSubpartitions();
        if (eList.size() == 0) {
            list.add(activityPartition);
        } else {
            for (int i2 = 0; i2 < eList.size(); ++i2) {
                ActivityPartition activityPartition2 = (ActivityPartition)eList.get(i2);
                PartitionUtil.getDeepestChildren(activityPartition2, list);
            }
        }
    }

    public static void getAllChildren(ActivityPartition activityPartition, List<ActivityPartition> list) {
        EList eList = activityPartition.getSubpartitions();
        for (int i2 = 0; i2 < eList.size(); ++i2) {
            ActivityPartition activityPartition2 = (ActivityPartition)eList.get(i2);
            list.add(activityPartition2);
            PartitionUtil.getAllChildren(activityPartition2, list);
        }
    }

    public static Set<ActivityPartition> getAllChildren(ActivityPartition activityPartition) {
        HashSet<ActivityPartition> hashSet = new HashSet<ActivityPartition>();
        for (ActivityPartition activityPartition2 : activityPartition.getSubpartitions()) {
            hashSet.add(activityPartition2);
            hashSet.addAll(PartitionUtil.getAllChildren(activityPartition2));
        }
        return hashSet;
    }

    public static boolean isDeepest(ActivityPartition activityPartition) {
        EList eList = activityPartition.getSubpartitions();
        return eList.size() == 0;
    }

    public static ActivityPartitionPresentation getPresentation(ActivityPartition activityPartition) {
        ActivityPartitionPresentation activityPartitionPresentation = null;
        List<Presentation> list = Presentations.getPresentations((EObject)activityPartition);
        if (list.size() > 0) {
            activityPartitionPresentation = (ActivityPartitionPresentation)list.get(0);
        }
        return activityPartitionPresentation;
    }

    public static List<ActivityPartitionPresentation> getPresentations(List<ActivityPartition> list) {
        ArrayList<ActivityPartitionPresentation> arrayList = new ArrayList<ActivityPartitionPresentation>();
        for (ActivityPartition activityPartition : list) {
            ActivityPartitionPresentation activityPartitionPresentation = PartitionUtil.getPresentation(activityPartition);
            if (activityPartitionPresentation == null) continue;
            arrayList.add(activityPartitionPresentation);
        }
        return arrayList;
    }

    public static void moveAll(UMLActivityDiagram uMLActivityDiagram, double d2, boolean bl, boolean bl2) {
        ActivityPartitionPresentation activityPartitionPresentation;
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, bl);
        if (activityPartition != null && (activityPartitionPresentation = PartitionUtil.getPresentation(activityPartition)) != null) {
            Vec2d vec2d = null;
            vec2d = bl ? new Vec2d(0.0, d2) : new Vec2d(d2, 0.0);
            activityPartitionPresentation.move(vec2d, false, bl2, false);
        }
    }

    public static void moveContentsAndOtherPresentation(UMLActivityDiagram uMLActivityDiagram, double d2, boolean bl) {
        Object object;
        int n2;
        List<Presentation> list;
        List<ActivityPartitionPresentation> list2 = PartitionUtil.getOrderedSwimlanePs(uMLActivityDiagram, bl);
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            list = list2.get(i2);
            ActivityPartition object22 = (ActivityPartition)list.getModel();
            EList eList = object22.getNodes();
            for (int i3 = 0; i3 < eList.size(); ++i3) {
                ActivityNodePresentation activityNodePresentation;
                ActivityNode activityNode = (ActivityNode)eList.get(i3);
                List<Presentation> list3 = Presentations.getPresentations((EObject)activityNode);
                if (list3.size() <= 0 || arrayList.contains(activityNodePresentation = (ActivityNodePresentation)list3.get(0))) continue;
                arrayList.add(activityNodePresentation);
            }
            for (ActivityNode activityNode : object22.getEdges()) {
                arrayList.addAll(Presentations.getPresentations((EObject)activityNode));
            }
        }
        Vec2d vec2d = null;
        vec2d = bl ? new Vec2d(d2, 0.0) : new Vec2d(0.0, d2);
        for (Presentation presentation : arrayList) {
            if (presentation instanceof PinPresentation || !(presentation instanceof JomtPresentation)) continue;
            ((JomtPresentation)presentation).move(vec2d);
        }
        list = uMLActivityDiagram.getPresentations();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (n2 = 0; n2 < list.size(); ++n2) {
            object = list.get(n2);
            if (!PartitionUtil.isMoveTarget((Presentation)object)) continue;
            arrayList2.add(object);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            object = (JomtPresentation)arrayList2.get(n2);
            object.move(vec2d);
        }
    }

    public static boolean isMoveTarget(Presentation presentation) {
        return presentation instanceof TextPresentation || presentation instanceof NotePresentation || presentation instanceof NoteAnchorPresentation || presentation instanceof TextPresentation || presentation instanceof RectPresentation && !(presentation instanceof ActivityPartitionPresentation) && !(presentation instanceof FramePresentation) && !(presentation instanceof ActivityNodePresentation) || presentation instanceof LinePresentation;
    }

    public static boolean isMoveTargetForUML2Convert(Presentation presentation) {
        return presentation instanceof TextPresentation || presentation instanceof NotePresentation || presentation instanceof NoteAnchorPresentation || presentation instanceof TextPresentation || presentation instanceof RectPresentation && !(presentation instanceof ActivityPartitionPresentation) && !(presentation instanceof FramePresentation) || presentation instanceof LinePresentation;
    }

    public static Rectangle2d getOverlapPartitionNamaBlockRectangle2D(UMLActivityDiagram uMLActivityDiagram) {
        ActivityPartitionPresentation activityPartitionPresentation = PartitionUtil.getTopVerticalSwimlanePs(uMLActivityDiagram);
        if (activityPartitionPresentation == null) {
            return null;
        }
        Pnt2d pnt2d = activityPartitionPresentation.getLocation();
        List<ActivityPartitionPresentation> list = PartitionUtil.getOrderedSwimlanePs(uMLActivityDiagram, false);
        if (list.size() == 0) {
            return null;
        }
        ActivityPartitionPresentation activityPartitionPresentation2 = list.get(0);
        ActivityPartitionPresentation activityPartitionPresentation3 = list.get(list.size() - 1);
        Rectangle2d rectangle2d = new Rectangle2d(pnt2d.x, pnt2d.y, activityPartitionPresentation3.getMaxX() - activityPartitionPresentation2.getMinX(), activityPartitionPresentation3.getMyNameBlockHeight() * 2.0);
        return rectangle2d;
    }

    public static Vec2d getOverlapPartitionNamaBlockMoveVector(Rectangle2d rectangle2d, List<JomtPresentation> list) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            double d3;
            JomtPresentation jomtPresentation = list.get(i2);
            Pnt2d pnt2d = jomtPresentation.getLocation();
            if (!(rectangle2d.x < pnt2d.x) || !(rectangle2d.y < pnt2d.y) || !(rectangle2d.x + rectangle2d.width > pnt2d.x) || !(rectangle2d.y + rectangle2d.height > pnt2d.y) || !((d3 = Math.abs(pnt2d.y - (rectangle2d.y + rectangle2d.height))) > d2)) continue;
            d2 = d3;
        }
        if (d2 > 0.0) {
            return new Vec2d(0.0, d2);
        }
        return null;
    }

    public static ActivityPartitionPresentation getReferedSwimlanePsToMoveIn(UMLActivityDiagram uMLActivityDiagram, Pnt2d pnt2d, boolean bl) {
        Pnt2d pnt2d2 = PartitionUtil.getLowestLaneStart(uMLActivityDiagram);
        if (pnt2d.x < pnt2d2.x) {
            return null;
        }
        if (pnt2d.y < pnt2d2.y) {
            return null;
        }
        return PartitionUtil.getReferedSwimlanePs(uMLActivityDiagram, pnt2d, bl);
    }

    public static double getLowestLaneStartY(UMLActivityDiagram uMLActivityDiagram) {
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, false);
        if (activityPartition == null) {
            return Double.NEGATIVE_INFINITY;
        }
        ActivityPartitionPresentation activityPartitionPresentation = PartitionUtil.getLowestLastChildPartitionPs(PartitionUtil.getPresentation(activityPartition));
        return activityPartitionPresentation.getMinY() + activityPartitionPresentation.getNameBlockHeight();
    }

    public static double getLowestLaneStartX(UMLActivityDiagram uMLActivityDiagram) {
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, true);
        if (activityPartition == null) {
            return Double.NEGATIVE_INFINITY;
        }
        ActivityPartitionPresentation activityPartitionPresentation = PartitionUtil.getPresentation(activityPartition);
        ActivityPartitionPresentation activityPartitionPresentation2 = PartitionUtil.getLowestLastChildPartitionPs(activityPartitionPresentation);
        double d2 = activityPartitionPresentation2.getMinX();
        return d2 += activityPartitionPresentation2.getNameBlockHeight();
    }

    public static Pnt2d getLowestLaneStart(UMLActivityDiagram uMLActivityDiagram) {
        double d2 = 0.0;
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, true);
        if (activityPartition == null) {
            d2 = 0.0;
        } else {
            ActivityPartitionPresentation activityPartitionPresentation = PartitionUtil.getPresentation(activityPartition);
            ActivityPartitionPresentation activityPartitionPresentation2 = PartitionUtil.getLowestLastChildPartitionPs(activityPartitionPresentation);
            d2 = activityPartitionPresentation2.getMinX();
            d2 += activityPartitionPresentation2.getNameBlockHeight();
        }
        double d3 = 0.0;
        ActivityPartition activityPartition2 = PartitionUtil.getTopSwimlane(uMLActivityDiagram, false);
        if (activityPartition2 == null) {
            d3 = 0.0;
        } else {
            ActivityPartitionPresentation activityPartitionPresentation = PartitionUtil.getLowestLastChildPartitionPs(PartitionUtil.getPresentation(activityPartition2));
            d3 = activityPartitionPresentation.getMinY() + activityPartitionPresentation.getNameBlockHeight();
        }
        return new Pnt2d(d2, d3);
    }

    public static Map<ActivityPartitionPresentation, List<ActivityPartitionPresentation>> getPartitionPsMapByEachParent(UMLActivityDiagram uMLActivityDiagram) {
        ActivityPartition activityPartition;
        Object object;
        Object object2;
        Object object3;
        HashMap<ActivityPartitionPresentation, List<ActivityPartitionPresentation>> hashMap = new HashMap<ActivityPartitionPresentation, List<ActivityPartitionPresentation>>();
        List<ActivityPartitionPresentation> list = PartitionUtil.getOrderedSwimlanePs(uMLActivityDiagram, false);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ArrayList<ActivityPartitionPresentation> arrayList = new ArrayList<ActivityPartitionPresentation>();
            object3 = list.get(i2);
            object2 = (ActivityPartition)object3.getModel();
            for (int i3 = 0; i3 < list.size(); ++i3) {
                ActivityPartitionPresentation activityPartitionPresentation = list.get(i3);
                object = (ActivityPartition)activityPartitionPresentation.getModel();
                if (object == null || (activityPartition = object.getSuperPartition()) == null || !activityPartition.equals(object2)) continue;
                arrayList.add(activityPartitionPresentation);
            }
            if (arrayList.size() <= 0) continue;
            hashMap.put((ActivityPartitionPresentation)object3, arrayList);
        }
        List<ActivityPartitionPresentation> list2 = PartitionUtil.getOrderedSwimlanePs(uMLActivityDiagram, true);
        for (int i4 = 0; i4 < list2.size(); ++i4) {
            object3 = new ArrayList();
            object2 = list2.get(i4);
            ActivityPartition activityPartition2 = (ActivityPartition)object2.getModel();
            for (int i5 = 0; i5 < list2.size(); ++i5) {
                ActivityPartition activityPartition3;
                object = list2.get(i5);
                activityPartition = (ActivityPartition)object.getModel();
                if (activityPartition == null || (activityPartition3 = activityPartition.getSuperPartition()) == null || !activityPartition3.equals(activityPartition2)) continue;
                object3.add(object);
            }
            if (object3.size() <= 0) continue;
            hashMap.put((ActivityPartitionPresentation)object2, (List<ActivityPartitionPresentation>)object3);
        }
        return hashMap;
    }

    public static Map<Integer, List<ActivityPartitionPresentation>> getLevelPartitionPsMap(Presentation[] presentationArray, boolean bl) {
        List list;
        HashMap<Integer, List<ActivityPartitionPresentation>> hashMap = new HashMap<Integer, List<ActivityPartitionPresentation>>();
        for (int i2 = 0; i2 < presentationArray.length; ++i2) {
            Object object;
            if (!(presentationArray[i2] instanceof ActivityPartitionPresentation) || bl != (object = (ActivityPartitionPresentation)presentationArray[i2]).isHorizontal()) continue;
            list = (ActivityPartition)object.getModel();
            int n2 = PartitionUtil.getLevel((ActivityPartition)list);
            Integer n3 = new Integer(n2);
            Object v = hashMap.get(n3);
            ArrayList<Object> arrayList = null;
            arrayList = v == null ? new ArrayList<Object>() : (ArrayList<Object>)v;
            arrayList.add(object);
            hashMap.put(n3, arrayList);
        }
        for (Object object : hashMap.keySet()) {
            list = (List)hashMap.get(object);
            if (list.size() <= 0) continue;
            ActivityPartitionPresentation activityPartitionPresentation = (ActivityPartitionPresentation)list.get(0);
            PartitionUtil.sortSwimlanePs(list, activityPartitionPresentation.isHorizontal());
        }
        return hashMap;
    }

    public static ActivityPartition getOtherPartitionHaveContents(UMLActivityDiagram uMLActivityDiagram, ActivityNode activityNode, ActivityPartition activityPartition) {
        ActivityPartitionPresentation activityPartitionPresentation = PartitionUtil.getPresentation(activityPartition);
        if (activityPartitionPresentation == null) {
            return null;
        }
        boolean bl = !activityPartitionPresentation.isHorizontal();
        List<ActivityPartitionPresentation> list = PartitionUtil.getOrderedSwimlanePs(uMLActivityDiagram, bl);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ActivityPartitionPresentation activityPartitionPresentation2 = list.get(i2);
            ActivityPartition activityPartition2 = (ActivityPartition)activityPartitionPresentation2.getModel();
            if (activityPartition.equals(activityPartition2)) continue;
            EList eList = activityPartition2.getContainedNodes();
            for (int i3 = 0; i3 < eList.size(); ++i3) {
                ActivityNode activityNode2 = (ActivityNode)eList.get(i3);
                if (!activityNode2.equals(activityNode)) continue;
                return activityPartition2;
            }
        }
        return null;
    }

    public static List<ActivityPartitionPresentation> getSwimlanePssIncludeTop(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        ArrayList<ActivityPartitionPresentation> arrayList = new ArrayList<ActivityPartitionPresentation>();
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, bl);
        if (activityPartition == null) {
            return arrayList;
        }
        ActivityPartitionPresentation activityPartitionPresentation = PartitionUtil.getPresentation(activityPartition);
        if (activityPartitionPresentation != null) {
            arrayList.add(activityPartitionPresentation);
        }
        arrayList.addAll(PartitionUtil.getSwimlanePss(uMLActivityDiagram, bl));
        return arrayList;
    }

    public static void doAlign(UMLActivityDiagram uMLActivityDiagram, ActivityPartitionPresentation activityPartitionPresentation, List<ActivityPartitionPresentation> list) {
        List<ActivityPartitionPresentation> list2 = PartitionUtil.getDeepestPartitionPs(uMLActivityDiagram, activityPartitionPresentation.isHorizontal());
        PartitionUtil.sortSwimlanePs(list2, activityPartitionPresentation.isHorizontal());
        if (list2.size() > 0) {
            for (int i2 = list2.size() - 1; i2 > -1; --i2) {
                ActivityPartitionPresentation activityPartitionPresentation2 = list2.get(i2);
                boolean bl = true;
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    ActivityPartitionPresentation activityPartitionPresentation3 = list.get(i3);
                    if (!activityPartitionPresentation3.equals(activityPartitionPresentation2)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                PartitionUtil.alignLengthOfSwimlanes(uMLActivityDiagram, activityPartitionPresentation2);
                return;
            }
            ActivityPartitionPresentation activityPartitionPresentation4 = list2.get(list2.size() - 1);
            PartitionUtil.alignLengthOfSwimlanes(uMLActivityDiagram, activityPartitionPresentation4);
        }
    }

    public static void doAlign(UMLDiagram uMLDiagram) {
        UMLActivityDiagram uMLActivityDiagram = (UMLActivityDiagram)uMLDiagram;
        PartitionUtil.doAlign(uMLActivityDiagram, false);
        PartitionUtil.doAlign(uMLActivityDiagram, true);
    }

    public static void doAlign(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        List<ActivityPartitionPresentation> list = PartitionUtil.getDeepestPartitionPs(uMLActivityDiagram, bl);
        PartitionUtil.sortSwimlanePs(list, bl);
        if (list.size() > 0) {
            int n2 = list.size() - 1;
            if (n2 > -1) {
                ActivityPartitionPresentation activityPartitionPresentation = list.get(n2);
                PartitionUtil.alignLengthOfSwimlanes(uMLActivityDiagram, activityPartitionPresentation);
                return;
            }
            ActivityPartitionPresentation activityPartitionPresentation = list.get(list.size() - 1);
            PartitionUtil.alignLengthOfSwimlanes(uMLActivityDiagram, activityPartitionPresentation);
        }
    }

    public static void moveOtherPresenations(ActivityPartitionPresentation activityPartitionPresentation, Vec2d vec2d, ActivityPartitionPresentation activityPartitionPresentation2, ActivityPartitionPresentation activityPartitionPresentation3, Vec2d vec2d2) {
        if (vec2d.x == 0.0 && vec2d.y == 0.0) {
            return;
        }
        Pnt2d pnt2d = activityPartitionPresentation.getLocation();
        Pnt2d pnt2d2 = activityPartitionPresentation2.getLocation();
        Rectangle2d rectangle2d = new Rectangle2d(pnt2d.x, pnt2d.y, activityPartitionPresentation.getWidth(), activityPartitionPresentation.getHeight());
        Rectangle2d rectangle2d2 = new Rectangle2d(pnt2d2.x, pnt2d2.y, activityPartitionPresentation3.getMaxX() - activityPartitionPresentation2.getMinX(), activityPartitionPresentation3.getMaxY() - activityPartitionPresentation2.getMinY());
        UMLDiagram uMLDiagram = activityPartitionPresentation.getDiagram();
        List<Presentation> list = uMLDiagram.getPresentations();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Pnt2d pnt2d3;
            JomtPresentation jomtPresentation;
            Presentation presentation = list.get(i2);
            if (presentation instanceof TextPresentation) {
                jomtPresentation = (TextPresentation)presentation;
                pnt2d3 = jomtPresentation.getLocation();
                if (rectangle2d.contains((Point2D)pnt2d3)) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!rectangle2d2.contains((Point2D)pnt2d3)) continue;
                jomtPresentation.move(vec2d2);
                continue;
            }
            if (presentation instanceof NotePresentation) {
                jomtPresentation = (NotePresentation)presentation;
                pnt2d3 = jomtPresentation.getLocation();
                if (rectangle2d.contains((Point2D)pnt2d3)) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!rectangle2d2.contains((Point2D)pnt2d3)) continue;
                jomtPresentation.move(vec2d2);
                continue;
            }
            if (presentation instanceof NoteAnchorPresentation) {
                int n2;
                jomtPresentation = (NoteAnchorPresentation)presentation;
                pnt2d3 = jomtPresentation.getAllPoints().toArray(new Pnt2d[0]);
                boolean bl = false;
                for (n2 = 0; n2 < ((Pnt2d)pnt2d3).length; ++n2) {
                    Pnt2d pnt2d4 = pnt2d3[n2];
                    if (!rectangle2d.contains((Point2D)pnt2d4)) continue;
                    bl = true;
                    break;
                }
                n2 = 0;
                for (int i3 = 0; i3 < ((Pnt2d)pnt2d3).length; ++i3) {
                    Pnt2d pnt2d5 = pnt2d3[i3];
                    if (!rectangle2d2.contains((Point2D)pnt2d5)) continue;
                    n2 = 1;
                    break;
                }
                if (bl) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (n2 == 0) continue;
                jomtPresentation.move(vec2d2);
                continue;
            }
            if (presentation instanceof TextPresentation) {
                jomtPresentation = (TextPresentation)presentation;
                pnt2d3 = jomtPresentation.getLocation();
                if (rectangle2d.contains((Point2D)pnt2d3)) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!rectangle2d2.contains((Point2D)pnt2d3)) continue;
                jomtPresentation.move(vec2d2);
                continue;
            }
            if (presentation instanceof LinePresentation) {
                jomtPresentation = (LinePresentation)presentation;
                pnt2d3 = jomtPresentation.getLocation();
                if (rectangle2d.contains((Point2D)pnt2d3)) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!rectangle2d2.contains((Point2D)pnt2d3)) continue;
                jomtPresentation.move(vec2d2);
                continue;
            }
            if (!(presentation instanceof RectPresentation) || presentation instanceof ActivityPartitionPresentation || presentation instanceof FramePresentation) continue;
            jomtPresentation = (RectPresentation)presentation;
            pnt2d3 = jomtPresentation.getLocation();
            if (rectangle2d.contains((Point2D)pnt2d3)) {
                jomtPresentation.move(vec2d);
                jomtPresentation.setChanged();
                continue;
            }
            if (!rectangle2d2.contains((Point2D)pnt2d3)) continue;
            jomtPresentation.move(vec2d2);
        }
    }

    public static void moveOtherPresenations(ActivityPartitionPresentation activityPartitionPresentation, Vec2d vec2d) {
        PartitionUtil.moveOtherPresenations(activityPartitionPresentation, vec2d, false);
    }

    public static void moveOtherPresenations(ActivityPartitionPresentation activityPartitionPresentation, Vec2d vec2d, boolean bl) {
        if (vec2d.x == 0.0 && vec2d.y == 0.0) {
            return;
        }
        Pnt2d pnt2d = activityPartitionPresentation.getLocation();
        Rectangle2d rectangle2d = new Rectangle2d(pnt2d.x, pnt2d.y, activityPartitionPresentation.getWidth(), activityPartitionPresentation.getHeight());
        UMLDiagram uMLDiagram = activityPartitionPresentation.getDiagram();
        if (uMLDiagram == null) {
            return;
        }
        List<Presentation> list = uMLDiagram.getPresentations();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Pnt2d pnt2d2;
            JomtPresentation jomtPresentation;
            Presentation presentation = list.get(i2);
            if (presentation instanceof TextPresentation) {
                jomtPresentation = (TextPresentation)presentation;
                pnt2d2 = jomtPresentation.getLocation();
                if (rectangle2d.contains((Point2D)pnt2d2)) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl) continue;
                if (!activityPartitionPresentation.isHorizontal() && rectangle2d.x <= pnt2d2.x) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl || !activityPartitionPresentation.isHorizontal() || !(rectangle2d.y <= pnt2d2.y)) continue;
                jomtPresentation.move(vec2d);
                continue;
            }
            if (presentation instanceof NotePresentation) {
                jomtPresentation = (NotePresentation)presentation;
                pnt2d2 = jomtPresentation.getLocation();
                if (rectangle2d.contains((Point2D)pnt2d2)) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl) continue;
                if (!activityPartitionPresentation.isHorizontal() && rectangle2d.x <= pnt2d2.x) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl || !activityPartitionPresentation.isHorizontal() || !(rectangle2d.y <= pnt2d2.y)) continue;
                jomtPresentation.move(vec2d);
                continue;
            }
            if (presentation instanceof NoteAnchorPresentation) {
                jomtPresentation = (NoteAnchorPresentation)presentation;
                pnt2d2 = jomtPresentation.getAllPoints().toArray(new Pnt2d[0]);
                boolean bl2 = false;
                double d2 = 0.0;
                double d3 = 0.0;
                for (int i3 = 0; i3 < ((Pnt2d)pnt2d2).length; ++i3) {
                    Pnt2d pnt2d3 = pnt2d2[i3];
                    if (rectangle2d.contains((Point2D)pnt2d3)) {
                        bl2 = true;
                    }
                    if (pnt2d3.x > d2) {
                        d2 = pnt2d3.x;
                    }
                    if (!(pnt2d3.y > d3)) continue;
                    d3 = pnt2d3.y;
                }
                if (bl2) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl) continue;
                if (!activityPartitionPresentation.isHorizontal() && rectangle2d.x <= d2) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl || !activityPartitionPresentation.isHorizontal() || !(rectangle2d.y <= d3)) continue;
                jomtPresentation.move(vec2d);
                continue;
            }
            if (presentation instanceof TextPresentation) {
                jomtPresentation = (TextPresentation)presentation;
                pnt2d2 = jomtPresentation.getLocation();
                if (rectangle2d.contains((Point2D)pnt2d2)) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl) continue;
                if (!activityPartitionPresentation.isHorizontal() && rectangle2d.x <= pnt2d2.x) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl || !activityPartitionPresentation.isHorizontal() || !(rectangle2d.y <= pnt2d2.y)) continue;
                jomtPresentation.move(vec2d);
                continue;
            }
            if (presentation instanceof LinePresentation) {
                jomtPresentation = (LinePresentation)presentation;
                pnt2d2 = jomtPresentation.getLocation();
                if (rectangle2d.contains((Point2D)pnt2d2)) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl) continue;
                if (!activityPartitionPresentation.isHorizontal() && rectangle2d.x <= pnt2d2.x) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl || !activityPartitionPresentation.isHorizontal() || !(rectangle2d.y <= pnt2d2.y)) continue;
                jomtPresentation.move(vec2d);
                continue;
            }
            if (presentation instanceof ForkNodePresentation) {
                jomtPresentation = (ForkNodePresentation)presentation;
                pnt2d2 = jomtPresentation.getLocation();
                if (!jomtPresentation.isSwimlaneIndependent()) continue;
                if (rectangle2d.contains((Point2D)pnt2d2)) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl) continue;
                if (!activityPartitionPresentation.isHorizontal() && rectangle2d.x <= pnt2d2.x) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl || !activityPartitionPresentation.isHorizontal() || !(rectangle2d.y <= pnt2d2.y)) continue;
                jomtPresentation.move(vec2d);
                continue;
            }
            if (presentation instanceof JoinNodePresentation) {
                jomtPresentation = (JoinNodePresentation)presentation;
                pnt2d2 = jomtPresentation.getLocation();
                if (!jomtPresentation.isSwimlaneIndependent()) continue;
                if (rectangle2d.contains((Point2D)pnt2d2)) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl) continue;
                if (!activityPartitionPresentation.isHorizontal() && rectangle2d.x <= pnt2d2.x) {
                    jomtPresentation.move(vec2d);
                    continue;
                }
                if (!bl || !activityPartitionPresentation.isHorizontal() || !(rectangle2d.y <= pnt2d2.y)) continue;
                jomtPresentation.move(vec2d);
                continue;
            }
            if (!(presentation instanceof RectPresentation) || presentation instanceof ActivityPartitionPresentation || presentation instanceof FramePresentation || presentation instanceof ActivityNodePresentation) continue;
            jomtPresentation = (RectPresentation)presentation;
            pnt2d2 = jomtPresentation.getLocation();
            if (rectangle2d.contains((Point2D)pnt2d2)) {
                jomtPresentation.move(vec2d);
                continue;
            }
            if (!bl) continue;
            if (!activityPartitionPresentation.isHorizontal() && rectangle2d.x <= pnt2d2.x) {
                jomtPresentation.move(vec2d);
                continue;
            }
            if (!bl || !activityPartitionPresentation.isHorizontal() || !(rectangle2d.y <= pnt2d2.y)) continue;
            jomtPresentation.move(vec2d);
        }
    }

    public static void resetLoc(ActivityPartition activityPartition) {
        ActivityPartition activityPartition2 = activityPartition.getSuperPartition();
        if (activityPartition2 != null && !Presentations.getPresentations((EObject)activityPartition2).isEmpty()) {
            ActivityPartitionPresentation activityPartitionPresentation = PartitionUtil.getPresentation(activityPartition2);
            ActivityPartitionPresentation activityPartitionPresentation2 = PartitionUtil.getPresentation(activityPartition);
            double d2 = activityPartitionPresentation.getMyNameBlockHeight();
            Pnt2d pnt2d = activityPartitionPresentation2.getLocation();
            if (activityPartitionPresentation2.isHorizontal()) {
                if (pnt2d.x != activityPartitionPresentation.getLocation().x + d2) {
                    Pnt2d pnt2d2 = new Pnt2d(activityPartitionPresentation.getLocation().x + d2, activityPartitionPresentation2.getLocation().y);
                    activityPartitionPresentation2.setLocation(pnt2d2);
                    double d3 = pnt2d2.x - pnt2d.x;
                    double d4 = pnt2d2.y - pnt2d.y;
                    PartitionUtil.a(activityPartitionPresentation2, d3, d4);
                }
            } else if (pnt2d.y != activityPartitionPresentation.getLocation().y + d2) {
                Pnt2d pnt2d3 = new Pnt2d(activityPartitionPresentation2.getLocation().x, activityPartitionPresentation.getLocation().y + d2);
                activityPartitionPresentation2.setLocation(pnt2d3);
                double d5 = pnt2d3.x - pnt2d.x;
                double d6 = pnt2d3.y - pnt2d.y;
                PartitionUtil.a(activityPartitionPresentation2, d5, d6);
            }
        }
    }

    public static void updatePartition(ActivityPartitionPresentation activityPartitionPresentation) {
        UMLActivityDiagram uMLActivityDiagram = (UMLActivityDiagram)activityPartitionPresentation.getDiagram();
        int n2 = uMLActivityDiagram.getVerticalMaxLevel() + 1;
        int n3 = uMLActivityDiagram.getHorizontalMaxLevel() + 1;
        if (PartitionUtil.getTopSwimlane(uMLActivityDiagram, activityPartitionPresentation.isHorizontal()) == activityPartitionPresentation.getPartition() && n2 > 0 && n3 > 0) {
            ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, true);
            ActivityPartition activityPartition2 = PartitionUtil.getTopSwimlane(uMLActivityDiagram, false);
            if (activityPartition != null && activityPartition2 != null) {
                ActivityPartitionPresentation activityPartitionPresentation2 = PartitionUtil.getPresentation(activityPartition);
                ActivityPartitionPresentation activityPartitionPresentation3 = PartitionUtil.getPresentation(activityPartition2);
                Pnt2d pnt2d = activityPartitionPresentation2.getLocation();
                Pnt2d pnt2d2 = activityPartitionPresentation3.getLocation();
                double d2 = (double)n3 * activityPartitionPresentation2.getMyNameBlockHeight();
                double d3 = (double)n2 * activityPartitionPresentation3.getMyNameBlockHeight();
                if (activityPartitionPresentation.isHorizontal()) {
                    if (activityPartitionPresentation2.getFirstSubSwimlane().getLocation().y != pnt2d.y) {
                        Pnt2d pnt2d3 = activityPartitionPresentation2.getLocation();
                        Pnt2d pnt2d4 = new Pnt2d(pnt2d.x, activityPartitionPresentation2.getFirstSubSwimlane().getLocation().y);
                        activityPartitionPresentation2.setLocation(pnt2d4);
                        double d4 = pnt2d4.x - pnt2d3.x;
                        double d5 = pnt2d4.y - pnt2d3.y;
                        PartitionUtil.a(activityPartitionPresentation, d4, d5);
                    }
                    double d6 = pnt2d2.y + d3 - pnt2d.y;
                    PartitionUtil.moveAll(uMLActivityDiagram, d6, true, false);
                } else {
                    if (activityPartitionPresentation3.getFirstSubSwimlane().getLocation().x != pnt2d2.x) {
                        Pnt2d pnt2d5 = activityPartitionPresentation3.getLocation();
                        Pnt2d pnt2d6 = new Pnt2d(activityPartitionPresentation3.getFirstSubSwimlane().getLocation().x, pnt2d2.y);
                        activityPartitionPresentation3.setLocation(pnt2d6);
                        double d7 = pnt2d6.x - pnt2d5.x;
                        double d8 = pnt2d6.y - pnt2d5.y;
                        PartitionUtil.a(activityPartitionPresentation, d7, d8);
                    }
                    double d9 = pnt2d.x + d2 - pnt2d2.x;
                    PartitionUtil.moveAll(uMLActivityDiagram, d9, false, false);
                }
            }
        }
    }

    private static double a(Font font, double d2, int n2, List<Presentation> list) {
        ActivityPartitionPresentation activityPartitionPresentation;
        if (list.get(n2) instanceof ActivityPartitionPresentation && (activityPartitionPresentation = (ActivityPartitionPresentation)list.get(n2)).getPartition().getSuperPartition() != null && d2 != PartitionUtil.getNameBlockHeight(activityPartitionPresentation, font)) {
            d2 = PartitionUtil.getNameBlockHeight(activityPartitionPresentation, font);
        }
        return d2;
    }

    public static double getNameBlockHeight(ActivityPartitionPresentation activityPartitionPresentation, Font font) {
        String string = activityPartitionPresentation.getName();
        if (string == null) {
            string = "m";
        }
        double d2 = JomtFontUtilities.computeStringHeight(font, string);
        double d3 = 10.0 + d2 + 10.0;
        return d3;
    }

    public static double canResizedMinValue(ActivityPartitionPresentation activityPartitionPresentation) {
        double d2 = activityPartitionPresentation.getDefaultSpan() - activityPartitionPresentation.getSpan();
        return d2;
    }

    public static double getDifferentSpanLength(ActivityPartitionPresentation activityPartitionPresentation, ActivityPartitionPresentation activityPartitionPresentation2) {
        if (activityPartitionPresentation.isHorizontal() != activityPartitionPresentation2.isHorizontal()) {
            return 0.0;
        }
        if (activityPartitionPresentation.isHorizontal()) {
            return activityPartitionPresentation.getLocation().getX() - activityPartitionPresentation2.getLocation().getX();
        }
        return activityPartitionPresentation.getLocation().getY() - activityPartitionPresentation2.getLocation().getY();
    }

    public static ActivityPartitionPresentation getNotDemensionTopSuperSwimlanePs(ActivityPartitionPresentation activityPartitionPresentation) {
        ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation.getModel();
        ActivityPartition activityPartition2 = activityPartition.getSuperPartition();
        ActivityPartitionPresentation activityPartitionPresentation2 = PartitionUtil.getPresentation(activityPartition2);
        if (activityPartition2 != null) {
            if (activityPartition2.getSuperPartition() == null) {
                return activityPartitionPresentation;
            }
            return PartitionUtil.getNotDemensionTopSuperSwimlanePs(activityPartitionPresentation2);
        }
        return null;
    }

    public static boolean isDemensionSwimlane(ActivityPartition activityPartition) {
        return activityPartition.getSuperPartition() == null;
    }

    public static int getDgmMaxLevel(UMLActivityDiagram uMLActivityDiagram, boolean bl) {
        int n2 = bl ? uMLActivityDiagram.getHorizontalMaxLevel() : uMLActivityDiagram.getVerticalMaxLevel();
        return n2;
    }

    public static Pnt2d getCossPositeion(UMLActivityDiagram uMLActivityDiagram) {
        ActivityPartitionPresentation activityPartitionPresentation;
        ActivityPartitionPresentation activityPartitionPresentation2;
        int n2 = PartitionUtil.getDeepestPartitionLevel(uMLActivityDiagram, false);
        ActivityPartition activityPartition = PartitionUtil.getTopSwimlane(uMLActivityDiagram, false);
        ArrayList<ActivityPartition> arrayList = new ArrayList<ActivityPartition>();
        if (activityPartition != null) {
            PartitionUtil.getDeepestChildren(activityPartition, arrayList);
        }
        ArrayList<ActivityPartitionPresentation> arrayList2 = new ArrayList<ActivityPartitionPresentation>();
        for (ActivityPartition activityPartition2 : arrayList) {
            int n3 = PartitionUtil.getLevel(activityPartition2);
            if (n3 != n2) continue;
            activityPartitionPresentation2 = PartitionUtil.getPresentation(activityPartition2);
            arrayList2.add(activityPartitionPresentation2);
        }
        double d2 = 0.0;
        if (arrayList2.size() > 0) {
            PartitionUtil.sortSwimlanePs(arrayList2, false);
            ActivityPartitionPresentation activityPartitionPresentation3 = (ActivityPartitionPresentation)arrayList2.get(0);
            activityPartitionPresentation2 = activityPartitionPresentation3.getLocation();
            double d3 = activityPartitionPresentation3.getNameBlockHeight();
            d2 = activityPartitionPresentation2.getY() + d3;
        } else {
            d2 = 0.0;
        }
        int n4 = PartitionUtil.getDeepestPartitionLevel(uMLActivityDiagram, true);
        activityPartitionPresentation2 = PartitionUtil.getTopSwimlane(uMLActivityDiagram, true);
        ArrayList<ActivityPartition> arrayList3 = new ArrayList<ActivityPartition>();
        if (activityPartitionPresentation2 != null) {
            PartitionUtil.getDeepestChildren((ActivityPartition)activityPartitionPresentation2, arrayList3);
        }
        ArrayList<ActivityPartitionPresentation> arrayList4 = new ArrayList<ActivityPartitionPresentation>();
        for (ActivityPartition activityPartition3 : arrayList3) {
            int n5 = PartitionUtil.getLevel(activityPartition3);
            if (n5 != n4) continue;
            activityPartitionPresentation = PartitionUtil.getPresentation(activityPartition3);
            arrayList4.add(activityPartitionPresentation);
        }
        double d4 = 0.0;
        if (arrayList4.size() > 0) {
            PartitionUtil.sortSwimlanePs(arrayList2, true);
            ActivityPartitionPresentation activityPartitionPresentation4 = (ActivityPartitionPresentation)arrayList4.get(0);
            activityPartitionPresentation = activityPartitionPresentation4.getLocation();
            double d5 = activityPartitionPresentation4.getNameBlockHeight();
            d4 = activityPartitionPresentation.getX() + d5;
        } else {
            d4 = 0.0;
        }
        return new Pnt2d(d4, d2);
    }

    public static int getLevel(ActivityPartition activityPartition) {
        return PartitionUtil.a(activityPartition, 0);
    }

    private static int a(ActivityPartition activityPartition, int n2) {
        ActivityPartition activityPartition2 = activityPartition.getSuperPartition();
        if (activityPartition2 == null) {
            return n2;
        }
        return PartitionUtil.a(activityPartition2, ++n2);
    }

    public static Set<ActivityPartition> getAllParentPartitions(ActivityPartition activityPartition) {
        HashSet<ActivityPartition> hashSet = new HashSet<ActivityPartition>();
        for (ActivityPartition activityPartition2 = activityPartition; activityPartition2 != null; activityPartition2 = activityPartition2.getSuperPartition()) {
            hashSet.add(activityPartition2);
        }
        return hashSet;
    }
}

