/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml.util;

import net.astah.jmodel.EntityAccessor;
import net.astah.jmodel.PrimitiveTypeProvider;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.ModelGlobal;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Type;

public class ClassifierUtil {
    public static final String JAVA_LANG_STRING = "java.lang.String";

    public static boolean isJavaCollectionClass(Classifier classifier, String[] stringArray) {
        return ClassifierUtil.a(classifier, new String[]{"java", "util"}, stringArray);
    }

    public static boolean isCSharpCollectionClass(Classifier classifier, String[] stringArray) {
        return ClassifierUtil.a(classifier, new String[]{"System", "Collections", "Generic"}, stringArray);
    }

    public static boolean isCppCollectionClass(Classifier classifier, String[] stringArray) {
        return ClassifierUtil.a(classifier, new String[]{"std"}, stringArray);
    }

    private static boolean a(Classifier classifier, String[] classifier2, String[] stringArray) {
        if (classifier == null || classifier2 == null || stringArray == null) {
            return false;
        }
        Model model = (Model)EntityAccessor.getProjectModel();
        for (String string : stringArray) {
            StringBuilder stringBuilder = new StringBuilder(model.getName());
            for (Classifier classifier3 : classifier2) {
                stringBuilder.append("::");
                stringBuilder.append((String)classifier3);
            }
            Classifier classifier4 = EntityAccessor.getClassiferUnderNamespaceFromName(stringBuilder.toString(), string);
            if (classifier4 != classifier) continue;
            return true;
        }
        if (classifier.getNamespace() instanceof Package && classifier.getNamespace().getName().equals("util") && classifier.getNamespace().getNamespace() instanceof Package && classifier.getNamespace().getNamespace().getName().equals("java") && classifier.getNamespace().getNamespace().getNamespace() == model) {
            try {
                Class<?> classNotFoundException = Class.forName("java.util." + classifier.getName());
                if (ClassifierUtil.a(classNotFoundException, stringArray)) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        return false;
    }

    private static boolean a(Class<?> clazz, String[] stringArray) {
        Class<?>[] classArray;
        if (clazz == null) {
            return false;
        }
        String string = clazz.getName();
        for (String string2 : stringArray) {
            if (!string.equals("java.util." + string2)) continue;
            return true;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (ClassifierUtil.a(clazz2, stringArray)) {
            return true;
        }
        for (Class<?> clazz3 : classArray = clazz.getInterfaces()) {
            if (!ClassifierUtil.a(clazz3, stringArray)) continue;
            return true;
        }
        return false;
    }

    public static Classifier getPrimitiveTypeClassifier(String string) {
        Type type;
        Project project = ModelGlobal.prjManager.getCurrentProject();
        if (project != null && project.doc instanceof PrimitiveTypeProvider && (type = ((PrimitiveTypeProvider)((Object)project.doc)).getPrimitiveType(string)) != null && type instanceof Classifier) {
            return (Classifier)type;
        }
        return null;
    }
}

