/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.constraints;

import com.google.common.base.Strings;
import net.astah.emf.validation.java.ModeledJavaConstraintProvider;
import net.astah.emf.validation.java.annotation.Constraint;
import net.astah.emf.validation.java.annotation.ConstraintTarget;
import net.astah.emf.validation.java.annotation.EvaluationModeType;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.uml2.uml.Classes;
import net.astah.uml2.uml.Classifiers;
import net.astah.uml2.uml.Enumerations;
import net.astah.uml2.uml.NamedElements;
import net.astah.uml2.uml.Packages;
import net.astah.uml2.uml.Properties;
import net.astah.uml2.uml.TemplateBindings;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.uml2.uml.AttributeOwner;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Usage;

@Constraint(evaluationMode=EvaluationModeType.LIVE, severity=ConstraintSeverity.ERROR)
public class UML2ConstraintProvider
extends ModeledJavaConstraintProvider {
    @Constraint(message="%model_element_no_name_error.message", targets={@ConstraintTarget(type=Package.class, events={1, 2}, eFeatures={5}), @ConstraintTarget(type=BehavioredClassifier.class, events={1, 2}, eFeatures={5}), @ConstraintTarget(type=Interface.class, events={1, 2}, eFeatures={5}), @ConstraintTarget(type=DataType.class, events={1, 2}, eFeatures={5}), @ConstraintTarget(type=State.class, events={1, 2}, eFeatures={5}), @ConstraintTarget(type=Operation.class, events={1, 2}, eFeatures={5}), @ConstraintTarget(type=Property.class, events={1, 2}, eFeatures={5}), @ConstraintTarget(type=InteractionUse.class, events={1, 2}, eFeatures={5}), @ConstraintTarget(type=Pseudostate.class, events={1, 2}, eFeatures={5})})
    public IStatus validateHasName(IValidationContext iValidationContext, NamedElement namedElement) {
        String string = iValidationContext.getEventType().isNull() ? namedElement.getName() : (String)iValidationContext.getFeatureNewValue();
        if (Strings.isNullOrEmpty((String)string)) {
            if (namedElement instanceof Property) {
                Property property = (Property)namedElement;
                if (property.getAssociation() != null) {
                    return iValidationContext.createSuccessStatus();
                }
                if (property.getOwner() instanceof Interaction) {
                    return iValidationContext.createSuccessStatus();
                }
                if (property instanceof Port) {
                    return iValidationContext.createSuccessStatus();
                }
            } else {
                PseudostateKind pseudostateKind;
                if (namedElement instanceof Classifier && Classes.isAnonymousBoundClass((Classifier)((Classifier)namedElement))) {
                    return iValidationContext.createSuccessStatus();
                }
                if (namedElement instanceof Pseudostate && (PseudostateKind.ENTRY_POINT_LITERAL.equals((Object)(pseudostateKind = ((Pseudostate)namedElement).getKind())) || PseudostateKind.EXIT_POINT_LITERAL.equals((Object)pseudostateKind))) {
                    return iValidationContext.createSuccessStatus();
                }
            }
            return iValidationContext.createFailureStatus(new Object[]{namedElement});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%classifier_unique_name_error.message", targets={@ConstraintTarget(events={1}, eFeatures={5})})
    public IStatus validateClassifierUniqueness(IValidationContext iValidationContext, Classifier classifier) {
        if (Classifiers.validateClassifierUniqueness((Classifier)classifier)) {
            return iValidationContext.createSuccessStatus();
        }
        return iValidationContext.createFailureStatus(new Object[]{classifier});
    }

    @Constraint(message="%classifier_unique_name_error.message", targets={@ConstraintTarget(type=Package.class, events={3, 5}, eFeatures={26})})
    public IStatus validateMoveClassifierUniqueness(IValidationContext iValidationContext, Package package_) {
        EList eList = package_.getPackagedElements();
        for (PackageableElement packageableElement : eList) {
            if (!(packageableElement instanceof Classifier) || Classifiers.validateClassifierUniqueness((Classifier)((Classifier)packageableElement))) continue;
            return iValidationContext.createFailureStatus(new Object[]{package_});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%classifier_unique_name_error.message", targets={@ConstraintTarget(type=Class.class, events={3, 5}, eFeatures={49}), @ConstraintTarget(type=Interface.class, events={3, 5}, eFeatures={38}), @ConstraintTarget(type=Classifier.class, events={3, 5}, eFeatures={33})})
    public IStatus validateMoveNestedClassifierUniqueness(IValidationContext iValidationContext, Classifier classifier) {
        for (Element element : classifier.allOwnedElements()) {
            if (!(element instanceof Classifier) || Classifiers.validateClassifierUniqueness((Classifier)((Classifier)element))) continue;
            return iValidationContext.createFailureStatus(new Object[]{classifier});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%classifier_loop_error.message", targets={@ConstraintTarget(type=Generalization.class, events={1}, eFeatures={10, 7})})
    public IStatus validateNoCyclesInGeneralization(IValidationContext iValidationContext, Generalization generalization) {
        Classifier classifier = generalization.getGeneral();
        if (classifier != null && !classifier.validateNoCyclesInGeneralization(null, null)) {
            return iValidationContext.createFailureStatus(new Object[]{generalization});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%invalid_inheritance.message", targets={@ConstraintTarget(type=Generalization.class, events={1}, eFeatures={10, 7})})
    public IStatus validateSpecializeType(IValidationContext iValidationContext, Generalization generalization) {
        Classifier classifier = generalization.getSpecific();
        Classifier classifier2 = generalization.getGeneral();
        if (classifier instanceof Class && classifier2 instanceof Class) {
            return iValidationContext.createSuccessStatus();
        }
        if (classifier != null && !classifier.validateSpecializeType(null, null)) {
            return iValidationContext.createFailureStatus(new Object[]{generalization});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%combinedfragment_operator_changed.message", targets={@ConstraintTarget(type=CombinedFragment.class, events={1, 2}, eFeatures={15})})
    public IStatus validateOptLoopBreakNeg(IValidationContext iValidationContext, CombinedFragment combinedFragment) {
        if (!combinedFragment.validateOptLoopBreakNeg(null, null)) {
            return iValidationContext.createFailureStatus(new Object[]{combinedFragment});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%attribute_unique_name_error.message", targets={@ConstraintTarget(events={1}, eFeatures={5})})
    public IStatus validateAttributeUniqueness(IValidationContext iValidationContext, Property property) {
        if (Properties.validateAttributeUniqueness((Property)property)) {
            return iValidationContext.createSuccessStatus();
        }
        return iValidationContext.createFailureStatus(new Object[]{property});
    }

    @Constraint(message="%attribute_unique_name_error.message", targets={@ConstraintTarget(type=StructuredClassifier.class, events={3, 5}, eFeatures={38})})
    public IStatus validateMoveAttributeToClassifierUniqueness(IValidationContext iValidationContext, StructuredClassifier structuredClassifier) {
        return this.a(iValidationContext, (AttributeOwner)structuredClassifier);
    }

    @Constraint(message="%attribute_unique_name_error.message", targets={@ConstraintTarget(type=DataType.class, events={3, 5}, eFeatures={38})})
    public IStatus validateMoveAttributeToDataTypeUniqueness(IValidationContext iValidationContext, DataType dataType) {
        return this.a(iValidationContext, (AttributeOwner)dataType);
    }

    @Constraint(message="%attribute_unique_name_error.message", targets={@ConstraintTarget(type=PrimitiveType.class, events={3, 5}, eFeatures={38})})
    public IStatus validateMoveAttributeToPrimitiveTypeUniqueness(IValidationContext iValidationContext, PrimitiveType primitiveType) {
        return this.a(iValidationContext, (AttributeOwner)primitiveType);
    }

    @Constraint(message="%attribute_unique_name_error.message", targets={@ConstraintTarget(type=Interface.class, events={3, 5}, eFeatures={39})})
    public IStatus validateMoveAttributeToInterfaceUniqueness(IValidationContext iValidationContext, Interface interface_) {
        return this.a(iValidationContext, (AttributeOwner)interface_);
    }

    @Constraint(message="%enumeration_literal_unique_name_error.message", targets={@ConstraintTarget(events={1}, eFeatures={5})})
    public IStatus validateEnumerationLiteralUniqueness(IValidationContext iValidationContext, EnumerationLiteral enumerationLiteral) {
        if (Enumerations.validateEnumerationLiteralUniqueness((EnumerationLiteral)enumerationLiteral)) {
            return iValidationContext.createSuccessStatus();
        }
        return iValidationContext.createFailureStatus(new Object[]{enumerationLiteral});
    }

    @Constraint(message="%enumeration_literal_unique_name_error.message", targets={@ConstraintTarget(type=Enumeration.class, events={3, 5}, eFeatures={38})})
    public IStatus validateMoveAttributeToEnumerationUniqueness(IValidationContext iValidationContext, Enumeration enumeration) {
        return this.a(iValidationContext, (AttributeOwner)enumeration);
    }

    @Constraint(message="%enumeration_literal_unique_name_error.message", targets={@ConstraintTarget(type=Enumeration.class, events={3, 5}, eFeatures={40})})
    public IStatus validateMoveEnumerationLiteralToEnumerationUniqueness(IValidationContext iValidationContext, Enumeration enumeration) {
        return this.a(iValidationContext, enumeration);
    }

    private IStatus a(IValidationContext iValidationContext, Enumeration enumeration) {
        EList eList = enumeration.getOwnedLiterals();
        for (EnumerationLiteral enumerationLiteral : eList) {
            if (Enumerations.validateEnumerationLiteralUniqueness((EnumerationLiteral)enumerationLiteral)) continue;
            return iValidationContext.createFailureStatus(new Object[]{enumeration});
        }
        return iValidationContext.createSuccessStatus();
    }

    private IStatus a(IValidationContext iValidationContext, AttributeOwner attributeOwner) {
        EList eList = attributeOwner.getOwnedAttributes();
        for (Property property : eList) {
            if (Properties.validateAttributeUniqueness((Property)property)) continue;
            return iValidationContext.createFailureStatus(new Object[]{attributeOwner});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%package_unique_name_error.message", targets={@ConstraintTarget(type=Package.class, events={1}, eFeatures={5})})
    public IStatus validatePackageUniqueness(IValidationContext iValidationContext, Package package_) {
        if (Packages.validatePackageUniqueness((Package)package_)) {
            return iValidationContext.createSuccessStatus();
        }
        return iValidationContext.createFailureStatus(new Object[]{package_});
    }

    @Constraint(message="%package_unique_name_error.message", targets={@ConstraintTarget(type=Package.class, events={3, 5}, eFeatures={21, 26})})
    public IStatus validateMovePackageUniqueness(IValidationContext iValidationContext, Package package_) {
        EList eList = package_.getNestedPackages();
        for (Package package_2 : eList) {
            if (Packages.validatePackageUniqueness((Package)package_2)) continue;
            return iValidationContext.createFailureStatus(new Object[]{package_});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%deep_history_exists.message", targets={@ConstraintTarget(type=Region.class, events={3, 5}, eFeatures={23})})
    public IStatus validateDeepHistoryVertexNumber(IValidationContext iValidationContext, Region region) {
        if (!region.validateDeepHistoryVertex(null, null)) {
            return iValidationContext.createFailureStatus(new Object[]{region});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%shallow_history_exists.message", targets={@ConstraintTarget(type=Region.class, events={3, 5}, eFeatures={23})})
    public IStatus validateShalloHistoryVertexNumber(IValidationContext iValidationContext, Region region) {
        if (!region.validateShallowHistoryVertex(null, null)) {
            return iValidationContext.createFailureStatus(new Object[]{region});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%cannot_create_entry_exit_point_for_operaion_statemachine_frame.message", targets={@ConstraintTarget(type=StateMachine.class, events={3, 5}, eFeatures={60})})
    public IStatus validateStateMachineEntryExitConnectionPoint(IValidationContext iValidationContext, StateMachine stateMachine) {
        if (!stateMachine.validateMethod(null, null)) {
            return iValidationContext.createFailureStatus(new Object[]{stateMachine});
        }
        if (stateMachine.getSpecification() instanceof BehavioralFeature) {
            return iValidationContext.createFailureStatus(new Object[]{stateMachine});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%cannot_create_entry_exit_point_for_operaion_submachinestate.message", targets={@ConstraintTarget(type=State.class, events={3, 5}, eFeatures={23})})
    public IStatus validateContainerStateMachineEntryExitConnectionPoint(IValidationContext iValidationContext, State state) {
        StateMachine stateMachine = state.getSubmachine();
        if (stateMachine != null && stateMachine.getSpecification() instanceof BehavioralFeature) {
            return iValidationContext.createFailureStatus(new Object[]{state});
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%initial_exists.message", targets={@ConstraintTarget(type=Region.class, events={3, 5}, eFeatures={23})})
    public IStatus validateInitialExists(IValidationContext iValidationContext, Region region) {
        if (!RuntimeGlobal.sysProp.getBooleanWithDefault("basic.there_is_only_one_initalstate_in_an_statemachinediagram")) {
            return iValidationContext.createSuccessStatus();
        }
        if (region.validateInitialVertex(null, null)) {
            return iValidationContext.createSuccessStatus();
        }
        return iValidationContext.createFailureStatus(new Object[]{region});
    }

    @Constraint(message="%duplicated_realization.message", targets={@ConstraintTarget(type=Class.class, events={3, 5}, eFeatures={44})})
    public IStatus validateInterfaceRealization(IValidationContext iValidationContext, Class clazz) {
        if (Classes.validateInterfaceRealization((Class)clazz)) {
            return iValidationContext.createSuccessStatus();
        }
        return iValidationContext.createFailureStatus(new Object[]{clazz});
    }

    @Constraint(message="%duplicated_usage.message", targets={@ConstraintTarget(type=Usage.class, events={3, 5}, eFeatures={16})})
    public IStatus validateUsage(IValidationContext iValidationContext, Usage usage) {
        EList eList = usage.getClients();
        EList eList2 = usage.getSuppliers();
        for (NamedElement namedElement : eList) {
            for (NamedElement namedElement2 : eList2) {
                if (NamedElements.validateUsage((NamedElement)namedElement, (NamedElement)namedElement2)) continue;
                return iValidationContext.createFailureStatus(new Object[]{usage});
            }
        }
        return iValidationContext.createSuccessStatus();
    }

    @Constraint(message="%forbid_clear_class_name_as_actual.message", targets={@ConstraintTarget(type=Classifier.class, events={1, 2}, eFeatures={5})})
    public IStatus validateSelfAnonymousClassBindingRelationship(IValidationContext iValidationContext, Classifier classifier) {
        String string = iValidationContext.getEventType().isNull() ? classifier.getName() : (String)iValidationContext.getFeatureNewValue();
        if (TemplateBindings.isSelfAnonymousClassBindingRelationship((Classifier)classifier, (String)string)) {
            return iValidationContext.createFailureStatus(new Object[]{classifier});
        }
        return iValidationContext.createSuccessStatus();
    }

    protected String getString(String string) {
        return PropertyManager.getUmlMessageResourceBundle().getString(string);
    }
}

