/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import net.astah.emf.common.transaction.Transactions;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicClassMembers;

@Keep
@KeepPublicClassMembers
public class UML2ResourceInitializer {
    private static final Logger a = LoggerFactory.getLogger(UML2ResourceInitializer.class);

    public static void preload(ResourceSet resourceSet) {
        UML2ResourceInitializer.a(resourceSet, Arrays.asList(URI.createURI((String)"pathmap://UML_PROFILES/Standard.profile.uml"), URI.createURI((String)"pathmap://UML_PROFILES/Ecore.profile.uml"), URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml"), URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml")));
    }

    private static void a(ResourceSet resourceSet, Collection<URI> collection) {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        resourceSetImpl.setURIConverter(resourceSet.getURIConverter());
        resourceSetImpl.setPackageRegistry(resourceSet.getPackageRegistry());
        resourceSetImpl.setResourceFactoryRegistry(resourceSet.getResourceFactoryRegistry());
        Thread thread = new Thread(() -> UML2ResourceInitializer.a(collection, resourceSet, (ResourceSet)resourceSetImpl), "ResourcePreloader");
        thread.setPriority(4);
        thread.setDaemon(true);
        thread.start();
    }

    static void a(ResourceSet resourceSet, Runnable runnable) throws InterruptedException, ExecutionException {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet);
        Transactions.safeRunExclusive((TransactionalEditingDomain)transactionalEditingDomain, (Runnable)runnable).get();
    }

    private static /* synthetic */ void a(Collection collection, ResourceSet resourceSet, ResourceSet resourceSet2) {
        try {
            Thread.sleep(1000L);
            FutureTask<Collection> futureTask = new FutureTask<Collection>(() -> collection.stream().filter(uRI -> {
                Resource resource = resourceSet.getResource(uRI, false);
                return resource == null || !resource.isLoaded();
            }).collect(Collectors.toList()));
            UML2ResourceInitializer.a(resourceSet, futureTask);
            for (URI uRI : futureTask.get()) {
                resourceSet2.getResource(uRI, true);
            }
            UML2ResourceInitializer.a(resourceSet, () -> {
                EList eList = resourceSet.getResources();
                for (Resource resource : new ArrayList(resourceSet2.getResources())) {
                    Resource resource2 = resourceSet.getResource(resource.getURI(), false);
                    if (resource2 == null) {
                        eList.add((Object)resource);
                        continue;
                    }
                    if (!resource2.isLoaded()) {
                        int n2 = eList.indexOf((Object)resource2);
                        eList.set(n2, (Object)resource);
                        continue;
                    }
                    a.info("Discarding duplicated resource: {}", (Object)resource.getURI());
                    resource.unload();
                }
            });
        }
        catch (ExecutionException executionException) {
            a.warn("Failed to preload UML resources", executionException.getCause());
        }
        catch (InterruptedException | CancellationException exception) {
            a.info("Preloading UML resources have been canceled: {}", (Throwable)exception);
            return;
        }
    }
}

