/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml.mindmap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.util.XMLDataWriter;
import net.astah.golf.util.XMLWriter;
import net.astah.jmodel.EntityAccessor;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.uml.mindmap.MMUserIconInfo;
import net.astah.uml.mindmap.UserIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class MMUserIconManager {
    private static MMUserIconManager a;
    private Map<String, MMUserIconInfo> b = new HashMap<String, MMUserIconInfo>();
    private Map<String, MMUserIconInfo> c = new HashMap<String, MMUserIconInfo>();
    private boolean d = true;
    private static final Logger e;

    private MMUserIconManager() {
        if (PropertyManager.getTarget().equals("J")) {
            this.d = false;
        }
    }

    public static MMUserIconManager instance() {
        if (a == null) {
            a = new MMUserIconManager();
        }
        return a;
    }

    public Map<String, MMUserIconInfo> getUserIconInfo() {
        return this.b;
    }

    public MMUserIconInfo getProjectUserIconInfo() {
        return this.c.get("jude.usericons");
    }

    public MMUserIconInfo getSystemUserIconInfo() {
        return this.b.get("jude.usericons");
    }

    public void clearUserIconInfo() {
        try {
            this.a();
        }
        catch (Exception exception) {
            e.error("error has occurred.", (Throwable)exception);
        }
        this.c.clear();
    }

    private void a() throws IOException {
        if (!this.d) {
            return;
        }
        BufferedWriter bufferedWriter = null;
        try {
            String string = PropertyManager.getUserSetFilesFolderName();
            File file = new File(string + File.separator + RuntimeGlobal.sysProp.getDefaultString("jude.mmusericon"));
            e.info("file: {}", (Object)file.getAbsolutePath());
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            bufferedWriter.write(this.a(this.b));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bufferedWriter != null) {
            bufferedWriter.close();
        }
    }

    public void initializeMMUserIconInfo(IJomtEntityStore iJomtEntityStore) {
        this.b();
        this.initializeProjectUserIconInfo(iJomtEntityStore);
    }

    public void initializeProjectUserIconInfo(IJomtEntityStore iJomtEntityStore) {
    }

    private void b() {
        if (!this.d) {
            return;
        }
        String string = this.d();
        if (string != null && string.length() > 0) {
            this.b = MMUserIconManager.decodeUserIconInfo(string);
            if (!this.b.isEmpty()) {
                return;
            }
        }
        this.c();
    }

    private void c() {
        MMUserIconInfo mMUserIconInfo = new MMUserIconInfo("jude.usericons");
        this.b.put(mMUserIconInfo.getName(), mMUserIconInfo);
        try {
            this.a();
        }
        catch (IOException iOException) {
            e.error("error has occurred.", (Throwable)iOException);
        }
    }

    private String d() {
        String string = PropertyManager.getUserSetFilesFolderName();
        File file = new File(string + File.separator + RuntimeGlobal.sysProp.getDefaultString("jude.mmusericon"));
        if (!file.exists()) {
            return null;
        }
        StringWriter stringWriter = null;
        BufferedReader bufferedReader = null;
        try {
            int n2;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            stringWriter = new StringWriter();
            while ((n2 = bufferedReader.read()) != -1) {
                stringWriter.write(n2);
            }
            stringWriter.flush();
            bufferedReader.close();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    e.error("error has occurred.", (Throwable)iOException);
                }
            }
            e.error("error has occurred.", (Throwable)exception);
            return null;
        }
    }

    private String a(Map<String, MMUserIconInfo> map) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            XMLDataWriter xMLDataWriter = new XMLDataWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8")));
            xMLDataWriter.setIndentStep(1);
            MMUserIconManager.a((XMLWriter)xMLDataWriter, map);
            xMLDataWriter.close();
        }
        catch (Exception exception) {
            e.error("error has occurred.", (Throwable)exception);
            return null;
        }
        try {
            return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            e.error("error has occurred.", (Throwable)unsupportedEncodingException);
            return "";
        }
    }

    private static void a(XMLWriter xMLWriter, Map<String, MMUserIconInfo> map) throws SAXException {
        xMLWriter.startDocumentAsUTF_8();
        xMLWriter.startElement("mmUserIcon");
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            MMUserIconInfo mMUserIconInfo = map.get(iterator.next());
            xMLWriter.startElement("mmUserIconInfo");
            xMLWriter.dataElement("name", mMUserIconInfo.getName());
            List<UserIcon> list = mMUserIconInfo.getUserIcons();
            for (UserIcon userIcon : list) {
                String string;
                String string2;
                String string3;
                xMLWriter.startElement("userIcon");
                String string4 = userIcon.getUuid();
                if (string4 != null) {
                    xMLWriter.dataElement("uuid", string4);
                }
                if ((string3 = userIcon.getIconContent()) != null) {
                    xMLWriter.dataElement("iconContent", string3);
                }
                if ((string2 = userIcon.getIconExtension()) != null) {
                    xMLWriter.dataElement("iconExtension", string2);
                }
                if ((string = userIcon.getIconLabel()) != null) {
                    xMLWriter.dataElement("iconLabel", string);
                }
                xMLWriter.endElement("userIcon");
            }
            xMLWriter.endElement("mmUserIconInfo");
        }
        xMLWriter.endElement("mmUserIcon");
        xMLWriter.endDocument();
    }

    public static Map<String, MMUserIconInfo> decodeUserIconInfo(String string) {
        HashMap<String, MMUserIconInfo> hashMap = new HashMap<String, MMUserIconInfo>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(string.getBytes("UTF-8")), "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            Document document = documentBuilder.parse(new InputSource(bufferedReader));
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("mmUserIconInfo");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Element element2 = (Element)nodeList.item(i2);
                NodeList nodeList2 = element2.getElementsByTagName("name");
                Node node = ((Element)nodeList2.item(0)).getFirstChild();
                String string2 = node.getNodeValue();
                MMUserIconInfo mMUserIconInfo = new MMUserIconInfo(string2);
                hashMap.put(mMUserIconInfo.getName(), mMUserIconInfo);
                NodeList nodeList3 = element2.getElementsByTagName("userIcon");
                for (int i3 = 0; i3 < nodeList3.getLength(); ++i3) {
                    Element element3 = (Element)nodeList3.item(i3);
                    String string3 = MMUserIconManager.a(element3, "uuid");
                    String string4 = MMUserIconManager.a(element3, "iconContent");
                    String string5 = MMUserIconManager.a(element3, "iconExtension");
                    String string6 = MMUserIconManager.a(element3, "iconLabel");
                    UserIcon userIcon = new UserIcon(string3, string4, string5, string6);
                    mMUserIconInfo.addUserIcon(userIcon);
                }
            }
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            e.error("error has occurred.", (Throwable)exception);
        }
        return hashMap;
    }

    private static String a(Element element, String string) {
        Node node;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0 && (node = ((Element)nodeList.item(0)).getFirstChild()) != null) {
            return node.getNodeValue();
        }
        return "";
    }

    public void writeProjectUserIconInfo(IEntityStore iEntityStore) {
        if (!this.d) {
            return;
        }
        throw new UnsupportedOperationException("\u672a\u5bfe\u5fdc");
    }

    public void checkProjectUserIconInfoToDelete(IEntityStore iEntityStore, String string) {
        if (!this.d) {
            return;
        }
        if (!this.a(iEntityStore, string)) {
            MMUserIconInfo mMUserIconInfo = this.getProjectUserIconInfo();
            for (int i2 = mMUserIconInfo.getAllUserIcons().size() - 1; i2 >= 0; --i2) {
                UserIcon userIcon = mMUserIconInfo.getAllUserIcons().get(i2);
                if (!userIcon.getUuid().equals(string)) continue;
                mMUserIconInfo.removeUserIcon(userIcon);
                this.writeProjectUserIconInfo(iEntityStore);
                return;
            }
        }
    }

    private boolean a(IEntityStore iEntityStore, String string) {
        List<Diagram> list = EntityAccessor.getAllDiagrams(iEntityStore);
        for (Diagram diagram : list) {
            if (!(diagram instanceof MMDiagram)) continue;
            for (DiagramElement diagramElement : diagram.getOwnedElements()) {
                if (!(diagramElement instanceof MMTopicShape) || ((MMTopicShape)diagramElement).getIcons() == null || !((MMTopicShape)diagramElement).getIcons().contains((Object)string)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        e = LoggerFactory.getLogger(MMUserIconManager.class);
    }
}

