/*
 * Decompiled with CFR 0.152.
 */
package net.astah.model.operations;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.emf.common.ecore.EObjects;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jmodel.DepthUtil;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.PresentationUtil;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.project.Project;
import net.astah.project.Projects;
import net.astah.uml.exception.IllegalModelTypeException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class DiagramOperations {
    private static final Logger a = LoggerFactory.getLogger(DiagramOperations.class);

    public static List<Diagram> getOwningDiagrams(Project project) {
        return DiagramOperations.getOwningDiagrams((EObject)project, false);
    }

    public static List<Diagram> getOwningDiagrams(NamedElement namedElement) {
        return DiagramOperations.getOwningDiagrams((EObject)namedElement, false);
    }

    public static List<Diagram> getOwningDiagrams(EObject eObject, boolean bl) {
        ArrayList<Diagram> arrayList;
        block8: {
            block7: {
                Object object;
                arrayList = new ArrayList<Diagram>();
                if (!(eObject instanceof NamedElement)) break block7;
                Collection collection = UML2Util.getNonNavigableInverseReferences((EObject)eObject);
                for (EStructuralFeature.Setting setting : collection) {
                    object = setting.getEObject();
                    if (!(object instanceof Diagram)) continue;
                    arrayList.add((Diagram)object);
                }
                if (!bl) {
                    return arrayList;
                }
                for (EStructuralFeature.Setting setting : ((NamedElement)eObject).getOwnedElements()) {
                    if (!(setting instanceof NamedElement)) continue;
                    object = DiagramOperations.getOwningDiagrams((EObject)((NamedElement)setting), bl);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Diagram diagram = (Diagram)iterator.next();
                        if (arrayList.contains(diagram)) continue;
                        arrayList.add(diagram);
                    }
                }
                break block8;
            }
            if (!(eObject instanceof Project)) break block8;
            for (Diagram diagram : Projects.getFacetContents((Notifier)eObject, Diagram.class)) {
                arrayList.add(diagram);
            }
            if (!bl) {
                return arrayList;
            }
            for (Diagram diagram : Projects.getFacetContents((Notifier)eObject, NamedElement.class)) {
                arrayList.addAll(DiagramOperations.getOwningDiagrams((EObject)diagram, bl));
            }
        }
        return arrayList;
    }

    public static void setRequirementInitialValueVisibility(UMLDiagram uMLDiagram) {
        uMLDiagram.addStyleMap("requirement.compartment.visibility", RuntimeGlobal.sysProp.getStringWithDefault("sysml.requirement.detail_compartment_visibility"));
        uMLDiagram.addStyleMap("requirement.text.visibility", RuntimeGlobal.sysProp.getStringWithDefault("sysml.requirement.text_visibility"));
        uMLDiagram.addStyleMap("requirement.id.visibility", RuntimeGlobal.sysProp.getStringWithDefault("sysml.requirement.id_visibility"));
        uMLDiagram.addStyleMap("testcase.compartment.visibility", RuntimeGlobal.sysProp.getStringWithDefault("sysml.testcase.detail_compartment_visibility"));
    }

    public static FramePresentation getFramePresentation(Diagram diagram) {
        Iterator iterator = Iterables.filter((Iterable)diagram.getOwnedElements(), FramePresentation.class).iterator();
        if (iterator.hasNext()) {
            FramePresentation framePresentation = (FramePresentation)iterator.next();
            return framePresentation;
        }
        return null;
    }

    public static void addPresentation(Diagram diagram, Presentation presentation, Element element) throws IllegalModelTypeException {
        if (!(diagram instanceof UMLDiagram)) {
            throw new IllegalModelTypeException();
        }
        ((UMLDiagram)diagram).addPresentation(presentation);
        if (element != null) {
            presentation.setModel(element);
        }
    }

    private static boolean a(Diagram diagram) {
        FramePresentation framePresentation = PresentationUtil.getFramePresentation();
        if (framePresentation == null) {
            return false;
        }
        if (RuntimeGlobal.sysProp != null) {
            framePresentation.setVisibility(RuntimeGlobal.sysProp.getBooleanWithDefault("basic.frame_visibility"));
        }
        int n2 = 0;
        if (!diagram.getOwnedElements().isEmpty()) {
            n2 = DepthUtil.getMaxDepth((List<DiagramElement>)diagram.getOwnedElements()) + 1;
        }
        framePresentation.setDepth(n2);
        framePresentation.setLocation(new Pnt2d(10.0, 10.0));
        DiagramOperations.a(framePresentation);
        try {
            DiagramOperations.addPresentation(diagram, framePresentation, null);
        }
        catch (IllegalModelTypeException illegalModelTypeException) {
            a.error("error has occurred.", (Throwable)illegalModelTypeException);
        }
        DiagramOperations.b(diagram);
        return true;
    }

    private static void a(FramePresentation framePresentation) {
        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = new JomtDefaultSizeUtilities(framePresentation);
        if (jomtDefaultSizeUtilities.getDefaultUse()) {
            framePresentation.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
            framePresentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
        } else {
            framePresentation.setSize(640.0, 480.0);
        }
    }

    private static void b(Diagram diagram) {
        FramePresentation framePresentation = DiagramOperations.getFramePresentation(diagram);
        EList eList = diagram.getOwnedElements();
        if (eList.isEmpty()) {
            return;
        }
        for (DiagramElement diagramElement2 : Iterables.filter((Iterable)eList, diagramElement -> !(diagramElement instanceof FramePresentation))) {
            ((Presentation)diagramElement2).addObserver(framePresentation);
        }
    }

    public static boolean addNewFrameIfNeed(Diagram diagram) {
        if (DiagramOperations.isNeedFrame(diagram) && !DiagramOperations.c(diagram)) {
            return DiagramOperations.a(diagram);
        }
        return false;
    }

    protected static boolean isNeedFrame(Diagram diagram) {
        return true;
    }

    private static boolean c(Diagram diagram) {
        return !Iterables.isEmpty((Iterable)Iterables.filter((Iterable)diagram.getOwnedElements(), FramePresentation.class));
    }

    public static EObject getParent(Diagram diagram) {
        if (diagram instanceof UMLDiagram) {
            return ((UMLDiagram)diagram).getParent();
        }
        if (diagram instanceof MMDiagram) {
            return ((MMDiagram)diagram).getParent();
        }
        return null;
    }

    public static boolean onlySelectionAndPopUpMode(Diagram diagram) {
        if (EObjects.isReadOnly((EObject)diagram)) {
            return true;
        }
        if (PropertyManager.getTarget().equals("P") || PropertyManager.getTarget().equals("Y") || !PropertyManager.getTarget().equals("G")) {
            // empty if block
        }
        return false;
    }
}

