/*
 * Decompiled with CFR 0.152.
 */
package net.astah.model.extension;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import net.astah.dd.di.DiagramElement;
import net.astah.emf.edit.provider.ExtraLabelVariant;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.jmodel.ImagePresentation;
import net.astah.jmodel.MMTopicPresentation;
import net.astah.jmodel.ObjectPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.TextPresentation;
import net.astah.jmodel.UMLCommunicationDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.IconResource;
import net.astah.model.extension.Extensions;
import net.astah.model.extension.Hyperlink;
import net.astah.notation.mindmap.MMDiagramElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hyperlinks {
    private static final Logger a = LoggerFactory.getLogger(Hyperlink.class);
    public static final double HYPERLINK_OFFSET = 15.0;

    public static String getHyperlinkName(Hyperlink hyperlink) {
        String string = "";
        if (!hyperlink.getType().equals("model")) {
            string = hyperlink.getName();
        } else {
            EObject eObject = hyperlink.getReference();
            if (eObject == null) {
                string = Hyperlinks.getTitle("projectview.item.no_reference.label");
            } else {
                string = LabelProviders.getText((Object)eObject, (Object)ExtraLabelVariant.MODEL_TREE);
                if (string == null || eObject.eResource() == null || !eObject.eResource().getURI().equals(hyperlink.eResource().getURI())) {
                    string = Hyperlinks.getTitle("projectview.item.no_reference.label");
                }
            }
            string = string.replaceAll("\n", " ");
        }
        return string;
    }

    public static String getHyperlinkComment(Hyperlink hyperlink) {
        return hyperlink.getComment();
    }

    public static Icon getDisplayIcon(Hyperlink hyperlink) {
        Icon icon = null;
        String string = hyperlink.getType();
        if (string.equals("file")) {
            String string2 = hyperlink.getPath() + System.getProperty("file.separator") + hyperlink.getName();
            File file = new File(string2);
            File file2 = null;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                a.error("error has occurred.", (Throwable)iOException);
            }
            if (file2 != null && file2.canRead()) {
                icon = FileSystemView.getFileSystemView().getSystemIcon(file2);
            }
        } else if (string.equals("url")) {
            icon = IconResource.getBrowserIcon();
        } else if (string.equals("model")) {
            EObject eObject = hyperlink.getReference();
            if (eObject instanceof Presentation) {
                UMLDiagram uMLDiagram;
                icon = eObject instanceof MMTopicPresentation ? IconResource.getMMTopicIcon() : (eObject instanceof ObjectPresentation ? ((uMLDiagram = ((ObjectPresentation)eObject).getDiagram()) instanceof UMLCommunicationDiagram ? IconResource.getObjectIcon() : IconResource.getClassifierRoleIcon()) : (eObject instanceof TextPresentation ? IconResource.getTextIcon() : (eObject instanceof ImagePresentation ? IconResource.getImageIcon() : IconResource.getIcon(((Presentation)eObject).getModel()))));
            } else if (eObject instanceof Element) {
                icon = IconResource.getIcon((EObject)((Element)eObject));
            } else if (eObject instanceof MMDiagramElement) {
                try {
                    Object object = LabelProviders.getImage((Object)eObject);
                    if (object != null) {
                        icon = SwingIconRegistry.INSTANCE.getIcon(object);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    a.error("error has occurred.", (Throwable)missingResourceException);
                }
            } else {
                icon = IconResource.getIcon(eObject);
            }
        }
        return icon;
    }

    public static String getDisplayName(Hyperlink hyperlink) {
        if (!hyperlink.getComment().equals("")) {
            return hyperlink.getComment();
        }
        String string = Hyperlinks.getHyperlinkName(hyperlink);
        if (hyperlink.getReference() instanceof DiagramElement) {
            return string + Hyperlinks.getTitle("projectview.item.diagram_element.label");
        }
        return string;
    }

    public static String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static List<Hyperlink> getHyperlinks(EObject eObject) {
        Presentation presentation;
        EObject eObject2 = null;
        if (eObject instanceof Presentation) {
            presentation = (Presentation)eObject;
            eObject2 = presentation.getModel();
        } else {
            eObject2 = eObject;
        }
        if (eObject2 == null) {
            presentation = (Presentation)eObject;
            return Extensions.getHyperlinks((EObject)presentation);
        }
        return Extensions.getHyperlinks((EObject)eObject2);
    }

    public static boolean hasVisibleHyperlinkIcon(EObject eObject) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("hyperlink.diagram_icon_visibility");
        if (!bl) {
            return false;
        }
        List<Hyperlink> list = Hyperlinks.getHyperlinks(eObject);
        return list.size() > 0;
    }
}

