/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jutil;

import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextMeasurer;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.astah.golf.draw.GCanvas;
import net.astah.golf.draw.RenderingHintsHelper;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.GFontChooser;
import net.astah.golf.widget.CCanvas;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.LabelPresentation;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.FontManager;
import net.astah.jomt.jutil.JFont;
import net.astah.jomt.jutil.TextUtil;
import net.astah.model.extension.Preferences;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.project.operations.ProjectOperations;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class JomtFontUtilities {
    private static final String a = "default.font.size";
    private static final String b = "default.font.style";
    private static final String c = "default.font.name";
    public static final String DEFINED_KEY = "sun.font.attributevalues.defined_key";
    private static final String d = "Dialog";
    private static final String e = "PLAIN";
    private static final String f = "12";
    private static final String g = "Dialog,PLAIN,12";
    private static String h;
    private static Map i;
    public static Font defaultFont;
    public static final int MIN_SIZE = 6;
    public static final int MAX_SIZE_FOR_PROJECT = 18;
    public static final int MAX_SIZE = 96;
    private static Dimension j;

    public static Font getDefaultFont() {
        if (defaultFont != null) {
            return defaultFont;
        }
        JFont jFont = JomtFontUtilities.getDefaultJFont();
        Font font = FontManager.getFontFromJFontWithCash(jFont);
        return font;
    }

    public static Font getProjectFont() {
        if (ModelGlobal.prjManager.getCurrentProject() != null) {
            Font font;
            if (ModelGlobal.prjManager.getCurrentProject().projectFont != null) {
                return ModelGlobal.prjManager.getCurrentProject().projectFont;
            }
            ModelGlobal.prjManager.getCurrentProject().projectFont = font = JomtFontUtilities.getProjectFont(ModelGlobal.prjManager.getCurrentProject().doc);
            return font;
        }
        return null;
    }

    public static Font getProjectFont(IEntityStore iEntityStore) {
        JFont jFont = JomtFontUtilities.getProjectJFont(iEntityStore);
        Font font = FontManager.getFontFromJFontWithCash(jFont);
        return font;
    }

    public static Font getScaledProjectFont() {
        if (ModelGlobal.prjManager.getCurrentProject() != null) {
            Font font = JomtFontUtilities.getScaledProjectFont(ModelGlobal.prjManager.getCurrentProject().doc);
            return font;
        }
        return null;
    }

    public static Font getScaledProjectFont(IEntityStore iEntityStore) {
        JFont jFont = JomtFontUtilities.getProjectJFont(iEntityStore);
        jFont.setFontSize(SwingIconRegistry.scaleValue((int)jFont.getFontSize()));
        Font font = FontManager.getFontFromJFontWithCash(jFont);
        return font;
    }

    public static JFont getDefaultJFont() {
        String string = JomtFontUtilities.a();
        JFont jFont = JFont.decode(string);
        return jFont;
    }

    public static void setDefaultJFont(JFont jFont) {
        int n2;
        int n3;
        String string;
        String string2;
        String string3;
        String string4 = jFont.getFontName();
        if (!string4.equals(string3 = RuntimeGlobal.sysProp.getStringWithDefault(c))) {
            RuntimeGlobal.sysProp.setString(c, string4);
        }
        if (!(string2 = jFont.getFontStyle()).equals(string = RuntimeGlobal.sysProp.getStringWithDefault(b))) {
            RuntimeGlobal.sysProp.setString(b, string2);
        }
        if ((n3 = jFont.getFontSize()) != (n2 = RuntimeGlobal.sysProp.getIntWithDefault(a))) {
            RuntimeGlobal.sysProp.setInt(a, n3);
        }
        h = jFont.encode();
        defaultFont = FontManager.getFontFromJFontWithCash(jFont);
    }

    public static JFont getProjectJFont() {
        String string = JomtFontUtilities.b();
        JFont jFont = JFont.decode(string);
        return jFont;
    }

    public static JFont getProjectJFont(IEntityStore iEntityStore) {
        String string = JomtFontUtilities.a(iEntityStore);
        return JFont.decode(string);
    }

    public static void setProjectJFont(net.astah.jmodel.Project project, JFont jFont) {
        project.projectFont = FontManager.getFontFromJFontWithCash(jFont);
        ResourceSet resourceSet = project.doc.getDomain().getResourceSet();
        Project project2 = ProjectManagerAdapter.getRootProject((Notifier)resourceSet);
        Preferences preferences = project2.getPreferences();
        preferences.putStringValue("font.name", jFont.getFontName());
        preferences.putStringValue("font.style", jFont.getFontStyle());
        preferences.putIntValue("font.size", jFont.getFontSize());
    }

    public static String encodeJFont(JFont jFont) {
        return jFont.getFontName() + "," + jFont.getFontStyle() + "," + jFont.getFontSize();
    }

    private static String a() {
        if (h == null) {
            if (RuntimeGlobal.sysProp == null) {
                h = g;
            } else {
                String string;
                String string2;
                String string3 = RuntimeGlobal.sysProp.getStringWithDefault(c);
                if (string3 == null || string3.equals("")) {
                    string3 = JomtFontUtilities.a(c, d);
                }
                if ((string2 = RuntimeGlobal.sysProp.getStringWithDefault(b)) == null || string2.equals("")) {
                    string2 = JomtFontUtilities.a(b, e);
                }
                if ((string = RuntimeGlobal.sysProp.getStringWithDefault(a)) == null || string.equals("")) {
                    string = JomtFontUtilities.a(a, f);
                }
                h = string3 + "," + string2 + "," + string;
            }
        }
        return h;
    }

    private static String b() {
        IJomtEntityStore iJomtEntityStore = null;
        if (ModelGlobal.prjManager != null && ModelGlobal.prjManager.getCurrentProject() != null) {
            iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        }
        return JomtFontUtilities.a(iJomtEntityStore);
    }

    private static String a(IEntityStore iEntityStore) {
        String string = JomtFontUtilities.a();
        if (iEntityStore == null) {
            return string;
        }
        Project project = ProjectOperations.getProject(iEntityStore);
        if (project == null) {
            return string;
        }
        return JomtFontUtilities.a(project.getPreferences());
    }

    private static String a(Preferences preferences) {
        if (preferences == null) {
            return JomtFontUtilities.a();
        }
        String string = preferences.getStringValue("font.name", JomtFontUtilities.a(c, d));
        String string2 = preferences.getStringValue("font.style", JomtFontUtilities.a(b, e));
        String string3 = preferences.getStringValue("font.size", JomtFontUtilities.a(a, f));
        return string + "," + string2 + "," + string3;
    }

    private static String a(String string, String string2) {
        String string3 = PropertyManager.getJudeResourceBundle().getString(string);
        return Strings.isNullOrEmpty((String)string3) ? string2 : string3;
    }

    public static double computeStringWidth(Font font, String string) {
        if (string.length() == 0) {
            return 0.0;
        }
        Graphics graphics = JomtFontUtilities.c();
        if (graphics == null) {
            FontRenderContext fontRenderContext = new FontRenderContext(null, RenderingHintsHelper.isTextAntiAliasing, true);
            Map<TextAttribute, ?> map = font.getAttributes();
            AttributedString attributedString = new AttributedString(string, map);
            TextMeasurer textMeasurer = new TextMeasurer(attributedString.getIterator(), fontRenderContext);
            return Math.max((double)textMeasurer.getAdvanceBetween(0, string.length()), GolfUtilities.computeStringWidth((Font)font, (String)string));
        }
        return GolfUtilities.computeStringWidth((Graphics)graphics, (Font)font, (String)string);
    }

    private static Graphics c() {
        if (ModelGlobal.currentDiagramAccessor == null) {
            return null;
        }
        CCanvas cCanvas = ModelGlobal.currentDiagramAccessor.getDiagramEditorCanvas();
        if (cCanvas == null || !(cCanvas.getComponent() instanceof GCanvas)) {
            return null;
        }
        GCanvas gCanvas = (GCanvas)cCanvas.getComponent();
        return gCanvas.getGraphics2D();
    }

    public static double computeStringHeight(Font font, String string) {
        Graphics graphics = JomtFontUtilities.c();
        if (graphics == null) {
            return GolfUtilities.computeStringHeight((Font)font, (String)string);
        }
        return GolfUtilities.computeStringHeight((Graphics)graphics, (Font)font, (String)string);
    }

    public static int getLineCount(Font font, String string, double d2) {
        int n2 = 0;
        if (string != null) {
            int n3 = 0;
            while (n3 < string.length()) {
                n3 = JomtFontUtilities.a(font, string, d2, n3);
                ++n2;
            }
        }
        return n2;
    }

    private static int a(Font font, String string, double d2, int n2) {
        int n3;
        for (n3 = n2 + 1; n3 <= string.length() && !(d2 < JomtFontUtilities.computeStringWidth(font, string.substring(n2, n3))); ++n3) {
        }
        if (n3 == n2 + 1) {
            return n3;
        }
        return n3 - 1;
    }

    public static Dimension getStringSize(String string, Font font) {
        String[] stringArray = TextUtil.devideMultiLineString(string);
        double d2 = 0.0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            double d3 = JomtFontUtilities.computeStringWidth(font, stringArray[i2]);
            d2 = Math.max(d2, d3);
        }
        double d4 = JomtFontUtilities.computeStringHeight(font, "T");
        double d5 = d4 * (double)stringArray.length;
        JomtFontUtilities.j.width = (int)(d2 + 5.0);
        JomtFontUtilities.j.height = (int)(d5 + 5.0);
        return j;
    }

    public static Font correctFont(Font font) {
        if (font == null) {
            return null;
        }
        Map<TextAttribute, ?> map = font.getAttributes();
        String string = System.getProperty("java.version");
        if (string.compareTo("1.6") < 0 && map.containsKey(DEFINED_KEY)) {
            map.remove(DEFINED_KEY);
            return new Font(map);
        }
        return font;
    }

    public static boolean isSupportedFont(Font font) {
        String string;
        String string2 = font.getName();
        if (string2.equalsIgnoreCase(string = font.getFamily(Locale.ENGLISH))) {
            return true;
        }
        if (string.equals(d)) {
            return false;
        }
        if (i == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames(Locale.ENGLISH);
            i = new HashMap(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                i.put(stringArray[i2], stringArray[i2]);
            }
        }
        return i.containsKey(string);
    }

    public static String getEnglishName(Font font) {
        return font.getFamily(Locale.ENGLISH);
    }

    public static boolean isFontNameEnglish(Font font) {
        String string = font.getName();
        String string2 = font.getFamily(Locale.ENGLISH);
        return string.equals(string2);
    }

    public static String getDomesticFontName(Font font) {
        String string = font.getFamily(Locale.getDefault());
        return string;
    }

    public static void resetProjectFont() {
        JFont jFont = JomtFontUtilities.getProjectJFont();
        Font font = FontManager.getFontFromJFontWithCash(jFont);
        if (!JomtFontUtilities.isSupportedFont(font)) {
            font = JomtFontUtilities.getDefaultFont();
        }
        ModelGlobal.prjManager.getCurrentProject().projectFont = font;
    }

    public static double compareLabelSizeWithFont(Font font, Font font2, String string) {
        return JomtFontUtilities.computeStringHeight(font2, string) - JomtFontUtilities.computeStringHeight(font, string);
    }

    public static double computeMultiLineStringWidth(Font font, String string) {
        String[] stringArray = string.split("\n");
        double d2 = 0.0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            double d3 = JomtFontUtilities.computeStringWidth(font, string2);
            if (!(d2 < d3)) continue;
            d2 = d3;
        }
        return d2;
    }

    public static JFont getSelectedJFont(GFontChooser gFontChooser) {
        JFont jFont = FontManager.getJFontFromFont(gFontChooser.getSelectedFont());
        jFont.setUnderlined(gFontChooser.getFontChooserPeer().isUnderlined());
        jFont.setStruckThrough(gFontChooser.getFontChooserPeer().isStruckThrough());
        return jFont;
    }

    public static Font getFontForOperation(LabelPresentation labelPresentation, boolean bl) {
        Font font = labelPresentation.getFont();
        if (bl) {
            if (font.getStyle() == 1) {
                font = labelPresentation.getFont().deriveFont(3);
            } else if (font.getStyle() == 0) {
                font = labelPresentation.getFont().deriveFont(2);
            }
        } else if (font.getStyle() == 3) {
            font = labelPresentation.getFont().deriveFont(1);
        } else if (font.getStyle() == 2) {
            font = labelPresentation.getFont().deriveFont(0);
        }
        return font;
    }

    public static Font getFontForLabel(LabelPresentation labelPresentation, boolean bl) {
        Font font = labelPresentation.getFont();
        if (bl) {
            font = labelPresentation.getFont().deriveFont(1);
        }
        return font;
    }

    public static String getDefaultStringForRestore() {
        String string;
        String string2;
        String string3 = RuntimeGlobal.sysProp.getDefaultString(c);
        if (string3 == null || string3.equals("")) {
            string3 = d;
        }
        if ((string2 = RuntimeGlobal.sysProp.getDefaultString(b)) == null || string2.equals("")) {
            string2 = e;
        }
        if ((string = RuntimeGlobal.sysProp.getDefaultString(a)) == null || string.equals("")) {
            string = f;
        }
        return string3 + "," + string2 + "," + string;
    }

    static {
        defaultFont = JomtFontUtilities.getDefaultFont();
        j = new Dimension();
    }
}

