/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jutil;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.astah.golf.model.IExObservable;
import net.astah.golf.model.IHyperlink;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.model.extension.ExtensionFactory;
import net.astah.model.extension.Extensions;
import net.astah.model.extension.Hyperlink;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class HyperlinkUtil {
    public static final String RELATIVE_PRJ_DIR = "0";
    public static final String RELATIVE_WORK_DIR = "1";
    private static final Logger a = LoggerFactory.getLogger(HyperlinkUtil.class);

    public static boolean isAbsoluteFilePath(String string) {
        return new File(string).isAbsolute();
    }

    public static boolean isRelativeFilePath(String string) {
        return !new File(string).isAbsolute();
    }

    public static boolean isValidFilePath(String string) {
        if (!HyperlinkUtil.isAbsoluteFilePath(string)) {
            string = HyperlinkUtil.convertRelativeToAbsolute(string);
        }
        return new File(string).isFile();
    }

    public static String convertAbsoluteToRelative(String string) {
        String string2 = HyperlinkUtil.getCurrentRelativeDir();
        if (string2 == null) {
            return string;
        }
        if (string.charAt(0) != string2.charAt(0)) {
            return string;
        }
        return HyperlinkUtil.a(new File(string2), new File(string));
    }

    public static String convertRelativeToAbsolute(String string) {
        return HyperlinkUtil.convertRelativeToAbsolute(null, string);
    }

    public static String convertRelativeToAbsolute(String string, String string2) {
        if (string == null && (string = HyperlinkUtil.getCurrentRelativeDir()) == null) {
            return string2;
        }
        return HyperlinkUtil.a(new File(string), string2);
    }

    public static String getCurrentRelativeDir() {
        if (RuntimeGlobal.sysProp.getStringWithDefault("hyperlink.relative_path_type.selected").equals(RELATIVE_PRJ_DIR)) {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            if ("no_title".equals(project.doc.getName())) {
                return PropertyManager.getUserSetFilesFolderName();
            }
            String string = new File(project.doc.getName()).getParent();
            return null == string ? "" : string;
        }
        return HyperlinkUtil.getCurrentWorkDir();
    }

    public static String getDetailedCurrentRelativeDir() {
        if (RuntimeGlobal.sysProp.getStringWithDefault("hyperlink.relative_path_type.selected").equals(RELATIVE_PRJ_DIR)) {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            if ("no_title".equals(project.doc.getName())) {
                return HyperlinkUtil.a("ui.add_file_dialog.text.relative_path_unusable.label");
            }
            String string = new File(project.doc.getName()).getParent();
            return null == string ? "" : string;
        }
        return HyperlinkUtil.getCurrentWorkDir();
    }

    public static String getCurrentWorkDir() {
        String string = RuntimeGlobal.sysProp.getStringWithDefault("hyperlink.user_work_dir");
        if (string.equals("")) {
            string = PropertyManager.getUserSetFilesFolderName();
        }
        return string;
    }

    private static String a(File file, File file2) {
        List list = HyperlinkUtil.a(file);
        List list2 = HyperlinkUtil.a(file2);
        String string = HyperlinkUtil.a(list, list2);
        return string;
    }

    private static String a(File file, String string) {
        int n2;
        int n3 = 0;
        String[] stringArray = string.split("/");
        for (n2 = 0; n2 < stringArray.length && stringArray[n2].equals(".."); ++n2) {
            ++n3;
        }
        for (n2 = n3; n2 > 0; --n2) {
            if ((file = file.getParentFile()) != null) continue;
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(file.getAbsolutePath());
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '\\') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        for (int i2 = n3; i2 < stringArray.length; ++i2) {
            stringBuilder.append(File.separator);
            stringBuilder.append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    private static List a(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (File file2 = file.getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                arrayList.add(file2.getName());
            }
        }
        catch (IOException iOException) {
            a.error("error has occurred.", (Throwable)iOException);
            arrayList = null;
        }
        return arrayList;
    }

    private static String a(List list, List list2) {
        int n2;
        String string = "";
        int n3 = list.size() - 1;
        for (n2 = list2.size() - 1; n3 >= 0 && n2 >= 0 && list.get(n3).equals(list2.get(n2)); --n3, --n2) {
        }
        while (n3 >= 0) {
            string = string + ".." + File.separator;
            --n3;
        }
        while (n2 >= 1) {
            string = string + list2.get(n2) + File.separator;
            --n2;
        }
        string = string + list2.get(n2);
        return string;
    }

    private static String a(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static Hyperlink createHyperlink(EObject eObject) {
        Hyperlink hyperlink = ExtensionFactory.eINSTANCE.createHyperlink();
        hyperlink.setOwner(eObject);
        return hyperlink;
    }

    public static Hyperlink createHyperlink(EObject eObject, EObject eObject2) {
        Hyperlink hyperlink = ExtensionFactory.eINSTANCE.createHyperlink();
        hyperlink.setOwner(eObject);
        hyperlink.setReference(eObject2);
        return hyperlink;
    }

    public static Hyperlink createHyperlink(EObject eObject, URI uRI) {
        Hyperlink hyperlink = ExtensionFactory.eINSTANCE.createHyperlink();
        hyperlink.setOwner(eObject);
        hyperlink.setLocation(uRI);
        return hyperlink;
    }

    public static void addHyperlink(Hyperlink hyperlink, EObject eObject) {
        hyperlink.setOwner(eObject);
    }

    public static void copyHyperlinkToModel(EObject eObject, Hyperlink hyperlink) {
        EObject eObject2;
        URI uRI = hyperlink.getLocation();
        if (uRI != null) {
            HyperlinkUtil.createHyperlink(eObject, uRI);
        }
        if ((eObject2 = hyperlink.getReference()) != null) {
            HyperlinkUtil.createHyperlink(eObject, eObject2);
        }
    }

    @Deprecated
    public static void addHyperlink(Hyperlink hyperlink) {
        throw new UnsupportedOperationException();
    }

    public static void removeHyperlink(EObject eObject, int[] nArray) {
        EList eList = Extensions.getHyperlinks((EObject)eObject, (boolean)true);
        int n2 = nArray.length;
        while (n2-- > 0) {
            eList.remove(nArray[n2]);
        }
    }

    @Deprecated
    public static void removeHyperlink(EObject eObject, int[] nArray, int n2) {
        throw new UnsupportedOperationException();
    }

    public static int[] upHyperlink(EObject eObject, int[] nArray) {
        EList eList = Extensions.getHyperlinks((EObject)eObject, (boolean)true);
        int[] nArray2 = new int[nArray.length];
        int n2 = -1;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            int n4 = n3 - 1;
            if (n4 >= 0 && n4 != n2) {
                eList.move(n4, n3);
                nArray2[i2] = n4;
                continue;
            }
            n2 = n3;
            nArray2[i2] = n3;
        }
        return nArray2;
    }

    @Deprecated
    public static int upHyperlink(EObject eObject, int[] nArray, int n2) {
        throw new UnsupportedOperationException();
    }

    private static int b(List list, List list2) {
        Object e2 = list2.get(list2.size() - 1);
        int n2 = list.indexOf(e2);
        return n2;
    }

    private static Object c(List list, List list2) {
        Object var2_4;
        Object e2;
        Object e3 = list2.get(0);
        if (e3.equals(e2 = list.get(0))) {
            var2_4 = null;
        } else {
            int n2 = list.indexOf(e3);
            var2_4 = list.get(n2 - 1);
        }
        return var2_4;
    }

    public static int[] downHyperlink(EObject eObject, int[] nArray) {
        EList eList = Extensions.getHyperlinks((EObject)eObject, (boolean)true);
        int[] nArray2 = new int[nArray.length];
        int n2 = -1;
        int n3 = nArray.length;
        while (n3-- > 0) {
            int n4 = nArray[n3];
            int n5 = n4 + 1;
            if (n5 < eList.size() && n5 != n2) {
                eList.move(n5, n4);
                nArray2[n3] = n5;
                continue;
            }
            n2 = n4;
            nArray2[n3] = n4;
        }
        return nArray2;
    }

    @Deprecated
    public static int downHyperlink(EObject eObject, int[] nArray, int n2) {
        throw new UnsupportedOperationException();
    }

    private static int d(List list, List list2) {
        Object e2 = list2.get(0);
        int n2 = list.indexOf(e2);
        return n2;
    }

    private static Object e(List list, List list2) {
        Object var2_4;
        Object e2;
        Object e3 = list2.get(list2.size() - 1);
        if (e3.equals(e2 = list.get(list.size() - 1))) {
            var2_4 = null;
        } else {
            int n2 = list.indexOf(e3);
            var2_4 = list.get(n2 + 1);
        }
        return var2_4;
    }

    private static void a(int[] nArray, List list, int n2, int n3, List list2, List list3) {
        Object e2;
        int n4;
        for (n4 = 0; n4 < list.size(); ++n4) {
            e2 = list.get(n4);
            if (!(e2 instanceof Hyperlink)) continue;
            list2.add(e2);
        }
        for (n4 = list.size() - 1; n4 > -1; --n4) {
            e2 = list.get(n4);
            if (!(e2 instanceof Hyperlink) || --n2 != nArray[n3]) continue;
            list3.add(0, e2);
            if (n2 < 0 || --n3 < 0) break;
        }
    }

    public static void updateHyperlink(Hyperlink hyperlink, int n2, EObject eObject) {
        EList eList = Extensions.getHyperlinks((EObject)eObject, (boolean)true);
        ((Hyperlink)eList.get(n2)).setValue(hyperlink);
    }

    public static List<IHyperlink> getHyperlinks(IExObservable iExObservable) {
        Presentation presentation;
        ArrayList<IHyperlink> arrayList = new ArrayList<IHyperlink>(0);
        EObject eObject = null;
        if (iExObservable instanceof Presentation) {
            presentation = (Presentation)iExObservable;
            eObject = presentation.getModel();
        } else if (iExObservable instanceof Element) {
            eObject = (Element)iExObservable;
        }
        if (eObject == null) {
            presentation = (Presentation)iExObservable;
            List<IHyperlink> list = presentation.getHyperlinks();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                IHyperlink iHyperlink = list.get(i2);
                if (iHyperlink == null) continue;
                iHyperlink.setOwner((EObject)presentation);
                arrayList.add(iHyperlink);
            }
        }
        return arrayList;
    }
}

