/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jutil;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.astah.jomt.jutil.JFont;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class FontManager {
    private static Map a = new HashMap();
    public static double sizeRatio = 1.0;

    public static Font getFontFromJFontWithCash(JFont jFont) {
        String string = jFont.encode();
        Font font = (Font)a.get(string);
        if (font == null) {
            String string2 = jFont.getFontName();
            String string3 = jFont.getFontStyle();
            int n2 = FontManager.getFontStyleValueInt(string3);
            int n3 = jFont.getFontSize();
            font = new Font(string2, n2, n3);
            a.put(string, font);
        }
        return font;
    }

    public static Font getFontFromJFontWithoutCash(JFont jFont) {
        String string = jFont.getFontName();
        String string2 = jFont.getFontStyle();
        int n2 = jFont.getFontSize();
        int n3 = FontManager.getFontStyleValueInt(string2);
        Font font = new Font(string, n3, n2);
        return font;
    }

    public static int getFontStyleValueInt(String string) {
        if (string.equals("BOLDITALIC")) {
            return 3;
        }
        if (string.equals("BOLD")) {
            return 1;
        }
        if (string.equals("ITALIC")) {
            return 2;
        }
        return 0;
    }

    public static JFont getJFontFromFont(Font font) {
        String string = font.getName();
        int n2 = font.getStyle();
        int n3 = font.getSize();
        String string2 = FontManager.getFontStyleString(n2);
        return new JFont(string, string2, n3);
    }

    public static String getFontStyleString(int n2) {
        String string = "PLAIN";
        if ((n2 & 3) == 3) {
            string = "BOLDITALIC";
        } else if ((n2 & 1) == 1) {
            string = "BOLD";
        } else if ((n2 & 2) == 2) {
            string = "ITALIC";
        }
        return string;
    }

    public static void resizeFonts() {
        Set set = a.entrySet();
        HashMap<String, Font> hashMap = new HashMap<String, Font>();
        for (Object e2 : set) {
            Map.Entry entry = (Map.Entry)e2;
            Font font = (Font)entry.getValue();
            font = font.deriveFont(font.getSize2D() * (float)sizeRatio);
            String string = entry.getKey().toString();
            hashMap.put(string, font);
        }
        a.putAll(hashMap);
    }
}

