/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jsystem;

import com.google.common.base.Strings;
import net.astah.golf.util.ResourceBundleList;
import net.astah.jomt.jsystem.PropertyManager;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class ModelVersionInfo {
    public static final String EDITION_OF_PROFESSIONAL = "professional";
    public static final String EDITION_OF_UML = "UML";
    public static final String EDITION_OF_COMMUNITY = "community";
    public static final String EDITION_OF_THINK = "think";
    public static final String EDITION_OF_SYSML = "sysML";
    public static final String EDITION_OF_GSN = "gsn";
    public static final String EDITION_OF_AMERIGO = "amerigo";

    public static String getFullProductLabel() {
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList == null) {
            return "";
        }
        String string = resourceBundleList.getString("product.label");
        String string2 = resourceBundleList.getString("product.edition");
        String string3 = resourceBundleList.getString("product.version");
        return string + ' ' + string2 + ' ' + string3;
    }

    public static String getKind() {
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList == null) {
            return "";
        }
        return resourceBundleList.getString("product.kind");
    }

    public static String getEdition() {
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList == null) {
            return "";
        }
        String string = resourceBundleList.getString("product.kind");
        if ("astah_professional".equals(string)) {
            return EDITION_OF_PROFESSIONAL;
        }
        if ("astah_UML".equals(string)) {
            return EDITION_OF_UML;
        }
        if ("astah_community".equals(string)) {
            return EDITION_OF_COMMUNITY;
        }
        if ("astah_think".equals(string)) {
            return EDITION_OF_THINK;
        }
        if ("astah_amerigo".equals(string)) {
            return EDITION_OF_AMERIGO;
        }
        return "";
    }

    public static String getEditionLabel() {
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList == null) {
            return "";
        }
        String string = resourceBundleList.getString("product.edition");
        return Strings.isNullOrEmpty((String)string) ? resourceBundleList.getString("product.name") : string;
    }

    public static String getVersion() {
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList == null) {
            return "";
        }
        return resourceBundleList.getString("product.version");
    }

    public static String getVersionWithEdition() {
        return ModelVersionInfo.getEditionLabel() + ' ' + ModelVersionInfo.getVersion();
    }

    public static int getModelVersion() {
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList == null) {
            return 0;
        }
        return Integer.parseInt(resourceBundleList.getString("model.version"));
    }
}

