/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel.impl;

import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.astah.golf.util.GolfUtilities;
import net.astah.jmodel.JmodelPackage;
import net.astah.jmodel.NotePresentation;
import net.astah.jmodel.alias.AliasAccessor;
import net.astah.jmodel.impl.LabelPresentationImpl;
import net.astah.jomt.jutil.JomtFontUtilities;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Comment;

public class NotePresentationImpl
extends LabelPresentationImpl
implements NotePresentation {
    public static final double TOP_MARGIN = 4.0;
    public static final double BOTTOM_MARGIN = 4.0;
    public static final double LINE_SPACE = 0.0;
    protected static final String NOTE_STRING_EDEFAULT = null;

    protected NotePresentationImpl() {
    }

    @Override
    public boolean isDoAutoResize() {
        return false;
    }

    @Override
    public boolean isValidModel(EObject eObject) {
        return eObject instanceof Comment && super.isValidModel(eObject);
    }

    @Override
    protected EClass eStaticClass() {
        return JmodelPackage.Literals.NOTE_PRESENTATION;
    }

    @Override
    public String getNoteString() {
        return this._getNoteString();
    }

    @Override
    public String getLabel() {
        return AliasAccessor.getIndicatoryName(this.getModel());
    }

    @Override
    public void setDoAutoResize(boolean bl) {
        this.doAutoResize = false;
    }

    @Override
    public double getMinWidth() {
        return 25.5;
    }

    @Override
    public double getMinHeight() {
        return 20.0;
    }

    @Override
    public double getDefaultWidth() {
        String[] stringArray = this.analyzeNoteString();
        double d2 = 0.0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            double d3 = JomtFontUtilities.computeStringWidth(this.getFont(), stringArray[i2]);
            d2 = Math.max(d2, d3);
        }
        d2 = Math.max(this.getStereotypesWidth(), d2);
        return Math.max(this.getMinWidth(), 10.0 + d2 + 10.0);
    }

    @Override
    public double getDefaultHeight() {
        double d2 = this.getWidth() - 4.0 - 10.0;
        double d3 = GolfUtilities.computeMultiLineStringHeight((Font)this.getFont(), (String)this.getNoteString(), (double)d2, (double)0.0);
        return Math.max(this.getMinHeight(), d3 += this.getStereotypesHeight() + 4.0 + 4.0);
    }

    protected String _getNoteString() {
        return ((Comment)this.getModel()).getBody();
    }

    @Override
    public String[] analyzeNoteString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "\n";
        String string2 = this.getLabel();
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if ((n3 = string2.indexOf(string, n2)) == -1) break;
            arrayList.add(string2.substring(n2, n3));
            n2 = n3 + 1;
        }
        arrayList.add(string2.substring(n2));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public void update(Notifier notifier, Object object) {
        if (this.isValid()) {
            super.update(notifier, null);
            this.resize();
        }
    }

    @Override
    public void resize() {
        if (suppressResize || !this.isValid()) {
            return;
        }
        if (!this._isDoAutoResize()) {
            double d2 = this.getDefaultHeight();
            this.setHeight(Math.max(d2, this.getHeight()));
        }
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        return string.equals("fill.color") || string.equals("font.name") || string.equals("font.size") || string.equals("font.color") || string.equals("font.struckthrough") || string.equals("font.style") || string.equals("font.underlined") || string.equals("font");
    }

    @Override
    public double getMinResizeLeftWidth() {
        return this.getMinWidth();
    }

    @Override
    public double getMinResizeRightWidth() {
        return this.getMinWidth();
    }

    @Override
    public Object eGet(int n2, boolean bl, boolean bl2) {
        switch (n2) {
            case 94: {
                return this._getNoteString();
            }
        }
        return super.eGet(n2, bl, bl2);
    }

    @Override
    public boolean eIsSet(int n2) {
        switch (n2) {
            case 94: {
                return NOTE_STRING_EDEFAULT == null ? this.getNoteString() != null : !NOTE_STRING_EDEFAULT.equals(this.getNoteString());
            }
        }
        return super.eIsSet(n2);
    }

    @Override
    public Object eInvoke(int n2, EList<?> eList) throws InvocationTargetException {
        switch (n2) {
            case 61: {
                return this.analyzeNoteString();
            }
        }
        return super.eInvoke(n2, eList);
    }
}

