/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.StateEditable;
import net.astah.jmodel.TemplateItem;

public class Template
implements Serializable,
StateEditable {
    static final long serialVersionUID = 4556593962289907469L;
    private List<TemplateItem> templateItems = new ArrayList<TemplateItem>();
    private String name;

    public Template() {
        this(null);
    }

    public Template(String string) {
        this(string, null);
    }

    public Template(String string, Template template) {
        this.name = string;
        if (template != null) {
            Iterator<TemplateItem> iterator = template.getAllTemplateItems();
            while (iterator.hasNext()) {
                TemplateItem templateItem = iterator.next();
                this.templateItems.add((TemplateItem)templateItem.clone());
            }
        }
    }

    public void addTemplateItem(TemplateItem templateItem) {
        this.templateItems.add(templateItem);
    }

    public void removeTemplateItem(int n2) {
        this.templateItems.remove(n2);
    }

    public void removeAllTemplateItems() {
        this.templateItems.clear();
    }

    public Iterator<TemplateItem> getAllTemplateItems() {
        return this.templateItems.iterator();
    }

    public TemplateItem getTemplateItem(int n2) {
        return this.templateItems.get(n2);
    }

    public int size() {
        return this.templateItems.size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void restoreState(Hashtable<?, ?> hashtable) {
    }

    @Override
    public void storeState(Hashtable<Object, Object> hashtable) {
    }

    public void downItem(int n2) {
        if (n2 < 0 || n2 >= this.templateItems.size() - 1) {
            return;
        }
        TemplateItem templateItem = this.templateItems.get(n2);
        this.templateItems.add(n2 + 2, templateItem);
        this.templateItems.remove(n2);
    }

    public void upItem(int n2) {
        if (n2 <= 0 || n2 > this.templateItems.size()) {
            return;
        }
        TemplateItem templateItem = this.templateItems.get(n2);
        this.templateItems.add(n2 - 1, templateItem);
        this.templateItems.remove(n2 + 1);
    }

    public String toString() {
        return this.name;
    }
}

