/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel;

import java.awt.Font;
import java.awt.Image;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.ImageUtilities;
import net.astah.golf.util.ResourceBundleList;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.jomt.jutil.ProfileUtilities;
import net.astah.jomt.jutil.VectorCustomeIconSpec;
import net.astah.uml2.uml.Stereotypes;
import net.astah.uml2.uml.edit.provider.UMLProviders;
import net.astah.uml2.uml.util.TypeUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StereotypeUtil {
    public static final String JAVA_CLASS = "Java Class";
    public static final String JAVA_ATTRIBUTE = "Java Attribute";
    public static final String JAVA_OPERATION = "Java Method";
    public static final String CSHARP_CLASS = "C# Class";
    public static final String CSHARP_ATTRIBUTE = "C# Attribute";
    public static final String CSHARP_OPERATION = "C# Method";
    public static final String CPLUS_CLASS = "C++ Class";
    public static final String CPLUS_ATTRIBUTE = "C++ Attribute";
    public static final String CPLUS_OPERATION = "C++ Method";
    public static final String CPLUS_PARAMETER = "C++ Parameter";
    public static final String DELEGATE = "delegate";
    public static final String ENUM = "enum";
    public static final String ENUM_CONSTANT = "enum constant";
    public static final String STRUCT = "struct";
    public static final String PROPERTY = "property";
    public static final String EVENT = "event";
    public static final String INDEXER = "indexer";
    public static final String UNION = "union";
    public static final String JAVA_STEREOTYPE = "Java ";
    public static final String C_SHARP_STEREOTYPE = "C# ";
    public static final String C_PLUS_STEREOTYPE = "C++ ";
    private static List<String> a;
    private static Logger b;
    private static final String c = "%s=%s";
    private static final String d = "%s=\"%s\"";

    public static List<String> getStereotypes(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (element != null) {
            Object object = element.getApplicableStereotypes();
            try {
                String string = PropertyManager.getJudeResourceBundle().getString("jude.classifier_presentation_util");
                String string2 = PropertyManager.getJudeResourceBundle().getString("jude.object_presentation_util_method");
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getMethod(string2, Element.class, List.class);
                object = (List)method.invoke(clazz.newInstance(), element, object);
            }
            catch (Exception exception) {
                object = ProfileUtilities.getStereotypes(element, (EList<Stereotype>)element.getAppliedStereotypes());
            }
            arrayList.addAll(StereotypeUtil.a(object));
        }
        return arrayList;
    }

    private static List<String> a(List<Stereotype> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Stereotype stereotype : list) {
            String string = stereotype.getName();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<<");
            stringBuilder.append(string);
            stringBuilder.append(">>");
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public static List<String> getStereotypeList(String string) {
        return Stereotypes.getStereotypeList((String)string, (Boolean)true);
    }

    public static double getStereotypesWidth(Element element, Font font) {
        double d2 = 0.0;
        List<String> list = StereotypeUtil.getStereotypes(element);
        for (String string : list) {
            d2 = Math.max(JomtFontUtilities.computeStringWidth(font, string), d2);
        }
        double d3 = StereotypeUtil.getKeywordWidth(element, font);
        d2 = Math.max(d3, d2);
        return d2;
    }

    public static double getKeywordWidth(Element element, Font font) {
        double d2 = 0.0;
        if (element != null) {
            for (String string : UMLProviders.getKeywords(element, null)) {
                d2 = Math.max(JomtFontUtilities.computeStringWidth(font, Stereotypes.getGuillemetString((String)string)), d2);
            }
        }
        return d2;
    }

    public static double getStereotypesWidth(List<Stereotype> list, Font font) {
        double d2 = 0.0;
        List<String> list2 = StereotypeUtil.a(list);
        for (String string : list2) {
            d2 = Math.max(JomtFontUtilities.computeStringWidth(font, string), d2);
        }
        return d2;
    }

    public static double getStereotypesHeight(Element element, Font font) {
        double d2 = 0.0;
        List<String> list = StereotypeUtil.getStereotypes(element);
        for (String string : list) {
            d2 += JomtFontUtilities.computeStringHeight(font, string);
        }
        return d2 += StereotypeUtil.getKeywordsHeight(element, font);
    }

    public static double getKeywordsHeight(Element element, Font font) {
        double d2 = 0.0;
        if (element != null) {
            for (String string : UMLProviders.getKeywords(element, null)) {
                d2 += JomtFontUtilities.computeStringHeight(font, Stereotypes.getGuillemetString((String)string));
            }
        }
        return d2;
    }

    public static double getStereotypesHeight(List<Stereotype> list, Font font) {
        double d2 = 0.0;
        List<String> list2 = StereotypeUtil.a(list);
        for (String string : list2) {
            d2 += JomtFontUtilities.computeStringHeight(font, string);
        }
        return d2;
    }

    public static boolean canObjectBeIcon(Lifeline lifeline) {
        ConnectableElement connectableElement = lifeline.getRepresents();
        Type type = null;
        if (connectableElement != null) {
            type = connectableElement.getType();
        }
        if (type instanceof Actor) {
            return true;
        }
        return type instanceof Interface;
    }

    public static boolean canBeIcon(Element element) {
        if (element == null) {
            return false;
        }
        return false;
    }

    public static boolean canBeIcon(EObject eObject) {
        return eObject instanceof Interface || eObject instanceof Actor;
    }

    public static boolean canBeIconClassifier(String string) {
        return StereotypeUtil.a("stereotypes.classifier.can_be_icon", string);
    }

    public static boolean canBeIconObject(String string) {
        return StereotypeUtil.a("stereotypes.object.can_be_icon", string);
    }

    public static boolean canBeIconActionState(String string) {
        if (StereotypeUtil.a("stereotypes.action_state.can_be_icon", string)) {
            return true;
        }
        return VectorCustomeIconSpec.getSpec(string) != null;
    }

    public static boolean outTextFlowchart(String string) {
        return StereotypeUtil.a("stereotypes.flow_chart.out_text_icon", string);
    }

    public static boolean canBeIconObjectFlowState(ObjectNode objectNode) {
        String string = "";
        return StereotypeUtil.canBeIconObjectNode(string);
    }

    public static boolean canBeIconObjectNode(String string) {
        return StereotypeUtil.a("stereotypes.object_flow_state.can_be_icon", string);
    }

    private static boolean a(String string, String string2) {
        List<String> list = StereotypeUtil.a(string);
        for (String string3 : list) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static List<String> a(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = StereotypeUtil.b(string);
        String[] stringArray2 = stringArray = string2 != null ? GolfUtilities.tokenize((String)string2, (String)",") : null;
        if (stringArray == null) {
            return arrayList;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList;
    }

    private static String b(String string) {
        return PropertyManager.getProjectViewResourceBundle().getString(string);
    }

    private static boolean a(Element element, String string) {
        if (element == null || string != null) {
            // empty if block
        }
        return false;
    }

    public static boolean isInterface(EObject eObject) {
        return eObject instanceof Interface;
    }

    public static boolean isUsage(EObject eObject) {
        return eObject instanceof Usage;
    }

    public static boolean isRealization(EObject eObject) {
        return eObject instanceof Realization;
    }

    public static double getIconPreferredWidth(Element element) {
        String string = Stereotypes.getStereotypeString((EObject)element);
        if ("interface".equals(string)) {
            return 20.0;
        }
        if ("actor".equals(string)) {
            return 40.0;
        }
        if ("control".equals(string)) {
            return 40.0;
        }
        if ("boundary".equals(string)) {
            return 60.0;
        }
        if ("entity".equals(string)) {
            return 40.0;
        }
        if ("information".equals(string)) {
            return 45.0;
        }
        return 0.0;
    }

    public static double getIconPreferredWidthForRole(Element element) {
        String string = Stereotypes.getStereotypeString((EObject)element);
        if ("interface".equals(string)) {
            return 20.0;
        }
        if ("actor".equals(string)) {
            return 20.0;
        }
        if ("control".equals(string)) {
            return 25.0;
        }
        if ("boundary".equals(string)) {
            return 40.0;
        }
        if ("entity".equals(string)) {
            return 25.0;
        }
        if ("information".equals(string)) {
            return 30.0;
        }
        return 0.0;
    }

    public static double getIconPreferredHeight(Element element) {
        String string = Stereotypes.getStereotypeString((EObject)element);
        if (StereotypeUtil.isInterface((EObject)element)) {
            return 20.0;
        }
        if (element instanceof Actor) {
            return 55.0;
        }
        if ("control".equals(string)) {
            return 40.0;
        }
        if ("boundary".equals(string)) {
            return 40.0;
        }
        if ("entity".equals(string)) {
            return 40.0;
        }
        if ("information".equals(string)) {
            return 35.0;
        }
        return 0.0;
    }

    public static double getIconPreferredHeightForRole(Element element) {
        if (element instanceof Actor) {
            return 25.0;
        }
        if (element instanceof Interface) {
            return 20.0;
        }
        return 0.0;
    }

    public static boolean isActor(EObject eObject) {
        return eObject instanceof Actor;
    }

    public static boolean isEditable(Stereotype stereotype) {
        return StereotypeUtil.a(stereotype);
    }

    public static boolean isLangStereotypeForClass(Stereotype stereotype) {
        return stereotype.getName().equals(JAVA_CLASS) || stereotype.getName().equals(CSHARP_CLASS) || stereotype.getName().equals(CPLUS_CLASS) || stereotype.getName().equals(ENUM) || stereotype.getName().equals(DELEGATE) || stereotype.getName().equals(UNION) || stereotype.getName().equals(STRUCT);
    }

    public static boolean isOrderChangeable(Stereotype stereotype) {
        return StereotypeUtil.a(stereotype);
    }

    private static boolean a(Stereotype stereotype) {
        return true;
    }

    public static Image getImage(Stereotype stereotype) {
        if (stereotype == null || stereotype.getIcons().isEmpty()) {
            return null;
        }
        org.eclipse.uml2.uml.Image image = (org.eclipse.uml2.uml.Image)stereotype.getIcons().get(0);
        String string = image.getContent();
        try {
            return ImageUtilities.hexToImage((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            b.warn("Illegal image format. {}", (Object)stereotype.getName());
            return null;
        }
    }

    public static String getStereotypeAttributeString(Element element, Stereotypes.TaggedValueProperty taggedValueProperty) {
        Property property;
        String string;
        Stereotype stereotype = taggedValueProperty.getAppliedStereotype();
        Object object = element.getValue(stereotype, string = (property = taggedValueProperty.getProperty()).getName());
        if (Stereotypes.isIllegalTaggedValue((Object)object)) {
            return "";
        }
        Type type = property.getType();
        String string2 = Stereotypes.getTaggedValueString((Object)object);
        if (TypeUtil.isString(type)) {
            return String.format(d, string, string2);
        }
        return String.format(c, string, string2);
    }

    static {
        try {
            ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
            a = Arrays.asList(resourceBundleList.getStrings("jude.unmodifiable_stereotypes"));
        }
        catch (MissingResourceException missingResourceException) {
            a = new ArrayList<String>();
        }
        b = LoggerFactory.getLogger(StereotypeUtil.class);
    }
}

