/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.jmodel.BinaryRelationPresentation;
import net.astah.notation.LineConstraint;
import net.astah.notation.RightAngleCurve;
import net.astah.notation.RightAngleLine;

public class RightAngleUtil {
    private static final double a = 2.0;

    public static boolean isOverlapXCoordinate(BinaryRelationPresentation binaryRelationPresentation) {
        Rectangle2d rectangle2d = binaryRelationPresentation.getSourceRect();
        Rectangle2d rectangle2d2 = binaryRelationPresentation.getTargetRect();
        return RightAngleUtil.isOverlapXCoordinate(rectangle2d, rectangle2d2);
    }

    public static boolean isOverlapXCoordinate(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        if (RightAngleUtil.isOverlapXCoordinate(rectangle2d, rectangle2d2.x)) {
            return true;
        }
        if (RightAngleUtil.isOverlapXCoordinate(rectangle2d, rectangle2d2.x + rectangle2d2.width)) {
            return true;
        }
        if (RightAngleUtil.isOverlapXCoordinate(rectangle2d2, rectangle2d.x)) {
            return true;
        }
        return RightAngleUtil.isOverlapXCoordinate(rectangle2d2, rectangle2d.x + rectangle2d.width);
    }

    public static boolean isOverlapYCoordinate(BinaryRelationPresentation binaryRelationPresentation) {
        Rectangle2d rectangle2d = binaryRelationPresentation.getSourceRect();
        Rectangle2d rectangle2d2 = binaryRelationPresentation.getTargetRect();
        return RightAngleUtil.isOverlapYCoordinate(rectangle2d, rectangle2d2);
    }

    public static boolean isOverlapYCoordinate(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        if (RightAngleUtil.isOverlapYCoordinate(rectangle2d, rectangle2d2.y)) {
            return true;
        }
        if (RightAngleUtil.isOverlapYCoordinate(rectangle2d, rectangle2d2.y + rectangle2d2.height)) {
            return true;
        }
        if (RightAngleUtil.isOverlapYCoordinate(rectangle2d2, rectangle2d.y)) {
            return true;
        }
        return RightAngleUtil.isOverlapYCoordinate(rectangle2d2, rectangle2d.y + rectangle2d.height);
    }

    public static double getNewEndX(Rectangle2d rectangle2d, Pnt2d pnt2d) {
        return (pnt2d.x - rectangle2d.x) / rectangle2d.width;
    }

    public static double getNewEndY(Rectangle2d rectangle2d, Pnt2d pnt2d) {
        return (pnt2d.y - rectangle2d.y) / rectangle2d.height;
    }

    public static boolean isOverlapXCoordinate(Rectangle2d rectangle2d, Pnt2d pnt2d) {
        return RightAngleUtil.isOverlapXCoordinate(rectangle2d, pnt2d.x);
    }

    public static boolean isOverlapYCoordinate(Rectangle2d rectangle2d, Pnt2d pnt2d) {
        return RightAngleUtil.isOverlapYCoordinate(rectangle2d, pnt2d.y);
    }

    public static boolean isOverlapXCoordinate(Rectangle2d rectangle2d, double d2) {
        return rectangle2d.x <= d2 && rectangle2d.x + rectangle2d.width >= d2;
    }

    public static boolean isOverlapYCoordinate(Rectangle2d rectangle2d, double d2) {
        return rectangle2d.y <= d2 && rectangle2d.y + rectangle2d.height >= d2;
    }

    public static Pnt2d[] optimizeThroughPnts(BinaryRelationPresentation binaryRelationPresentation, Pnt2d[] pnt2dArray) {
        Rectangle2d rectangle2d = binaryRelationPresentation.getSourceRect();
        Rectangle2d rectangle2d2 = binaryRelationPresentation.getTargetRect();
        return RightAngleUtil.optimizeThroughPnts(rectangle2d, rectangle2d2, pnt2dArray);
    }

    public static List<Pnt2d> optimizeThroughPnts(Rectangle2d rectangle2d, Pnt2d pnt2d, Rectangle2d rectangle2d2, Pnt2d pnt2d2, Pnt2d[] pnt2dArray) {
        Pnt2d[] pnt2dArray2;
        Pnt2d[] pnt2dArray3 = RightAngleUtil.optimizeThroughPnts(rectangle2d, rectangle2d2, pnt2dArray);
        if (!(pnt2dArray3.length != 0 || pnt2d.getX() == pnt2d2.getX() && pnt2d.getY() == pnt2d2.getY() || RightAngleUtil.a((pnt2dArray2 = RightAngleUtil.a(rectangle2d, pnt2d, rectangle2d2, pnt2d2))[0], pnt2dArray2[1]))) {
            return Arrays.asList(pnt2dArray2);
        }
        return Arrays.asList(pnt2dArray3);
    }

    private static boolean a(Pnt2d pnt2d, Pnt2d pnt2d2) {
        return pnt2d.distance((Point2D)pnt2d2) < 2.0;
    }

    private static Pnt2d[] a(Rectangle2d rectangle2d, Pnt2d pnt2d, Rectangle2d rectangle2d2, Pnt2d pnt2d2) {
        Pnt2d[] pnt2dArray = new Pnt2d[2];
        if (RightAngleUtil.isOverlapXCoordinate(rectangle2d, rectangle2d2)) {
            double d2 = (pnt2d2.getY() - pnt2d.getY()) / 2.0 + pnt2d.getY();
            pnt2dArray[0] = new Pnt2d(pnt2d.getX(), d2);
            pnt2dArray[1] = new Pnt2d(pnt2d2.getX(), d2);
        } else {
            double d3 = (pnt2d2.getX() - pnt2d.getX()) / 2.0 + pnt2d.getX();
            pnt2dArray[0] = new Pnt2d(d3, pnt2d.getY());
            pnt2dArray[1] = new Pnt2d(d3, pnt2d2.getY());
        }
        return pnt2dArray;
    }

    public static Pnt2d[] optimizeThroughPnts(Rectangle2d rectangle2d, Rectangle2d rectangle2d2, Pnt2d[] pnt2dArray) {
        Pnt2d pnt2d;
        Pnt2d pnt2d2;
        int n2;
        ArrayList<Pnt2d> arrayList = new ArrayList<Pnt2d>();
        Pnt2d pnt2d3 = null;
        for (n2 = 0; n2 < pnt2dArray.length; ++n2) {
            if (rectangle2d.contains((Point2D)pnt2dArray[n2])) continue;
            arrayList.add(pnt2dArray[n2]);
            pnt2d3 = pnt2dArray[n2];
            break;
        }
        ++n2;
        while (n2 < pnt2dArray.length - 1) {
            if (!RightAngleUtil.a(pnt2d3, pnt2dArray[n2], pnt2dArray[n2 + 1])) {
                arrayList.add(pnt2dArray[n2]);
                pnt2d3 = pnt2dArray[n2];
            }
            ++n2;
        }
        if (n2 < pnt2dArray.length) {
            arrayList.add(pnt2dArray[n2]);
        }
        while (arrayList.size() > 0 && rectangle2d2.contains((Point2D)((Pnt2d)arrayList.get(arrayList.size() - 1)))) {
            arrayList.remove(arrayList.size() - 1);
        }
        if (arrayList.size() > 1 && (RightAngleUtil.isHorizontalLine(pnt2d2 = (Pnt2d)arrayList.get(0), pnt2d = (Pnt2d)arrayList.get(1)) && RightAngleUtil.isOverlapYCoordinate(rectangle2d, pnt2d2) || RightAngleUtil.isVerticalLine(pnt2d2, pnt2d) && RightAngleUtil.isOverlapXCoordinate(rectangle2d, pnt2d2))) {
            arrayList.remove(pnt2d2);
        }
        if (arrayList.size() > 1 && (RightAngleUtil.isHorizontalLine(pnt2d2 = (Pnt2d)arrayList.get(arrayList.size() - 1), pnt2d = (Pnt2d)arrayList.get(arrayList.size() - 2)) && RightAngleUtil.isOverlapYCoordinate(rectangle2d2, pnt2d2) || RightAngleUtil.isVerticalLine(pnt2d2, pnt2d) && RightAngleUtil.isOverlapXCoordinate(rectangle2d2, pnt2d2))) {
            arrayList.remove(pnt2d2);
        }
        if (arrayList.size() == 1 && (RightAngleUtil.isOverlapXCoordinate(rectangle2d, pnt2d2 = (Pnt2d)arrayList.get(0)) && RightAngleUtil.isOverlapXCoordinate(rectangle2d2, pnt2d2) || RightAngleUtil.isOverlapYCoordinate(rectangle2d, pnt2d2) && RightAngleUtil.isOverlapYCoordinate(rectangle2d2, pnt2d2))) {
            arrayList.remove(0);
        }
        return arrayList.toArray(new Pnt2d[arrayList.size()]);
    }

    private static boolean a(Pnt2d pnt2d, Pnt2d pnt2d2, Pnt2d pnt2d3) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(pnt2d.x, pnt2d.y, 0.0, 0.0);
        double_.add((Point2D)pnt2d2);
        double_.add((Point2D)pnt2d3);
        return ((RectangularShape)double_).getWidth() < 2.0 || ((RectangularShape)double_).getHeight() < 2.0;
    }

    public static boolean isHorizontalLine(Pnt2d pnt2d, Pnt2d pnt2d2) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(pnt2d.x, pnt2d.y, 0.0, 0.0);
        double_.add((Point2D)pnt2d2);
        return ((RectangularShape)double_).getHeight() < 2.0;
    }

    public static boolean isVerticalLine(Pnt2d pnt2d, Pnt2d pnt2d2) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(pnt2d.x, pnt2d.y, 0.0, 0.0);
        double_.add((Point2D)pnt2d2);
        return ((RectangularShape)double_).getWidth() < 2.0;
    }

    public static void setConstraint(BinaryRelationPresentation binaryRelationPresentation) {
        Pnt2d[] pnt2dArray = binaryRelationPresentation.getPoints().toArray(new Pnt2d[0]);
        if (pnt2dArray.length < 1) {
            binaryRelationPresentation.setRightAngleConstraint(true);
            return;
        }
        Pnt2d[] pnt2dArray2 = new Pnt2d[pnt2dArray.length + 2];
        pnt2dArray2[0] = binaryRelationPresentation.getSourceEndPnt();
        for (int i2 = 0; i2 < pnt2dArray.length; ++i2) {
            pnt2dArray2[i2 + 1] = pnt2dArray[i2];
        }
        pnt2dArray2[pnt2dArray2.length - 1] = binaryRelationPresentation.getTargetEndPnt();
        binaryRelationPresentation.getPoints().clear();
        binaryRelationPresentation.getPoints().addAll(Arrays.asList(RightAngleUtil.makeNewPoints(pnt2dArray2)));
        binaryRelationPresentation.setRightAngleConstraint(true);
    }

    public static Pnt2d[] makeNewPoints(Pnt2d[] pnt2dArray) {
        Pnt2d pnt2d;
        int n2;
        Pnt2d[] pnt2dArray2 = new Pnt2d[pnt2dArray.length];
        for (n2 = 0; n2 < pnt2dArray.length; ++n2) {
            pnt2dArray2[n2] = pnt2dArray[n2];
        }
        for (n2 = 1; n2 < pnt2dArray2.length - 1; ++n2) {
            Pnt2d pnt2d2;
            if (pnt2dArray2[n2 - 1].x > pnt2dArray2[n2 + 1].x) {
                pnt2d2 = pnt2dArray2[n2 + 1];
                pnt2d = pnt2dArray2[n2 - 1];
            } else {
                pnt2d2 = pnt2dArray2[n2 - 1];
                pnt2d = pnt2dArray2[n2 + 1];
            }
            pnt2dArray2[n2] = RightAngleUtil.getOptimizedPoint(pnt2dArray2[n2], pnt2d2, pnt2d);
        }
        ArrayList<Pnt2d> arrayList = new ArrayList<Pnt2d>();
        for (int i2 = 1; i2 < pnt2dArray2.length - 1; ++i2) {
            pnt2d = pnt2dArray2[i2];
            if (!arrayList.isEmpty() && ((Pnt2d)arrayList.get(arrayList.size() - 1)).equals((Object)pnt2d)) continue;
            arrayList.add(pnt2d);
        }
        return arrayList.toArray(new Pnt2d[0]);
    }

    protected static Pnt2d getOptimizedPoint(Pnt2d pnt2d, Pnt2d pnt2d2, Pnt2d pnt2d3) {
        Pnt2d pnt2d4 = new Pnt2d(pnt2d2.x, pnt2d3.y);
        Pnt2d pnt2d5 = new Pnt2d(pnt2d3.x, pnt2d2.y);
        if (pnt2d4.equals((Object)pnt2d) || pnt2d5.equals((Object)pnt2d)) {
            return pnt2d;
        }
        double d2 = (pnt2d3.y - pnt2d2.y) / (pnt2d3.x - pnt2d2.x);
        double d3 = pnt2d2.y - pnt2d2.x * d2;
        if (Double.isInfinite(d2)) {
            return pnt2d4;
        }
        if (d2 > 0.0) {
            if (pnt2d.y > d2 * pnt2d.x + d3) {
                return pnt2d4;
            }
            return pnt2d5;
        }
        if (pnt2d.y <= d2 * pnt2d.x + d3) {
            return pnt2d4;
        }
        return pnt2d5;
    }

    public static Pnt2d[] adjustMiddleEndWaypoints(Pnt2d[] pnt2dArray) {
        Pnt2d pnt2d = pnt2dArray[0];
        Pnt2d pnt2d2 = pnt2dArray[1];
        Pnt2d pnt2d3 = pnt2dArray[pnt2dArray.length - 2];
        Pnt2d pnt2d4 = pnt2dArray[pnt2dArray.length - 1];
        if (pnt2dArray.length == 2 && !RightAngleUtil.b(pnt2d, pnt2d4)) {
            return RightAngleUtil.makeNewPoints(pnt2dArray);
        }
        if (!RightAngleUtil.b(pnt2d, pnt2d2)) {
            pnt2dArray[1] = RightAngleUtil.isHorizontalLine(pnt2d2, pnt2dArray[2]) ? new Pnt2d(pnt2d.x, pnt2d2.y) : new Pnt2d(pnt2d2.x, pnt2d.y);
        }
        if (!RightAngleUtil.b(pnt2d4, pnt2d3)) {
            pnt2dArray[pnt2dArray.length - 2] = RightAngleUtil.isHorizontalLine(pnt2d3, pnt2dArray[pnt2dArray.length - 3]) ? new Pnt2d(pnt2d4.x, pnt2d3.y) : new Pnt2d(pnt2d3.x, pnt2d4.y);
        }
        return pnt2dArray;
    }

    private static boolean b(Pnt2d pnt2d, Pnt2d pnt2d2) {
        return RightAngleUtil.isHorizontalLine(pnt2d, pnt2d2) || RightAngleUtil.isVerticalLine(pnt2d, pnt2d2);
    }

    public static boolean isRightAngle(LineConstraint lineConstraint) {
        return lineConstraint instanceof RightAngleLine || lineConstraint instanceof RightAngleCurve;
    }

    public static List<Pnt2d> getPointsForRightAngle(Rectangle2d rectangle2d, Rectangle2d rectangle2d2, List<Pnt2d> list) {
        Pnt2d[] pnt2dArray;
        Pnt2d[] pnt2dArray2 = list.toArray(new Pnt2d[list.size()]);
        Pnt2d[] pnt2dArray3 = null;
        if (pnt2dArray2.length == 2) {
            pnt2dArray = new ArrayList();
            if (pnt2dArray2[0].x != pnt2dArray2[1].x && pnt2dArray2[0].y != pnt2dArray2[1].y) {
                if (RightAngleUtil.isOverlapXCoordinate(rectangle2d, rectangle2d2)) {
                    Pnt2d[] pnt2dArray4;
                    pnt2dArray4 = new Pnt2d[]{rectangle2d.getMaxY() < rectangle2d2.getMaxY() ? new Pnt2d(pnt2dArray2[0].x, (rectangle2d.getMaxY() + rectangle2d2.getMinY()) / 2.0) : new Pnt2d(pnt2dArray2[0].x, (rectangle2d2.getMaxY() + rectangle2d.getMinY()) / 2.0), new Pnt2d(pnt2dArray2[1].x, pnt2dArray4[0].y)};
                    pnt2dArray.addAll(Arrays.asList(pnt2dArray4));
                } else if (RightAngleUtil.isOverlapYCoordinate(rectangle2d, rectangle2d2)) {
                    Pnt2d[] pnt2dArray5;
                    pnt2dArray5 = new Pnt2d[]{rectangle2d.getMaxX() < rectangle2d2.getMaxX() ? new Pnt2d((rectangle2d.getMaxX() + rectangle2d2.getMinX()) / 2.0, pnt2dArray2[0].y) : new Pnt2d((rectangle2d2.getMaxX() + rectangle2d.getMinX()) / 2.0, pnt2dArray2[0].y), new Pnt2d(pnt2dArray5[0].x, pnt2dArray2[1].y)};
                    pnt2dArray.addAll(Arrays.asList(pnt2dArray5));
                } else {
                    Pnt2d pnt2d = new Pnt2d(pnt2dArray2[0].x, pnt2dArray2[1].y);
                    pnt2dArray.add(pnt2d);
                }
            }
            pnt2dArray3 = pnt2dArray.toArray(new Pnt2d[0]);
        } else {
            pnt2dArray3 = RightAngleUtil.makeNewPoints(pnt2dArray2);
            pnt2dArray = new Pnt2d[pnt2dArray3.length + 2];
            pnt2dArray[0] = pnt2dArray2[0];
            System.arraycopy(pnt2dArray3, 0, pnt2dArray, 1, pnt2dArray3.length);
            pnt2dArray[pnt2dArray.length - 1] = pnt2dArray2[pnt2dArray2.length - 1];
            if (pnt2dArray[0].x != pnt2dArray[1].x && pnt2dArray[0].y != pnt2dArray[1].y) {
                if (RightAngleUtil.isHorizontalLine(pnt2dArray[1], pnt2dArray[2])) {
                    if (rectangle2d.getMinY() <= pnt2dArray[1].y && pnt2dArray[1].y <= rectangle2d.getMaxY()) {
                        pnt2dArray3[0].y = pnt2dArray[0].y;
                        if (2 <= pnt2dArray3.length) {
                            pnt2dArray3[1].y = pnt2dArray[0].y;
                        }
                        pnt2dArray[1].y = pnt2dArray[0].y;
                    } else {
                        pnt2dArray3[0].x = pnt2dArray[0].x;
                        pnt2dArray[1].x = pnt2dArray[0].x;
                    }
                } else if (rectangle2d.getMinX() <= pnt2dArray[1].x && pnt2dArray[1].x <= rectangle2d.getMaxX()) {
                    pnt2dArray3[0].x = pnt2dArray[0].x;
                    if (2 <= pnt2dArray3.length) {
                        pnt2dArray3[1].x = pnt2dArray[0].x;
                    }
                    pnt2dArray[1].x = pnt2dArray[0].x;
                } else {
                    pnt2dArray3[0].y = pnt2dArray[0].y;
                    pnt2dArray[1].y = pnt2dArray[0].y;
                }
            }
            if (pnt2dArray[pnt2dArray.length - 1].x != pnt2dArray[pnt2dArray.length - 2].x && pnt2dArray[pnt2dArray.length - 1].y != pnt2dArray[pnt2dArray.length - 2].y) {
                if (RightAngleUtil.isHorizontalLine(pnt2dArray[pnt2dArray.length - 2], pnt2dArray[pnt2dArray.length - 3])) {
                    if (rectangle2d2.getMinY() <= pnt2dArray[pnt2dArray.length - 2].y && pnt2dArray[pnt2dArray.length - 2].y <= rectangle2d2.getMaxY()) {
                        pnt2dArray3[pnt2dArray3.length - 1].y = pnt2dArray[pnt2dArray.length - 1].y;
                        if (2 <= pnt2dArray3.length) {
                            pnt2dArray3[pnt2dArray3.length - 2].y = pnt2dArray[pnt2dArray.length - 1].y;
                        }
                        pnt2dArray[pnt2dArray.length - 2].y = pnt2dArray[pnt2dArray.length - 1].y;
                    } else {
                        pnt2dArray3[pnt2dArray3.length - 1].x = pnt2dArray[pnt2dArray.length - 1].x;
                        pnt2dArray[pnt2dArray.length - 2].x = pnt2dArray[pnt2dArray.length - 1].x;
                    }
                } else if (rectangle2d2.getMinX() <= pnt2dArray[pnt2dArray.length - 2].x && pnt2dArray[pnt2dArray.length - 2].x <= rectangle2d2.getMaxX()) {
                    pnt2dArray3[pnt2dArray3.length - 1].x = pnt2dArray[pnt2dArray.length - 1].x;
                    if (2 <= pnt2dArray3.length) {
                        pnt2dArray3[pnt2dArray3.length - 2].x = pnt2dArray[pnt2dArray.length - 1].x;
                    }
                    pnt2dArray[pnt2dArray.length - 2].x = pnt2dArray[pnt2dArray.length - 1].x;
                } else {
                    pnt2dArray3[pnt2dArray3.length - 1].y = pnt2dArray[pnt2dArray.length - 1].y;
                    pnt2dArray[pnt2dArray.length - 2].y = pnt2dArray[pnt2dArray.length - 1].y;
                }
            }
        }
        pnt2dArray = RightAngleUtil.optimizeThroughPnts(rectangle2d, rectangle2d2, pnt2dArray3);
        return Arrays.asList(pnt2dArray);
    }
}

