/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel;

import java.util.List;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.WidgetPackage;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.model.extension.Preferences;
import net.astah.project.Project;
import net.astah.project.operations.ProjectOperations;
import org.eclipse.uml2.uml.Stereotype;

public class ProjectPropertyUtil {
    public static Preferences getPreferences() {
        if (ModelGlobal.prjManager.getCurrentProject() == null) {
            return null;
        }
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        Project project = ProjectOperations.getProject(iJomtEntityStore);
        if (project == null) {
            return null;
        }
        return project.getPreferences();
    }

    public static boolean getBooleanValue(String string) {
        Boolean bl;
        Preferences preferences = ProjectPropertyUtil.getPreferences();
        if (preferences != null && (bl = preferences.getBooleanValue(string)) != null) {
            return bl;
        }
        return RuntimeGlobal.sysProp.getBooleanWithDefault(string);
    }

    public static int getIntValue(String string) {
        Integer n2;
        Preferences preferences = ProjectPropertyUtil.getPreferences();
        if (preferences != null && (n2 = preferences.getIntValue(string)) != null) {
            return n2;
        }
        return RuntimeGlobal.sysProp.getIntWithDefault(string);
    }

    public static String getTextValue(String string) {
        String string2;
        Preferences preferences = ProjectPropertyUtil.getPreferences();
        if (preferences != null && (string2 = preferences.getStringValue(string)) != null) {
            return string2;
        }
        return RuntimeGlobal.sysProp.getStringWithDefault(string);
    }

    public static CColor getColorValue(String string) {
        Object object;
        Preferences preferences = ProjectPropertyUtil.getPreferences();
        if (preferences != null && (object = preferences.getValue(string, WidgetPackage.Literals.CCOLOR, null)) instanceof CColor) {
            return (CColor)object;
        }
        return RuntimeGlobal.sysProp.getColorWithDefault(string);
    }

    public static double getDoubleValue(String string) {
        Double d2;
        Preferences preferences = ProjectPropertyUtil.getPreferences();
        if (preferences != null && (d2 = preferences.getDoubleValue(string)) != null) {
            return d2;
        }
        return RuntimeGlobal.sysProp.getDoubleWithDefault(string);
    }

    public static CColor getStereotypeColor(String string) {
        for (int i2 = 0; i2 < 30; ++i2) {
            String string2 = ProjectPropertyUtil.getTextValue("uml.stereotype.name." + i2);
            if (string2 == null || string2.equals("")) continue;
            CColor cColor = ProjectPropertyUtil.getColorValue("uml.stereotype.color." + i2);
            if (!string.equalsIgnoreCase(string2)) continue;
            return cColor;
        }
        CColor cColor = RuntimeGlobal.sysProp.getStereotypeColor(string);
        if (cColor != null) {
            return cColor;
        }
        return null;
    }

    public static CColor getStereotypeColor(List<Stereotype> list) {
        for (Stereotype stereotype : list) {
            CColor cColor = ProjectPropertyUtil.getStereotypeColor(stereotype.getName());
            if (cColor == null) continue;
            return cColor;
        }
        return null;
    }
}

