/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.widget.CColor;
import net.astah.jmodel.ActivityParameterNodePresentation;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.AssociationClassPresentation;
import net.astah.jmodel.BinaryRelationPresentation;
import net.astah.jmodel.CommunicationMessagePresentation;
import net.astah.jmodel.ContainmentPresentation;
import net.astah.jmodel.EntryPointPresentation;
import net.astah.jmodel.ExitPointPresentation;
import net.astah.jmodel.JmodelPackage;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jmodel.LinePresentation;
import net.astah.jmodel.NoteAnchorPresentation;
import net.astah.jmodel.PortPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.SequenceMessageEndPresentation;
import net.astah.jmodel.StateInvariantPresentation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Presentations {
    private static final Logger a = LoggerFactory.getLogger(Presentations.class);

    public static List<Presentation> getPresentations(EObject eObject) {
        if (eObject == null) {
            return Collections.emptyList();
        }
        ECrossReferenceAdapter eCrossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eObject);
        if (eCrossReferenceAdapter == null) {
            return Collections.emptyList();
        }
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        for (EStructuralFeature.Setting setting : eCrossReferenceAdapter.getNonNavigableInverseReferences(eObject)) {
            if (!Presentations.a(setting)) continue;
            arrayList.add((Presentation)setting.getEObject());
        }
        return arrayList;
    }

    public static Presentation getPresentation(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        ECrossReferenceAdapter eCrossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eObject);
        if (eCrossReferenceAdapter != null) {
            for (EStructuralFeature.Setting setting : eCrossReferenceAdapter.getNonNavigableInverseReferences(eObject)) {
                if (!Presentations.a(setting)) continue;
                return (Presentation)setting.getEObject();
            }
        }
        return null;
    }

    public static <T extends Presentation> T getPresentation(EObject eObject, Class<T> clazz) {
        for (Presentation presentation : Presentations.getPresentations(eObject)) {
            if (!clazz.isInstance(presentation)) continue;
            return (T)((Presentation)clazz.cast(presentation));
        }
        return null;
    }

    static boolean a(EStructuralFeature.Setting setting) {
        return setting.getEStructuralFeature() == JmodelPackage.Literals.PRESENTATION__MODEL;
    }

    public static void setRelationsDepth(JomtPresentation jomtPresentation) {
        int n2 = jomtPresentation.getDepth();
        Presentations.setIncomingsAndOutgoingsDepth(n2, Presentations.getAllRelations(jomtPresentation));
    }

    public static List<BinaryRelationPresentation> getAllRelations(JomtPresentation jomtPresentation) {
        ArrayList<BinaryRelationPresentation> arrayList = new ArrayList<BinaryRelationPresentation>();
        arrayList.addAll(jomtPresentation.getSourceRelations());
        arrayList.addAll(jomtPresentation.getTargetRelations());
        return arrayList;
    }

    public static void setIncomingsAndOutgoingsDepth(int n2, List<BinaryRelationPresentation> list) {
        if (!list.isEmpty()) {
            Object[] objectArray = list.toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (!(objectArray[i2] instanceof JomtPresentation)) continue;
                JomtPresentation jomtPresentation = (JomtPresentation)objectArray[i2];
                jomtPresentation.setDepth(Math.min(jomtPresentation.getDepth(), n2));
                jomtPresentation.notifyObservers(null);
            }
        }
    }

    public static void removePresentation(Presentation presentation) {
        NoteAnchorPresentation noteAnchorPresentation;
        if (presentation instanceof NoteAnchorPresentation) {
            noteAnchorPresentation = (NoteAnchorPresentation)presentation;
            Presentations.clearAnnotatedElementInv(noteAnchorPresentation, noteAnchorPresentation.getAnnotatedElement());
        }
        noteAnchorPresentation = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)presentation);
        try {
            CommandUtils.execute((EditingDomain)noteAnchorPresentation, (Command)DestroyCommand.create((EditingDomain)noteAnchorPresentation, (Object)presentation));
        }
        catch (InterruptedException | RollbackException throwable) {
            a.error("error has occurred.", throwable);
        }
    }

    public static void removePresentations(List<Presentation> list) {
        list.stream().filter(presentation -> presentation instanceof NoteAnchorPresentation).forEach(presentation -> {
            NoteAnchorPresentation noteAnchorPresentation = (NoteAnchorPresentation)presentation;
            Presentations.clearAnnotatedElementInv(noteAnchorPresentation, noteAnchorPresentation.getAnnotatedElement());
        });
        if (list.size() > 0) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)list.get(0));
            try {
                CommandUtils.execute((EditingDomain)editingDomain, (Command)DestroyCommand.create((EditingDomain)editingDomain, list));
            }
            catch (InterruptedException | RollbackException throwable) {
                a.error("error has occurred.", throwable);
            }
        }
    }

    public static Collection<NoteAnchorPresentation> getNoteAnchorPresentations(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("annotatedElement is null.");
        }
        return (Collection)new UMLSwitch<Collection<NoteAnchorPresentation>>(){

            public Collection<NoteAnchorPresentation> caseFeature(Feature feature) {
                Collection collection = Collections2.filter(this.a(feature.getOwner()), noteAnchorPresentation -> feature.equals(noteAnchorPresentation.getAnnotatedElement()));
                collection.addAll(this.caseElement((Element)feature));
                return collection;
            }

            public Collection<NoteAnchorPresentation> caseEnumerationLiteral(EnumerationLiteral enumerationLiteral) {
                Collection collection = Collections2.filter(this.a(enumerationLiteral.getOwner()), noteAnchorPresentation -> enumerationLiteral.equals(noteAnchorPresentation.getAnnotatedElement()));
                collection.addAll(this.caseElement((Element)enumerationLiteral));
                return collection;
            }

            public Collection<NoteAnchorPresentation> caseElement(Element element) {
                return Collections2.filter(this.a(element), noteAnchorPresentation -> element.equals(noteAnchorPresentation.getAnnotatedElement()));
            }

            private List<NoteAnchorPresentation> a(Element element) {
                ArrayList arrayList = new ArrayList();
                Presentations.getPresentations((EObject)element).forEach(presentation -> arrayList.addAll(presentation.getAllClients()));
                return Lists.newArrayList((Iterable)Iterables.filter(arrayList, NoteAnchorPresentation.class));
            }

            public Collection<NoteAnchorPresentation> defaultCase(EObject eObject) {
                throw new IllegalArgumentException("object is not Element.");
            }
        }.doSwitch((EObject)element);
    }

    public static Collection<NoteAnchorPresentation> getNoteAnchorPresentations(Comment comment, Element element) {
        if (comment == null) {
            throw new IllegalArgumentException("comment is null.");
        }
        return Presentations.getNoteAnchorPresentations(element).stream().filter(noteAnchorPresentation -> noteAnchorPresentation.getNotePresentation() != null).filter(noteAnchorPresentation -> comment.equals(noteAnchorPresentation.getNotePresentation().getModel())).collect(Collectors.toList());
    }

    public static List<JomtPresentation> getAnnotatedPresentations(Element element) {
        List<Presentation> list = Presentations.getPresentations((EObject)element);
        if (element instanceof Feature) {
            list.addAll(Presentations.getPresentations((EObject)element.getOwner()));
        }
        return Lists.newArrayList((Iterable)Iterables.filter(list, JomtPresentation.class));
    }

    public static void clearAnnotatedElement(NoteAnchorPresentation noteAnchorPresentation, Comment comment) {
        if (noteAnchorPresentation == null) {
            throw new IllegalArgumentException("noteAnchorPresentation is null.");
        }
        if (comment == null) {
            throw new IllegalArgumentException("comment is null.");
        }
        Element element = noteAnchorPresentation.getAnnotatedElement();
        Presentations.a(comment, element);
    }

    public static void clearAnnotatedElementInv(NoteAnchorPresentation noteAnchorPresentation, Element element) {
        if (noteAnchorPresentation == null) {
            throw new IllegalArgumentException("noteAnchorPresentation is null.");
        }
        if (element == null) {
            throw new IllegalArgumentException("annotatedElement is null.");
        }
        Presentation presentation = noteAnchorPresentation.getNotePresentation();
        if (presentation != null) {
            EObject eObject = presentation.getModel();
            if (eObject == null || !(eObject instanceof Comment)) {
                return;
            }
            Comment comment = (Comment)Comment.class.cast(eObject);
            Presentations.a(comment, element);
        }
    }

    private static void a(Comment comment, Element element) {
        if (Presentations.getNoteAnchorPresentations(comment, element).size() > 1) {
            return;
        }
        comment.getAnnotatedElements().remove((Object)element);
    }

    public static boolean isContainmentLegal(ContainmentPresentation containmentPresentation, JomtPresentation jomtPresentation, JomtPresentation jomtPresentation2) {
        if (Presentations.a(containmentPresentation, jomtPresentation, jomtPresentation2)) {
            return false;
        }
        Presentation presentation = containmentPresentation.getParentPresentation();
        LabelPresentation labelPresentation = (LabelPresentation)containmentPresentation.getChildPresentation();
        EObject eObject = presentation.getModel();
        if (jomtPresentation != null) {
            if (Presentations.a(containmentPresentation, (Presentation)jomtPresentation, (Presentation)labelPresentation)) {
                return false;
            }
            if (jomtPresentation == labelPresentation.getContainer()) {
                return false;
            }
            eObject = jomtPresentation.getModel();
        }
        EObject eObject2 = containmentPresentation.getChildPresentation().getModel();
        if (jomtPresentation2 != null) {
            if (Presentations.a(containmentPresentation, presentation, (Presentation)jomtPresentation2)) {
                return false;
            }
            if (jomtPresentation2.getContainer() == presentation) {
                return false;
            }
            eObject2 = jomtPresentation2.getModel();
        }
        if (Presentations.a((Namespace)eObject, (Element)eObject2)) {
            return false;
        }
        if (eObject instanceof Package) {
            if (eObject2 instanceof Model && !(eObject instanceof Model)) {
                return false;
            }
            if (eObject2 instanceof Package || eObject2 instanceof Classifier) {
                return true;
            }
        } else if (Presentations.a(eObject) && Presentations.a(eObject2)) {
            Classifier classifier = (Classifier)eObject;
            Classifier classifier2 = (Classifier)eObject2;
            if (Presentations.a(classifier)) {
                return false;
            }
            return classifier instanceof Package || !Presentations.a(classifier2);
        }
        return false;
    }

    private static boolean a(Classifier classifier) {
        return classifier instanceof Component || classifier instanceof Node || classifier instanceof Artifact;
    }

    private static boolean a(ContainmentPresentation containmentPresentation, Presentation presentation, Presentation presentation2) {
        for (Presentation presentation3 : presentation.getAllClients()) {
            ContainmentPresentation containmentPresentation2;
            if (!(presentation3 instanceof ContainmentPresentation) || (containmentPresentation2 = (ContainmentPresentation)presentation3) == containmentPresentation || containmentPresentation2.getParentPresentation() != presentation || containmentPresentation2.getChildPresentation() != presentation2) continue;
            return true;
        }
        return false;
    }

    private static boolean a(Namespace namespace, Element element) {
        for (Namespace namespace2 = namespace; namespace2 != null; namespace2 = namespace2.getNamespace()) {
            if (namespace2 != element) continue;
            return true;
        }
        return false;
    }

    private static boolean a(EObject eObject) {
        return true;
    }

    private static boolean a(ContainmentPresentation containmentPresentation, JomtPresentation jomtPresentation, JomtPresentation jomtPresentation2) {
        JomtPresentation jomtPresentation3 = containmentPresentation.getSourcePresentation();
        JomtPresentation jomtPresentation4 = containmentPresentation.getTargetPresentation();
        if (jomtPresentation != null) {
            jomtPresentation3 = jomtPresentation;
        }
        if (jomtPresentation2 != null) {
            jomtPresentation4 = jomtPresentation2;
        }
        return jomtPresentation3 == jomtPresentation4;
    }

    public static boolean isLayoutTarget(Presentation presentation) {
        if (presentation instanceof RectPresentation) {
            return !(presentation instanceof SequenceMessageEndPresentation) && !(presentation instanceof LifelinePresentation) && !(presentation instanceof CommunicationMessagePresentation) && !(presentation instanceof ActivityPartitionPresentation) && !(presentation instanceof PortPresentation) && !(presentation instanceof ActivityParameterNodePresentation) && !(presentation instanceof EntryPointPresentation) && !(presentation instanceof ExitPointPresentation);
        }
        return presentation instanceof LinePresentation;
    }

    public static void setPreferedColor(RectPresentation rectPresentation, CColor cColor) {
        if (cColor != null) {
            rectPresentation.setBodyColor(cColor);
        } else {
            rectPresentation.setBodyColorWithDefault();
        }
    }

    public static Vec2d adjustStateInvariant(List<Presentation> list, Vec2d vec2d) {
        double d2;
        double d3 = Double.MAX_VALUE;
        StateInvariantPresentation stateInvariantPresentation = null;
        Object object = list.iterator();
        while (object.hasNext()) {
            Presentation presentation = object.next();
            if (!(presentation instanceof StateInvariantPresentation)) continue;
            StateInvariantPresentation stateInvariantPresentation2 = (StateInvariantPresentation)presentation;
            LifelinePresentation lifelinePresentation = stateInvariantPresentation2.getFather();
            double d4 = lifelinePresentation.getMaxY();
            double d5 = stateInvariantPresentation2.getMinY() - d4;
            if (!(d3 > d5)) continue;
            d3 = d5;
            stateInvariantPresentation = stateInvariantPresentation2;
        }
        if (stateInvariantPresentation != null && (d2 = (object = stateInvariantPresentation.getFather()).getMaxY()) > stateInvariantPresentation.getMinY() + vec2d.y) {
            vec2d.set(vec2d.x, d2 - stateInvariantPresentation.getMinY());
        }
        return vec2d;
    }

    public static CColor getPrefferedColor(boolean bl, Element element) {
        List<Presentation> list = Presentations.getPresentations((EObject)element);
        int n2 = list.size();
        if (bl && n2 > 0) {
            RectPresentation rectPresentation = null;
            rectPresentation = element instanceof AssociationClass ? (AssociationClassPresentation)Presentations.a(list, AssociationClassPresentation.class) : (RectPresentation)Presentations.a(list, RectPresentation.class);
            if (rectPresentation != null) {
                return rectPresentation.getBodyColor();
            }
        }
        return null;
    }

    private static Object a(List<?> list, Class<?> clazz) {
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter(list, clazz));
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.get(arrayList.size() - 1);
    }
}

