/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.Point;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Group;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.model.EntityClipboard;
import net.astah.golf.util.Debug;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jmodel.ActionPresentation;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.AssociationClassAnchorPresentation;
import net.astah.jmodel.AssociationClassPresentation;
import net.astah.jmodel.AssociationPathPresentation;
import net.astah.jmodel.BinaryRelationPresentation;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.ComponentInstancePresentation;
import net.astah.jmodel.ComponentPresentation;
import net.astah.jmodel.CompositeJomtPresentation;
import net.astah.jmodel.ContainmentPresentation;
import net.astah.jmodel.DepthUtil;
import net.astah.jmodel.DurationConstraintPresentation;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.GeneralizationPresentation;
import net.astah.jmodel.HeaderCellPresentation;
import net.astah.jmodel.InteractionUsePresentation;
import net.astah.jmodel.JmodelFactory;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jmodel.LinePresentation;
import net.astah.jmodel.MMBoundaryPresentation;
import net.astah.jmodel.MMEdgePresentation;
import net.astah.jmodel.MMLinkPresentation;
import net.astah.jmodel.MMTopicPresentation;
import net.astah.jmodel.NodeInstancePresentation;
import net.astah.jmodel.NodePresentation;
import net.astah.jmodel.NoteAnchorPresentation;
import net.astah.jmodel.NotePresentation;
import net.astah.jmodel.ObjectNodePresentation;
import net.astah.jmodel.PackagePresentation;
import net.astah.jmodel.PartPresentation;
import net.astah.jmodel.PathPresentation;
import net.astah.jmodel.PinPresentation;
import net.astah.jmodel.PolyLinePresentation;
import net.astah.jmodel.PortPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.PresentationContainer;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.RequirementPresentation;
import net.astah.jmodel.SequenceDestructionPresentation;
import net.astah.jmodel.SequenceMessageEndPresentation;
import net.astah.jmodel.SequenceMessagePresentation;
import net.astah.jmodel.StereotypeUtil;
import net.astah.jmodel.TestCasePresentation;
import net.astah.jmodel.TimeConstraintPresentation;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UseCasePresentation;
import net.astah.jmodel.operations.FrameOperations;
import net.astah.jomt.jutil.VectorCustomeIconSpec;
import net.astah.notation.Edge;
import net.astah.notation.Shape;
import net.astah.notation.mindmap.MMDiagramElement;
import net.astah.notation.mindmap.MMGraphicalShape;
import net.astah.uml.profile.StereotypeDefinition;
import net.astah.uml.profile.UMLProfileManager;
import net.astah.uml2.uml.Constraints;
import net.astah.uml2.uml.util.PartitionUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.AttributeOwner;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OperationOwner;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.VisibilityKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;

@Keep
public class PresentationUtil {
    private static final String[] a = new String[]{"create_description", "load-policy", "alias", "derive", "biz_flow_chart", "uuid", "jude.hyperlink"};
    private static final Logger b = LoggerFactory.getLogger(PresentationUtil.class);

    public static Presentation[] getCopy(Presentation[] presentationArray, boolean bl) {
        int n2;
        Presentation[] presentationArray2 = new Presentation[presentationArray.length];
        for (n2 = 0; n2 < presentationArray.length; ++n2) {
            Presentation presentation = presentationArray[n2];
            if (presentation == null) {
                b.debug("orgPs==null  {}", (Object)n2);
                continue;
            }
            try {
                Object object = presentation.clone();
                presentationArray2[n2] = (Presentation)object;
                continue;
            }
            catch (RuntimeException runtimeException) {
                b.error("error has occurred.", (Throwable)runtimeException);
            }
        }
        PresentationUtil.a(presentationArray, presentationArray2);
        for (n2 = 0; n2 < presentationArray2.length; ++n2) {
            for (int i2 = 0; i2 < presentationArray2.length; ++i2) {
                if (presentationArray2[n2] == null || presentationArray2[i2] == null || presentationArray[i2] == null) continue;
                presentationArray2[n2].resetPReference(presentationArray[i2], presentationArray2[i2]);
            }
        }
        return presentationArray2;
    }

    private static void a(Presentation[] presentationArray, Presentation[] presentationArray2) {
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>(Arrays.asList(presentationArray));
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            JomtPresentation jomtPresentation = (JomtPresentation)arrayList.get(i2);
            if (jomtPresentation instanceof PackagePresentation) {
                PresentationUtil.d(presentationArray2, arrayList, i2);
                continue;
            }
            if (jomtPresentation instanceof ComponentPresentation || jomtPresentation instanceof NodePresentation || jomtPresentation instanceof NodeInstancePresentation || jomtPresentation instanceof ComponentInstancePresentation || jomtPresentation instanceof ClassifierPresentation || jomtPresentation instanceof PartPresentation) {
                PresentationUtil.f(presentationArray2, arrayList, i2);
                continue;
            }
            if (jomtPresentation instanceof MMTopicPresentation) {
                PresentationUtil.b(presentationArray2, arrayList, i2);
                continue;
            }
            if (jomtPresentation instanceof MMEdgePresentation) {
                PresentationUtil.c(presentationArray2, arrayList, i2);
                continue;
            }
            if (jomtPresentation instanceof MMBoundaryPresentation) {
                PresentationUtil.a(presentationArray2, arrayList, i2);
                continue;
            }
            if (!(jomtPresentation instanceof HeaderCellPresentation)) continue;
            PresentationUtil.e(presentationArray2, arrayList, i2);
        }
    }

    private static void a(Presentation[] presentationArray, List<Presentation> list, int n2) {
        MMBoundaryPresentation mMBoundaryPresentation = (MMBoundaryPresentation)presentationArray[n2];
        int n3 = list.indexOf(mMBoundaryPresentation.getTopic());
        if (n3 >= 0 && n3 < presentationArray.length) {
            mMBoundaryPresentation.setTopic((MMTopicPresentation)presentationArray[n3]);
        } else {
            mMBoundaryPresentation.setTopic(null);
        }
    }

    private static void b(Presentation[] presentationArray, List<Presentation> list, int n2) {
        MMTopicPresentation mMTopicPresentation = (MMTopicPresentation)presentationArray[n2];
        int n3 = list.indexOf(mMTopicPresentation.getParent());
        if (n3 >= 0 && n3 < presentationArray.length) {
            mMTopicPresentation.setParent((MMTopicPresentation)presentationArray[n3]);
        } else {
            mMTopicPresentation.setParent(null);
        }
        int n4 = list.indexOf(mMTopicPresentation.getEdge());
        if (n4 >= 0 && n4 < presentationArray.length) {
            mMTopicPresentation.setEdge((MMEdgePresentation)presentationArray[n4]);
        } else {
            mMTopicPresentation.setEdge(null);
        }
        if (mMTopicPresentation.getBoundary() != null) {
            int n5 = list.indexOf(mMTopicPresentation.getBoundary());
            if (n5 >= 0 && n5 < presentationArray.length) {
                mMTopicPresentation.setBoundary((MMBoundaryPresentation)presentationArray[n5]);
            } else {
                mMTopicPresentation.setBoundary(null);
            }
        }
        ArrayList<MMTopicPresentation> arrayList = new ArrayList<MMTopicPresentation>();
        for (MMTopicPresentation mMTopicPresentation2 : mMTopicPresentation.getChildren()) {
            int n6 = list.indexOf(mMTopicPresentation2);
            if (n6 < 0 || n6 >= presentationArray.length) continue;
            arrayList.add((MMTopicPresentation)presentationArray[n6]);
        }
        mMTopicPresentation.setChildren(arrayList);
    }

    private static void c(Presentation[] presentationArray, List<Presentation> list, int n2) {
        MMEdgePresentation mMEdgePresentation = (MMEdgePresentation)presentationArray[n2];
        int n3 = list.indexOf(mMEdgePresentation.getParentTopic());
        if (n3 >= 0 && n3 < presentationArray.length) {
            Map map = mMEdgePresentation.getStyleMap();
            if (map != null) {
                mMEdgePresentation.setParentTopic((MMTopicPresentation)presentationArray[n3]);
            } else {
                mMEdgePresentation.setParentTopic((MMTopicPresentation)presentationArray[n3]);
            }
        } else {
            mMEdgePresentation.setParentTopic(null);
        }
    }

    private static void d(Presentation[] presentationArray, List<Presentation> list, int n2) {
        PackagePresentation packagePresentation = (PackagePresentation)list.get(n2);
        PackagePresentation packagePresentation2 = (PackagePresentation)presentationArray[n2];
        List list2 = packagePresentation.getSubElements();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            int n3 = list.indexOf(list2.get(i2));
            if (n3 == -1 || n3 > presentationArray.length - 1) continue;
            JomtPresentation jomtPresentation = (JomtPresentation)presentationArray[n3];
            jomtPresentation.setContainer(packagePresentation2);
        }
    }

    private static void e(Presentation[] presentationArray, List<Presentation> list, int n2) {
        HeaderCellPresentation headerCellPresentation = (HeaderCellPresentation)list.get(n2);
        HeaderCellPresentation headerCellPresentation2 = (HeaderCellPresentation)presentationArray[n2];
        List list2 = headerCellPresentation.getSubElements();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            int n3 = list.indexOf(list2.get(i2));
            if (n3 == -1 || n3 > presentationArray.length - 1) continue;
            HeaderCellPresentation headerCellPresentation3 = (HeaderCellPresentation)presentationArray[n3];
            headerCellPresentation3.setParent(headerCellPresentation2);
            headerCellPresentation2.getSubElements().add(headerCellPresentation3);
        }
    }

    private static void f(Presentation[] presentationArray, List<Presentation> list, int n2) {
        PresentationContainer presentationContainer = (PresentationContainer)list.get(n2);
        PresentationContainer presentationContainer2 = (PresentationContainer)presentationArray[n2];
        List<JomtPresentation> list2 = presentationContainer.getSubElements();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            int n3 = list.indexOf(list2.get(i2));
            if (n3 == -1 || n3 > presentationArray.length - 1) continue;
            JomtPresentation jomtPresentation = (JomtPresentation)presentationArray[n3];
            jomtPresentation.setContainer(presentationContainer2);
        }
    }

    public static void setActivationRelation(List<Presentation> list, List<Presentation> list2) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object;
            Presentation presentation = list.get(i2);
            if (!(presentation instanceof SequenceMessageEndPresentation)) continue;
            SequenceMessageEndPresentation sequenceMessageEndPresentation = (SequenceMessageEndPresentation)list2.get(i2);
            SequenceMessageEndPresentation sequenceMessageEndPresentation2 = (SequenceMessageEndPresentation)presentation;
            SequenceMessageEndPresentation sequenceMessageEndPresentation3 = null;
            boolean bl = false;
            while (!bl) {
                object = sequenceMessageEndPresentation2.getLefts();
                if (object.size() > 0) {
                    sequenceMessageEndPresentation3 = (SequenceMessageEndPresentation)object.get(0);
                    if (list.contains(sequenceMessageEndPresentation3)) {
                        bl = true;
                        continue;
                    }
                    sequenceMessageEndPresentation2 = sequenceMessageEndPresentation3;
                    continue;
                }
                sequenceMessageEndPresentation3 = null;
                bl = true;
            }
            object = sequenceMessageEndPresentation2.getRelatedTp();
            if (object == null || !list.contains(object)) continue;
            SequenceDestructionPresentation sequenceDestructionPresentation = (SequenceDestructionPresentation)list2.get(list.indexOf(object));
            sequenceMessageEndPresentation.setRelatedTp(sequenceDestructionPresentation);
            sequenceDestructionPresentation.setRelatedAp(sequenceMessageEndPresentation);
        }
        PresentationUtil.setLocation(list2);
    }

    public static void setLocation(List<Presentation> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SequenceMessageEndPresentation sequenceMessageEndPresentation;
            List<SequenceMessageEndPresentation> list2;
            Presentation presentation = list.get(i2);
            if (!(presentation instanceof SequenceMessageEndPresentation) || (list2 = (sequenceMessageEndPresentation = (SequenceMessageEndPresentation)presentation).getLefts()).size() <= 0) continue;
            SequenceMessageEndPresentation sequenceMessageEndPresentation2 = list2.get(0);
            double d2 = sequenceMessageEndPresentation.getLocation().x - sequenceMessageEndPresentation2.getMaxX();
            sequenceMessageEndPresentation2.move(new Vec2d(d2, 0.0));
        }
    }

    public static Presentation[] getAllRelatedPresenations(Presentation[] presentationArray) {
        HashSet<Presentation> hashSet = new HashSet<Presentation>();
        hashSet.addAll(Arrays.asList(presentationArray));
        for (int i2 = 0; i2 < presentationArray.length; ++i2) {
            if (!(presentationArray[i2] instanceof MMTopicPresentation)) continue;
            MMTopicPresentation mMTopicPresentation = (MMTopicPresentation)presentationArray[i2];
            hashSet.addAll(PresentationUtil.getAllRelatedPresentationOfTopic(mMTopicPresentation, new HashSet<Presentation>()));
        }
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        for (int i3 = 0; i3 < presentationArray.length; ++i3) {
            if (arrayList.contains(presentationArray[i3])) continue;
            arrayList.add(presentationArray[i3]);
        }
        for (Presentation presentation : hashSet) {
            if (arrayList.contains(presentation)) continue;
            arrayList.add(presentation);
        }
        return arrayList.toArray(new Presentation[0]);
    }

    public static Collection<Presentation> getAllRelatedPresentationOfTopic(MMTopicPresentation mMTopicPresentation, Set<Presentation> set) {
        set.add(mMTopicPresentation);
        if (mMTopicPresentation.getEdge() != null) {
            set.add(mMTopicPresentation.getEdge());
        }
        if (mMTopicPresentation.getBoundary() != null) {
            set.add(mMTopicPresentation.getBoundary());
        }
        for (MMTopicPresentation mMTopicPresentation2 : mMTopicPresentation.getChildren()) {
            PresentationUtil.getAllRelatedPresentationOfTopic(mMTopicPresentation2, set);
        }
        return set;
    }

    public static boolean needIsolated(Presentation presentation) {
        if (presentation instanceof PortPresentation || presentation instanceof BinaryRelationPresentation) {
            return presentation instanceof NoteAnchorPresentation;
        }
        return true;
    }

    public static boolean isIsolated(ListIterator<Presentation> listIterator) {
        while (listIterator.hasNext()) {
            if (!(listIterator.next() instanceof AssociationClassAnchorPresentation)) continue;
            return false;
        }
        return true;
    }

    public static Presentation[] getClipedPresentations(EntityClipboard entityClipboard) {
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        if (entityClipboard != null) {
            Iterator iterator = entityClipboard.entityIterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!(e2 instanceof Presentation)) continue;
                Presentation presentation = (Presentation)e2;
                arrayList.add(presentation);
            }
        }
        return arrayList.toArray(new Presentation[arrayList.size()]);
    }

    public static int getMinDepth(Diagram diagram) {
        ArrayList arrayList = Lists.newArrayList();
        if (diagram instanceof UMLDiagram) {
            arrayList.addAll(((UMLDiagram)diagram).getPresentations());
        }
        return DepthUtil.getMinDepth(arrayList);
    }

    public static int getMaxDepth(UMLDiagram uMLDiagram) {
        EList eList = uMLDiagram.getOwnedElements();
        return DepthUtil.getMaxDepth((List<DiagramElement>)eList);
    }

    public static boolean isCloseSet(List<Presentation> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Presentation presentation;
            ListIterator<Presentation> listIterator;
            Presentation presentation2 = list.get(i2);
            if (!presentation2.getClients().isEmpty()) {
                listIterator = presentation2.getClients().listIterator();
                while (listIterator.hasNext()) {
                    presentation = listIterator.next();
                    if (presentation == null || list.contains(presentation)) continue;
                    return false;
                }
            }
            if (presentation2.getServers().isEmpty()) continue;
            listIterator = presentation2.getServers().listIterator();
            while (listIterator.hasNext()) {
                presentation = listIterator.next();
                if (presentation == null || list.contains(presentation)) continue;
                return false;
            }
        }
        return true;
    }

    public static DiagramElement[] getValidAssociationClass(DiagramElement[] diagramElementArray) {
        DiagramElement[] diagramElementArray2 = null;
        List<Presentation> list = PresentationUtil.a(diagramElementArray);
        if (list.size() > 0) {
            ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>(Arrays.asList(diagramElementArray));
            for (int i2 = 0; i2 < list.size(); ++i2) {
                arrayList.remove(list.get(i2));
            }
            diagramElementArray2 = arrayList.toArray(new Presentation[0]);
        } else {
            diagramElementArray2 = diagramElementArray;
        }
        return diagramElementArray2;
    }

    private static List<Presentation> a(DiagramElement[] diagramElementArray) {
        List<DiagramElement> list = Arrays.asList(diagramElementArray);
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List<Presentation> list2;
            JomtPresentation jomtPresentation;
            if (diagramElementArray[i2] instanceof AssociationPathPresentation) {
                jomtPresentation = (AssociationPathPresentation)diagramElementArray[i2];
                list2 = jomtPresentation.getSourcePresentation();
                JomtPresentation jomtPresentation2 = jomtPresentation.getTargetPresentation();
                if (list2 != null && jomtPresentation2 != null && list.contains(list2) && list.contains(jomtPresentation2) || arrayList.contains(jomtPresentation)) continue;
                arrayList.add(jomtPresentation);
                continue;
            }
            if (!(diagramElementArray[i2] instanceof AssociationClassPresentation)) continue;
            jomtPresentation = (AssociationClassPresentation)diagramElementArray[i2];
            list2 = jomtPresentation.getAssociationClassAnchorPresentations();
            if (list2 == null || list2.size() <= 0) {
                if (arrayList.contains(jomtPresentation)) break;
                arrayList.add(jomtPresentation);
                break;
            }
            boolean bl = true;
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                AssociationClassAnchorPresentation associationClassAnchorPresentation = (AssociationClassAnchorPresentation)list2.get(i3);
                AssociationPathPresentation associationPathPresentation = (AssociationPathPresentation)associationClassAnchorPresentation.getAssociationPathPresentation();
                JomtPresentation jomtPresentation3 = associationPathPresentation.getSourcePresentation();
                JomtPresentation jomtPresentation4 = associationPathPresentation.getTargetPresentation();
                if (jomtPresentation3 == null || jomtPresentation4 == null || !list.contains(jomtPresentation3) || !list.contains(jomtPresentation4)) continue;
                bl = false;
                break;
            }
            if (!bl || arrayList.contains(jomtPresentation)) continue;
            arrayList.add(jomtPresentation);
        }
        return arrayList;
    }

    public static DiagramElement[] addAssociationClassParts(DiagramElement[] diagramElementArray) {
        DiagramElement[] diagramElementArray2 = null;
        List<Presentation> list = PresentationUtil.b(diagramElementArray);
        if (list.size() > 0) {
            Presentation[] presentationArray = new Presentation[diagramElementArray.length + list.size()];
            System.arraycopy(diagramElementArray, 0, presentationArray, 0, diagramElementArray.length);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                presentationArray[i2 + diagramElementArray.length] = list.get(i2);
            }
            diagramElementArray2 = presentationArray;
        } else {
            diagramElementArray2 = diagramElementArray;
        }
        return diagramElementArray2;
    }

    private static List<Presentation> b(DiagramElement[] diagramElementArray) {
        List<DiagramElement> list = Arrays.asList(diagramElementArray);
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            JomtPresentation jomtPresentation;
            AssociationClassAnchorPresentation associationClassAnchorPresentation;
            int n2;
            List<Presentation> list2;
            JomtPresentation jomtPresentation2;
            if (diagramElementArray[i2] instanceof AssociationPathPresentation) {
                jomtPresentation2 = (AssociationPathPresentation)diagramElementArray[i2];
                list2 = jomtPresentation2.getAssociationClassAnchorPresentations();
                if (list2 == null || list2.size() <= 0) break;
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    associationClassAnchorPresentation = (AssociationClassAnchorPresentation)list2.get(n2);
                    jomtPresentation = associationClassAnchorPresentation.getAssociationClassPresentation();
                    if (!list.contains(associationClassAnchorPresentation) && !arrayList.contains(associationClassAnchorPresentation)) {
                        arrayList.add(associationClassAnchorPresentation);
                    }
                    if (list.contains(jomtPresentation) || arrayList.contains(jomtPresentation)) continue;
                    arrayList.add(jomtPresentation);
                }
                continue;
            }
            if (!(diagramElementArray[i2] instanceof AssociationClassPresentation)) continue;
            jomtPresentation2 = (AssociationClassPresentation)diagramElementArray[i2];
            list2 = jomtPresentation2.getAssociationClassAnchorPresentations();
            if (list2 == null || list2.size() <= 0) break;
            for (n2 = 0; n2 < list2.size(); ++n2) {
                associationClassAnchorPresentation = (AssociationClassAnchorPresentation)list2.get(n2);
                jomtPresentation = associationClassAnchorPresentation.getAssociationPathPresentation();
                if (!list.contains(associationClassAnchorPresentation) && !arrayList.contains(associationClassAnchorPresentation)) {
                    arrayList.add(associationClassAnchorPresentation);
                }
                if (list.contains(jomtPresentation) || arrayList.contains(jomtPresentation)) continue;
                arrayList.add(jomtPresentation);
            }
        }
        return arrayList;
    }

    public static DiagramElement[] addGroup(DiagramElement[] diagramElementArray) {
        DiagramElement[] diagramElementArray2 = null;
        List<CompositeJomtPresentation> list = PresentationUtil.c(diagramElementArray);
        if (list.size() > 0) {
            Presentation[] presentationArray = new Presentation[diagramElementArray.length + list.size()];
            System.arraycopy(diagramElementArray, 0, presentationArray, 0, diagramElementArray.length);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                presentationArray[i2 + diagramElementArray.length] = list.get(i2);
            }
            diagramElementArray2 = presentationArray;
        } else {
            diagramElementArray2 = diagramElementArray;
        }
        return diagramElementArray2;
    }

    private static List<CompositeJomtPresentation> c(DiagramElement[] diagramElementArray) {
        ArrayList<CompositeJomtPresentation> arrayList = new ArrayList<CompositeJomtPresentation>();
        for (int i2 = 0; i2 < diagramElementArray.length; ++i2) {
            CompositeJomtPresentation compositeJomtPresentation;
            BinaryRelationPresentation binaryRelationPresentation;
            if (diagramElementArray[i2] instanceof GeneralizationPresentation) {
                binaryRelationPresentation = (GeneralizationPresentation)diagramElementArray[i2];
                if (!binaryRelationPresentation.isShared() || arrayList.contains(compositeJomtPresentation = binaryRelationPresentation.getSharedGroup())) continue;
                arrayList.add(compositeJomtPresentation);
                continue;
            }
            if (!(diagramElementArray[i2] instanceof ContainmentPresentation) || !(binaryRelationPresentation = (ContainmentPresentation)diagramElementArray[i2]).isShared() || arrayList.contains(compositeJomtPresentation = binaryRelationPresentation.getSharedGroup())) continue;
            arrayList.add(compositeJomtPresentation);
        }
        return arrayList;
    }

    public static Rectangle2D getBoundsRect(DiagramElement[] diagramElementArray, boolean bl) {
        return PresentationUtil.getBoundsRect(Arrays.asList(diagramElementArray), bl);
    }

    public static Path2D getPath2d(Presentation presentation) {
        if (presentation instanceof TimeConstraintPresentation) {
            TimeConstraintPresentation timeConstraintPresentation = (TimeConstraintPresentation)presentation;
            Pnt2d[] pnt2dArray = timeConstraintPresentation.getPoints().toArray(new Pnt2d[0]);
            if (pnt2dArray == null || pnt2dArray.length < 2) {
                return null;
            }
            Path2D.Double double_ = new Path2D.Double();
            ((Path2D)double_).moveTo(pnt2dArray[0].x, pnt2dArray[0].y);
            for (int i2 = 1; i2 < pnt2dArray.length; ++i2) {
                ((Path2D)double_).lineTo(pnt2dArray[i2].x, pnt2dArray[i2].y);
            }
            return double_;
        }
        if (presentation instanceof PolyLinePresentation) {
            PolyLinePresentation polyLinePresentation = (PolyLinePresentation)presentation;
            Pnt2d[] pnt2dArray = polyLinePresentation.getPoints().toArray(new Pnt2d[0]);
            if (pnt2dArray == null || pnt2dArray.length < 2) {
                return null;
            }
            Path2D.Double double_ = new Path2D.Double();
            ((Path2D)double_).moveTo(pnt2dArray[0].x, pnt2dArray[0].y);
            for (int i3 = 1; i3 < pnt2dArray.length; ++i3) {
                ((Path2D)double_).lineTo(pnt2dArray[i3].x, pnt2dArray[i3].y);
            }
            return double_;
        }
        if (presentation instanceof BinaryRelationPresentation) {
            BinaryRelationPresentation binaryRelationPresentation = (BinaryRelationPresentation)presentation;
            Pnt2d[] pnt2dArray = binaryRelationPresentation.getOuterPoints().toArray(new Pnt2d[0]);
            if (pnt2dArray == null || pnt2dArray.length == 0) {
                pnt2dArray = binaryRelationPresentation.getAllPoints().toArray(new Pnt2d[0]);
            }
            if (pnt2dArray == null || pnt2dArray.length == 0) {
                pnt2dArray = binaryRelationPresentation.getPoints().toArray(new Pnt2d[0]);
            }
            if (pnt2dArray == null || pnt2dArray.length < 2) {
                return null;
            }
            if (!binaryRelationPresentation.isCurve() && !(presentation instanceof MMLinkPresentation) || pnt2dArray.length == 2) {
                Path2D.Double double_ = new Path2D.Double();
                ((Path2D)double_).moveTo(pnt2dArray[0].x, pnt2dArray[0].y);
                for (int i4 = 1; i4 < pnt2dArray.length; ++i4) {
                    ((Path2D)double_).lineTo(pnt2dArray[i4].x, pnt2dArray[i4].y);
                }
                return double_;
            }
            Pnt2d pnt2d = pnt2dArray[0];
            Pnt2d pnt2d2 = pnt2dArray[1];
            Pnt2d pnt2d3 = pnt2dArray[pnt2dArray.length - 2];
            Pnt2d pnt2d4 = pnt2dArray[pnt2dArray.length - 1];
            Path2D.Double double_ = new Path2D.Double();
            ((Path2D)double_).moveTo(pnt2d.x, pnt2d.y);
            ((Path2D)double_).curveTo(pnt2d2.x, pnt2d2.y, pnt2d3.x, pnt2d3.y, pnt2d4.x, pnt2d4.y);
            return double_;
        }
        if (presentation instanceof PathPresentation) {
            PathPresentation pathPresentation = (PathPresentation)presentation;
            Pnt2d[] pnt2dArray = null;
            pnt2dArray = pathPresentation.getOuterPoints().toArray(new Pnt2d[0]);
            if (pnt2dArray == null || pnt2dArray.length == 0) {
                pnt2dArray = pathPresentation.getAllPoints().toArray(new Pnt2d[0]);
            }
            if (pnt2dArray == null || pnt2dArray.length < 2) {
                return null;
            }
            Path2D.Double double_ = new Path2D.Double();
            ((Path2D)double_).moveTo(pnt2dArray[0].x, pnt2dArray[0].y);
            for (int i5 = 1; i5 < pnt2dArray.length; ++i5) {
                ((Path2D)double_).lineTo(pnt2dArray[i5].x, pnt2dArray[i5].y);
            }
            return double_;
        }
        if (presentation instanceof LinePresentation) {
            Path2D.Double double_ = new Path2D.Double();
            ((Path2D)double_).moveTo(((LinePresentation)presentation).getStartLocation().x, ((LinePresentation)presentation).getStartLocation().y);
            ((Path2D)double_).lineTo(((LinePresentation)presentation).getEndLocation().x, ((LinePresentation)presentation).getEndLocation().y);
            return double_;
        }
        return null;
    }

    public static Rectangle2d getBoundsRect(Iterable<DiagramElement> iterable, boolean bl) {
        Rectangle2d rectangle2d = new Rectangle2d();
        boolean bl2 = true;
        for (DiagramElement diagramElement : iterable) {
            Rectangle2d rectangle2d2;
            if (diagramElement instanceof FramePresentation && !((FramePresentation)diagramElement).isVisibility() || diagramElement instanceof ActivityPartitionPresentation && ((ActivityPartitionPresentation)diagramElement).isTop() && !(rectangle2d2 = (ActivityPartition)((ActivityPartitionPresentation)diagramElement).getModel()).isDimension()) continue;
            if (diagramElement instanceof ClassifierPresentation) {
                rectangle2d2 = ((ClassifierPresentation)diagramElement).getBoundsRectWithParameter();
            } else if (diagramElement instanceof JomtPresentation) {
                rectangle2d2 = ((JomtPresentation)diagramElement).getBoundsRect();
            } else if (diagramElement instanceof Shape) {
                Bounds bounds = ((Shape)diagramElement).getBounds();
                rectangle2d2 = new Rectangle2d(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            } else {
                if (!(diagramElement instanceof Edge)) continue;
                rectangle2d2 = PresentationUtil.a(diagramElement);
            }
            if (rectangle2d2.isEmpty()) continue;
            PresentationUtil.resizeOutsideNameForFlowElement(diagramElement, rectangle2d2);
            if (bl2) {
                rectangle2d.setRect((Rectangle2D)rectangle2d2);
                bl2 = false;
                continue;
            }
            rectangle2d.add((Rectangle2D)rectangle2d2);
        }
        return rectangle2d;
    }

    private static Rectangle2d a(DiagramElement diagramElement) {
        EList eList = ((Edge)diagramElement).getWaypoints();
        double d2 = ((Point)eList.get(0)).getX();
        double d3 = ((Point)eList.get(0)).getY();
        double d4 = ((Point)eList.get(0)).getX();
        double d5 = ((Point)eList.get(0)).getY();
        for (Point point : eList) {
            double d6 = point.getX();
            double d7 = point.getY();
            if (d6 < d2) {
                d2 = d6;
            }
            if (d6 > d4) {
                d4 = d6;
            }
            if (d7 < d3) {
                d3 = d7;
            }
            if (!(d7 > d5)) continue;
            d5 = d7;
        }
        Rectangle2d rectangle2d = new Rectangle2d(d2, d3, d4 - d2, d5 - d3);
        return rectangle2d;
    }

    public static Rectangle2d getBoundsRectForHyperlinkIconPopUp(DiagramElement[] diagramElementArray) {
        Rectangle2d rectangle2d = new Rectangle2d();
        boolean bl = true;
        for (DiagramElement diagramElement : diagramElementArray) {
            Bounds bounds;
            GraphicalElement graphicalElement;
            ActivityPartition activityPartition;
            if (!(diagramElement instanceof JomtPresentation || diagramElement instanceof MMDiagramElement || diagramElement instanceof Shape)) {
                Debug.impossible();
            }
            if (diagramElement instanceof FramePresentation && !((FramePresentation)diagramElement).isVisibility() || diagramElement instanceof ActivityPartitionPresentation && ((ActivityPartitionPresentation)diagramElement).isTop() && !(activityPartition = (ActivityPartition)((ActivityPartitionPresentation)diagramElement).getModel()).isDimension()) continue;
            activityPartition = null;
            if (diagramElement instanceof ClassifierPresentation) {
                activityPartition = ((ClassifierPresentation)diagramElement).getBoundsRectWithParameter();
            } else if (diagramElement instanceof JomtPresentation) {
                activityPartition = ((JomtPresentation)diagramElement).getBoundsRect();
            } else if (diagramElement instanceof MMGraphicalShape) {
                graphicalElement = ((MMGraphicalShape)diagramElement).getFigure();
                if (graphicalElement instanceof Group && (bounds = (Rectangle)Iterables.getFirst((Iterable)Iterables.filter((Iterable)((Group)graphicalElement).getMembers(), Rectangle.class), null)) != null) {
                    Bounds bounds2 = bounds.getBounds();
                    activityPartition = new Rectangle2d(bounds2.getX(), bounds2.getY(), bounds2.getWidth(), bounds2.getHeight());
                }
            } else if (diagramElement instanceof MMDiagramElement) {
                graphicalElement = ((MMDiagramElement)diagramElement).getBoundsRect();
                activityPartition = new Rectangle2d(graphicalElement.getX(), graphicalElement.getY(), graphicalElement.getWidth(), graphicalElement.getHeight());
            } else if (diagramElement instanceof Shape) {
                graphicalElement = (Shape)diagramElement;
                bounds = graphicalElement.getBounds();
                activityPartition = new Rectangle2d(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            }
            if (activityPartition.isEmpty()) continue;
            if (diagramElement instanceof JomtPresentation) {
                PresentationUtil.resizeOutsideNameForFlowElement((JomtPresentation)diagramElement, (Rectangle2d)activityPartition);
            }
            if (bl) {
                rectangle2d.setRect((Rectangle2D)activityPartition);
                bl = false;
                continue;
            }
            rectangle2d.add((Rectangle2D)activityPartition);
        }
        return rectangle2d;
    }

    public static Pnt2d getLeftTopPoint(List<Presentation> list) {
        Pnt2d pnt2d = new Pnt2d(0.0, 0.0);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!(list.get(i2) instanceof JomtPresentation)) continue;
            JomtPresentation jomtPresentation = (JomtPresentation)list.get(i2);
            Pnt2d pnt2d2 = jomtPresentation.getLocation();
            if (pnt2d2.getX() < pnt2d.getX()) {
                pnt2d.x = pnt2d2.getX();
            }
            if (!(pnt2d2.getY() < pnt2d.getY())) continue;
            pnt2d.y = pnt2d2.getY();
        }
        return pnt2d;
    }

    public static List<DiagramElement> addRelationsMoveTogether(DiagramElement[] diagramElementArray) {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        arrayList.addAll(Arrays.asList(diagramElementArray));
        for (DiagramElement diagramElement : diagramElementArray) {
            if (!(diagramElement instanceof RectPresentation)) continue;
            arrayList.addAll(PresentationUtil.a((RectPresentation)diagramElement));
        }
        return arrayList.stream().distinct().collect(Collectors.toList());
    }

    private static Set<BinaryRelationPresentation> a(RectPresentation rectPresentation) {
        HashSet<BinaryRelationPresentation> hashSet = new HashSet<BinaryRelationPresentation>();
        hashSet.addAll(rectPresentation.getSourceRelations());
        hashSet.addAll(rectPresentation.getTargetRelations());
        return hashSet;
    }

    private static boolean a(Presentation presentation, List<DiagramElement> list) {
        if (list.contains(presentation)) {
            return true;
        }
        if (presentation instanceof PinPresentation) {
            PinPresentation pinPresentation = (PinPresentation)presentation;
            if (list.contains(pinPresentation.getContainer())) {
                return true;
            }
        } else if (presentation instanceof SequenceMessagePresentation) {
            SequenceMessagePresentation sequenceMessagePresentation = (SequenceMessagePresentation)presentation;
            for (Object e2 : sequenceMessagePresentation.getServers()) {
                SequenceMessageEndPresentation sequenceMessageEndPresentation = (SequenceMessageEndPresentation)e2;
                if (PresentationUtil.a(sequenceMessageEndPresentation, list)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean a(SequenceMessageEndPresentation sequenceMessageEndPresentation, List list) {
        LabelPresentation labelPresentation = sequenceMessageEndPresentation.getFather();
        if (labelPresentation instanceof InteractionUsePresentation) {
            InteractionUsePresentation interactionUsePresentation = (InteractionUsePresentation)labelPresentation;
            for (Object e2 : interactionUsePresentation.getInteractionUse().getCovereds()) {
                Lifeline lifeline = (Lifeline)e2;
                if (list.containsAll(Presentations.getPresentations((EObject)lifeline))) continue;
                return false;
            }
            return true;
        }
        if (labelPresentation instanceof FramePresentation) {
            return true;
        }
        return list.contains(sequenceMessageEndPresentation);
    }

    public static List<DiagramElement> addRelationsMoveTogether(List<DiagramElement> list) {
        return PresentationUtil.addRelationsMoveTogether(list.toArray(new DiagramElement[0]));
    }

    public static List<DiagramElement> removeRelationsNotMoveTogether(List<DiagramElement> list) {
        return PresentationUtil.removeRelationsNotMoveTogether(list.toArray(new DiagramElement[0]));
    }

    public static List<DiagramElement> removeRelationsNotMoveTogether(DiagramElement[] diagramElementArray) {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        arrayList.addAll(Arrays.asList(diagramElementArray));
        for (int i2 = 0; i2 < diagramElementArray.length; ++i2) {
            BinaryRelationPresentation binaryRelationPresentation;
            DiagramElement diagramElement = diagramElementArray[i2];
            if (!(diagramElement instanceof BinaryRelationPresentation) || (binaryRelationPresentation = (BinaryRelationPresentation)diagramElement) instanceof DurationConstraintPresentation || PresentationUtil.a(binaryRelationPresentation.getSourcePresentation(), arrayList) && PresentationUtil.a(binaryRelationPresentation.getTargetPresentation(), arrayList)) continue;
            arrayList.remove(diagramElement);
        }
        return arrayList;
    }

    public static String getVisibilityKindString(VisibilityKind visibilityKind) {
        String string = "";
        if (visibilityKind != null) {
            if (visibilityKind.equals((Object)VisibilityKind.PACKAGE_LITERAL)) {
                string = "~";
            } else if (visibilityKind.equals((Object)VisibilityKind.PRIVATE_LITERAL)) {
                string = "-";
            } else if (visibilityKind.equals((Object)VisibilityKind.PROTECTED_LITERAL)) {
                string = "#";
            } else if (visibilityKind.equals((Object)VisibilityKind.PUBLIC_LITERAL)) {
                string = "+";
            }
        }
        return string;
    }

    protected static String getStereotypesString(List<Stereotype> list) {
        String string = "";
        Stereotype stereotype = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            stereotype = list.get(i2);
            string = string + "<<" + stereotype.getName() + ">>";
        }
        return string;
    }

    protected static String getConstraintsString(List<Constraint> list) {
        String string = "";
        for (Constraint constraint : list) {
            String string2 = PresentationUtil.a(constraint);
            string = string + "{" + PresentationUtil.dealConstraintString(string2) + "}";
        }
        return string;
    }

    private static String a(Constraint constraint) {
        String string = Constraints.getLabel((Constraint)constraint);
        Namespace namespace = constraint.getContext();
        if (namespace instanceof Operation) {
            Operation operation = (Operation)namespace;
            if (operation.getPreconditions().contains((Object)constraint)) {
                return "PRECONDITION:" + string;
            }
            if (operation.getPostconditions().contains((Object)constraint)) {
                return "POSTCONDITION:" + string;
            }
            if (constraint.equals(operation.getBodyCondition())) {
                return "BODYCONDITION:" + string;
            }
        }
        return string;
    }

    public static String dealConstraintString(String string) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split("\n");
        for (n2 = 0; n2 < stringArray.length - 1; ++n2) {
            stringBuilder.append(stringArray[n2] + "\\n");
        }
        stringBuilder.append(stringArray[n2]);
        return stringBuilder.toString();
    }

    public static DiagramElement[] toPresentationArray(List<? extends DiagramElement> list) {
        return list.toArray(new DiagramElement[list.size()]);
    }

    public static DiagramElement[] removeChildPresentations(DiagramElement[] diagramElementArray) {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>(Arrays.asList(diagramElementArray));
        ArrayList<JomtPresentation> arrayList2 = new ArrayList<JomtPresentation>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            JomtPresentation jomtPresentation;
            Presentation presentation;
            Presentation presentation2;
            if (!(iterator.next() instanceof Presentation) || !((presentation2 = (Presentation)iterator.next()) instanceof JomtPresentation) || (presentation = (jomtPresentation = (JomtPresentation)presentation2).getCompositeParent()) == null) continue;
            arrayList2.add(jomtPresentation);
        }
        arrayList.removeAll(arrayList2);
        return PresentationUtil.toPresentationArray(arrayList);
    }

    public static DiagramElement[] removeFramePresentations(DiagramElement[] diagramElementArray) {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>(Arrays.asList(diagramElementArray));
        for (int i2 = 0; i2 < diagramElementArray.length; ++i2) {
            if (!(diagramElementArray[i2] instanceof FramePresentation)) continue;
            arrayList.remove(diagramElementArray[i2]);
        }
        return PresentationUtil.toPresentationArray(arrayList);
    }

    public static DiagramElement[] removeTopSwimlanes(DiagramElement[] diagramElementArray, UMLActivityDiagram uMLActivityDiagram) {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>(Arrays.asList(diagramElementArray));
        for (int i2 = 0; i2 < diagramElementArray.length; ++i2) {
            EObject eObject;
            if (!(diagramElementArray[i2] instanceof Presentation) || (eObject = ((Presentation)diagramElementArray[i2]).getModel()) == null || PartitionUtil.getTopSwimlane(uMLActivityDiagram, true) != eObject && PartitionUtil.getTopSwimlane(uMLActivityDiagram, false) != eObject) continue;
            arrayList.remove(diagramElementArray[i2]);
        }
        return PresentationUtil.toPresentationArray(arrayList);
    }

    public static LifelinePresentation getFronterEnteredClassifierRole(List<JomtPresentation> list, Pnt2d pnt2d) {
        ArrayList<JomtPresentation> arrayList = new ArrayList<JomtPresentation>();
        for (JomtPresentation jomtPresentation : list) {
            if (!(jomtPresentation instanceof LifelinePresentation) || !jomtPresentation.getBoundsRect().contains((Point2D)pnt2d)) continue;
            arrayList.add(jomtPresentation);
        }
        if (PresentationUtil.getFrontestPresentation(arrayList) != null) {
            return (LifelinePresentation)PresentationUtil.getFrontestPresentation(arrayList);
        }
        return null;
    }

    public static JomtPresentation getFrontestPresentation(Collection<JomtPresentation> collection) {
        JomtPresentation jomtPresentation = null;
        for (JomtPresentation jomtPresentation2 : collection) {
            if (jomtPresentation == null) {
                jomtPresentation = jomtPresentation2;
                continue;
            }
            if (jomtPresentation2.getDepth() >= jomtPresentation.getDepth()) continue;
            jomtPresentation = jomtPresentation2;
        }
        return jomtPresentation;
    }

    public static double getOffset(String string) {
        double d2 = 10.0;
        String string2 = RuntimeGlobal.sysProp.getString(string);
        try {
            if (string2 == null) {
                return d2;
            }
            d2 = Double.parseDouble(string2);
            if (d2 < 0.0) {
                d2 = 0.0;
            } else if (d2 > 20.0) {
                d2 = 20.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            b.error("The key '{}' isn't number. Please set number format", (Object)string);
            throw new IllegalStateException("The key '" + string + "' isn't number. Please set number format.");
        }
        return d2;
    }

    public static boolean isShowTaggedValueOnDiagram() {
        return RuntimeGlobal.sysProp.getBooleanWithDefault("ui.editor.show_tagged_value_function");
    }

    public static boolean isInvalidateTaggedValue(String string) {
        String string2 = string.toLowerCase();
        return Arrays.asList(a).contains(string) || string2.startsWith("jude.") || string2.startsWith("create_description") || string.equals("_jude.profiles_obfuscated");
    }

    public static boolean isNormalNotation(JomtPresentation jomtPresentation) {
        return (jomtPresentation.getNotationType() != 1 || !StereotypeUtil.canObjectBeIcon((Lifeline)jomtPresentation.getModel())) && (jomtPresentation.getNotationType() != 2 || !PresentationUtil.isValidCustomIcon(jomtPresentation));
    }

    public static boolean isValidCustomIcon(JomtPresentation jomtPresentation) {
        if (jomtPresentation != null) {
            StereotypeDefinition stereotypeDefinition = UMLProfileManager.instance().getStereotypeDefinition(jomtPresentation.getIconID());
            return stereotypeDefinition != null && stereotypeDefinition.isValidIcon(jomtPresentation.getModel(), jomtPresentation.getDiagram(), jomtPresentation.getStereotype());
        }
        return false;
    }

    private static boolean a(LabelPresentation labelPresentation) {
        return labelPresentation != null && !"".equals(labelPresentation.getLabel());
    }

    public static void resizeOutsideNameForFlowElement(DiagramElement diagramElement, Rectangle2d rectangle2d) {
        ObjectNodePresentation objectNodePresentation;
        if (diagramElement instanceof ActionPresentation) {
            ActionPresentation actionPresentation = (ActionPresentation)diagramElement;
            VectorCustomeIconSpec vectorCustomeIconSpec = VectorCustomeIconSpec.getSpec(actionPresentation.getStereotype());
            if (vectorCustomeIconSpec != null && !vectorCustomeIconSpec.isNameInside()) {
                double d2 = actionPresentation.getNameWidth();
                if (d2 > actionPresentation.getWidth()) {
                    rectangle2d.setRect(actionPresentation.getCenterX() - d2 / 2.0, rectangle2d.y, d2, rectangle2d.height + actionPresentation.getNameHeight());
                } else {
                    rectangle2d.setRect(rectangle2d.x, rectangle2d.y, rectangle2d.width, rectangle2d.height + actionPresentation.getNameHeight());
                }
            }
        } else if (diagramElement instanceof ObjectNodePresentation && (objectNodePresentation = (ObjectNodePresentation)diagramElement) instanceof PinPresentation) {
            PinPresentation pinPresentation = (PinPresentation)objectNodePresentation;
            if (PresentationUtil.a(pinPresentation.getStatePresentation())) {
                rectangle2d.add((Rectangle2D)pinPresentation.getStatePresentation().getRect());
            }
            if (PresentationUtil.a(pinPresentation.getNamePresentation())) {
                rectangle2d.add((Rectangle2D)pinPresentation.getNamePresentation().getRect());
            }
        }
    }

    public static List<Presentation> getDeletedAssociationPathPresentations(AssociationPathPresentation associationPathPresentation) {
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        arrayList.add(associationPathPresentation);
        List<AssociationClassAnchorPresentation> list = associationPathPresentation.getAssociationClassAnchorPresentations();
        arrayList.addAll(list);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AssociationClassAnchorPresentation associationClassAnchorPresentation = list.get(i2);
            AssociationClassPresentation associationClassPresentation = (AssociationClassPresentation)associationClassAnchorPresentation.getAssociationClassPresentation();
            if (associationClassPresentation.getAssociationClassAnchorPresentations().size() != 1) continue;
            arrayList.add(associationClassPresentation);
            for (int i3 = 0; i3 < associationClassPresentation.getClients().size(); ++i3) {
                if (associationClassPresentation.getClients().get(i3) instanceof AssociationPathPresentation) {
                    List<Presentation> list2 = PresentationUtil.getDeletedAssociationPathPresentations((AssociationPathPresentation)associationClassPresentation.getClients().get(i3));
                    arrayList.addAll(list2);
                    continue;
                }
                arrayList.add((Presentation)associationClassPresentation.getClients().get(i3));
            }
        }
        return arrayList;
    }

    @Keep
    public static boolean isFeatureValidContainer(RectPresentation rectPresentation) {
        if (rectPresentation == null) {
            return false;
        }
        EObject eObject = rectPresentation.getModel();
        if (!(eObject instanceof AttributeOwner || eObject instanceof OperationOwner || eObject instanceof Enumeration)) {
            return false;
        }
        if (rectPresentation instanceof ClassifierPresentation) {
            if (rectPresentation instanceof UseCasePresentation) {
                return false;
            }
            if (rectPresentation instanceof RequirementPresentation) {
                return false;
            }
            return !(rectPresentation instanceof TestCasePresentation);
        }
        return false;
    }

    public static void updateFrame(UMLDiagram uMLDiagram) {
        FramePresentation framePresentation = PresentationUtil.a(uMLDiagram);
        if (framePresentation != null) {
            framePresentation.resize();
        }
    }

    private static FramePresentation a(UMLDiagram uMLDiagram) {
        for (Presentation presentation : uMLDiagram.getPresentations()) {
            if (!(presentation instanceof FramePresentation)) continue;
            return (FramePresentation)presentation;
        }
        return null;
    }

    public static FramePresentation getFramePresentation() {
        return JmodelFactory.eINSTANCE.createFramePresentation();
    }

    public static boolean isFramePresentationClient(Presentation presentation) {
        return presentation instanceof JomtPresentation && ((JomtPresentation)presentation).getContainer() instanceof FramePresentation;
    }

    public static List<Property> getSameTypeProperty(Classifier classifier, Element element) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : classifier.getAllAttributes()) {
            if (!element.equals(property.getType())) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public static List<Property> getSameTypeCompositeProp(Classifier classifier, Element element) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : PresentationUtil.getSameTypeProperty(classifier, element)) {
            if (!property.isComposite()) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public static List<Property> getSameTypeNonCompositeProp(Classifier classifier, Element element) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : PresentationUtil.getSameTypeProperty(classifier, element)) {
            if (property.isComposite()) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public static void adjustLocation(RectPresentation rectPresentation, Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        double d2;
        double d3;
        String string;
        if (PresentationUtil.isFramePresentationClient(rectPresentation)) {
            string = FrameOperations.getPresentationPosition(rectangle2d, rectPresentation.getRect());
            Pnt2d pnt2d = FrameOperations.getAdjustPosition(new Pnt2d(rectPresentation.getCenterX(), rectPresentation.getCenterY()), rectPresentation.getRect(), rectangle2d2, string);
            d3 = pnt2d.x;
            d2 = pnt2d.y;
        } else {
            double d4 = rectangle2d2.getWidth() / rectangle2d.getWidth();
            double d5 = rectangle2d2.getHeight() / rectangle2d.getHeight();
            double d6 = rectPresentation.getCenterX() - rectangle2d.x;
            double d7 = rectPresentation.getCenterY() - rectangle2d.y;
            double d8 = d6 * d4;
            double d9 = d7 * d5;
            d3 = rectangle2d2.x + d8;
            d2 = rectangle2d2.y + d9;
        }
        string = PresentationUtil.a(rectPresentation, rectangle2d2, new Pnt2d(d3, d2));
        rectPresentation.setLocation((Pnt2d)string);
    }

    private static Pnt2d a(RectPresentation rectPresentation, Rectangle2d rectangle2d, Pnt2d pnt2d) {
        return new Pnt2d(pnt2d.getX() - rectPresentation.getWidth() / 2.0, pnt2d.getY() - rectPresentation.getHeight() / 2.0);
    }

    public static void setNoteAnchorsVisibility(BinaryRelationPresentation binaryRelationPresentation) {
        Object[] objectArray = binaryRelationPresentation.getClients().toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Presentation presentation = (Presentation)objectArray[i2];
            Presentation presentation2 = presentation.getServer(0);
            if (!(presentation instanceof NoteAnchorPresentation) || !(presentation2 instanceof NotePresentation)) continue;
            ((NoteAnchorPresentation)presentation).setVisibility(binaryRelationPresentation.isVisibility());
        }
    }
}

