/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel;

import java.util.ArrayList;
import java.util.List;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.jmodel.ClassifierPresentationUtil;
import net.astah.jmodel.EnumerationPresentation;
import net.astah.jmodel.StereotypeUtil;
import net.astah.jmodel.alias.AliasAccessor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;

public class EnumerationPresentationUtil
extends ClassifierPresentationUtil {
    public static final int ENUMERATION_LITERAL_NAME = 0;
    public static final int ENUMERATION_LITERAL_ALIAS_NAME = 1;

    public static List<String[]> getEnumerationLiteralInfos(EnumerationPresentation enumerationPresentation) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        EList eList = ((Enumeration)enumerationPresentation.getModel()).getOwnedLiterals();
        for (int i2 = 0; i2 < eList.size(); ++i2) {
            EnumerationLiteral enumerationLiteral = (EnumerationLiteral)eList.get(i2);
            String[] stringArray = new String[]{enumerationLiteral.getName(), AliasAccessor.getIndicatoryName(enumerationLiteral)};
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public static double getEnumerationLineY(EnumerationPresentation enumerationPresentation) {
        if (enumerationPresentation.isAllOperationVisibility()) {
            double d2 = EnumerationPresentationUtil.getMethodLineY(enumerationPresentation) + 4.0;
            double d3 = enumerationPresentation.getLabelHeight();
            List<List<Object>> list = enumerationPresentation.getOperationInfos();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                d2 += d3;
            }
            return d2 + 4.0;
        }
        return EnumerationPresentationUtil.getMethodLineY(enumerationPresentation);
    }

    public static boolean isShown(EnumerationPresentation enumerationPresentation, EnumerationLiteral enumerationLiteral) {
        return !EnumerationPresentationUtil.a(enumerationPresentation) && enumerationLiteral != null && enumerationPresentation.isAllEnumerationLiteralVisibility();
    }

    private static boolean a(EnumerationPresentation enumerationPresentation) {
        return enumerationPresentation.getNotationType() != 0 && StereotypeUtil.canBeIconClassifier(enumerationPresentation.getStereotype());
    }

    public static Rectangle2d getEnumerationLiteralRect(EnumerationPresentation enumerationPresentation, EnumerationLiteral enumerationLiteral) {
        double d2 = enumerationPresentation.getLabelHeight();
        double d3 = EnumerationPresentationUtil.getEnumerationLineY(enumerationPresentation) + 4.0;
        Enumeration enumeration = (Enumeration)enumerationPresentation.getModel();
        for (EnumerationLiteral enumerationLiteral2 : enumeration.getOwnedLiterals()) {
            if (!EnumerationPresentationUtil.isShown(enumerationPresentation, enumerationLiteral2)) continue;
            if (enumerationLiteral2 == enumerationLiteral) {
                double d4 = enumerationPresentation.getLocation().x + 10.0 - 2.0;
                double d5 = enumerationPresentation.getWidth() - 20.0 + 4.0;
                return new Rectangle2d(d4, d3, d5, d2);
            }
            d3 += d2;
        }
        return new Rectangle2d();
    }

    public static List<EnumerationLiteral> getStructualEnumerationLiterals(EnumerationPresentation enumerationPresentation) {
        List<EnumerationLiteral> list = enumerationPresentation.getEnumerationLiterals();
        EList<EnumerationLiteral> eList = EnumerationPresentationUtil.getTargetEnumerationLIterals(enumerationPresentation, list);
        return eList;
    }

    public static EList<EnumerationLiteral> getTargetEnumerationLIterals(EnumerationPresentation enumerationPresentation, List<? extends EnumerationLiteral> list) {
        BasicEList basicEList = new BasicEList(list.size());
        if (enumerationPresentation.isAllEnumerationLiteralVisibility()) {
            for (EnumerationLiteral enumerationLiteral : list) {
                basicEList.add((Object)enumerationLiteral);
            }
        }
        return basicEList;
    }
}

