/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.astah.dd.di.DiagramElement;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.HeaderCellPresentation;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.NoteAnchorPresentation;
import net.astah.jmodel.NotePresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.TextPresentation;
import net.astah.jmodel.UMLDiagram;

public class DepthUtil {
    public static void setDepthAsForeground(UMLDiagram uMLDiagram, Presentation[] presentationArray) {
        List<DiagramElement> list = Arrays.asList(presentationArray);
        List<Presentation> list2 = DepthUtil.a(uMLDiagram);
        list2.removeAll(list);
        int n2 = DepthUtil.getMinDepth(list2);
        int n3 = DepthUtil.getMaxDepth(list);
        int n4 = n3 - n2 + 1;
        if (n4 > 0) {
            for (int i2 = 0; i2 < presentationArray.length; ++i2) {
                JomtPresentation jomtPresentation = (JomtPresentation)presentationArray[i2];
                jomtPresentation.setSimpleDepth(jomtPresentation.getDepth() - n4);
                jomtPresentation.notifyObservers();
            }
        }
    }

    public static int getMinDepth(Collection<Presentation> collection) {
        int n2 = 0x7FFFFFF5;
        for (Presentation presentation : collection) {
            JomtPresentation jomtPresentation;
            if (!(presentation instanceof JomtPresentation) || (jomtPresentation = (JomtPresentation)presentation).getDepth() == Integer.MIN_VALUE) continue;
            n2 = Math.min(n2, jomtPresentation.getDepth());
        }
        return n2;
    }

    public static int getMaxDepth(List<DiagramElement> list) {
        int n2 = Integer.MIN_VALUE;
        for (JomtPresentation jomtPresentation : Iterables.filter(list, JomtPresentation.class)) {
            n2 = Math.max(n2, jomtPresentation.getDepth());
        }
        return n2;
    }

    public static int getMinDepthExceptNote(List<Presentation> list) {
        int n2 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Presentation presentation = list.get(i2);
            if (!(presentation instanceof JomtPresentation) || presentation instanceof NotePresentation || presentation instanceof NoteAnchorPresentation) continue;
            JomtPresentation jomtPresentation = (JomtPresentation)presentation;
            n2 = Math.min(n2, jomtPresentation.getDepth());
        }
        return n2;
    }

    public static int getMinDepthExceptText(List<Presentation> list) {
        int n2 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Presentation presentation = list.get(i2);
            if (!(presentation instanceof JomtPresentation) || presentation instanceof TextPresentation) continue;
            JomtPresentation jomtPresentation = (JomtPresentation)presentation;
            n2 = Math.min(n2, jomtPresentation.getDepth());
        }
        return n2;
    }

    private static List<Presentation> a(UMLDiagram uMLDiagram) {
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        for (Presentation presentation : uMLDiagram.getPresentations()) {
            ActivityPartitionPresentation activityPartitionPresentation;
            if (presentation instanceof ActivityPartitionPresentation ? (activityPartitionPresentation = (ActivityPartitionPresentation)presentation).isTop() && !activityPartitionPresentation.isDimension() : presentation instanceof HeaderCellPresentation) continue;
            arrayList.add(presentation);
        }
        return arrayList;
    }
}

