/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel;

import com.change_vision.judebiz.model.FlowChartUtil;
import java.awt.Color;
import java.util.List;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.jmodel.AcceptEventActionPresentation;
import net.astah.jmodel.AcceptTimeEventActionPresentation;
import net.astah.jmodel.ActionPresentation;
import net.astah.jmodel.ActivityParameterNodePresentation;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.ArtifactPresentation;
import net.astah.jmodel.CallBehaviorActionPresentation;
import net.astah.jmodel.ChoicePresentation;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.ComponentInstancePresentation;
import net.astah.jmodel.ComponentPresentation;
import net.astah.jmodel.DecisionNodePresentation;
import net.astah.jmodel.DeepHistoryPresentation;
import net.astah.jmodel.EntryPointPresentation;
import net.astah.jmodel.ExitPointPresentation;
import net.astah.jmodel.FlowFinalNodePresentation;
import net.astah.jmodel.InstancePresentation;
import net.astah.jmodel.InstanceSpecificationPresentation;
import net.astah.jmodel.InteractionUsePresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jmodel.MergeNodePresentation;
import net.astah.jmodel.ModelPresentation;
import net.astah.jmodel.NodeInstancePresentation;
import net.astah.jmodel.NodePresentation;
import net.astah.jmodel.NotePresentation;
import net.astah.jmodel.ObjectNodePresentation;
import net.astah.jmodel.ObjectPresentation;
import net.astah.jmodel.PackagePresentation;
import net.astah.jmodel.PartPresentation;
import net.astah.jmodel.PortPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.ProjectPropertyUtil;
import net.astah.jmodel.PseudoStatePresentation;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.RequirementPresentation;
import net.astah.jmodel.SendSignalActionPresentation;
import net.astah.jmodel.ShallowHistoryPresentation;
import net.astah.jmodel.StateInvariantPresentation;
import net.astah.jmodel.StatePresentation;
import net.astah.jmodel.StateVertexPresentation;
import net.astah.jmodel.SubmachineStatePresentation;
import net.astah.jmodel.TestCasePresentation;
import net.astah.jmodel.TextPresentation;
import net.astah.jmodel.UseCasePresentation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import proguard.annotation.Keep;

@Keep
public class ColorUtil {
    @Keep
    public static CColor getDefaultColor(RectPresentation rectPresentation) {
        CColor cColor = null;
        if (rectPresentation instanceof ClassifierPresentation) {
            cColor = ColorUtil.a((ClassifierPresentation)rectPresentation);
        } else if (rectPresentation instanceof PackagePresentation) {
            cColor = ColorUtil.a((PackagePresentation)rectPresentation);
        } else if (rectPresentation instanceof InstancePresentation) {
            cColor = ColorUtil.a((InstancePresentation)rectPresentation);
        } else if (rectPresentation instanceof StateVertexPresentation) {
            cColor = ColorUtil.a((StateVertexPresentation)rectPresentation);
        } else if (rectPresentation instanceof ObjectPresentation) {
            cColor = rectPresentation instanceof LifelinePresentation ? ProjectPropertyUtil.getColorValue("uml.color.seq_lifeline") : (rectPresentation instanceof ObjectPresentation ? ProjectPropertyUtil.getColorValue("uml.color.com_lifeline") : ProjectPropertyUtil.getColorValue("uml.color.role"));
        } else if (rectPresentation instanceof NotePresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.note");
        } else if (rectPresentation instanceof PartPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.part");
        } else if (rectPresentation instanceof PortPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.port");
        } else if (rectPresentation instanceof ActivityPartitionPresentation) {
            cColor = FlowChartUtil.isFlowChartDiagram(rectPresentation.getDiagram()) ? ProjectPropertyUtil.getColorValue("uml.color.lane") : ProjectPropertyUtil.getColorValue("uml.color.partition");
        } else if (rectPresentation instanceof InteractionUsePresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.interaction_use");
        } else if (rectPresentation instanceof StateInvariantPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.state_invariant");
        } else if (rectPresentation instanceof ActionPresentation || rectPresentation instanceof SendSignalActionPresentation || rectPresentation instanceof AcceptEventActionPresentation || rectPresentation instanceof AcceptTimeEventActionPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.action_state");
        } else if (rectPresentation instanceof CallBehaviorActionPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.sub_activity");
        } else if (rectPresentation instanceof CallBehaviorActionPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.sub_activity");
        } else if (rectPresentation instanceof FlowFinalNodePresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.flow_final_node");
        } else if (rectPresentation instanceof DecisionNodePresentation || rectPresentation instanceof MergeNodePresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.merge");
        } else if (rectPresentation instanceof ObjectNodePresentation) {
            cColor = rectPresentation instanceof ActivityParameterNodePresentation ? ProjectPropertyUtil.getColorValue("uml.color.activity_parameter_node") : ProjectPropertyUtil.getColorValue("uml.color.object_flow_state");
        } else if (rectPresentation instanceof TextPresentation || rectPresentation instanceof RectPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("other.color.common");
        }
        return cColor;
    }

    private static CColor a(StateVertexPresentation stateVertexPresentation) {
        CColor cColor = null;
        if (stateVertexPresentation instanceof PseudoStatePresentation) {
            cColor = ColorUtil.a((PseudoStatePresentation)stateVertexPresentation);
        } else if (stateVertexPresentation instanceof StatePresentation) {
            cColor = ColorUtil.a((StatePresentation)stateVertexPresentation);
        }
        return cColor;
    }

    private static CColor a(StatePresentation statePresentation) {
        CColor cColor = null;
        if (statePresentation != null) {
            cColor = statePresentation instanceof SubmachineStatePresentation ? ProjectPropertyUtil.getColorValue("uml.color.submachine_state") : ProjectPropertyUtil.getColorValue("uml.color.composite_state");
        }
        return cColor;
    }

    private static CColor a(PseudoStatePresentation pseudoStatePresentation) {
        CColor cColor = null;
        if (pseudoStatePresentation instanceof ShallowHistoryPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.shallow_history");
        } else if (pseudoStatePresentation instanceof DeepHistoryPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.deep_history");
        } else if (pseudoStatePresentation instanceof ChoicePresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.choice");
        } else if (pseudoStatePresentation instanceof EntryPointPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.entrypoint");
        } else if (pseudoStatePresentation instanceof ExitPointPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.exitpoint");
        }
        return cColor;
    }

    private static CColor a(InstancePresentation instancePresentation) {
        CColor cColor = null;
        if (instancePresentation instanceof InstanceSpecificationPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.role");
        } else if (instancePresentation instanceof NodeInstancePresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.node_instance");
        } else if (instancePresentation instanceof ComponentInstancePresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.component_instance");
        }
        return cColor;
    }

    private static CColor a(PackagePresentation packagePresentation) {
        CColor cColor;
        CColor cColor2 = ProjectPropertyUtil.getColorValue("uml.color.package");
        String string = packagePresentation.getStereotype();
        if (string != null && (cColor = ProjectPropertyUtil.getStereotypeColor(string)) != null) {
            return cColor;
        }
        if (packagePresentation instanceof ModelPresentation) {
            cColor2 = ProjectPropertyUtil.getColorValue("uml.color.model");
        }
        return cColor2;
    }

    private static CColor a(ClassifierPresentation classifierPresentation) {
        CColor cColor = ProjectPropertyUtil.getColorValue("uml.color.class");
        if (classifierPresentation instanceof NodePresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.node");
        } else if (classifierPresentation instanceof ComponentPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.component");
        } else if (classifierPresentation instanceof ArtifactPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.artifact");
        } else if (classifierPresentation instanceof UseCasePresentation) {
            cColor = ProjectPropertyUtil.getColorValue("uml.color.usecase");
            String string = classifierPresentation.getStereotype();
            if (string == null || string.equals("")) {
                return cColor;
            }
            CColor cColor2 = ProjectPropertyUtil.getStereotypeColor(string);
            if (cColor2 != null) {
                return cColor2;
            }
        } else if (classifierPresentation instanceof RequirementPresentation) {
            cColor = ProjectPropertyUtil.getColorValue("sysml.color.requirement");
            CColor cColor3 = ColorUtil.a(classifierPresentation, cColor);
            if (cColor3 != null) {
                return cColor3;
            }
        } else if (classifierPresentation instanceof TestCasePresentation) {
            cColor = ProjectPropertyUtil.getColorValue("sysml.color.testcase");
            CColor cColor4 = ColorUtil.a(classifierPresentation, cColor);
            if (cColor4 != null) {
                return cColor4;
            }
        } else {
            String string = classifierPresentation.getStereotype();
            if (string == null || string.equals("")) {
                cColor = ProjectPropertyUtil.getColorValue("uml.color.class");
            } else {
                CColor cColor5 = ProjectPropertyUtil.getStereotypeColor(string);
                if (cColor5 != null) {
                    return cColor5;
                }
            }
        }
        return cColor;
    }

    public static void setStereotypeColor(Stereotype stereotype) {
    }

    public static void setStereotypeColor(Element element) {
        if (element == null) {
            return;
        }
    }

    private static void a(Element element, CColor cColor) {
        List<Presentation> list = Presentations.getPresentations((EObject)element);
        for (Presentation presentation : list) {
            if (!(presentation instanceof LabelPresentation)) continue;
            LabelPresentation labelPresentation = (LabelPresentation)presentation;
            labelPresentation.setBodyColor(cColor);
        }
    }

    private static void a(Classifier classifier) {
    }

    private static CColor a(ClassifierPresentation classifierPresentation, CColor cColor) {
        String string;
        CColor cColor2;
        if ((cColor == null || Color.WHITE.equals(((SwingColor)cColor).getComponent())) && (cColor2 = ProjectPropertyUtil.getStereotypeColor(string = classifierPresentation.getStereotype())) != null) {
            return cColor2;
        }
        return null;
    }
}

