/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel;

import java.awt.Font;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.util.GolfUtilities;
import net.astah.jmodel.ActionPresentation;
import net.astah.jmodel.CustomResizeLogic;
import net.astah.jmodel.LabelPresentation;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.jomt.jutil.TextUtil;
import net.astah.jomt.jutil.VectorCustomeIconSpec;
import proguard.annotation.Keep;

@Keep
public class ActionStateCustomResizeLogic
extends CustomResizeLogic {
    @Override
    public boolean isValidTarget(LabelPresentation labelPresentation) {
        if (labelPresentation.getNotationType() != 1) {
            return false;
        }
        VectorCustomeIconSpec vectorCustomeIconSpec = VectorCustomeIconSpec.getSpec(labelPresentation.getStereotype());
        return vectorCustomeIconSpec != null;
    }

    @Override
    public void resize(LabelPresentation labelPresentation) {
        double d2;
        ActionPresentation actionPresentation = (ActionPresentation)labelPresentation;
        VectorCustomeIconSpec vectorCustomeIconSpec = VectorCustomeIconSpec.getSpec(labelPresentation.getStereotype());
        if (vectorCustomeIconSpec == null) {
            return;
        }
        if (!vectorCustomeIconSpec.isNameInside()) {
            this.a(actionPresentation);
            return;
        }
        Pnt2d[] pnt2dArray = vectorCustomeIconSpec.getNamePointsRatio();
        double d3 = pnt2dArray[1].x * 2.0;
        double d4 = pnt2dArray[1].y * 2.0;
        double d5 = labelPresentation.getWidth() * d3;
        double d6 = labelPresentation.getHeight() * d4;
        double d7 = this.getNameWidth(actionPresentation);
        double d8 = this.getNameHeight(actionPresentation);
        boolean bl = false;
        if (vectorCustomeIconSpec.isfixedAspectRatio()) {
            if (d7 != d5 && actionPresentation.isDoAutoResize()) {
                if (d7 > d8) {
                    actionPresentation.setWidth(d7 / d3);
                    actionPresentation.setHeight(actionPresentation.getWidth());
                    bl = true;
                } else {
                    actionPresentation.setHeight(d8 / d4);
                    actionPresentation.setWidth(actionPresentation.getHeight());
                    bl = true;
                }
            } else if (d8 > d6 && !actionPresentation.isDoAutoResize()) {
                d2 = d8 / d6;
                actionPresentation.setHeight(Math.sqrt(d2) * actionPresentation.getHeight());
                actionPresentation.setWidth(actionPresentation.getHeight());
                bl = true;
            }
        } else {
            if (d7 != d5 && actionPresentation.isDoAutoResize()) {
                actionPresentation.setWidth(d7 / d3);
                bl = true;
            }
            if (d8 != d6 && actionPresentation.isDoAutoResize()) {
                actionPresentation.setHeight(d8 / d4);
                bl = true;
            } else if (d8 > d6 && !actionPresentation.isDoAutoResize()) {
                actionPresentation.setHeight(d8 / d4);
                bl = true;
            }
        }
        d2 = this.getMinWidth(labelPresentation);
        if (vectorCustomeIconSpec.isfixedAspectRatio()) {
            if (d2 > labelPresentation.getWidth()) {
                labelPresentation.setWidth(d2);
                labelPresentation.setHeight(d2);
            }
        } else {
            double d9 = this.getMinHeight(labelPresentation);
            if (d2 > labelPresentation.getWidth()) {
                labelPresentation.setWidth(d2);
            }
            if (d9 > labelPresentation.getHeight()) {
                labelPresentation.setHeight(d9);
            }
        }
        if (bl) {
            actionPresentation.resizeSwimlane();
        }
    }

    private void a(LabelPresentation labelPresentation) {
        if (labelPresentation.isDoAutoResize()) {
            if (labelPresentation.getWidth() != this.getInitialWidth(labelPresentation)) {
                labelPresentation.setWidth(this.getInitialWidth(labelPresentation));
            }
            if (labelPresentation.getHeight() != this.getInitialHeight(labelPresentation)) {
                labelPresentation.setHeight(this.getInitialHeight(labelPresentation));
            }
        }
    }

    @Override
    public double getMinWidth(LabelPresentation labelPresentation) {
        VectorCustomeIconSpec vectorCustomeIconSpec = VectorCustomeIconSpec.getSpec(labelPresentation.getStereotype());
        if (vectorCustomeIconSpec == null) {
            return 10.0;
        }
        return vectorCustomeIconSpec.getMinimumSize().x;
    }

    @Override
    public double getMinHeight(LabelPresentation labelPresentation) {
        VectorCustomeIconSpec vectorCustomeIconSpec = VectorCustomeIconSpec.getSpec(labelPresentation.getStereotype());
        if (vectorCustomeIconSpec == null) {
            return 10.0;
        }
        return vectorCustomeIconSpec.getMinimumSize().y;
    }

    public double getInitialWidth(LabelPresentation labelPresentation) {
        VectorCustomeIconSpec vectorCustomeIconSpec = VectorCustomeIconSpec.getSpec(labelPresentation.getStereotype());
        if (vectorCustomeIconSpec == null) {
            return 10.0;
        }
        return vectorCustomeIconSpec.getInitialSize().x;
    }

    public double getInitialHeight(LabelPresentation labelPresentation) {
        VectorCustomeIconSpec vectorCustomeIconSpec = VectorCustomeIconSpec.getSpec(labelPresentation.getStereotype());
        if (vectorCustomeIconSpec == null) {
            return 10.0;
        }
        return vectorCustomeIconSpec.getInitialSize().y;
    }

    @Override
    public double getNameWidth(LabelPresentation labelPresentation) {
        String[] stringArray = TextUtil.devideMultiLineString(labelPresentation.getLabel());
        double d2 = 0.0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            double d3 = JomtFontUtilities.computeStringWidth(labelPresentation.getFont(), stringArray[i2]);
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    @Override
    public double getNameHeight(LabelPresentation labelPresentation) {
        VectorCustomeIconSpec vectorCustomeIconSpec = VectorCustomeIconSpec.getSpec(labelPresentation.getStereotype());
        if (labelPresentation.isDoAutoResize() || !vectorCustomeIconSpec.isNameInside()) {
            double d2 = 1.0;
            String string = labelPresentation.getLabel();
            if (string == null || string.equals("")) {
                string = "m";
            }
            double d3 = JomtFontUtilities.computeStringHeight(labelPresentation.getFont(), string);
            String[] stringArray = TextUtil.devideMultiLineString(labelPresentation.getLabel());
            return (d3 + d2) * (double)stringArray.length - d2;
        }
        double d4 = labelPresentation.getWidth() * vectorCustomeIconSpec.getNamePointsRatio()[1].x * 2.0;
        double d5 = 0.0;
        double d6 = GolfUtilities.computeMultiLineStringHeight((Font)labelPresentation.getFont(), (String)labelPresentation.getLabel(), (double)d4, (double)d5);
        return d6;
    }
}

