/*
 * Decompiled with CFR 0.152.
 */
package net.astah.golf.widget.impl;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import javax.swing.ImageIcon;
import net.astah.golf.util.Base64Util;
import net.astah.golf.util.ReplaceableObjectInputStream;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.WidgetFactory;
import net.astah.golf.widget.WidgetPackage;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.golf.widget.swing.SwingImageIcon;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetFactoryImpl
extends EFactoryImpl
implements WidgetFactory {
    private static final Logger logger = LoggerFactory.getLogger(WidgetFactoryImpl.class);

    public static WidgetFactory init() {
        try {
            WidgetFactory widgetFactory = (WidgetFactory)EPackage.Registry.INSTANCE.getEFactory("http://astah.net/golf/1.0.0/widget");
            if (widgetFactory != null) {
                return widgetFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new WidgetFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            default: 
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String string) {
        switch (eDataType.getClassifierID()) {
            case 0: {
                return this.createCColorFromString(eDataType, string);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object object) {
        switch (eDataType.getClassifierID()) {
            case 0: {
                return this.convertCColorToString(eDataType, object);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public CColor createCColorFromString(EDataType eDataType, String string) {
        if (string != null && string.length() == 7) {
            int n2 = string.indexOf("#");
            string = string.substring(n2 + 1, string.length());
            int[] nArray = new int[3];
            String string2 = string;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                string2 = string.substring(n2 * 2, n2 * 2 + 2);
                nArray[n2] = (int)Long.parseLong(string2, 16);
            }
            return new SwingColor(new Color(nArray[0], nArray[1], nArray[2]));
        }
        return (CColor)super.createFromString(eDataType, string);
    }

    public String convertCColorToString(EDataType eDataType, Object object) {
        return super.convertToString(eDataType, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CImageIcon createCImageIconFromString(EDataType eDataType, String string) {
        byte[] byArray = Base64Util.decode((String)string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ReplaceableObjectInputStream replaceableObjectInputStream = null;
        try {
            replaceableObjectInputStream = new ReplaceableObjectInputStream((InputStream)byteArrayInputStream);
            Object object = replaceableObjectInputStream.readObject();
            replaceableObjectInputStream.close();
            replaceableObjectInputStream = null;
            if (object instanceof ImageIcon) {
                ImageIcon imageIcon = (ImageIcon)object;
                SwingImageIcon swingImageIcon = new SwingImageIcon(imageIcon);
                return swingImageIcon;
            }
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("error has occurred.", (Throwable)classNotFoundException);
        }
        finally {
            try {
                if (replaceableObjectInputStream != null) {
                    replaceableObjectInputStream.close();
                } else {
                    byteArrayInputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.error("error has occurred.", (Throwable)iOException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertCImageIconToString(EDataType eDataType, Object object) {
        if (object instanceof SwingImageIcon) {
            Object object2;
            SwingImageIcon swingImageIcon = (SwingImageIcon)object;
            ImageIcon imageIcon = swingImageIcon.getImageIcon();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                object2 = new ObjectOutputStream(byteArrayOutputStream);
                ((ObjectOutputStream)object2).writeObject(imageIcon);
                ((ObjectOutputStream)object2).close();
            }
            catch (IOException iOException) {
                logger.error("error has occurred.", (Throwable)iOException);
                String string = "";
                return string;
            }
            finally {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    logger.error("error has occurred.", (Throwable)iOException);
                    return "";
                }
            }
            object2 = Base64Util.encode((byte[])byteArrayOutputStream.toByteArray());
            return object2;
        }
        return super.convertToString(eDataType, object);
    }

    @Override
    public WidgetPackage getWidgetPackage() {
        return (WidgetPackage)this.getEPackage();
    }

    @Deprecated
    public static WidgetPackage getPackage() {
        return WidgetPackage.eINSTANCE;
    }
}

