/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel.compare;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import net.astah.emf.compare.diagram.CompareDiagramConfiguration;
import net.astah.emf.compare.diagram.CompareDiagramPostProcessor;
import net.astah.emf.compare.diagram.extensions.DiagramChange;
import net.astah.emf.compare.diagram.extensions.ExtensionsFactory;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.postprocessor.factories.IChangeFactory;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;

public abstract class AtomicDiagramPostProcessor
extends CompareDiagramPostProcessor {
    public void postComparison(Comparison comparison, Monitor monitor) {
        super.postComparison(comparison, monitor);
        IdentityHashMap<Match, DiagramChange> identityHashMap = new IdentityHashMap<Match, DiagramChange>();
        for (Diff diff : comparison.getDifferences()) {
            Match match = this.getDiagramMatch(comparison, diff);
            if (match == null) continue;
            DiagramChange diagramChange = identityHashMap.computeIfAbsent(match, match2 -> this.createDiagramChange(comparison, match, diff));
            diagramChange.getRefinedBy().add((Object)diff);
        }
    }

    protected Match getDiagramMatch(Comparison comparison, Diff diff) {
        Match match;
        EObject eObject;
        if (diff.getKind() != DifferenceKind.CHANGE) {
            eObject = MatchUtil.getContainer((Comparison)comparison, (Diff)diff);
        } else {
            match = diff.getMatch();
            eObject = (EObject)MoreObjects.firstNonNull((Object)match.getLeft(), (Object)match.getRight());
        }
        match = this.getDiagramAncestor(eObject);
        if (match != null) {
            return comparison.getMatch((EObject)match);
        }
        if (diff instanceof ReferenceChange) {
            EObject eObject2 = ((ReferenceChange)diff).getValue();
            return comparison.getMatch(this.getDiagramAncestor(eObject2));
        }
        return null;
    }

    protected abstract EObject getDiagramAncestor(EObject var1);

    protected DiagramChange createDiagramChange(Comparison comparison, Match match, Diff diff) {
        DiagramChange diagramChange = ExtensionsFactory.eINSTANCE.createDiagramChange();
        diagramChange.setKind(DifferenceKind.CHANGE);
        diagramChange.setDiagramElement(comparison.isThreeWay() ? match.getOrigin() : match.getLeft());
        diagramChange.setSemanticDiff(diff);
        match.getDifferences().add((Object)diagramChange);
        return diagramChange;
    }

    protected Map<Class<? extends Diff>, IChangeFactory> createExtensionFactories(CompareDiagramConfiguration compareDiagramConfiguration) {
        return Collections.emptyMap();
    }
}

