/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jmodel.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.astah.dd.di.edit.command.ArrangeDepthCommand;
import net.astah.emf.edit.command.DiagramCommands;
import net.astah.jmodel.JmodelPackage;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.command.UpdateObserverCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class DiagramDepthCommand
extends ArrangeDepthCommand {
    public DiagramDepthCommand(EditingDomain editingDomain, Object object, EObject eObject, Collection<?> collection, int n) {
        super(editingDomain, object, eObject, collection, n);
    }

    protected void appendCommands(int n, Collection<?> collection) {
        List<JomtPresentation> list = this.getSortedPresentations();
        this.arrangeDepthOrder(list, collection);
        this.updateDepth(list);
        this.append((Command)new UpdateObserverCommand(this.domain, this.context, list, null));
    }

    protected List<JomtPresentation> getSortedPresentations() {
        Collection collection = DiagramCommands.adjustSelection((EditingDomain)this.domain, ArrangeDepthCommand.class, (Collection)((UMLDiagram)this.owner).getPresentations());
        ArrayList<JomtPresentation> arrayList = new ArrayList<JomtPresentation>(collection.size());
        for (Presentation presentation : collection) {
            if (!(presentation instanceof JomtPresentation)) continue;
            arrayList.add((JomtPresentation)presentation);
        }
        arrayList.sort((jomtPresentation, jomtPresentation2) -> jomtPresentation2.getDepth() - jomtPresentation.getDepth());
        return arrayList;
    }

    protected void arrangeDepthOrder(List<JomtPresentation> list, Collection<?> collection) {
        Comparator<PresentationEntry> comparator = this.comparatorFor(this.arrangeType);
        if (comparator != null) {
            ArrayList<PresentationEntry> arrayList = new ArrayList<PresentationEntry>(list.size());
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            for (JomtPresentation object : list) {
                boolean presentationEntry = collection.contains(object);
                int n3 = n2 + (presentationEntry && presentationEntry == bl ? 0 : 1);
                arrayList.add(new PresentationEntry(n3, n++, presentationEntry, object));
                n2 = n3;
                bl = presentationEntry;
            }
            arrayList.sort(comparator);
            Iterator<JomtPresentation> iterator = list.listIterator();
            for (PresentationEntry presentationEntry : arrayList) {
                iterator.next();
                iterator.set(presentationEntry.getValue());
            }
        }
    }

    protected void updateDepth(List<JomtPresentation> list) {
        int n = this.getStartDepth();
        for (JomtPresentation jomtPresentation : list) {
            this.append(this.createSetDepthCommand(jomtPresentation, n--));
        }
    }

    protected Command createSetDepthCommand(JomtPresentation jomtPresentation, int n) {
        return SetCommand.create((EditingDomain)this.domain, (Object)jomtPresentation, (Object)JmodelPackage.Literals.JOMT_PRESENTATION__DEPTH, (Object)n);
    }

    protected int getStartDepth() {
        return -10;
    }

    protected Comparator<PresentationEntry> comparatorFor(int n) {
        switch (n) {
            case -2147483648: {
                return (presentationEntry, presentationEntry2) -> {
                    if (presentationEntry.c != presentationEntry2.c) {
                        return presentationEntry.c ? 1 : -1;
                    }
                    return presentationEntry.b - presentationEntry2.b;
                };
            }
            case -2147483647: {
                return (presentationEntry, presentationEntry2) -> {
                    int n = presentationEntry.a - presentationEntry2.a;
                    if (presentationEntry.c != presentationEntry2.c) {
                        int n2;
                        int n3 = n2 = presentationEntry.c ? -1 : 1;
                        if (n == n2) {
                            return -n2;
                        }
                    }
                    return presentationEntry.b - presentationEntry2.b;
                };
            }
            case -2147483646: {
                return (presentationEntry, presentationEntry2) -> {
                    int n = presentationEntry.a - presentationEntry2.a;
                    if (presentationEntry.c != presentationEntry2.c) {
                        int n2;
                        int n3 = n2 = presentationEntry2.c ? -1 : 1;
                        if (n == n2) {
                            return -n2;
                        }
                    }
                    return presentationEntry.b - presentationEntry2.b;
                };
            }
            case -2147483645: {
                return (presentationEntry, presentationEntry2) -> {
                    if (presentationEntry.c != presentationEntry2.c) {
                        return presentationEntry2.c ? 1 : -1;
                    }
                    return presentationEntry.b - presentationEntry2.b;
                };
            }
        }
        return null;
    }

    protected static class PresentationEntry {
        final int a;
        final int b;
        final boolean c;
        final JomtPresentation d;

        public PresentationEntry(int n, int n2, boolean bl, JomtPresentation jomtPresentation) {
            this.a = n;
            this.b = n2;
            this.c = bl;
            this.d = jomtPresentation;
        }

        public int getGroup() {
            return this.a;
        }

        public int getIndex() {
            return this.b;
        }

        public boolean isTarget() {
            return this.c;
        }

        public JomtPresentation getValue() {
            return this.d;
        }
    }
}

