/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.impl;

import net.astah.table.Cell;
import net.astah.table.DynamicDataset;
import net.astah.table.Element;
import net.astah.table.ElementSet;
import net.astah.table.FeaturePath;
import net.astah.table.FeatureSegment;
import net.astah.table.FixedCellDescriptor;
import net.astah.table.FixedDataset;
import net.astah.table.Grid;
import net.astah.table.ICellEvaluator;
import net.astah.table.IQueryExecutor;
import net.astah.table.JoinReference;
import net.astah.table.JoinType;
import net.astah.table.NativeCellDescriptor;
import net.astah.table.NativeDataQuery;
import net.astah.table.ObjectDataQuery;
import net.astah.table.ObjectElement;
import net.astah.table.PropertyCellDescriptor;
import net.astah.table.PseudoCellDescriptor;
import net.astah.table.PseudoCellType;
import net.astah.table.Row;
import net.astah.table.Table;
import net.astah.table.TableFactory;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.table.impl.CellImpl;
import net.astah.table.impl.DynamicDatasetImpl;
import net.astah.table.impl.ElementImpl;
import net.astah.table.impl.ElementSetImpl;
import net.astah.table.impl.FeaturePathImpl;
import net.astah.table.impl.FeatureSegmentImpl;
import net.astah.table.impl.FixedCellDescriptorImpl;
import net.astah.table.impl.FixedDatasetImpl;
import net.astah.table.impl.GridImpl;
import net.astah.table.impl.JoinReferenceImpl;
import net.astah.table.impl.NativeCellDescriptorImpl;
import net.astah.table.impl.NativeDataQueryImpl;
import net.astah.table.impl.ObjectDataQueryImpl;
import net.astah.table.impl.ObjectElementImpl;
import net.astah.table.impl.PropertyCellDescriptorImpl;
import net.astah.table.impl.PseudoCellDescriptorImpl;
import net.astah.table.impl.RowImpl;
import net.astah.table.impl.TableImpl;
import net.astah.table.impl.TupleImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class TableFactoryImpl
extends EFactoryImpl
implements TableFactory {
    public static TableFactory init() {
        try {
            TableFactory tableFactory = (TableFactory)EPackage.Registry.INSTANCE.getEFactory("http://astah.net/table/1.0.0/Table");
            if (tableFactory != null) {
                return tableFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new TableFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createTable();
            }
            case 3: {
                return this.createDynamicDataset();
            }
            case 6: {
                return this.createNativeCellDescriptor();
            }
            case 7: {
                return this.createObjectDataQuery();
            }
            case 8: {
                return this.createJoinReference();
            }
            case 9: {
                return this.createFeaturePath();
            }
            case 10: {
                return this.createFeatureSegment();
            }
            case 11: {
                return this.createNativeDataQuery();
            }
            case 12: {
                return this.createFixedDataset();
            }
            case 13: {
                return this.createElementSet();
            }
            case 14: {
                return this.createObjectElement();
            }
            case 15: {
                return this.createFixedCellDescriptor();
            }
            case 16: {
                return this.createPropertyCellDescriptor();
            }
            case 17: {
                return this.createPseudoCellDescriptor();
            }
            case 18: {
                return this.createGrid();
            }
            case 19: {
                return this.createTuple();
            }
            case 20: {
                return this.createElement();
            }
            case 21: {
                return this.createRow();
            }
            case 22: {
                return this.createCell();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String string) {
        switch (eDataType.getClassifierID()) {
            case 23: {
                return this.createJoinTypeFromString(eDataType, string);
            }
            case 24: {
                return this.createPseudoCellTypeFromString(eDataType, string);
            }
            case 25: {
                return this.createICellEvaluatorFromString(eDataType, string);
            }
            case 26: {
                return this.createIQueryExecutorProviderFromString(eDataType, string);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object object) {
        switch (eDataType.getClassifierID()) {
            case 23: {
                return this.convertJoinTypeToString(eDataType, object);
            }
            case 24: {
                return this.convertPseudoCellTypeToString(eDataType, object);
            }
            case 25: {
                return this.convertICellEvaluatorToString(eDataType, object);
            }
            case 26: {
                return this.convertIQueryExecutorProviderToString(eDataType, object);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Table createTable() {
        TableImpl tableImpl = new TableImpl();
        return tableImpl;
    }

    @Override
    public DynamicDataset createDynamicDataset() {
        DynamicDatasetImpl dynamicDatasetImpl = new DynamicDatasetImpl();
        return dynamicDatasetImpl;
    }

    @Override
    public NativeCellDescriptor createNativeCellDescriptor() {
        NativeCellDescriptorImpl nativeCellDescriptorImpl = new NativeCellDescriptorImpl();
        return nativeCellDescriptorImpl;
    }

    @Override
    public ObjectDataQuery createObjectDataQuery() {
        ObjectDataQueryImpl objectDataQueryImpl = new ObjectDataQueryImpl();
        return objectDataQueryImpl;
    }

    @Override
    public JoinReference createJoinReference() {
        JoinReferenceImpl joinReferenceImpl = new JoinReferenceImpl();
        return joinReferenceImpl;
    }

    @Override
    public FeaturePath createFeaturePath() {
        FeaturePathImpl featurePathImpl = new FeaturePathImpl();
        return featurePathImpl;
    }

    @Override
    public FeatureSegment createFeatureSegment() {
        FeatureSegmentImpl featureSegmentImpl = new FeatureSegmentImpl();
        return featureSegmentImpl;
    }

    @Override
    public NativeDataQuery createNativeDataQuery() {
        NativeDataQueryImpl nativeDataQueryImpl = new NativeDataQueryImpl();
        return nativeDataQueryImpl;
    }

    @Override
    public FixedDataset createFixedDataset() {
        FixedDatasetImpl fixedDatasetImpl = new FixedDatasetImpl();
        return fixedDatasetImpl;
    }

    @Override
    public ElementSet createElementSet() {
        ElementSetImpl elementSetImpl = new ElementSetImpl();
        return elementSetImpl;
    }

    @Override
    public ObjectElement createObjectElement() {
        ObjectElementImpl objectElementImpl = new ObjectElementImpl();
        return objectElementImpl;
    }

    @Override
    public FixedCellDescriptor createFixedCellDescriptor() {
        FixedCellDescriptorImpl fixedCellDescriptorImpl = new FixedCellDescriptorImpl();
        return fixedCellDescriptorImpl;
    }

    @Override
    public FixedCellDescriptor createFixedCellDescriptor(String string) {
        FixedCellDescriptor fixedCellDescriptor = this.createFixedCellDescriptor();
        fixedCellDescriptor.setLabel(string);
        return fixedCellDescriptor;
    }

    @Override
    public PropertyCellDescriptor createPropertyCellDescriptor() {
        PropertyCellDescriptorImpl propertyCellDescriptorImpl = new PropertyCellDescriptorImpl();
        return propertyCellDescriptorImpl;
    }

    @Override
    public Grid createGrid() {
        GridImpl gridImpl = new GridImpl();
        return gridImpl;
    }

    @Override
    public Tuple createTuple() {
        TupleImpl tupleImpl = new TupleImpl();
        return tupleImpl;
    }

    @Override
    public Element createElement() {
        ElementImpl elementImpl = new ElementImpl();
        return elementImpl;
    }

    @Override
    public Element createElement(EObject eObject) {
        ElementImpl elementImpl = new ElementImpl();
        elementImpl.setObject(eObject);
        return elementImpl;
    }

    @Override
    public Row createRow() {
        RowImpl rowImpl = new RowImpl();
        return rowImpl;
    }

    @Override
    public Cell createCell() {
        CellImpl cellImpl = new CellImpl();
        return cellImpl;
    }

    @Override
    public PseudoCellDescriptor createPseudoCellDescriptor() {
        PseudoCellDescriptorImpl pseudoCellDescriptorImpl = new PseudoCellDescriptorImpl();
        return pseudoCellDescriptorImpl;
    }

    public JoinType createJoinTypeFromString(EDataType eDataType, String string) {
        JoinType joinType = JoinType.get(string);
        if (joinType == null) {
            throw new IllegalArgumentException("The value '" + string + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return joinType;
    }

    public String convertJoinTypeToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public PseudoCellType createPseudoCellTypeFromString(EDataType eDataType, String string) {
        PseudoCellType pseudoCellType = PseudoCellType.get(string);
        if (pseudoCellType == null) {
            throw new IllegalArgumentException("The value '" + string + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return pseudoCellType;
    }

    public String convertPseudoCellTypeToString(EDataType eDataType, Object object) {
        return object == null ? null : object.toString();
    }

    public ICellEvaluator createICellEvaluatorFromString(EDataType eDataType, String string) {
        return (ICellEvaluator)super.createFromString(eDataType, string);
    }

    public String convertICellEvaluatorToString(EDataType eDataType, Object object) {
        return super.convertToString(eDataType, object);
    }

    public IQueryExecutor.Provider createIQueryExecutorProviderFromString(EDataType eDataType, String string) {
        return (IQueryExecutor.Provider)super.createFromString(eDataType, string);
    }

    public String convertIQueryExecutorProviderToString(EDataType eDataType, Object object) {
        return super.convertToString(eDataType, object);
    }

    @Override
    public TablePackage getTablePackage() {
        return (TablePackage)this.getEPackage();
    }

    @Deprecated
    public static TablePackage getPackage() {
        return TablePackage.eINSTANCE;
    }
}

