/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.impl;

import com.google.common.base.Equivalence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.astah.common.collect.MoreLists;
import net.astah.table.Cell;
import net.astah.table.Grid;
import net.astah.table.Row;
import net.astah.table.TableFactory;
import net.astah.table.Tuple;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class RowSynchronizer
extends AdapterImpl {
    public static RowSynchronizer getInstance(Grid grid) {
        EList eList = grid.eAdapters();
        Adapter adapter = EcoreUtil.getAdapter((List)eList, RowSynchronizer.class);
        if (adapter instanceof RowSynchronizer) {
            return (RowSynchronizer)adapter;
        }
        RowSynchronizer rowSynchronizer = new RowSynchronizer();
        eList.add((Object)rowSynchronizer);
        return rowSynchronizer;
    }

    public boolean isAdapterForType(Object object) {
        return object == RowSynchronizer.class;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.isTouch()) {
            return;
        }
        Object object = notification.getNotifier();
        if (object instanceof Grid) {
            switch (notification.getFeatureID(Grid.class)) {
                case 5: {
                    this.materializedChanged((Grid)object, notification);
                    break;
                }
                case 1: {
                    this.rowTupleChanged((Grid)object, notification);
                    break;
                }
                case 2: {
                    this.columnTupleChanged((Grid)object, notification);
                }
            }
        }
    }

    public void setTarget(Notifier notifier) {
        super.setTarget(notifier);
        if (notifier instanceof Grid) {
            Grid grid = (Grid)notifier;
            if (grid.isMaterialized()) {
                this.synchronizeRows(grid);
            } else {
                this.clearRows(grid);
            }
        }
    }

    protected void synchronizeRows(Grid grid) {
        EList<Tuple> eList = grid.getRowTuples();
        EList<Tuple> eList2 = grid.getColumnTuples();
        MoreLists.synchronize(grid.getRows(), eList, (tuple, row) -> {
            Row row2 = row != null ? row : this.createRow();
            this.synchronizeRow(row2, (Tuple)tuple, eList2);
            return row2;
        }, this.a());
    }

    protected void synchronizeRow(Row row, Tuple tuple, EList<Tuple> eList) {
        row.setRowTuple(tuple);
        this.synchronizeCells(row, eList);
    }

    protected void synchronizeCells(Row row, EList<Tuple> eList) {
        MoreLists.synchronize(row.getCells(), eList, (tuple, cell) -> {
            Cell cell2 = cell != null ? cell : this.createCell();
            this.synchronizeCell(cell2, (Tuple)tuple);
            return cell2;
        }, this.a());
    }

    protected void synchronizeCell(Cell cell, Tuple tuple) {
        cell.setColumnTuple(tuple);
    }

    protected void clearRows(Grid grid) {
        grid.getRows().clear();
    }

    protected void materializedChanged(Grid grid, Notification notification) {
        if (notification.getNewBooleanValue()) {
            this.synchronizeRows(grid);
        } else {
            this.clearRows(grid);
        }
    }

    protected void rowTupleChanged(Grid grid, Notification notification) {
        if (!grid.isMaterialized()) {
            return;
        }
        EList<Row> eList = grid.getRows();
        switch (notification.getEventType()) {
            case 3: {
                Object object = notification.getNewValue();
                EList<Tuple> eList2 = grid.getColumnTuples();
                Row row = this.createRow();
                this.synchronizeRow(row, (Tuple)object, eList2);
                eList.add(notification.getPosition(), (Object)row);
                break;
            }
            case 5: {
                Collection collection = (Collection)notification.getNewValue();
                EList<Tuple> eList3 = grid.getColumnTuples();
                ArrayList<Row> arrayList = new ArrayList<Row>(collection.size());
                for (Object e : collection) {
                    Row row = this.createRow();
                    this.synchronizeRow(row, (Tuple)e, eList3);
                    arrayList.add(row);
                }
                eList.addAll(notification.getPosition(), arrayList);
                break;
            }
            case 4: {
                eList.remove(notification.getPosition());
                break;
            }
            case 6: {
                int[] nArray = (int[])notification.getNewValue();
                int n = nArray.length;
                while (n-- > 0) {
                    eList.remove(nArray[n]);
                }
                break;
            }
            case 7: {
                eList.move(notification.getPosition(), ((Integer)notification.getOldValue()).intValue());
            }
        }
    }

    protected void columnTupleChanged(Grid grid, Notification notification) {
        if (!grid.isMaterialized()) {
            return;
        }
        EList<Row> eList = grid.getRows();
        switch (notification.getEventType()) {
            case 3: {
                for (Row row : eList) {
                    EList<Cell> eList2 = row.getCells();
                    Object object = notification.getNewValue();
                    Cell cell = this.createCell();
                    this.synchronizeCell(cell, (Tuple)object);
                    eList2.add(notification.getPosition(), (Object)cell);
                }
                break;
            }
            case 5: {
                for (Row row : eList) {
                    EList<Cell> eList3 = row.getCells();
                    Collection collection = (Collection)notification.getNewValue();
                    ArrayList<Cell> arrayList = new ArrayList<Cell>(collection.size());
                    for (Object e : collection) {
                        Cell cell = this.createCell();
                        this.synchronizeCell(cell, (Tuple)e);
                        arrayList.add(cell);
                    }
                    eList3.addAll(notification.getPosition(), arrayList);
                }
                break;
            }
            case 4: {
                for (Row row : eList) {
                    EList<Cell> eList4 = row.getCells();
                    eList4.remove(notification.getPosition());
                }
                break;
            }
            case 6: {
                for (Row row : eList) {
                    EList<Cell> eList5 = row.getCells();
                    int[] nArray = (int[])notification.getNewValue();
                    int n = nArray.length;
                    while (n-- > 0) {
                        eList5.remove(nArray[n]);
                    }
                }
                break;
            }
            case 7: {
                for (Row row : eList) {
                    EList<Cell> eList6 = row.getCells();
                    eList6.move(notification.getPosition(), ((Integer)notification.getOldValue()).intValue());
                }
                break;
            }
        }
    }

    protected Row createRow() {
        return TableFactory.eINSTANCE.createRow();
    }

    protected Cell createCell() {
        return TableFactory.eINSTANCE.createCell();
    }

    protected boolean useEquals() {
        return false;
    }

    Equivalence<Object> a() {
        return this.useEquals() ? Equivalence.equals() : Equivalence.identity();
    }
}

