/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.engine.impl;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import net.astah.table.Cell;
import net.astah.table.Dataset;
import net.astah.table.Element;
import net.astah.table.Grid;
import net.astah.table.Row;
import net.astah.table.Table;
import net.astah.table.TableFactory;
import net.astah.table.Tuple;
import net.astah.table.engine.IEngineTable;
import net.astah.table.engine.impl.DatasetEngineAdapter;
import net.astah.table.engine.impl.EngineAdapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableEngineAdapter
extends EngineAdapter
implements IEngineTable {
    private static final Logger a = LoggerFactory.getLogger(TableEngineAdapter.class);

    public TableEngineAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public static Grid generateGrid(AdapterFactory adapterFactory, Object object, boolean bl) {
        Object object2 = adapterFactory.adapt(object, IEngineTable.class);
        if (!(object2 instanceof IEngineTable)) {
            a.warn("Can't adapt IEngineTable from {}", object);
            return null;
        }
        return ((IEngineTable)object2).generateGrid(object, bl);
    }

    public static Iterable<Tuple> generateTuples(AdapterFactory adapterFactory, Object object, List<Dataset> list) {
        Object object2 = adapterFactory.adapt(object, IEngineTable.class);
        if (!(object2 instanceof IEngineTable)) {
            a.warn("Can't adapt IEngineTable from {}", object);
            return null;
        }
        return ((IEngineTable)object2).generateTuples(object, list);
    }

    public boolean isAdapterForType(Object object) {
        return object == IEngineTable.class;
    }

    @Override
    public Grid generateGrid(@NonNull Object object, boolean bl) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        Table table = (Table)object;
        Grid grid = this.createGrid();
        grid.setMaterialized(bl);
        grid.setTable(table);
        Iterables.addAll(grid.getRowTuples(), this.generateTuples(table, (List<Dataset>)table.getRows()));
        Iterables.addAll(grid.getColumnTuples(), this.generateTuples(table, (List<Dataset>)table.getColumns()));
        return grid;
    }

    @Override
    public Iterable<Tuple> generateTuples(@NonNull Object object, @NonNull List<Dataset> list2) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        if (list2 == null) {
            throw new NullPointerException("datasets");
        }
        ArrayList<Iterable> arrayList = new ArrayList<Iterable>(list2.size());
        for (Dataset dataset : list2) {
            Iterable<List<? extends EObject>> iterable = DatasetEngineAdapter.getTuples(this.adapterFactory, dataset);
            arrayList.add(Iterables.transform(iterable, list -> this.generateTuple(dataset, (List<? extends EObject>)list)));
        }
        if (arrayList.size() == 1) {
            return (Iterable)arrayList.get(0);
        }
        return Iterables.concat(arrayList);
    }

    @Override
    public Equivalence<Tuple> getTupleEquivalence(Object object) {
        return net.astah.table.engine.impl.TableEngineAdapter$a.a;
    }

    protected Tuple generateTuple(Dataset dataset, List<? extends EObject> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"objects must not be empty");
        Tuple tuple = this.createTuple();
        EList<Element> eList = tuple.getElements();
        for (EObject eObject : list) {
            eList.add((Object)TableFactory.eINSTANCE.createElement(eObject));
        }
        tuple.setDataset(dataset);
        return tuple;
    }

    protected void updateTuples(EList<Tuple> eList, Iterable<Tuple> iterable) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Object object : eList) {
            this.a(hashMap, (Tuple)object);
        }
        int n = 0;
        for (Tuple tuple : iterable) {
            Tuple tuple2 = this.b(hashMap, tuple);
            if (tuple2 == null) {
                eList.add(n++, (Object)tuple);
                continue;
            }
            eList.move(n++, (Object)tuple2);
        }
        while (eList.size() > n) {
            eList.remove(eList.size() - 1);
        }
    }

    protected Grid createGrid() {
        return TableFactory.eINSTANCE.createGrid();
    }

    protected Tuple createTuple() {
        return TableFactory.eINSTANCE.createTuple();
    }

    protected Row createRow() {
        return TableFactory.eINSTANCE.createRow();
    }

    protected Cell createCell() {
        return TableFactory.eINSTANCE.createCell();
    }

    void a(Map<Object, Object> map, Tuple tuple) {
        Equivalence.Wrapper wrapper = net.astah.table.engine.impl.TableEngineAdapter$a.a.wrap(tuple);
        Object object = map.putIfAbsent(wrapper, tuple);
        if (object instanceof Tuple) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            map.put(wrapper, arrayList);
            arrayList.add(object);
            arrayList.add(tuple);
        } else if (object instanceof List) {
            List list = (List)object;
            map.put(wrapper, list);
            list.add(tuple);
        }
    }

    Tuple b(Map<Object, Object> map, Tuple tuple) {
        Equivalence.Wrapper wrapper = net.astah.table.engine.impl.TableEngineAdapter$a.a.wrap(tuple);
        Object object = map.remove(wrapper);
        if (object instanceof Tuple) {
            return (Tuple)object;
        }
        if (object instanceof List) {
            List list = (List)object;
            Tuple tuple2 = (Tuple)list.remove(0);
            if (!list.isEmpty()) {
                map.put(wrapper, list);
            }
            return tuple2;
        }
        return null;
    }

    static class a
    extends Equivalence<Tuple> {
        static final a a = new a();

        a() {
        }

        protected boolean a(Tuple tuple, Tuple tuple2) {
            EList<Element> eList = tuple.getElements();
            EList<Element> eList2 = tuple2.getElements();
            int n = eList.size();
            if (n != eList2.size()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                Element element = (Element)eList.get(i);
                Element element2 = (Element)eList2.get(i);
                if (element.getObject() == element2.getObject()) continue;
                return false;
            }
            return tuple.getDataset() == tuple2.getDataset();
        }

        protected int a(Tuple tuple) {
            int n = Objects.hashCode(tuple.getDataset());
            for (Element element : tuple.getElements()) {
                n = n * 37 + Objects.hashCode(element.getObject());
            }
            return n;
        }

        protected /* synthetic */ int doHash(Object object) {
            return this.a((Tuple)object);
        }

        protected /* synthetic */ boolean doEquivalent(Object object, Object object2) {
            return this.a((Tuple)object, (Tuple)object2);
        }
    }
}

