/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.engine.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.table.CellDescriptor;
import net.astah.table.DynamicDataset;
import net.astah.table.Element;
import net.astah.table.ObjectElement;
import net.astah.table.PropertyCellDescriptor;
import net.astah.table.Table;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.table.engine.impl.CellDescriptorEngineAdapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyCellDescriptorEngineAdapter
extends CellDescriptorEngineAdapter {
    private static final Logger a = LoggerFactory.getLogger(PropertyCellDescriptorEngineAdapter.class);
    private final Map<PropertyCellDescriptor, EFeaturePath> b = new WeakHashMap<PropertyCellDescriptor, EFeaturePath>();
    protected IItemPropertyDescriptor labelDescriptor;

    public PropertyCellDescriptorEngineAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Object getHeaderElement(Object object, Tuple tuple) {
        EFeaturePath eFeaturePath;
        PropertyCellDescriptor propertyCellDescriptor = (PropertyCellDescriptor)object;
        EObject eObject = this.getTupleElement(propertyCellDescriptor, tuple);
        if (eObject != null && (eFeaturePath = this.getEFeaturePath(propertyCellDescriptor)) != null) {
            return this.getReference(eFeaturePath, eObject);
        }
        return null;
    }

    @Override
    public IItemPropertyDescriptor getHeaderPropertyDescriptor(Object object, Tuple tuple, AdapterFactory adapterFactory) {
        PropertyCellDescriptor propertyCellDescriptor = (PropertyCellDescriptor)object;
        EObject eObject = this.getTupleElement(propertyCellDescriptor, tuple);
        if (eObject != null) {
            return this.getPropertyDescriptor(propertyCellDescriptor, eObject, adapterFactory);
        }
        return null;
    }

    @Override
    public IItemPropertyDescriptor getCellPropertyDescriptor(Object object, Tuple tuple, Tuple tuple2, AdapterFactory adapterFactory) {
        PropertyCellDescriptor propertyCellDescriptor = (PropertyCellDescriptor)object;
        EObject eObject = this.getCellElement(propertyCellDescriptor, tuple, tuple2);
        if (eObject != null) {
            return this.getPropertyDescriptor(propertyCellDescriptor, eObject, adapterFactory);
        }
        return null;
    }

    @Override
    public Comparator<?> getComparator(Object object) {
        return null;
    }

    protected EObject getTupleElement(PropertyCellDescriptor propertyCellDescriptor, Tuple tuple) {
        int n = propertyCellDescriptor.getOrigin();
        EList<Element> eList = tuple.getElements();
        if (n >= 0 && n < eList.size()) {
            return ((Element)eList.get(n)).getObject();
        }
        a.warn("Cannot determine tuple element: {}", (Object)propertyCellDescriptor);
        return null;
    }

    protected EObject getCellElement(PropertyCellDescriptor propertyCellDescriptor, Tuple tuple, Tuple tuple2) {
        ObjectElement objectElement;
        Tuple tuple3;
        EStructuralFeature eStructuralFeature = propertyCellDescriptor.eContainingFeature();
        if (eStructuralFeature == TablePackage.Literals.OBJECT_ELEMENT__CELL && (tuple3 = this.getOppositeTuple(objectElement = (ObjectElement)propertyCellDescriptor.eContainer(), tuple, tuple2)) != null) {
            return this.getTupleElement(propertyCellDescriptor, tuple3);
        }
        a.warn("Cannot determine cell element: {}", (Object)propertyCellDescriptor);
        return null;
    }

    protected IItemPropertyDescriptor getPropertyDescriptor(PropertyCellDescriptor propertyCellDescriptor, EObject eObject, AdapterFactory adapterFactory) {
        EObject eObject2;
        EFeaturePath eFeaturePath = this.getEFeaturePath(propertyCellDescriptor);
        if (eFeaturePath != null && (eObject2 = this.getReference(eFeaturePath, eObject)) != null) {
            return this.getPropertyDescriptor(propertyCellDescriptor, eFeaturePath, eObject2, adapterFactory);
        }
        return null;
    }

    protected EClass getOriginType(PropertyCellDescriptor propertyCellDescriptor) {
        List<EClass> list = this.getTupleTypes(propertyCellDescriptor);
        int n = propertyCellDescriptor.getOrigin();
        if (n >= 0 && n < list.size()) {
            return list.get(n);
        }
        a.warn("Cannot determine origin type: {}", (Object)propertyCellDescriptor);
        return null;
    }

    protected List<EClass> getTupleTypes(PropertyCellDescriptor propertyCellDescriptor) {
        EStructuralFeature eStructuralFeature = propertyCellDescriptor.eContainingFeature();
        if (eStructuralFeature == TablePackage.Literals.OBJECT_ELEMENT__CELL) {
            return this.getOppositeTupleTypes((ObjectElement)propertyCellDescriptor.eContainer());
        }
        if (eStructuralFeature == TablePackage.Literals.DYNAMIC_DATASET__HEADER) {
            return ((DynamicDataset)propertyCellDescriptor.eContainer()).getTupleTypes();
        }
        return Collections.emptyList();
    }

    protected List<EClass> getOppositeTupleTypes(ObjectElement objectElement) {
        EStructuralFeature.Setting setting = this.getDatasetDimension(objectElement);
        if (setting != null) {
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            if (eStructuralFeature == TablePackage.Literals.TABLE__COLUMN) {
                return ((Table)setting.getEObject()).getRowTupleTypes();
            }
            if (eStructuralFeature == TablePackage.Literals.TABLE__ROW) {
                return ((Table)setting.getEObject()).getColumnTupleTypes();
            }
        }
        return Collections.emptyList();
    }

    protected Tuple getOppositeTuple(ObjectElement objectElement, Tuple tuple, Tuple tuple2) {
        EStructuralFeature.Setting setting = this.getDatasetDimension(objectElement);
        if (setting != null) {
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            if (eStructuralFeature == TablePackage.Literals.TABLE__COLUMN) {
                return tuple;
            }
            if (eStructuralFeature == TablePackage.Literals.TABLE__ROW) {
                return tuple2;
            }
        }
        return null;
    }

    protected EStructuralFeature.Setting getDatasetDimension(ObjectElement objectElement) {
        ObjectElement objectElement2 = objectElement;
        for (int i = 0; i < 100000; ++i) {
            EObject eObject = objectElement2.eContainer();
            if (eObject instanceof Table) {
                EReference eReference = objectElement2.eContainmentFeature();
                return ((InternalEObject)eObject).eSetting((EStructuralFeature)eReference);
            }
            if (eObject == null) break;
            objectElement2 = eObject;
        }
        return null;
    }

    protected EFeaturePath getEFeaturePath(PropertyCellDescriptor propertyCellDescriptor) {
        return this.b.computeIfAbsent(propertyCellDescriptor, propertyCellDescriptor2 -> {
            EClass eClass = this.getOriginType(propertyCellDescriptor);
            return PropertyCellDescriptorEngineAdapter.a(propertyCellDescriptor2, (EClassifier)eClass);
        });
    }

    protected IItemPropertyDescriptor getPropertyDescriptor(PropertyCellDescriptor propertyCellDescriptor, EFeaturePath eFeaturePath, EObject eObject, AdapterFactory adapterFactory) {
        IItemPropertyDescriptor iItemPropertyDescriptor;
        IItemPropertySource iItemPropertySource = (IItemPropertySource)ItemProviders.adapt((AdapterFactory)adapterFactory, (Notifier)eObject, IItemPropertySource.class);
        if (iItemPropertySource != null && (iItemPropertyDescriptor = iItemPropertySource.getPropertyDescriptor((Object)eObject, (Object)eFeaturePath.getLast().getFeature())) != null) {
            return new CellDescriptorEngineAdapter.PropertyDescriptorWrapper(this, propertyCellDescriptor, eObject, iItemPropertyDescriptor);
        }
        return null;
    }

    protected EObject getReference(EFeaturePath eFeaturePath, EObject eObject) {
        return (EObject)eFeaturePath.getReference(eObject, eFeaturePath.getLast());
    }

    @Override
    protected boolean isReadOnly(CellDescriptor cellDescriptor) {
        return ((PropertyCellDescriptor)cellDescriptor).isReadOnly();
    }
}

