/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.engine.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.table.IQueryExecutor;
import net.astah.table.ObjectDataQuery;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.table.engine.impl.DataQueryEngineAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public class ObjectDataQueryEngineAdapter
extends DataQueryEngineAdapter {
    public ObjectDataQueryEngineAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public IQueryExecutor createExecutor(Object object) {
        ObjectDataQuery objectDataQuery = (ObjectDataQuery)object;
        Predicate<? super EObject> predicate = this.createPredicate(objectDataQuery);
        return eMap -> Iterators.filter(this.iterate(objectDataQuery), (Predicate)predicate);
    }

    @Override
    public Command createDeleteElementObjectCommand(EditingDomain editingDomain, Object object, Tuple tuple) {
        ObjectDataQuery objectDataQuery = (ObjectDataQuery)object;
        int n = objectDataQuery.getOwner().getQueries().indexOf((Object)objectDataQuery);
        EObject eObject = tuple.getElementObject(n);
        if (eObject != null) {
            if (objectDataQuery.getObjects().contains((Object)eObject)) {
                if (objectDataQuery.getOwnedObjects().contains((Object)eObject)) {
                    return DestroyCommand.create((EditingDomain)editingDomain, (Object)eObject);
                }
                return RemoveCommand.create((EditingDomain)editingDomain, (Object)objectDataQuery, (Object)TablePackage.Literals.OBJECT_DATA_QUERY__OBJECT, (Object)eObject);
            }
            return DestroyCommand.create((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject), (Object)eObject);
        }
        return super.createDeleteElementObjectCommand(editingDomain, object, tuple);
    }

    protected Predicate<? super EObject> createPredicate(ObjectDataQuery objectDataQuery) {
        return arg_0 -> ((EClass)objectDataQuery.getMetaclass()).isInstance(arg_0);
    }

    protected Iterator<EObject> iterate(ObjectDataQuery objectDataQuery) {
        if (objectDataQuery.isTraversal()) {
            return EcoreUtil.getAllContents(objectDataQuery.getObjects(), (boolean)true);
        }
        return objectDataQuery.getObjects().iterator();
    }
}

