/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.engine.impl;

import com.google.common.base.Preconditions;
import net.astah.table.IQueryExecutor;
import net.astah.table.NativeDataQuery;
import net.astah.table.Tuple;
import net.astah.table.engine.impl.DataQueryEngineAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.edit.domain.EditingDomain;

public class NativeDataQueryEngineAdapter
extends DataQueryEngineAdapter {
    public NativeDataQueryEngineAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public IQueryExecutor createExecutor(Object object) {
        NativeDataQuery nativeDataQuery = (NativeDataQuery)object;
        Class<? extends IQueryExecutor.Provider> clazz = nativeDataQuery.getImplementationClass();
        Preconditions.checkNotNull(clazz, (Object)"The query has no implementationClass");
        try {
            IQueryExecutor.Provider provider = clazz.newInstance();
            return provider.createExecutor(nativeDataQuery);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new WrappedException(reflectiveOperationException.getMessage(), (Exception)reflectiveOperationException);
        }
    }

    @Override
    public Command createDeleteElementObjectCommand(EditingDomain editingDomain, Object object, Tuple tuple) {
        NativeDataQuery nativeDataQuery = (NativeDataQuery)object;
        Class<? extends IQueryExecutor.Provider> clazz = nativeDataQuery.getImplementationClass();
        Preconditions.checkNotNull(clazz, (Object)"The query has no implementationClass");
        try {
            IQueryExecutor.Provider provider = clazz.newInstance();
            return provider.createDeleteElementObjectCommand(editingDomain, nativeDataQuery, tuple);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new WrappedException(reflectiveOperationException.getMessage(), (Exception)reflectiveOperationException);
        }
    }
}

