/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.engine.impl;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Map;
import java.util.WeakHashMap;
import net.astah.table.ICellEvaluator;
import net.astah.table.NativeCellDescriptor;
import net.astah.table.Tuple;
import net.astah.table.engine.IEngineCellDescriptor;
import net.astah.table.engine.impl.EngineAdapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

public class NativeCellDescriptorEngineAdapter
extends EngineAdapter
implements IEngineCellDescriptor {
    private final Map<NativeCellDescriptor, ICellEvaluator> a = new WeakHashMap<NativeCellDescriptor, ICellEvaluator>();

    public NativeCellDescriptorEngineAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public boolean isAdapterForType(Object object) {
        return object == IEngineCellDescriptor.class;
    }

    @Override
    public Object getHeaderElement(Object object, Tuple tuple) {
        NativeCellDescriptor nativeCellDescriptor = (NativeCellDescriptor)object;
        ICellEvaluator iCellEvaluator = this.getCellEvaluator(nativeCellDescriptor);
        return iCellEvaluator.getElement(nativeCellDescriptor, tuple);
    }

    @Override
    public IItemPropertyDescriptor getHeaderPropertyDescriptor(Object object, Tuple tuple, AdapterFactory adapterFactory) {
        NativeCellDescriptor nativeCellDescriptor = (NativeCellDescriptor)object;
        ICellEvaluator iCellEvaluator = this.getCellEvaluator(nativeCellDescriptor);
        return iCellEvaluator.getHeaderPropertyDescriptor(nativeCellDescriptor, tuple);
    }

    @Override
    public IItemPropertyDescriptor getCellPropertyDescriptor(Object object, Tuple tuple, Tuple tuple2, AdapterFactory adapterFactory) {
        NativeCellDescriptor nativeCellDescriptor = (NativeCellDescriptor)object;
        ICellEvaluator iCellEvaluator = this.getCellEvaluator(nativeCellDescriptor);
        return iCellEvaluator.getCellPropertyDescriptor(nativeCellDescriptor, tuple, tuple2);
    }

    @Override
    public Comparator<?> getComparator(Object object) {
        NativeCellDescriptor nativeCellDescriptor = (NativeCellDescriptor)object;
        ICellEvaluator iCellEvaluator = this.getCellEvaluator(nativeCellDescriptor);
        return iCellEvaluator.getComparator(nativeCellDescriptor);
    }

    protected ICellEvaluator getCellEvaluator(NativeCellDescriptor nativeCellDescriptor) {
        return this.a.computeIfAbsent(nativeCellDescriptor, this::createCellEvaluator);
    }

    protected ICellEvaluator createCellEvaluator(NativeCellDescriptor nativeCellDescriptor) {
        Class<? extends ICellEvaluator> clazz = nativeCellDescriptor.getImplementationClass();
        Preconditions.checkNotNull(clazz, (Object)"The descriptor has no implementationClass");
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new WrappedException(reflectiveOperationException.getMessage(), (Exception)reflectiveOperationException);
        }
    }
}

