/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.engine.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.table.DataQuery;
import net.astah.table.IQueryExecutor;
import net.astah.table.JoinReference;
import net.astah.table.JoinType;
import net.astah.table.Tuple;
import net.astah.table.engine.impl.DataQueryEngineAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public class JoinReferenceEngineAdapter
extends DataQueryEngineAdapter {
    static final List<EObject> a = Collections.singletonList(null);

    public JoinReferenceEngineAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public IQueryExecutor createExecutor(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        JoinReference joinReference = (JoinReference)object;
        EFeaturePath eFeaturePath = this.createEFeaturePath(joinReference);
        return eMap -> this.iterate(joinReference, eFeaturePath, (EMap<DataQuery, EObject>)eMap);
    }

    @Override
    public Command createDeleteElementObjectCommand(EditingDomain editingDomain, Object object2, Tuple tuple) {
        EFeaturePath eFeaturePath;
        EFeaturePath.Segment segment;
        JoinReference joinReference = (JoinReference)object2;
        int n = joinReference.getIndexOfDataset();
        EObject eObject = tuple.getElementObject(n);
        if (eObject != null && (segment = (eFeaturePath = this.createEFeaturePath(joinReference)).getLast()).getPrevious() == null) {
            int n2 = joinReference.getOrigin().getIndexOfDataset();
            EObject eObject2 = tuple.getElementObject(n2);
            return eFeaturePath.getReferences(eObject2, segment).stream().map(object -> this.createDeletePathCommand(segment, object, eObject)).reduce(Command::chain).orElse((Command)UnexecutableCommand.INSTANCE);
        }
        return super.createDeleteElementObjectCommand(editingDomain, object2, tuple);
    }

    protected Iterator<EObject> iterate(JoinReference joinReference, EFeaturePath eFeaturePath, EMap<DataQuery, EObject> eMap) {
        Set<EObject> set = this.getReferences(joinReference, eFeaturePath, eMap);
        if (set != null) {
            if (!set.isEmpty()) {
                return set.iterator();
            }
            if (joinReference.getJoinType() == JoinType.OUTER) {
                return a.iterator();
            }
        }
        return Collections.emptyIterator();
    }

    protected Set<EObject> getReferences(JoinReference joinReference, EFeaturePath eFeaturePath, EMap<DataQuery, EObject> eMap) {
        DataQuery dataQuery = joinReference.getOrigin();
        EObject eObject = (EObject)eMap.get((Object)dataQuery);
        if (eObject != null) {
            return eFeaturePath.castReferences(this.getReferences(eFeaturePath, eObject));
        }
        if (eMap.containsKey((Object)dataQuery)) {
            return Collections.emptySet();
        }
        return null;
    }

    protected Command createDeletePathCommand(EFeaturePath.Segment segment, Object object, Object object2) {
        if (segment.isInverse()) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)object2);
            EReference eReference = segment.getEOpposite();
            if (eReference.isContainer()) {
                return DestroyCommand.create((EditingDomain)editingDomain, (Object)object2);
            }
            return DestroyCommand.create((EditingDomain)editingDomain, (Object)new DestroyCommand.Reference((EObject)object2, (EStructuralFeature)eReference, object));
        }
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)object);
        EReference eReference = (EReference)segment.getFeature();
        if (eReference.isContainment()) {
            return DestroyCommand.create((EditingDomain)editingDomain, (Object)object2);
        }
        return DestroyCommand.create((EditingDomain)editingDomain, (Object)new DestroyCommand.Reference((EObject)object, (EStructuralFeature)eReference, object2));
    }

    protected EFeaturePath createEFeaturePath(JoinReference joinReference) {
        return JoinReferenceEngineAdapter.a(joinReference, (EClassifier)joinReference.getOrigin().getResultType());
    }

    protected Set<Object> getReferences(EFeaturePath eFeaturePath, EObject eObject) {
        return (Set)eFeaturePath.getFirst().getReferences(eObject, null, LinkedHashSet::new);
    }
}

