/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.engine.impl;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.table.CellDescriptor;
import net.astah.table.ElementSet;
import net.astah.table.FixedDataset;
import net.astah.table.ObjectElement;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.table.engine.impl.DatasetEngineAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedDatasetEngineAdapter
extends DatasetEngineAdapter {
    private static final Logger b = LoggerFactory.getLogger(FixedDatasetEngineAdapter.class);

    public FixedDatasetEngineAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Iterable<List<? extends EObject>> getTuples(Object object) {
        FixedDataset fixedDataset = (FixedDataset)object;
        EList<ElementSet> eList = fixedDataset.getElementSets();
        if (eList.isEmpty()) {
            return Collections.emptyList();
        }
        if (eList.size() > 1) {
            return () -> new a((List<ElementSet>)eList);
        }
        EList<ObjectElement> eList2 = ((ElementSet)eList.get(0)).getElements();
        return Iterables.transform(eList2, objectElement -> Collections.singletonList(objectElement.getObject()));
    }

    @Override
    public List<? extends CellDescriptor> getHeaderDescriptors(Object object, Tuple tuple) {
        FixedDataset fixedDataset = (FixedDataset)object;
        assert (fixedDataset == tuple.getDataset()) : "tuple dataset must be same";
        int n = tuple.getIndexOfDataset();
        return this.getDescriptors(fixedDataset, n, TablePackage.Literals.OBJECT_ELEMENT__HEADER);
    }

    @Override
    public List<? extends CellDescriptor> getCellDescriptors(Object object, Tuple tuple, Tuple tuple2) {
        FixedDataset fixedDataset = (FixedDataset)object;
        assert (fixedDataset.isProjectable()) : "Dataset must be projectable";
        Tuple tuple3 = this.getTuple(fixedDataset, tuple, tuple2);
        if (tuple3 != null) {
            int n = tuple3.getIndexOfDataset();
            return this.getDescriptors(fixedDataset, n, TablePackage.Literals.OBJECT_ELEMENT__CELL);
        }
        return Collections.emptyList();
    }

    @Override
    public Comparator<?> getCellComparator(Object object, Tuple tuple) {
        FixedDataset fixedDataset = (FixedDataset)object;
        assert (fixedDataset == tuple.getDataset()) : "tuple dataset must be same";
        int n = tuple.getIndexOfDataset();
        return this.getCellComparator(this.getDescriptors(fixedDataset, n, TablePackage.Literals.OBJECT_ELEMENT__CELL));
    }

    @Override
    public Command createDeleteTupleElementCommand(EditingDomain editingDomain, Object object, Tuple tuple, int n) {
        FixedDataset fixedDataset = (FixedDataset)object;
        assert (fixedDataset == tuple.getDataset()) : "tuple dataset must be same";
        int n2 = tuple.getIndexOfDataset();
        ElementSet elementSet = (ElementSet)fixedDataset.getElementSets().get(n2);
        EList<ObjectElement> eList = elementSet.getElements();
        if (n >= 0 && n < eList.size()) {
            ObjectElement objectElement = (ObjectElement)eList.get(n);
            return this.createDeleteObjectElementCommand(objectElement).chain(super.createDeleteTupleElementCommand(editingDomain, object, tuple, n));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected List<? extends CellDescriptor> getDescriptors(FixedDataset fixedDataset, int n, EReference eReference) {
        if (n >= 0) {
            return fixedDataset.getElementSets().stream().map(elementSet -> {
                EList<ObjectElement> eList = elementSet.getElements();
                if (n >= eList.size()) {
                    return null;
                }
                return (CellDescriptor)((ObjectElement)eList.get(n)).eGet((EStructuralFeature)eReference);
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected Tuple getTuple(FixedDataset fixedDataset, Tuple tuple, Tuple tuple2) {
        if (tuple2.getDataset() == fixedDataset) {
            return tuple2;
        }
        if (tuple.getDataset() == fixedDataset) {
            return tuple;
        }
        b.warn("Cannot determine cell tuple: {}", (Object)fixedDataset);
        return null;
    }

    protected Command createDeleteObjectElementCommand(ObjectElement objectElement) {
        EObject eObject = objectElement.getObject();
        if (eObject != null) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)objectElement);
            if (objectElement.getOwnedObject() == eObject) {
                return DestroyCommand.create((EditingDomain)editingDomain, (Object)eObject);
            }
            return SetCommand.create((EditingDomain)editingDomain, (Object)objectElement, (Object)TablePackage.Literals.OBJECT_ELEMENT__OBJECT, (Object)SetCommand.UNSET_VALUE);
        }
        return UnexecutableCommand.INSTANCE;
    }

    static class a
    implements Iterator<List<? extends EObject>> {
        final List<Iterator<ObjectElement>> a;

        a(List<ElementSet> list) {
            this.a = list.stream().map(elementSet -> elementSet.getElements().iterator()).collect(Collectors.toList());
        }

        @Override
        public boolean hasNext() {
            for (Iterator<ObjectElement> iterator : this.a) {
                if (iterator.hasNext()) continue;
                return false;
            }
            return true;
        }

        public List<? extends EObject> a() {
            ArrayList<EObject> arrayList = new ArrayList<EObject>(this.a.size());
            for (Iterator<ObjectElement> iterator : this.a) {
                arrayList.add(iterator.next().getObject());
            }
            return arrayList;
        }

        @Override
        public /* synthetic */ Object next() {
            return this.a();
        }
    }
}

