/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.engine.impl;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.astah.table.CellDescriptor;
import net.astah.table.DataQuery;
import net.astah.table.DynamicDataset;
import net.astah.table.IQueryExecutor;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.table.engine.impl.DataQueryEngineAdapter;
import net.astah.table.engine.impl.DatasetEngineAdapter;
import net.astah.table.engine.impl.a;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicDatasetEngineAdapter
extends DatasetEngineAdapter {
    private static final Logger b = LoggerFactory.getLogger(DynamicDatasetEngineAdapter.class);

    public DynamicDatasetEngineAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Iterable<List<? extends EObject>> getTuples(Object object) {
        DynamicDataset dynamicDataset = (DynamicDataset)object;
        b.debug("Preparing query execution of {}", (Object)dynamicDataset);
        List list = dynamicDataset.getQueries().stream().sorted(this.getQueryComparator(dynamicDataset)).map(this::prepareQuery).collect(Collectors.toList());
        assert (!list.isEmpty()) : "Dataset queries are empty";
        return () -> new Generator(dynamicDataset, list);
    }

    @Override
    public Iterable<EObject> getDistinguishableElements(Object object, Tuple tuple) {
        DynamicDataset dynamicDataset = (DynamicDataset)object;
        assert (dynamicDataset == tuple.getDataset()) : "A tuple must be produced by the dataset";
        return () -> new a(this, dynamicDataset, tuple);
    }

    @Override
    public List<? extends CellDescriptor> getHeaderDescriptors(Object object, Tuple tuple) {
        DynamicDataset dynamicDataset = (DynamicDataset)object;
        if (dynamicDataset.eIsSet((EStructuralFeature)TablePackage.Literals.DYNAMIC_DATASET__HEADER)) {
            return dynamicDataset.getHeaders();
        }
        return Collections.emptyList();
    }

    @Override
    public List<? extends CellDescriptor> getCellDescriptors(Object object, Tuple tuple, Tuple tuple2) {
        DynamicDataset dynamicDataset = (DynamicDataset)object;
        if (dynamicDataset.eIsSet((EStructuralFeature)TablePackage.Literals.DYNAMIC_DATASET__CELL)) {
            return dynamicDataset.getCells();
        }
        return Collections.emptyList();
    }

    @Override
    public Comparator<?> getCellComparator(Object object, Tuple tuple) {
        DynamicDataset dynamicDataset = (DynamicDataset)object;
        return this.getCellComparator((List<? extends CellDescriptor>)dynamicDataset.getCells());
    }

    @Override
    public Command createDeleteTupleElementCommand(EditingDomain editingDomain, Object object, Tuple tuple, int n) {
        DynamicDataset dynamicDataset = (DynamicDataset)object;
        assert (dynamicDataset == tuple.getDataset()) : "tuple dataset must be same";
        EList<DataQuery> eList = dynamicDataset.getQueries();
        if (n >= 0 && n < eList.size()) {
            DataQuery dataQuery = (DataQuery)eList.get(n);
            return DataQueryEngineAdapter.createDeleteElementObjectCommand(this.adapterFactory, editingDomain, dataQuery, tuple).chain(super.createDeleteTupleElementCommand(editingDomain, object, tuple, n));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Comparator<? super DataQuery> getQueryComparator(DynamicDataset dynamicDataset) {
        Map map = dynamicDataset.getQueries().stream().collect(Collectors.toMap(Function.identity(), dataQuery -> DynamicDatasetEngineAdapter.a(Collections.emptySet(), dataQuery)));
        return (dataQuery, dataQuery2) -> ((Set)map.get(dataQuery)).contains(dataQuery2) ? 1 : (((Set)map.get(dataQuery2)).contains(dataQuery) ? -1 : 0);
    }

    protected Query prepareQuery(DataQuery dataQuery) {
        IQueryExecutor iQueryExecutor = DataQueryEngineAdapter.createExecutor(this.adapterFactory, dataQuery);
        return new Query(dataQuery, iQueryExecutor);
    }

    static Set<DataQuery> a(Set<DataQuery> set, DataQuery dataQuery) {
        for (DataQuery dataQuery2 : dataQuery.getDependencies()) {
            if (set.isEmpty()) {
                set = new HashSet<DataQuery>();
            }
            if (set.add(dataQuery2)) {
                set = DynamicDatasetEngineAdapter.a(set, dataQuery2);
                continue;
            }
            throw new IllegalArgumentException(NLS.bind((String)"Found cyclic dependency: {0} and {1}", (Object)dataQuery, (Object)dataQuery2));
        }
        return set;
    }

    protected static class Generator
    implements Iterator<List<? extends EObject>> {
        private final EMap<DataQuery, EObject> a;
        private final Deque<Iterator<? extends EObject>> b;
        protected final DynamicDataset dataset;
        protected final List<Query> queries;
        private List<EObject> c;

        public Generator(@NonNull DynamicDataset dynamicDataset, @NonNull List<Query> list) {
            if (dynamicDataset == null) {
                throw new NullPointerException("dataset");
            }
            if (list == null) {
                throw new NullPointerException("queries");
            }
            this.dataset = dynamicDataset;
            this.queries = list;
            this.a = new BasicEMap(list.size());
            this.b = new ArrayDeque<Iterator<? extends EObject>>(list.size());
            b.debug("Starting query execution of {}", (Object)dynamicDataset);
            for (DataQuery dataQuery : dynamicDataset.getQueries()) {
                this.a.put((Object)dataQuery, null);
            }
            this.b.push(list.get(0).getExecutor().executeQuery(this.a));
        }

        @Override
        public boolean hasNext() {
            if (this.c != null) {
                return true;
            }
            while (true) {
                Object object;
                Iterator<? extends EObject> iterator;
                if ((iterator = this.b.getFirst()).hasNext()) {
                    object = iterator.next();
                    Query query = this.queries.get(this.b.size() - 1);
                    this.a.put((Object)query.getQuery(), object);
                    if (this.b.size() < this.queries.size()) {
                        Query query2 = this.queries.get(this.b.size());
                        IQueryExecutor iQueryExecutor = query2.getExecutor();
                        this.b.push(iQueryExecutor.executeQuery(this.a));
                        continue;
                    }
                    this.c = this.a.stream().map(Map.Entry::getValue).collect(Collectors.toList());
                    return true;
                }
                if (this.b.size() <= 1) break;
                this.b.pop();
                object = this.queries.get(this.b.size());
                this.a.put((Object)((Query)object).getQuery(), null);
            }
            b.debug("Completed query execution of {}", (Object)this.dataset);
            return false;
        }

        @Override
        public List<EObject> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            List<EObject> list = this.c;
            this.c = null;
            return list;
        }
    }

    protected static class Query {
        protected final DataQuery query;
        protected final IQueryExecutor executor;

        public Query(@NonNull DataQuery dataQuery, @NonNull IQueryExecutor iQueryExecutor) {
            if (dataQuery == null) {
                throw new NullPointerException("query");
            }
            if (iQueryExecutor == null) {
                throw new NullPointerException("executor");
            }
            this.query = dataQuery;
            this.executor = iQueryExecutor;
        }

        public DataQuery getQuery() {
            return this.query;
        }

        public IQueryExecutor getExecutor() {
            return this.executor;
        }
    }
}

