/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.engine.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.astah.table.CellDescriptor;
import net.astah.table.Element;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.table.engine.IEngineDataset;
import net.astah.table.engine.impl.CellDescriptorEngineAdapter;
import net.astah.table.engine.impl.EngineAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatasetEngineAdapter
extends EngineAdapter
implements IEngineDataset {
    private static final Logger a = LoggerFactory.getLogger(DatasetEngineAdapter.class);

    public DatasetEngineAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public static Iterable<List<? extends EObject>> getTuples(AdapterFactory adapterFactory, Object object) {
        Object object2 = adapterFactory.adapt(object, IEngineDataset.class);
        if (!(object2 instanceof IEngineDataset)) {
            a.warn("Can't adapt IEngineDataset from {}", object);
            return Collections.emptyList();
        }
        return ((IEngineDataset)object2).getTuples(object);
    }

    public static Iterable<EObject> getDistinguishableElements(AdapterFactory adapterFactory, Object object, Tuple tuple) {
        Object object2 = adapterFactory.adapt(object, IEngineDataset.class);
        if (!(object2 instanceof IEngineDataset)) {
            a.warn("Can't adapt IEngineDataset from {}", object);
            return Collections.emptySet();
        }
        return ((IEngineDataset)object2).getDistinguishableElements(object, tuple);
    }

    public static List<? extends CellDescriptor> getHeaderDescriptors(AdapterFactory adapterFactory, Object object, Tuple tuple) {
        Object object2 = adapterFactory.adapt(object, IEngineDataset.class);
        if (!(object2 instanceof IEngineDataset)) {
            a.warn("Can't adapt IEngineDataset from {}", object);
            return Collections.emptyList();
        }
        return ((IEngineDataset)object2).getHeaderDescriptors(object, tuple);
    }

    public static List<? extends CellDescriptor> getCellDescriptors(AdapterFactory adapterFactory, Object object, Tuple tuple, Tuple tuple2) {
        Object object2 = adapterFactory.adapt(object, IEngineDataset.class);
        if (!(object2 instanceof IEngineDataset)) {
            a.warn("Can't adapt IEngineDataset from {}", object);
            return Collections.emptyList();
        }
        return ((IEngineDataset)object2).getCellDescriptors(object, tuple, tuple2);
    }

    public static Command createDeleteTupleElementCommand(AdapterFactory adapterFactory, EditingDomain editingDomain, Object object, Tuple tuple, int n) {
        Object object2 = adapterFactory.adapt(object, IEngineDataset.class);
        if (!(object2 instanceof IEngineDataset)) {
            a.warn("Can't adapt IEngineDataset from {}", object);
            return UnexecutableCommand.INSTANCE;
        }
        return ((IEngineDataset)object2).createDeleteTupleElementCommand(editingDomain, object, tuple, n);
    }

    public boolean isAdapterForType(Object object) {
        return object == IEngineDataset.class;
    }

    @Override
    public Iterable<EObject> getDistinguishableElements(Object object, Tuple tuple) {
        return Collections.emptySet();
    }

    @Override
    public Command createDeleteTupleElementCommand(EditingDomain editingDomain, Object object, Tuple tuple, int n) {
        Element element;
        EList<Element> eList = tuple.getElements();
        if (n >= 0 && n < eList.size() && (element = (Element)eList.get(n)).getObject() != null) {
            return SetCommand.create((EditingDomain)editingDomain, (Object)element, (Object)TablePackage.Literals.ELEMENT__OBJECT, (Object)SetCommand.UNSET_VALUE);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Comparator<?> getCellComparator(List<? extends CellDescriptor> list) {
        Iterator<? extends CellDescriptor> iterator;
        if (list.size() == 1 && (iterator = list.iterator()).hasNext()) {
            CellDescriptor cellDescriptor = iterator.next();
            return CellDescriptorEngineAdapter.getComparator(this.adapterFactory, cellDescriptor);
        }
        return null;
    }
}

