/*
 * Decompiled with CFR 0.152.
 */
package net.astah.dd.di.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.astah.common.collect.Streams;
import net.astah.dd.di.DiagramElement;
import net.astah.emf.common.ecore.EObjects;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class DiagramElements {
    public static List<DiagramElement> filter(@NonNull List<DiagramElement> list, @NonNull EClass eClass, @NonNull EClass eClass2) {
        if (list == null) {
            throw new NullPointerException("elements");
        }
        if (eClass == null) {
            throw new NullPointerException("elementEClass");
        }
        if (eClass2 == null) {
            throw new NullPointerException("modelEClass");
        }
        return list.stream().filter(DiagramElements.matchElementAndModel(eClass, eClass2)).collect(Collectors.toList());
    }

    public static Predicate<? super DiagramElement> matchElementAndModel(@NonNull EClass eClass, @NonNull EClass eClass2) {
        if (eClass == null) {
            throw new NullPointerException("elementEClass");
        }
        if (eClass2 == null) {
            throw new NullPointerException("modelEClass");
        }
        return diagramElement -> DiagramElements.matchElementAndModel(diagramElement, eClass, eClass2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean matchElementAndModel(@NonNull DiagramElement diagramElement, @NonNull EClass eClass, @NonNull EClass eClass2) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (eClass == null) {
            throw new NullPointerException("elementEClass");
        }
        if (eClass2 == null) {
            throw new NullPointerException("modelEClass");
        }
        if (!eClass.isInstance((Object)diagramElement)) return false;
        if (!diagramElement.getModelElements().stream().anyMatch(arg_0 -> ((EClass)eClass2).isInstance(arg_0))) return false;
        return true;
    }

    public static TreeIterator<DiagramElement> getAllContents(@NonNull DiagramElement diagramElement) {
        if (diagramElement == null) {
            throw new NullPointerException("element");
        }
        return new AbstractTreeIterator<DiagramElement>((Object)diagramElement, false){
            private static final long serialVersionUID = 1L;

            public Iterator<DiagramElement> getChildren(Object object) {
                return ((DiagramElement)object).getOwnedElements().iterator();
            }
        };
    }

    private static Optional<EObject> a(@NonNull DiagramElement diagramElement) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (diagramElement.getModelElements().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(diagramElement.getModelElements().get(0));
    }

    public static EObject getModelElement(@NonNull DiagramElement diagramElement) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        return DiagramElements.a(diagramElement).orElse(null);
    }

    public static boolean isModelElementPresent(@NonNull DiagramElement diagramElement) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        return DiagramElements.a(diagramElement).isPresent();
    }

    public static void ifModelElementPresent(@NonNull DiagramElement diagramElement, @NonNull Consumer<EObject> consumer) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer");
        }
        DiagramElements.a(diagramElement).ifPresent(consumer);
    }

    public static <R> R mapModelElement(@NonNull DiagramElement diagramElement, @NonNull Function<EObject, R> function) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (function == null) {
            throw new NullPointerException("mapper");
        }
        return DiagramElements.mapModelElement(diagramElement, function, null);
    }

    public static <R> R mapModelElement(@NonNull DiagramElement diagramElement, @NonNull Function<EObject, R> function, R r) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (function == null) {
            throw new NullPointerException("mapper");
        }
        return DiagramElements.a(diagramElement).map(function).orElse(r);
    }

    private static <T> Optional<T> a(@NonNull DiagramElement diagramElement, @NonNull Class<T> clazz) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (clazz == null) {
            throw new NullPointerException("type");
        }
        return Streams.stream(diagramElement.getModelElements(), clazz).findFirst();
    }

    public static <T> T getModelElement(@NonNull DiagramElement diagramElement, @NonNull Class<T> clazz) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (clazz == null) {
            throw new NullPointerException("type");
        }
        return DiagramElements.a(diagramElement, clazz).orElse(null);
    }

    public static boolean isModelElementPresent(@NonNull DiagramElement diagramElement, @NonNull Class<?> clazz) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (clazz == null) {
            throw new NullPointerException("type");
        }
        return DiagramElements.a(diagramElement, clazz).isPresent();
    }

    public static <T> void ifModelElementPresent(@NonNull DiagramElement diagramElement, @NonNull Class<T> clazz, @NonNull Consumer<T> consumer) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (clazz == null) {
            throw new NullPointerException("type");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer");
        }
        DiagramElements.a(diagramElement, clazz).ifPresent(consumer);
    }

    public static <T, R> R mapModelElement(@NonNull DiagramElement diagramElement, @NonNull Class<T> clazz, @NonNull Function<T, R> function) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (clazz == null) {
            throw new NullPointerException("type");
        }
        if (function == null) {
            throw new NullPointerException("mapper");
        }
        return DiagramElements.mapModelElement(diagramElement, clazz, function, null);
    }

    public static <T, R> R mapModelElement(@NonNull DiagramElement diagramElement, @NonNull Class<T> clazz, @NonNull Function<T, R> function, R r) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (clazz == null) {
            throw new NullPointerException("type");
        }
        if (function == null) {
            throw new NullPointerException("mapper");
        }
        return DiagramElements.a(diagramElement, clazz).map(function).orElse(r);
    }

    public static void setModelElement(@NonNull DiagramElement diagramElement, @NonNull EObject eObject) {
        if (diagramElement == null) {
            throw new NullPointerException("diagramElement");
        }
        if (eObject == null) {
            throw new NullPointerException("modelElement");
        }
        ECollections.setEList(diagramElement.getModelElements(), Collections.singletonList(eObject));
    }

    public static DiagramElement getCommonAncestor(DiagramElement diagramElement, DiagramElement diagramElement2) {
        return (DiagramElement)EObjects.getCommonAncestor((EObjects.ContainmentProvider)DIContainmentProvider.INSTANCE, (EObject)diagramElement, (EObject)diagramElement2);
    }

    static class DIContainmentProvider
    implements EObjects.ContainmentProvider {
        public static DIContainmentProvider INSTANCE = new DIContainmentProvider();

        DIContainmentProvider() {
        }

        public EObject getContainer(EObject eObject) {
            return ((DiagramElement)eObject).getOwningElement();
        }

        public List<? extends EObject> getContents(EObject eObject) {
            return ((DiagramElement)eObject).getOwnedElements();
        }
    }
}

