/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import java.util.ArrayList;
import java.util.List;
import net.astah.uml2.uml.Classes;
import net.astah.uml2.uml.MultiplicityElements;
import net.astah.uml2.uml.TemplateBindings;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.ValueSpecification;

public class TypeExpression {
    private Type a;
    private MultiplicityElement b;

    public TypeExpression(Type type, MultiplicityElement multiplicityElement) {
        this.a = type;
        this.b = multiplicityElement;
    }

    public TypeExpression(Type type) {
        this.a = type;
        this.b = null;
    }

    public String toString() {
        if (this.b != null) {
            String string = MultiplicityElements.getMultiplicityRangeString(this.b.getLowerValue(), this.b.getUpperValue());
            return TypeExpression.getExpression(this.a, "", string);
        }
        return TypeExpression.getExpression(this.a, "", "");
    }

    public static String getExpression(Type type, String string, String string2) {
        if (type == null) {
            return "";
        }
        String string3 = type.getName();
        if (type instanceof Classifier && Classes.isAnonymousBoundClass((Classifier)type)) {
            string3 = TemplateBindings.getAnonymousBoundClassInfo((Classifier)type);
        }
        if (string3 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string3);
        stringBuilder.append(string);
        if (string2.equals("")) {
            return stringBuilder.toString();
        }
        stringBuilder.append("[");
        stringBuilder.append(string2);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public Type getType() {
        return this.a;
    }

    public MultiplicityElement getMultiplicityElement() {
        return this.b;
    }

    public static List<ValueSpecification> getMultiplicityValue(String string) {
        int n = string.lastIndexOf(91);
        if (n == -1 || !string.endsWith("]") || string.length() <= 2) {
            return new ArrayList<ValueSpecification>();
        }
        int n2 = string.length() - 1;
        if (n == n2 - 1) {
            return new ArrayList<ValueSpecification>();
        }
        return MultiplicityElements.getLowerUpperValues(string.substring(n + 1, n2));
    }

    public static String getTypeName(String string) {
        int n = string.lastIndexOf(91);
        if (n == -1) {
            return string;
        }
        if (!string.endsWith("]") || string.length() <= 2) {
            return "";
        }
        return StringUtils.stripEnd((String)string.substring(0, n), (String)" ");
    }

    public boolean isEquivalent(MultiplicityElement multiplicityElement) {
        if (this.getType() == null && multiplicityElement == null) {
            return true;
        }
        if (!(multiplicityElement instanceof TypedElement)) {
            return false;
        }
        Type type = ((TypedElement)multiplicityElement).getType();
        return this.getType() == type && this.toString().equals(new TypeExpression(type, multiplicityElement).toString());
    }
}

