/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import com.google.common.base.Strings;
import java.util.Collections;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.uml2.uml.Elements;
import net.astah.uml2.uml.OpaqueBehaviors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transitions {
    private static final Logger a = LoggerFactory.getLogger(Transitions.class);

    public static String getTransitionNameTGA(Transition transition) {
        return Transitions.getTransitionName(Transitions.a(transition), Transitions.b(transition), Transitions.c(transition));
    }

    public static String getTransitionName(String string, String string2, String string3) {
        return (string == null ? "" : string) + (string2 == null ? "" : string2) + (string3 == null ? "" : string3);
    }

    public static boolean containEnter(String string) {
        int n;
        int n2 = string.length();
        int n3 = n2 > 1 ? n2 - 2 : 0;
        CharSequence charSequence = string.subSequence(n3, n = n2);
        String string2 = charSequence.toString();
        return string2.contains("\n");
    }

    private static String a(Transition transition) {
        String string = null;
        String string2 = Transitions.d(transition);
        String string3 = Transitions.e(transition);
        String string4 = Transitions.f(transition);
        if (string2 != null) {
            string = string2;
            if (string3 != null || string4 != null) {
                string = string + " ";
            }
        }
        return string;
    }

    private static String b(Transition transition) {
        String string = null;
        String string2 = Transitions.e(transition);
        String string3 = Transitions.f(transition);
        if (string2 != null) {
            string = "[" + string2 + "]";
            if (string3 != null) {
                string = string + " ";
            }
        }
        return string;
    }

    private static String c(Transition transition) {
        String string = null;
        String string2 = Transitions.f(transition);
        if (string2 != null) {
            string = "/ " + string2;
        }
        return string;
    }

    private static String d(Transition transition) {
        EList eList = transition.getTriggers();
        if (eList != null && !eList.isEmpty()) {
            Trigger trigger = (Trigger)eList.get(0);
            return trigger.getName();
        }
        return null;
    }

    private static String e(Transition transition) {
        Constraint constraint = transition.getGuard();
        if (constraint != null) {
            return constraint.getSpecification().stringValue();
        }
        return null;
    }

    private static String f(Transition transition) {
        return OpaqueBehaviors.getBodyString(transition.getEffect());
    }

    public static void up(Transition transition) {
        Region region = transition.getContainer();
        EList eList = region.getTransitions();
        int n = eList.indexOf((Object)transition);
        int n2 = -1;
        for (int i = n - 1; i >= 0; --i) {
            Transition transition2 = (Transition)eList.get(i);
            if (transition2.getKind() != TransitionKind.INTERNAL_LITERAL) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return;
        }
        eList.move(n2, (Object)transition);
    }

    public static void down(Transition transition) {
        Region region = transition.getContainer();
        EList eList = region.getTransitions();
        int n = eList.indexOf((Object)transition);
        int n2 = eList.size();
        for (int i = n + 1; i < eList.size(); ++i) {
            Transition transition2 = (Transition)eList.get(i);
            if (transition2.getKind() != TransitionKind.INTERNAL_LITERAL) continue;
            n2 = i;
            break;
        }
        if (n2 >= eList.size()) {
            return;
        }
        eList.move(n2, (Object)transition);
    }

    public static Region getContainer(Vertex vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("source is null");
        }
        Region region = vertex.getContainer();
        if (region != null || !(vertex instanceof Pseudostate)) {
            return region;
        }
        Pseudostate pseudostate = (Pseudostate)Pseudostate.class.cast(vertex);
        if (pseudostate.getKind().equals((Object)PseudostateKind.ENTRY_POINT_LITERAL) || pseudostate.getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL)) {
            State state = pseudostate.getState();
            if (state == null) {
                StateMachine stateMachine = pseudostate.getStateMachine();
                if (stateMachine != null) {
                    return (Region)stateMachine.getRegions().get(0);
                }
            } else {
                return state.getContainer();
            }
        }
        return region;
    }

    public static void setTrigger(Transition transition, String string) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)transition);
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)transition, (Object)UMLPackage.Literals.TRANSITION__TRIGGER, Collections.singletonList(Strings.nullToEmpty((String)string)));
        if (command != null) {
            try {
                CommandUtils.execute((EditingDomain)editingDomain, (Command)command);
            }
            catch (InterruptedException | RollbackException throwable) {
                a.error("error has occurred.", throwable);
            }
        }
    }

    public static void setGuard(Transition transition, String string) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)transition);
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)transition, (Object)UMLPackage.Literals.TRANSITION__GUARD, (Object)Strings.nullToEmpty((String)string));
        if (command != null) {
            try {
                CommandUtils.execute((EditingDomain)editingDomain, (Command)command);
            }
            catch (InterruptedException | RollbackException throwable) {
                a.error("error has occurred.", throwable);
            }
        }
    }

    public static void setEffect(Transition transition, String string) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)transition);
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)transition, (Object)UMLPackage.Literals.TRANSITION__EFFECT, (Object)Strings.nullToEmpty((String)string));
        if (command != null) {
            try {
                CommandUtils.execute((EditingDomain)editingDomain, (Command)command);
            }
            catch (InterruptedException | RollbackException throwable) {
                a.error("error has occurred.", throwable);
            }
        }
    }

    public static void removeInternalTransition(Transition transition) {
        Transitions.setTrigger(transition, "");
        Transitions.setGuard(transition, "");
        Transitions.setEffect(transition, "");
        Elements.removeModel((Element)transition);
    }

    public static void setName(Transition transition, String string, String string2, String string3, String string4) {
        Transitions.setTrigger(transition, string2);
        Transitions.setGuard(transition, string3);
        Transitions.setEffect(transition, string4);
    }
}

