/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.uml2.uml.Classes;
import net.astah.uml2.uml.TypeExpression;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.UMLFactory;

public class TemplateBindings {
    public static TemplateBinding createTemplateBinding(Classifier classifier, Classifier classifier2) {
        TemplateBinding templateBinding = UMLFactory.eINSTANCE.createTemplateBinding();
        templateBinding.setSignature(classifier2.getOwnedTemplateSignature());
        templateBinding.setBoundElement((TemplateableElement)classifier);
        for (TemplateParameter templateParameter : classifier2.getOwnedTemplateSignature().getParameters()) {
            TemplateParameterSubstitution templateParameterSubstitution = templateBinding.createParameterSubstitution();
            templateParameterSubstitution.setFormal(templateParameter);
        }
        return templateBinding;
    }

    public static List<TemplateBinding> getTemplateBindings(TemplateSignature templateSignature) {
        ArrayList<TemplateBinding> arrayList = new ArrayList<TemplateBinding>();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)templateSignature)) {
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof TemplateBinding) || ((TemplateBinding)eObject).getSignature() != templateSignature) continue;
            arrayList.add((TemplateBinding)eObject);
        }
        return arrayList;
    }

    public static String[] parseActuals(String string) {
        string = string.replaceAll(",", " , ");
        String[] stringArray = string.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i].trim());
            n += TemplateBindings.a("<", stringArray[i]);
            if ((n -= TemplateBindings.a(">", stringArray[i])) == 0 || i == stringArray.length - 1) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.delete(0, stringBuilder.length());
                continue;
            }
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(",");
        }
        if (arrayList.isEmpty()) {
            return stringArray;
        }
        return arrayList.toArray(new String[0]);
    }

    private static int a(String string, String string2) {
        int n = 0;
        while (string2.indexOf(string) != -1) {
            ++n;
            string2 = string2.substring(string2.indexOf(string) + 1);
        }
        return n;
    }

    public static boolean isWithSameType(ParameterableElement parameterableElement, Classifier classifier) {
        return classifier instanceof PrimitiveType && parameterableElement instanceof Expression || !(classifier instanceof PrimitiveType) && parameterableElement instanceof Classifier && !(parameterableElement instanceof PrimitiveType);
    }

    public static boolean isSelfAnonymousClassBindingRelationship(Classifier classifier, String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return false;
        }
        for (TemplateBinding templateBinding : classifier.getTemplateBindings()) {
            for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitutions()) {
                ParameterableElement parameterableElement = templateParameterSubstitution.getActual();
                if (parameterableElement != templateBinding.getBoundElement()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSelfAnonymousClassBindingRelationship(Classifier classifier, TemplateableElement templateableElement) {
        if (!Classes.isAnonymousBoundClass((Classifier)templateableElement)) {
            return false;
        }
        for (TemplateBinding templateBinding : classifier.getTemplateBindings()) {
            for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitutions()) {
                Classifier classifier2;
                if (!(templateParameterSubstitution.getActual() instanceof Classifier) || (classifier2 = (Classifier)templateParameterSubstitution.getActual()).equals(classifier) || !TemplateBindings.isSelfAnonymousClassBindingRelationship(classifier2, templateableElement)) continue;
                return true;
            }
        }
        return classifier == templateableElement;
    }

    public static String getAnonymousBoundClassInfo(Classifier classifier, boolean bl) {
        return TemplateBindings.getAnonymousBoundClassInfo(classifier, bl, false);
    }

    public static String getAnonymousBoundClassInfo(Classifier classifier, boolean bl, boolean bl2) {
        if (classifier == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        EList eList = classifier.getTemplateBindings();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TemplateBinding templateBinding = (TemplateBinding)iterator.next();
            stringBuilder.append(TemplateBindings.getTemplateBindingInfo(templateBinding, bl, bl2));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" , ");
        }
        if (bl2) {
            stringBuilder.insert(0, LabelProviders.getQualifiedText((Object)classifier));
        }
        return stringBuilder.toString();
    }

    public static String getAnonymousBoundClassInfo(Classifier classifier) {
        return TemplateBindings.getAnonymousBoundClassInfo(classifier, false);
    }

    public static String getTemplateBindingInfo(TemplateBinding templateBinding, boolean bl) {
        return TemplateBindings.getTemplateBindingInfo(templateBinding, bl, false);
    }

    public static String getTemplateBindingInfo(TemplateBinding templateBinding, boolean bl, boolean bl2) {
        TemplateableElement templateableElement = templateBinding.getBoundElement();
        TemplateSignature templateSignature = templateBinding.getSignature();
        TemplateableElement templateableElement2 = templateSignature.getTemplate();
        if (templateableElement2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        EList eList = templateBinding.getParameterSubstitutions();
        for (TemplateParameterSubstitution templateParameterSubstitution : eList) {
            TemplateParameter templateParameter = templateParameterSubstitution.getFormal();
            ParameterableElement parameterableElement = templateParameterSubstitution.getActual();
            if (parameterableElement == null) {
                stringBuilder.append(TemplateBindings.a(templateParameter, bl, bl2));
            } else {
                if (bl) {
                    stringBuilder.append(TemplateBindings.getNameString(templateParameter, bl2));
                    stringBuilder.append("->");
                }
                String string = TemplateBindings.a(templateParameter, templateBinding);
                if (parameterableElement instanceof TypeExpression) {
                    TypeExpression typeExpression = (TypeExpression)parameterableElement;
                    if (TemplateBindings.a(templateBinding, typeExpression)) {
                        stringBuilder.append("?");
                    }
                } else {
                    if (!(parameterableElement.equals(templateableElement) && parameterableElement instanceof Classifier && Classes.isAnonymousBoundClass((Classifier)parameterableElement))) {
                        stringBuilder.append(TemplateBindings.getNameString(parameterableElement, bl2));
                    }
                    stringBuilder.append(string);
                }
            }
            if (templateParameterSubstitution == eList.get(eList.size() - 1) || bl) continue;
            stringBuilder.append(",");
        }
        if (stringBuilder.toString().equals("")) {
            return "";
        }
        return String.format("%s<%s>", TemplateBindings.getNameString(templateableElement2, bl2), stringBuilder.toString());
    }

    private static Object a(TemplateParameter templateParameter, boolean bl, boolean bl2) {
        if (bl) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ParameterableElement parameterableElement = templateParameter.getDefault();
        if (parameterableElement instanceof Classifier) {
            if (!Classes.isAnonymousBoundClass((Classifier)parameterableElement)) {
                stringBuilder.append(TemplateBindings.getNameString(parameterableElement, bl2));
            }
        } else if (parameterableElement instanceof Expression) {
            Expression expression = (Expression)parameterableElement;
            stringBuilder.append(expression.getName());
        } else if (parameterableElement instanceof TypeExpression) {
            TypeExpression typeExpression = (TypeExpression)parameterableElement;
            String string = "";
            stringBuilder.append(TypeExpression.getExpression(typeExpression.getType(), string, typeExpression.getMultiplicityElement().toString()));
        } else if (parameterableElement == null) {
            stringBuilder.append("?");
        }
        return stringBuilder.toString();
    }

    private static boolean a(TemplateBinding templateBinding, TypeExpression typeExpression) {
        if (typeExpression == null || !(typeExpression.getType() instanceof TemplateableElement)) {
            return false;
        }
        TemplateableElement templateableElement = (TemplateableElement)typeExpression.getType();
        return templateableElement.getTemplateBindings().contains((Object)templateBinding);
    }

    private static String a(TemplateParameter templateParameter, TemplateBinding templateBinding) {
        return "";
    }

    private static String a(Object object) {
        return TemplateBindings.getNameString(object, false);
    }

    public static String getQualifiedNameString(Object object) {
        return TemplateBindings.getNameString(object, true);
    }

    public static String getNameString(Object object, boolean bl) {
        String string = "";
        if (object instanceof Expression) {
            string = ((Expression)object).getName();
        } else if (object instanceof Classifier && Classes.isAnonymousBoundClass((Classifier)object)) {
            string = bl ? TemplateBindings.getAnonymousBoundClassInfo((Classifier)object, false, true) : TemplateBindings.getAnonymousBoundClassInfo((Classifier)object);
        } else if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            string = bl ? LabelProviders.getQualifiedText((Object)eObject) : LabelProviders.getName((Object)eObject);
        }
        return string;
    }

    private static boolean a(Map<TemplateParameter, Object> map, TemplateParameter templateParameter) {
        Object object = map.get(templateParameter);
        return map.keySet().contains(templateParameter) && object != null;
    }

    public static StringBuilder getAnonymousBoundClassName(Classifier classifier) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(classifier.getName());
        if ("".equals(classifier.getName())) {
            Iterator iterator = classifier.getTemplateBindings().iterator();
            while (iterator.hasNext()) {
                TemplateBinding templateBinding = (TemplateBinding)iterator.next();
                TemplateSignature templateSignature = templateBinding.getSignature();
                if (templateSignature == null) continue;
                stringBuilder.append(TemplateBindings.getTemplateBindingInfo(templateBinding, false));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
        }
        return stringBuilder;
    }
}

