/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.astah.emf.edit.provider.LabelProviders;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class Stereotypes {
    public static String getStereotypeString(EObject eObject) {
        if (eObject instanceof Element) {
            Element element = (Element)eObject;
            EList eList = element.getAppliedStereotypes();
            if (eList.isEmpty()) {
                return "";
            }
            Stereotype stereotype = (Stereotype)eList.get(0);
            return stereotype.getName();
        }
        return "";
    }

    public static EList<Stereotype> getStereotypes(EObject eObject) {
        if (eObject instanceof Element) {
            Element element = (Element)eObject;
            return element.getAppliedStereotypes();
        }
        return null;
    }

    public static Stereotype getStereotype(EObject eObject) {
        Element element;
        EList eList;
        if (eObject instanceof Element && (eList = (element = (Element)eObject).getAppliedStereotypes()) != null && !eList.isEmpty()) {
            return (Stereotype)eList.get(0);
        }
        return null;
    }

    public static List<EObject> getStereotypeApplications(Element element) {
        Object object = null;
        object = element instanceof Connector ? ((Connector)element).getType() : element;
        EList eList = object.getAppliedStereotypes();
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        for (Stereotype stereotype : eList) {
            EObject eObject = object.getStereotypeApplication(stereotype);
            if (eObject == null) continue;
            arrayList.add(eObject);
        }
        return arrayList;
    }

    public static List<String> getStereotypeList(String string, Boolean bl) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = string.indexOf("<<");
        if (n2 != -1 && n2 == 0 && (n = string.indexOf(">>")) != -1) {
            String string2 = string.substring(n2 + 2, n);
            if (bl.booleanValue()) {
                string2 = string2.trim();
                arrayList.add(string2);
                string = string.substring(n + 2);
                string = string.trim();
            } else {
                string = string.substring(n + 2);
                string2 = string2 + StringUtils.repeat((String)" ", (int)(string.length() - string.trim().length()));
                arrayList.add(string2);
                string = string.trim();
            }
            if (!string.equals("")) {
                arrayList.addAll(Stereotypes.getStereotypeList(string, bl));
            }
        }
        return arrayList;
    }

    public static EList<Stereotype> getStereotypesByNames(List<String> list, Element element) {
        if (list == null || list.isEmpty()) {
            return new BasicEList();
        }
        if (list.stream().anyMatch(string -> string.trim().isEmpty())) {
            return null;
        }
        EList eList = element.getApplicableStereotypes();
        BasicEList basicEList = new BasicEList();
        for (String string2 : list) {
            Optional<Stereotype> optional = eList.stream().filter(stereotype -> stereotype.getName().equals(string2.trim())).findFirst();
            if (!optional.isPresent() || basicEList.contains((Object)optional.get())) continue;
            basicEList.add((Object)optional.get());
        }
        return basicEList.isEmpty() ? null : basicEList;
    }

    public static String getGuillemetString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<<");
        stringBuilder.append(string);
        stringBuilder.append(">>");
        return stringBuilder.toString();
    }

    public static List<TaggedValueProperty> getShownTaggedValues(Element element) {
        ArrayList<TaggedValueProperty> arrayList = new ArrayList<TaggedValueProperty>();
        for (Stereotype stereotype : element.getAppliedStereotypes()) {
            for (Property property : stereotype.getAllAttributes()) {
                if (Stereotypes.a(property)) continue;
                TaggedValueProperty taggedValueProperty = new TaggedValueProperty(stereotype, property);
                arrayList.add(taggedValueProperty);
            }
        }
        return arrayList;
    }

    private static boolean a(Property property) {
        String string = property.getName();
        return string != null && string.startsWith("base_");
    }

    public static String getTaggedValueString(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return "";
            }
            Object e = list.get(0);
            return Stereotypes.a(e);
        }
        return Stereotypes.a(object);
    }

    private static String a(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            return LabelProviders.getName((Object)eObject);
        }
        return object == null ? "" : object.toString();
    }

    public static boolean isIllegalTaggedValue(Object object) {
        Object object2;
        if (object == null) {
            return true;
        }
        if (object instanceof Character && ((Character)(object2 = (Character)object)).charValue() == '\u0000') {
            return true;
        }
        return object instanceof List && (object2 = (List)object).isEmpty();
    }

    public static final class TaggedValueProperty {
        private final Property a;
        private final Stereotype b;

        protected TaggedValueProperty(Stereotype stereotype, Property property) {
            this.b = stereotype;
            this.a = property;
        }

        public Stereotype getAppliedStereotype() {
            return this.b;
        }

        public Property getProperty() {
            return this.a;
        }
    }
}

