/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import java.util.ArrayList;
import java.util.List;
import net.astah.uml2.uml.Elements;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.ProtocolStateMachine;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class StateMachines {
    public static StateMachine createStateMachineWithRegion() {
        StateMachine stateMachine = UMLFactory.eINSTANCE.createStateMachine();
        stateMachine.createRegion(null);
        return stateMachine;
    }

    public static ProtocolStateMachine createProtocolStateMachineWithRegion() {
        ProtocolStateMachine protocolStateMachine = UMLFactory.eINSTANCE.createProtocolStateMachine();
        protocolStateMachine.createRegion(null);
        return protocolStateMachine;
    }

    public static StateMachine createStateMachine(NamedElement namedElement) {
        UMLSwitch<StateMachine> uMLSwitch = new UMLSwitch<StateMachine>(){

            public StateMachine caseBehavioredClassifier(BehavioredClassifier behavioredClassifier) {
                return StateMachines.createStateMachine(behavioredClassifier);
            }

            public StateMachine casePackage(Package package_) {
                return StateMachines.createStateMachine(package_);
            }

            public StateMachine caseInterface(Interface interface_) {
                return StateMachines.createStateMachine(interface_);
            }

            public StateMachine caseOperation(Operation operation) {
                return StateMachines.createStateMachine(operation);
            }
        };
        return (StateMachine)uMLSwitch.doSwitch((EObject)namedElement);
    }

    public static List<StateMachine> getStateMachines(Element element) {
        UMLSwitch<List<StateMachine>> uMLSwitch = new UMLSwitch<List<StateMachine>>(){

            public List<StateMachine> caseBehavioredClassifier(BehavioredClassifier behavioredClassifier) {
                return StateMachines.getStateMachines(behavioredClassifier);
            }

            public List<StateMachine> casePackage(Package package_) {
                return StateMachines.getStateMachines(package_);
            }
        };
        return (List)uMLSwitch.doSwitch((EObject)element);
    }

    public static StateMachine createStateMachine(Package package_) {
        StateMachine stateMachine = StateMachines.createStateMachineWithRegion();
        package_.getPackagedElements().add((Object)stateMachine);
        return stateMachine;
    }

    public static List<StateMachine> getStateMachines(Package package_) {
        ArrayList<StateMachine> arrayList = new ArrayList<StateMachine>();
        EList eList = package_.getPackagedElements();
        for (PackageableElement packageableElement : eList) {
            if (!(packageableElement instanceof StateMachine)) continue;
            arrayList.add((StateMachine)packageableElement);
        }
        return arrayList;
    }

    public static StateMachine createStateMachine(BehavioredClassifier behavioredClassifier) {
        StateMachine stateMachine = StateMachines.createStateMachineWithRegion();
        behavioredClassifier.getOwnedBehaviors().add((Object)stateMachine);
        behavioredClassifier.setClassifierBehavior((Behavior)stateMachine);
        return stateMachine;
    }

    public static List<StateMachine> getStateMachines(BehavioredClassifier behavioredClassifier) {
        ArrayList<StateMachine> arrayList = new ArrayList<StateMachine>();
        EList eList = behavioredClassifier.getOwnedBehaviors();
        for (Behavior behavior : eList) {
            if (!(behavior instanceof StateMachine)) continue;
            arrayList.add((StateMachine)behavior);
        }
        return arrayList;
    }

    public static StateMachine createStateMachine(Interface interface_) {
        BehavioredClassifier behavioredClassifier = Elements.getOwningElement((Element)interface_, BehavioredClassifier.class);
        if (behavioredClassifier != null) {
            return StateMachines.createStateMachine(behavioredClassifier);
        }
        StateMachine stateMachine = StateMachines.createStateMachineWithRegion();
        stateMachine.setPackage(interface_.getNearestPackage());
        return stateMachine;
    }

    public static StateMachine createStateMachine(Operation operation) {
        Element element = operation.getOwner();
        if (element instanceof NamedElement) {
            StateMachine stateMachine = StateMachines.createStateMachine((NamedElement)element);
            if (stateMachine != null) {
                operation.getMethods().add((Object)stateMachine);
            }
            return stateMachine;
        }
        return null;
    }
}

