/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import java.util.ArrayList;
import java.util.List;
import net.astah.emf.common.ecore.EObjects;
import net.astah.uml2.uml.Classes;
import net.astah.uml2.uml.Classifiers;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AttributeOwner;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.VisibilityKind;

public class Properties {
    public static boolean isAttribute(Property property) {
        return property.getAssociation() == null && !(property instanceof Port);
    }

    public static void setDefaultValue(Property property, String string) {
        if (property.getDefault() != null || string != null && !string.isEmpty()) {
            if (string == null || string.isEmpty()) {
                property.setDefaultValue(null);
            } else {
                property.setDefault(string);
            }
        }
    }

    public static List<ConnectorEnd> getConnectorEnds(Property property) {
        ArrayList<ConnectorEnd> arrayList = new ArrayList<ConnectorEnd>();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)property)) {
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof ConnectorEnd) || ((ConnectorEnd)eObject).getRole() != property) continue;
            arrayList.add((ConnectorEnd)eObject);
        }
        return arrayList;
    }

    public static List<Property> getRoles(Classifier classifier) {
        EList eList = classifier.getAllAttributes();
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : eList) {
            if (property.isComposite()) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public static boolean isPrimitiveType(Property property) {
        Type type = property.getType();
        return type instanceof Classifier && Classes.isPrimitiveType(type);
    }

    public static List<Property> getParts(Classifier classifier) {
        EList eList = classifier.getAllAttributes();
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : eList) {
            if (!property.isComposite()) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public static Property createMemberEndForPart(Type type, Classifier classifier, AggregationKind aggregationKind, String string) {
        if (type != null && classifier != null && aggregationKind != null && string != null) {
            boolean bl = !EObjects.isReadOnly((EObject)type);
            Association association = classifier.createAssociation(true, aggregationKind, string, 1, 1, type, bl, AggregationKind.NONE_LITERAL, null, 1, 1);
            EList eList = association.getMemberEnds();
            Property property = (Property)eList.get(0);
            property.setLowerValue(null);
            property.setUpperValue(null);
            property.setVisibility(VisibilityKind.PRIVATE_LITERAL);
            Property property2 = (Property)eList.get(1);
            property2.setLowerValue(null);
            property2.setUpperValue(null);
            property2.setVisibility(VisibilityKind.PRIVATE_LITERAL);
            if (!bl) {
                property2.setIsNavigable(true);
            }
            return property;
        }
        return null;
    }

    public static List<Property> getAttributeEnds(Classifier classifier) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)classifier)) {
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof Property) || ((Property)eObject).getType() != classifier || !((Property)eObject).isNavigable()) continue;
            arrayList.add((Property)eObject);
        }
        return arrayList;
    }

    @Deprecated
    public static Property getOppositeProperty(Property property) {
        return property == null ? null : property.getOpposite();
    }

    public static void down(Property property, Property property2) {
        EList eList = property.getQualifiers();
        int n = eList.indexOf((Object)property2);
        int n2 = n + 1;
        if (n2 >= eList.size()) {
            return;
        }
        eList.move(n2, (Object)property2);
    }

    public static void up(Property property, Property property2) {
        EList eList = property.getQualifiers();
        int n = eList.indexOf((Object)property2);
        int n2 = n - 1;
        if (n2 < 0) {
            return;
        }
        eList.move(n2, (Object)property2);
    }

    public static boolean validateAttributeUniqueness(Property property) {
        if (property == null) {
            throw new IllegalArgumentException("attribute is null.");
        }
        Element element = property.getOwner();
        if (element == null) {
            return true;
        }
        if (!(element instanceof Class || element instanceof DataType || element instanceof Interface)) {
            return true;
        }
        if (element instanceof Interaction) {
            return true;
        }
        if (property instanceof Port) {
            return true;
        }
        Classifier classifier = (Classifier)element;
        String string = property.getName();
        List<Property> list = Classifiers.getAttributesWithoutAssociations(classifier);
        return !list.stream().anyMatch(property2 -> property2 != property && (property2.getName() == null && string == null || string != null && string.equals(property2.getName())));
    }

    public static boolean isQualifier(Property property) {
        EList eList;
        Element element = property.getOwner();
        return element instanceof Property && (eList = ((Property)element).getQualifiers()) != null && eList.contains((Object)property);
    }

    public static void setAggregation(Property property, AggregationKind aggregationKind) {
        Property property2;
        property.setAggregation(aggregationKind);
        Association association = property.getAssociation();
        if (association == null) {
            return;
        }
        Property property3 = (Property)association.getMemberEnds().get(0);
        Property property4 = property2 = (Property)association.getMemberEnds().get(1);
        if (!property3.equals(property)) {
            property4 = property3;
        }
        if (aggregationKind != AggregationKind.NONE_LITERAL) {
            property4.setAggregation(AggregationKind.NONE_LITERAL);
        }
    }

    public static void setIsNavigable(Property property, boolean bl) {
        property.setIsNavigable(bl);
        Property property2 = property.getOtherEnd();
        Type type = property2.getType();
        if (type instanceof AttributeOwner && !EObjects.isReadOnly((EObject)type)) {
            AttributeOwner attributeOwner = (AttributeOwner)AttributeOwner.class.cast(type);
            if (bl) {
                attributeOwner.getOwnedAttributes().add((Object)property);
            } else {
                attributeOwner.getOwnedAttributes().remove((Object)property);
            }
        }
    }
}

