/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;

public class Ports {
    public static List<InterfaceRealization> getInterfaceRealizationForPort(Port port) {
        ArrayList<InterfaceRealization> arrayList = new ArrayList<InterfaceRealization>();
        Type type = port.getType();
        if (type == null) {
            return new ArrayList<InterfaceRealization>();
        }
        for (Element element : type.getOwnedElements()) {
            if (!(element instanceof InterfaceRealization)) continue;
            arrayList.add((InterfaceRealization)element);
        }
        return arrayList;
    }

    public static List<Usage> getUsageForPort(Port port) {
        ArrayList<Usage> arrayList = new ArrayList<Usage>();
        Type type = port.getType();
        if (type == null) {
            return new ArrayList<Usage>();
        }
        Model model = type.getModel();
        for (Element element : model.getOwnedElements()) {
            if (!(element instanceof Usage)) continue;
            arrayList.add((Usage)element);
        }
        return arrayList;
    }

    public static boolean isConnectedPort(NamedElement namedElement, Port port, ConnectorEnd connectorEnd) {
        ConnectableElement connectableElement = connectorEnd.getRole();
        Property property = connectorEnd.getPartWithPort();
        if (property == null) {
            property = connectableElement.getOwner();
        }
        return property == namedElement && connectableElement == port;
    }
}

