/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.astah.model.extension.ExtensionAdapter;
import net.astah.uml2.uml.Elements;
import net.astah.uml2.uml.Lifelines;
import net.astah.uml2.umlx.MessageExtension;
import net.astah.uml2.umlx.UMLExtensionPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;

public class Messages {
    public static final String UNSPECIFIED = "<<Unspecified>>";

    public static Operation getOperation(Message message) {
        NamedElement namedElement = message.getSignature();
        if (namedElement == null) {
            return null;
        }
        if (!(namedElement instanceof Operation)) {
            return null;
        }
        return (Operation)Operation.class.cast(namedElement);
    }

    public static Classifier getSenderBaseClassifier(Message message) {
        MessageEnd messageEnd = message.getSendEvent();
        return Messages.a(messageEnd);
    }

    public static Classifier getReceiverBaseClassifier(Message message) {
        MessageEnd messageEnd = message.getReceiveEvent();
        return Messages.a(messageEnd);
    }

    public static Property getSenderBaseProperty(Message message) {
        MessageEnd messageEnd = message.getSendEvent();
        Lifeline lifeline = Messages.getLifeline(messageEnd);
        if (lifeline == null) {
            return null;
        }
        return (Property)lifeline.getRepresents();
    }

    public static Property getReceiverBaseProperty(Message message) {
        MessageEnd messageEnd = message.getReceiveEvent();
        Lifeline lifeline = Messages.getLifeline(messageEnd);
        if (lifeline == null) {
            return null;
        }
        return (Property)lifeline.getRepresents();
    }

    static Classifier a(MessageEnd messageEnd) {
        Lifeline lifeline = Messages.getLifeline(messageEnd);
        if (lifeline == null) {
            return null;
        }
        return Lifelines.getBase(lifeline);
    }

    public static Lifeline getLifeline(MessageEnd messageEnd) {
        if (messageEnd == null) {
            return null;
        }
        if (!(messageEnd instanceof MessageOccurrenceSpecification)) {
            return null;
        }
        MessageOccurrenceSpecification messageOccurrenceSpecification = (MessageOccurrenceSpecification)messageEnd;
        Lifeline lifeline = messageOccurrenceSpecification.getCovered();
        return lifeline;
    }

    public static EList<ValueSpecification> getArguments(Message message) {
        return message.getArguments();
    }

    public static String getArgumentsString(Message message) {
        StringBuffer stringBuffer = new StringBuffer();
        for (ValueSpecification valueSpecification : Messages.getArguments(message)) {
            if (!stringBuffer.toString().isEmpty()) {
                stringBuffer.append(",");
            }
            if (!(valueSpecification instanceof OpaqueExpression)) continue;
            EList eList = ((OpaqueExpression)valueSpecification).getBodies();
            stringBuffer.append((String)eList.get(0));
        }
        return stringBuffer.toString();
    }

    public static void changeCoveredBy(MessageEnd messageEnd, Lifeline lifeline) {
        if (!(messageEnd instanceof MessageOccurrenceSpecification)) {
            return;
        }
        MessageOccurrenceSpecification messageOccurrenceSpecification = (MessageOccurrenceSpecification)messageEnd;
        for (Lifeline lifeline2 : (Lifeline[])messageOccurrenceSpecification.getCovereds().toArray((Object[])new Lifeline[0])) {
            lifeline2.getCoveredBys().remove((Object)messageOccurrenceSpecification);
        }
        lifeline.getCoveredBys().add((Object)messageOccurrenceSpecification);
    }

    public static final Message getMessageReferencedOperation(Operation operation) {
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)operation)) {
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof Message)) continue;
            return (Message)eObject;
        }
        return null;
    }

    public static Message getReplyMessage(Message message) {
        for (Message message2 : Messages.getActivatedMessages(message)) {
            if (message2.getMessageSort() != MessageSort.REPLY_LITERAL) continue;
            return message2;
        }
        return null;
    }

    public static List<Message> getIncomingMessages(Lifeline lifeline) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (MessageOccurrenceSpecification messageOccurrenceSpecification : Iterables.filter((Iterable)lifeline.getCoveredBys(), MessageOccurrenceSpecification.class)) {
            Message message = messageOccurrenceSpecification.getMessage();
            if (message.getReceiveEvent() != messageOccurrenceSpecification) continue;
            arrayList.add(message);
        }
        return arrayList;
    }

    public static List<Message> getOutgoingMessages(Lifeline lifeline) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (MessageOccurrenceSpecification messageOccurrenceSpecification : Iterables.filter((Iterable)lifeline.getCoveredBys(), MessageOccurrenceSpecification.class)) {
            Message message = messageOccurrenceSpecification.getMessage();
            if (message == null || message.getSendEvent() != messageOccurrenceSpecification) continue;
            arrayList.add(message);
        }
        return arrayList;
    }

    public static List<Message> getActivatedMessages(Message message) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        if (message == null) {
            return arrayList;
        }
        MessageEnd messageEnd = message.getReceiveEvent();
        if (messageEnd instanceof MessageOccurrenceSpecification) {
            MessageOccurrenceSpecification messageOccurrenceSpecification = (MessageOccurrenceSpecification)messageEnd;
            for (Message message2 : Messages.getOutgoingMessages(messageOccurrenceSpecification.getCovered())) {
                if (Messages.getActivator(message2) != message) continue;
                arrayList.add(message2);
            }
        } else if (messageEnd instanceof Gate && messageEnd.getMessage() != message) {
            arrayList.add(messageEnd.getMessage());
        }
        return Messages.sortMessageByIndex(arrayList);
    }

    public static List<Message> getAllActivatedMessages(Message message) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (Message message2 : Messages.getActivatedMessages(message)) {
            arrayList.add(message2);
            arrayList.addAll(Messages.getActivatedMessages(message2));
        }
        return arrayList;
    }

    public static Message getActivator(Message message) {
        MessageExtension messageExtension = (MessageExtension)ExtensionAdapter.getContent((EObject)message, (EClass)UMLExtensionPackage.Literals.MESSAGE_EXTENSION);
        return messageExtension != null ? messageExtension.getActivator() : null;
    }

    public static void setActivator(Message message, Message message2) {
        MessageExtension messageExtension = (MessageExtension)ExtensionAdapter.getContent((EObject)message, (EClass)UMLExtensionPackage.Literals.MESSAGE_EXTENSION, (message2 != null ? 1 : 0) != 0);
        if (messageExtension != null) {
            messageExtension.setActivator(message2);
        }
    }

    public static Message getPredecessor(Message message) {
        EList eList = message.getInteraction().getMessages();
        Message message2 = Messages.getActivator(message);
        if (message2 == null) {
            return null;
        }
        for (int i = eList.indexOf((Object)message) - 1; i > eList.indexOf((Object)message2); --i) {
            Message message3 = (Message)eList.get(i);
            if (Messages.getActivator(message3) != message2) continue;
            return message3;
        }
        return null;
    }

    public static int compareIndex(String string, String string2) {
        if (string.compareTo(string2) == 0) {
            return 0;
        }
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            if (n >= stringArray2.length) {
                return 1;
            }
            String string3 = stringArray[n];
            String string4 = stringArray2[n];
            int n3 = Integer.valueOf(string3);
            if (n3 != (n2 = Integer.valueOf(string4).intValue())) {
                return n3 - n2;
            }
            ++n;
        }
        return -1;
    }

    public static void moveMessages(EList<Message> eList, Message message, int n) {
        EList eList2 = message.getInteraction().getFragments();
        List<Message> list = Messages.getAllActivatedMessages(message);
        int n2 = eList.indexOf((Object)message);
        if (n == n2) {
            return;
        }
        for (int i = 0; i <= list.size(); ++i) {
            if (n2 < n) {
                eList.move(n, n2);
                eList2.move(2 * n + 1, 2 * n2);
                eList2.move(2 * n + 1, 2 * n2);
                continue;
            }
            int n3 = n2 + list.size();
            eList.move(n, n3);
            eList2.move(2 * n, 2 * n3 + 1);
            eList2.move(2 * n, 2 * n3 + 1);
        }
    }

    public static boolean isValidAncestor(Message message, Message message2) {
        if (message2 == null) {
            return true;
        }
        return Messages.getLifeline(message2.getReceiveEvent()) == Messages.getLifeline(message.getSendEvent());
    }

    public static List<Message> sortMessageByIndex(List<Message> list) {
        if (list.isEmpty()) {
            return list;
        }
        Optional<Message> optional = list.stream().filter(message -> message.getInteraction() != null).findFirst();
        if (!optional.isPresent()) {
            return list;
        }
        final EList eList = optional.get().getInteraction().getMessages();
        return list.stream().sorted(new Comparator<Message>(){

            @Override
            public int compare(Message message, Message message2) {
                return eList.indexOf((Object)message) - eList.indexOf((Object)message2);
            }
        }).collect(Collectors.toList());
    }

    public static void setSendEvent(Message message, MessageEnd messageEnd) {
        if (messageEnd == null) {
            MessageEnd messageEnd2 = message.getSendEvent();
            Elements.removeModel((Element)messageEnd2);
        }
        if (message != null) {
            message.setSendEvent(messageEnd);
        }
        if (messageEnd != null) {
            messageEnd.setMessage(message);
        }
    }

    public static void setReceiveEvent(Message message, MessageEnd messageEnd) {
        if (messageEnd == null) {
            MessageEnd messageEnd2 = message.getReceiveEvent();
            Elements.removeModel((Element)messageEnd2);
        }
        if (message != null) {
            message.setReceiveEvent(messageEnd);
        }
        if (messageEnd != null) {
            messageEnd.setMessage(message);
        }
    }
}

