/*
 * Decompiled with CFR 0.152.
 */
package net.astah.uml2.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.astah.uml2.uml.Constraints;
import net.astah.uml2.uml.Elements;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class Interactions {
    public static Interaction createInteraction(NamedElement namedElement) {
        UMLSwitch<Interaction> uMLSwitch = new UMLSwitch<Interaction>(){

            public Interaction caseBehavioredClassifier(BehavioredClassifier behavioredClassifier) {
                return Interactions.createInteraction(behavioredClassifier);
            }

            public Interaction casePackage(Package package_) {
                return Interactions.createInteraction(package_);
            }

            public Interaction caseInterface(Interface interface_) {
                return Interactions.createInteraction(interface_);
            }

            public Interaction caseOperation(Operation operation) {
                return Interactions.createInteraction(operation);
            }
        };
        return (Interaction)uMLSwitch.doSwitch((EObject)namedElement);
    }

    public static Interaction createInteraction(Package package_) {
        Interaction interaction = UMLFactory.eINSTANCE.createInteraction();
        package_.getPackagedElements().add((Object)interaction);
        interaction.createOwnedParameter(null, null);
        return interaction;
    }

    public static Interaction createInteraction(BehavioredClassifier behavioredClassifier) {
        Interaction interaction = UMLFactory.eINSTANCE.createInteraction();
        behavioredClassifier.getOwnedBehaviors().add((Object)interaction);
        interaction.createOwnedParameter(null, null);
        return interaction;
    }

    public static List<Interaction> getInteractions(BehavioredClassifier behavioredClassifier) {
        ArrayList<Interaction> arrayList = new ArrayList<Interaction>();
        EList eList = behavioredClassifier.getOwnedBehaviors();
        for (Behavior behavior : eList) {
            if (!(behavior instanceof Interaction)) continue;
            arrayList.add((Interaction)behavior);
        }
        return arrayList;
    }

    public static Interaction createInteraction(Interface interface_) {
        BehavioredClassifier behavioredClassifier = Elements.getOwningElement((Element)interface_, BehavioredClassifier.class);
        if (behavioredClassifier != null) {
            return Interactions.createInteraction(behavioredClassifier);
        }
        Interaction interaction = UMLFactory.eINSTANCE.createInteraction();
        interaction.setPackage(interface_.getNearestPackage());
        interaction.createOwnedParameter(null, null);
        return interaction;
    }

    public static Interaction createInteraction(Operation operation) {
        Interaction interaction;
        Element element = operation.getOwner();
        if (element instanceof NamedElement && (interaction = Interactions.createInteraction((NamedElement)element)) != null) {
            operation.getMethods().add((Object)interaction);
            return interaction;
        }
        return null;
    }

    public static String getArgument(Interaction interaction) {
        if (interaction == null) {
            return null;
        }
        if (interaction.getOwnedParameters().isEmpty()) {
            return null;
        }
        return ((Parameter)interaction.getOwnedParameters().get(0)).getName();
    }

    public static void setArgument(Interaction interaction, String string) {
        if (interaction == null) {
            return;
        }
        if (interaction.getOwnedParameters().isEmpty()) {
            interaction.createOwnedParameter(null, null);
        }
        ((Parameter)interaction.getOwnedParameters().get(0)).setName(string);
    }

    public static Gate createGate(MessageEnd messageEnd) {
        EObject eObject;
        Gate gate = null;
        EObject eObject2 = eObject = messageEnd != null ? messageEnd.eContainer() : null;
        if (eObject instanceof Interaction) {
            gate = ((Interaction)eObject).createFormalGate("");
        } else if (eObject instanceof InteractionUse) {
            gate = ((InteractionUse)eObject).createActualGate("");
        }
        return gate;
    }

    public static List<InteractionUse> getInteractionUses(Interaction interaction) {
        ArrayList<InteractionUse> arrayList = new ArrayList<InteractionUse>();
        Collection collection = UML2Util.getNonNavigableInverseReferences((EObject)interaction);
        for (EStructuralFeature.Setting setting : collection) {
            EObject eObject = setting.getEObject();
            if (!(eObject instanceof InteractionUse)) continue;
            arrayList.add((InteractionUse)eObject);
        }
        return arrayList;
    }

    public static InteractionOperand createInteractionOperand(CombinedFragment combinedFragment) {
        InteractionOperand interactionOperand = combinedFragment.createOperand(null);
        interactionOperand.createGuard(null);
        Constraints.setExpression((Constraint)interactionOperand.getGuard(), "guard");
        return interactionOperand;
    }
}

